"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QImageReader(object):
    """
    https://doc.qt.io/qt-6/qimagereader.html

    **Detailed Description**

    The most common way to read images is through **QImage**  and **QPixmap** 's
    constructors, or by calling **QImage::load** () and **QPixmap::load** ().
    QImageReader is a specialized class which gives you more control when
    reading images. For example, you can read an image into a specific size by
    calling **setScaledSize** (), and you can select a clip rect, effectively
    loading only parts of an image, by calling **setClipRect** (). Depending on
    the underlying support in the image format, this can save memory and speed
    up loading of images.

    To read an image, you start by constructing a QImageReader object. Pass
    either a file name or a device pointer, and the image format to
    QImageReader's constructor. You can then set several options, such as the
    clip rect (by calling **setClipRect** ()) and scaled size (by calling
    **setScaledSize** ()). **canRead** () returns the image if the QImageReader
    can read the image (i.e., the image format is supported and the device is
    open for reading). Call **read** () to read the image.

    If any error occurs when reading the image, **read** () will return a null
    **QImage** . You can then call **error** () to find the type of error that
    occurred, or **errorString** () to get a human readable description of what
    went wrong.

    **Note:** QImageReader assumes exclusive control over the file or device
    that is assigned. Any attempts to modify the assigned file or device during
    the lifetime of the QImageReader object will yield undefined results.

    **Formats**

    Call **supportedImageFormats** () for a list of formats that QImageReader
    can read. QImageReader supports all built-in image formats, in addition to
    any image format plugins that support reading. Call **supportedMimeTypes**
    () to obtain a list of supported MIME types, which for example can be passed
    to **QFileDialog::setMimeTypeFilters** ().

    QImageReader autodetects the image format by default, by looking at the
    provided (optional) format string, the file name suffix, and the data stream
    contents. You can enable or disable this feature, by calling
    **setAutoDetectImageFormat** ().

    **High Resolution Versions of Images**

    It is possible to provide high resolution versions of images should a
    scaling between **device pixels** and **device independent pixels** be in
    effect.

    The high resolution version is marked by the suffix `@2x` on the base name.
    The image read will have its **device pixel ratio** set to a value of 2.

    This can be disabled by setting the environment variable
    `QT_HIGHDPI_DISABLE_2X_IMAGE_LOADING`.

    **See also** **QImageWriter** , **QImageIOHandler** , **QImageIOPlugin** ,
    **QMimeDatabase** , **QColorSpace** , **QImage::devicePixelRatio** (),
    **QPixmap::devicePixelRatio** (), **QIcon** , **QPainter::drawPixmap** (),
    and **QPainter::drawImage** ().
    """

    UnknownError: QImageReader.ImageReaderError = ...
    FileNotFoundError: QImageReader.ImageReaderError = ...
    DeviceError: QImageReader.ImageReaderError = ...
    UnsupportedFormatError: QImageReader.ImageReaderError = ...
    InvalidDataError: QImageReader.ImageReaderError = ...

    class ImageReaderError(Enum):
        UnknownError: QImageReader.ImageReaderError = ...
        FileNotFoundError: QImageReader.ImageReaderError = ...
        DeviceError: QImageReader.ImageReaderError = ...
        UnsupportedFormatError: QImageReader.ImageReaderError = ...
        InvalidDataError: QImageReader.ImageReaderError = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#QImageReader

        **QImageReader::QImageReader()**

        Constructs an empty QImageReader object. Before reading an image, call
        **setDevice** () or **setFileName** ().
        """
        ...

    @overload
    def __init__(
        self,
        device: PySide6.QtCore.QIODevice,
        format: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#QImageReader-1

        **QImageReader::QImageReader(QIODevice * device , const QByteArray &
        format = QByteArray())**

        Constructs a QImageReader object with the device **device** and the
        image format **format**.
        """
        ...

    @overload
    def __init__(
        self, fileName: str, format: Union[PySide6.QtCore.QByteArray, bytes] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#QImageReader-2

        **QImageReader::QImageReader(const QString & fileName , const QByteArray
        & format = QByteArray())**

        Constructs a QImageReader object with the file name **fileName** and the
        image format **format**.

        **See also** **setFileName** ().
        """
        ...

    @staticmethod
    def allocationLimit() -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#allocationLimit

        **[static, since 6.0] int QImageReader::allocationLimit()**

        Returns the current allocation limit, in megabytes.

        This function was introduced in Qt 6.0.

        **See also** **setAllocationLimit** ().
        """
        ...

    def autoDetectImageFormat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#autoDetectImageFormat

        **bool QImageReader::autoDetectImageFormat() const**

        Returns `true` if image format autodetection is enabled on this image
        reader; otherwise returns `false`. By default, autodetection is enabled.

        **See also** **setAutoDetectImageFormat** ().
        """
        ...

    def autoTransform(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#autoTransform

        **[since 5.5] bool QImageReader::autoTransform() const**

        Returns `true` if the image handler will apply transformation metadata
        on **read** ().

        This function was introduced in Qt 5.5.

        **See also** **setAutoTransform** (), **transformation** (), and
        **read** ().
        """
        ...

    def backgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qimagereader.html#backgroundColor

        **QColor QImageReader::backgroundColor() const**

        Returns the background color that's used when reading an image. If the
        image format does not support setting the background color an invalid
        color is returned.

        **See also** **setBackgroundColor** () and **read** ().
        """
        ...

    def canRead(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#canRead

        **bool QImageReader::canRead() const**

        Returns `true` if an image can be read for the device (i.e., the image
        format is supported, and the device seems to contain valid data);
        otherwise returns `false`.

        canRead() is a lightweight function that only does a quick test to see
        if the image data is valid. **read** () may still return false after
        canRead() returns `true`, if the image data is corrupt.

        **Note:** A **QMimeDatabase**  lookup is normally a better approach than
        this function for identifying potentially non-image files or data.

        For images that support animation, canRead() returns `false` when all
        frames have been read.

        **See also** **read** (), **supportedImageFormats** (), and
        **QMimeDatabase** .
        """
        ...

    def clipRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qimagereader.html#clipRect

        **QRect QImageReader::clipRect() const**

        Returns the clip rect (also known as the ROI, or Region Of Interest) of
        the image. If no clip rect has been set, an invalid **QRect**  is
        returned.

        **See also** **setClipRect** ().
        """
        ...

    def currentImageNumber(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#currentImageNumber

        **int QImageReader::currentImageNumber() const**

        For image formats that support animation, this function returns the
        sequence number of the current frame. If the image format doesn't
        support animation, 0 is returned.

        This function returns -1 if an error occurred.

        **See also** **supportsAnimation** (),
        **QImageIOHandler::currentImageNumber** (), and **canRead** ().
        """
        ...

    def currentImageRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qimagereader.html#currentImageRect

        **QRect QImageReader::currentImageRect() const**

        For image formats that support animation, this function returns the rect
        for the current frame. Otherwise, a null rect is returned.

        **See also** **supportsAnimation** () and
        **QImageIOHandler::currentImageRect** ().
        """
        ...

    def decideFormatFromContent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#decideFormatFromContent

        **bool QImageReader::decideFormatFromContent() const**

        Returns whether the image reader should decide which plugin to use only
        based on the contents of the datastream rather than on the file
        extension.

        **See also** **setDecideFormatFromContent** ().
        """
        ...

    def device(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qimagereader.html#device

        **QIODevice *QImageReader::device() const**

        Returns the device currently assigned to **QImageReader** , or `nullptr`
        if no device has been assigned.

        **See also** **setDevice** ().
        """
        ...

    def error(self) -> PySide6.QtGui.QImageReader.ImageReaderError:
        """
        https://doc.qt.io/qt-6/qimagereader.html#error

        **QImageReader::ImageReaderError QImageReader::error() const**

        Returns the type of error that occurred last.

        **See also** **ImageReaderError**  and **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qimagereader.html#errorString

        **QString QImageReader::errorString() const**

        Returns a human readable description of the last error that occurred.

        **See also** **error** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qimagereader.html#fileName

        **QString QImageReader::fileName() const**

        If the currently assigned device is a **QFile** , or if **setFileName**
        () has been called, this function returns the name of the file
        **QImageReader**  reads from. Otherwise (i.e., if no device has been
        assigned or the device is not a **QFile** ), an empty **QString**  is
        returned.

        **See also** **setFileName** () and **setDevice** ().
        """
        ...

    def format(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagereader.html#format

        **QByteArray QImageReader::format() const**

        Returns the format **QImageReader**  uses for reading images.

        You can call this function after assigning a device to the reader to
        determine the format of the device. For example:

        **QImageReader**  reader("image.png");
            // reader.format() == "png"

        If the reader cannot read any image from the device (e.g., there is no
        image there, or the image has already been read), or if the format is
        unsupported, this function returns an empty QByteArray().

        **See also** **setFormat** () and **supportedImageFormats** ().
        """
        ...

    def imageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#imageCount

        **int QImageReader::imageCount() const**

        For image formats that support animation, this function returns the
        total number of images in the animation. If the format does not support
        animation, 0 is returned.

        This function returns -1 if an error occurred.

        **See also** **supportsAnimation** (), **QImageIOHandler::imageCount**
        (), and **canRead** ().
        """
        ...

    @overload
    @staticmethod
    def imageFormat(device: PySide6.QtCore.QIODevice) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagereader.html#imageFormat

        **QImage::Format QImageReader::imageFormat() const**

        Returns the format of the image, without actually reading the image
        contents. The format describes the image format **QImageReader::read**
        () returns, not the format of the actual image.

        If the image format does not support this feature, this function returns
        an invalid format.

        **See also** **QImageIOHandler::ImageOption** ,
        **QImageIOHandler::option** (), and **QImageIOHandler::supportsOption**
        ().
        """
        ...

    @overload
    @staticmethod
    def imageFormat(fileName: str) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagereader.html#imageFormat-1

        **[static] QByteArray QImageReader::imageFormat(const QString & fileName
        )**

        If supported, this function returns the image format of the file
        **fileName**. Otherwise, an empty string is returned.
        """
        ...

    @overload
    def imageFormat(self) -> PySide6.QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qimagereader.html#imageFormat-2

        **[static] QByteArray QImageReader::imageFormat(QIODevice * device )**

        If supported, this function returns the image format of the device
        **device**. Otherwise, an empty string is returned.

        **See also** **QImageReader::autoDetectImageFormat** ().
        """
        ...

    @staticmethod
    def imageFormatsForMimeType(
        mimeType: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagereader.html#imageFormatsForMimeType

        **[static, since 5.12] QList<QByteArray>
        QImageReader::imageFormatsForMimeType(const QByteArray & mimeType )**

        Returns the list of image formats corresponding to **mimeType**.

        Note that the **QGuiApplication**  instance must be created before this
        function is called.

        This function was introduced in Qt 5.12.

        **See also** **supportedImageFormats** () and **supportedMimeTypes** ().
        """
        ...

    def jumpToImage(self, imageNumber: int) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#jumpToImage

        **bool QImageReader::jumpToImage(int imageNumber )**

        For image formats that support animation, this function skips to the
        image whose sequence number is **imageNumber** , returning true if
        successful or false if the corresponding image cannot be found.

        The next call to **read** () will attempt to read this image.

        **See also** **jumpToNextImage** () and **QImageIOHandler::jumpToImage**
        ().
        """
        ...

    def jumpToNextImage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#jumpToNextImage

        **bool QImageReader::jumpToNextImage()**

        For image formats that support animation, this function steps over the
        current image, returning true if successful or false if there is no
        following image in the animation.

        The default implementation calls **read** (), then discards the
        resulting image, but the image handler may have a more efficient way of
        implementing this operation.

        **See also** **jumpToImage** () and **QImageIOHandler::jumpToNextImage**
        ().
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#loopCount

        **int QImageReader::loopCount() const**

        For image formats that support animation, this function returns the
        number of times the animation should loop. If this function returns -1,
        it can either mean the animation should loop forever, or that an error
        occurred. If an error occurred, **canRead** () will return false.

        **See also** **supportsAnimation** (), **QImageIOHandler::loopCount**
        (), and **canRead** ().
        """
        ...

    def nextImageDelay(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#nextImageDelay

        **int QImageReader::nextImageDelay() const**

        For image formats that support animation, this function returns the
        number of milliseconds to wait until displaying the next frame in the
        animation. If the image format doesn't support animation, 0 is returned.

        This function returns -1 if an error occurred.

        **See also** **supportsAnimation** (),
        **QImageIOHandler::nextImageDelay** (), and **canRead** ().
        """
        ...

    def quality(self) -> int:
        """
        https://doc.qt.io/qt-6/qimagereader.html#quality

        **int QImageReader::quality() const**

        Returns the quality setting of the image format.

        **See also** **setQuality** ().
        """
        ...

    def read(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qimagereader.html#read

        **QImage QImageReader::read()**

        Reads an image from the device. On success, the image that was read is
        returned; otherwise, a null **QImage**  is returned. You can then call
        **error** () to find the type of error that occurred, or **errorString**
        () to get a human readable description of the error.

        For image formats that support animation, calling read() repeatedly will
        return the next frame. When all frames have been read, a null image will
        be returned.

        **See also** **canRead** (), **supportedImageFormats** (),
        **supportsAnimation** (), and **QMovie** .
        """
        ...

    def scaledClipRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qimagereader.html#scaledClipRect

        **QRect QImageReader::scaledClipRect() const**

        Returns the scaled clip rect of the image.

        **See also** **setScaledClipRect** ().
        """
        ...

    def scaledSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qimagereader.html#scaledSize

        **QSize QImageReader::scaledSize() const**

        Returns the scaled size of the image.

        **See also** **setScaledSize** ().
        """
        ...

    @staticmethod
    def setAllocationLimit(mbLimit: int) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setAllocationLimit

        **[static, since 6.0] void QImageReader::setAllocationLimit(int mbLimit
        )**

        Sets the allocation limit to **mbLimit** megabytes. Images that would
        require a **QImage**  memory allocation above this limit will be
        rejected. If **mbLimit** is 0, the allocation size check will be
        disabled.

        This limit helps applications avoid unexpectedly large memory usage from
        loading corrupt image files. It is normally not needed to change it. The
        default limit is large enough for all commonly used image sizes.

        **Note:** The memory requirements are calculated for a minimum of 32
        bits per pixel, since Qt will typically convert an image to that depth
        when it is used in GUI. This means that the effective allocation limit
        is significantly smaller than **mbLimit** when reading 1 bpp and 8 bpp
        images.

        This function was introduced in Qt 6.0.

        **See also** **allocationLimit** ().
        """
        ...

    def setAutoDetectImageFormat(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setAutoDetectImageFormat

        **void QImageReader::setAutoDetectImageFormat(bool enabled )**

        If **enabled** is true, image format autodetection is enabled;
        otherwise, it is disabled. By default, autodetection is enabled.

        **QImageReader**  uses an extensive approach to detecting the image
        format; firstly, if you pass a file name to **QImageReader** , it will
        attempt to detect the file extension if the given file name does not
        point to an existing file, by appending supported default extensions to
        the given file name, one at a time. It then uses the following approach
        to detect the image format:

        * Image plugins are queried first, based on either the optional format
        string, or the file name suffix (if the source device is a file). No
        content detection is done at this stage. **QImageReader**  will choose
        the first plugin that supports reading for this format.
          * If no plugin
        supports the image format, Qt's built-in handlers are checked based on
        either the optional format string, or the file name suffix.
          * If no
        capable plugins or built-in handlers are found, each plugin is tested by
        inspecting the content of the data stream.
          * If no plugins could
        detect the image format based on data contents, each built-in image
        handler is tested by inspecting the contents.
          * Finally, if all above
        approaches fail, **QImageReader**  will report failure when trying to
        read the image.

        By disabling image format autodetection, **QImageReader**  will only
        query the plugins and built-in handlers based on the format string
        (i.e., no file name extensions are tested).

        **See also** **autoDetectImageFormat** (), **QImageIOHandler::canRead**
        (), and **QImageIOPlugin::capabilities** ().
        """
        ...

    def setAutoTransform(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setAutoTransform

        **[since 5.5] void QImageReader::setAutoTransform(bool enabled )**

        Determines that images returned by **read** () should have
        transformation metadata automatically applied if **enabled** is `true`.

        This function was introduced in Qt 5.5.

        **See also** **autoTransform** (), **transformation** (), and **read**
        ().
        """
        ...

    def setBackgroundColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setBackgroundColor

        **void QImageReader::setBackgroundColor(const QColor & color )**

        Sets the background color to **color**. Image formats that support this
        operation are expected to initialize the background to **color** before
        reading an image.

        **See also** **backgroundColor** () and **read** ().
        """
        ...

    def setClipRect(self, rect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setClipRect

        **void QImageReader::setClipRect(const QRect & rect )**

        Sets the image clip rect (also known as the ROI, or Region Of Interest)
        to **rect**. The coordinates of **rect** are relative to the
        untransformed image size, as returned by **size** ().

        **See also** **clipRect** (), **setScaledSize** (), and
        **setScaledClipRect** ().
        """
        ...

    def setDecideFormatFromContent(self, ignored: bool) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setDecideFormatFromContent

        **void QImageReader::setDecideFormatFromContent(bool ignored )**

        If **ignored** is set to true, then the image reader will ignore
        specified formats or file extensions and decide which plugin to use only
        based on the contents in the datastream.

        Setting this flag means that all image plugins gets loaded. Each plugin
        will read the first bytes in the image data and decide if the plugin is
        compatible or not.

        This also disables auto detecting the image format.

        **See also** **decideFormatFromContent** ().
        """
        ...

    def setDevice(self, device: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setDevice

        **void QImageReader::setDevice(QIODevice * device )**

        Sets **QImageReader** 's device to **device**. If a device has already
        been set, the old device is removed from **QImageReader**  and is
        otherwise left unchanged.

        If the device is not already open, **QImageReader**  will attempt to
        open the device in **ReadOnly**  mode by calling open(). Note that this
        does not work for certain devices, such as **QProcess** , **QTcpSocket**
        and **QUdpSocket** , where more logic is required to open the device.

        **See also** **device** () and **setFileName** ().
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setFileName

        **void QImageReader::setFileName(const QString & fileName )**

        Sets the file name of **QImageReader**  to **fileName**. Internally,
        **QImageReader**  will create a **QFile**  object and open it in
        **ReadOnly**  mode, and use this when reading images.

        If **fileName** does not include a file extension (e.g., .png or .bmp),
        **QImageReader**  will cycle through all supported extensions until it
        finds a matching file.

        **See also** **fileName** (), **setDevice** (), and
        **supportedImageFormats** ().
        """
        ...

    def setFormat(self, format: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setFormat

        **void QImageReader::setFormat(const QByteArray & format )**

        Sets the format **QImageReader**  will use when reading images, to
        **format**. **format** is a case insensitive text string. Example:

        **QImageReader**  reader;
            reader.setFormat("png"); // same as
        reader.setFormat("PNG");

        You can call **supportedImageFormats** () for the full list of formats
        **QImageReader**  supports.

        **See also** **format** ().
        """
        ...

    def setQuality(self, quality: int) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setQuality

        **void QImageReader::setQuality(int quality )**

        Sets the quality setting of the image format to **quality**.

        Some image formats, in particular lossy ones, entail a tradeoff between
        a) visual quality of the resulting image, and b) decoding execution
        time. This function sets the level of that tradeoff for image formats
        that support it.

        In case of scaled image reading, the quality setting may also influence
        the tradeoff level between visual quality and execution speed of the
        scaling algorithm.

        The value range of **quality** depends on the image format. For example,
        the "jpeg" format supports a quality range from 0 (low visual quality)
        to 100 (high visual quality).

        **See also** **quality** () and **setScaledSize** ().
        """
        ...

    def setScaledClipRect(self, rect: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setScaledClipRect

        **void QImageReader::setScaledClipRect(const QRect & rect )**

        Sets the scaled clip rect to **rect**. The scaled clip rect is the clip
        rect (also known as ROI, or Region Of Interest) that is applied after
        the image has been scaled.

        **See also** **scaledClipRect** () and **setScaledSize** ().
        """
        ...

    def setScaledSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qimagereader.html#setScaledSize

        **void QImageReader::setScaledSize(const QSize & size )**

        Sets the scaled size of the image to **size**. The scaling is performed
        after the initial clip rect, but before the scaled clip rect is applied.
        The algorithm used for scaling depends on the image format. By default
        (i.e., if the image format does not support scaling), **QImageReader**
        will use QImage::scale() with Qt::SmoothScaling.

        **See also** **scaledSize** (), **setClipRect** (), and
        **setScaledClipRect** ().
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qimagereader.html#size

        **QSize QImageReader::size() const**

        Returns the size of the image, without actually reading the image
        contents.

        If the image format does not support this feature, this function returns
        an invalid size. Qt's built-in image handlers all support this feature,
        but custom image format plugins are not required to do so.

        **See also** **QImageIOHandler::ImageOption** ,
        **QImageIOHandler::option** (), and **QImageIOHandler::supportsOption**
        ().
        """
        ...

    def subType(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qimagereader.html#subType

        **[since 5.4] QByteArray QImageReader::subType() const**

        Returns the subtype of the image.

        This function was introduced in Qt 5.4.
        """
        ...

    @staticmethod
    def supportedImageFormats() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagereader.html#supportedImageFormats

        **[static] QList<QByteArray> QImageReader::supportedImageFormats()**

        Returns the list of image formats supported by **QImageReader** .

        By default, Qt can read the following formats:

        FormatMIME typeDescription
        BMPimage/bmpWindows Bitmap
        GIFimage/gifGraphic Interchange Format (optional)
        JPGimage/jpegJoint
        Photographic Experts Group
        PNGimage/pngPortable Network Graphics
        PBMimage/x-portable-bitmapPortable Bitmap
        PGMimage/x-portable-
        graymapPortable Graymap
        PPMimage/x-portable-pixmapPortable Pixmap
        XBMimage/x-xbitmapX11 Bitmap
        XPMimage/x-xpixmapX11 Pixmap
        SVGimage/svg+xmlScalable Vector Graphics

        Reading and writing SVG files is supported through the **Qt SVG**
        module. The **Qt Image Formats**  module provides support for additional
        image formats.

        Note that the **QApplication**  instance must be created before this
        function is called.

        **See also** **setFormat** (), **QImageWriter::supportedImageFormats**
        (), and **QImageIOPlugin** .
        """
        ...

    @staticmethod
    def supportedMimeTypes() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagereader.html#supportedMimeTypes

        **[static] QList<QByteArray> QImageReader::supportedMimeTypes()**

        Returns the list of MIME types supported by **QImageReader** .

        Note that the **QApplication**  instance must be created before this
        function is called.

        **See also** **supportedImageFormats** () and
        **QImageWriter::supportedMimeTypes** ().
        """
        ...

    def supportedSubTypes(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qimagereader.html#supportedSubTypes

        **[since 5.4] QList<QByteArray> QImageReader::supportedSubTypes()
        const**

        Returns the list of subtypes supported by an image.

        This function was introduced in Qt 5.4.
        """
        ...

    def supportsAnimation(self) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#supportsAnimation

        **bool QImageReader::supportsAnimation() const**

        Returns `true` if the image format supports animation; otherwise, false
        is returned.

        **See also** **QMovie::supportedFormats** ().
        """
        ...

    def supportsOption(self, option: PySide6.QtGui.QImageIOHandler.ImageOption) -> bool:
        """
        https://doc.qt.io/qt-6/qimagereader.html#supportsOption

        **bool QImageReader::supportsOption(QImageIOHandler::ImageOption option
        ) const**

        Returns `true` if the reader supports **option** ; otherwise returns
        false.

        Different image formats support different options. Call this function to
        determine whether a certain option is supported by the current format.
        For example, the PNG format allows you to embed text into the image's
        metadata (see **text** ()), and the BMP format allows you to determine
        the image's size without loading the whole image into memory (see
        **size** ()).

        **QImageReader**  reader(":/image.png");
            if
        (reader.supportsOption(**QImageIOHandler** ::Size))
                **qDebug**
        () << "Size:" << reader.size();

        **See also** **QImageWriter::supportsOption** ().
        """
        ...

    def text(self, key: str) -> str:
        """
        https://doc.qt.io/qt-6/qimagereader.html#text

        **QString QImageReader::text(const QString & key ) const**

        Returns the image text associated with **key**.

        Support for this option is implemented through
        **QImageIOHandler::Description** .

        **See also** **textKeys** () and **QImageWriter::setText** ().
        """
        ...

    def textKeys(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qimagereader.html#textKeys

        **QStringList QImageReader::textKeys() const**

        Returns the text keys for this image. You can use these keys with
        **text** () to list the image text for a certain key.

        Support for this option is implemented through
        **QImageIOHandler::Description** .

        **See also** **text** (), **QImageWriter::setText** (), and
        **QImage::textKeys** ().
        """
        ...

    def transformation(self) -> PySide6.QtGui.QImageIOHandler.Transformations:
        """
        https://doc.qt.io/qt-6/qimagereader.html#transformation

        **[since 5.5] QImageIOHandler::Transformations
        QImageReader::transformation() const**

        Returns the transformation metadata of the image, including image
        orientation. If the format does not support transformation metadata,
        **QImageIOHandler::TransformationNone**  is returned.

        This function was introduced in Qt 5.5.

        **See also** **setAutoTransform** () and **autoTransform** ().
        """
        ...
