"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QFontDatabase(object):
    """
    https://doc.qt.io/qt-6/qfontdatabase.html

    **Detailed Description**

    The most common uses of this class are to query the database for the list of
    font **families** () and for the **pointSizes** () and **styles** () that
    are available for each family. An alternative to **pointSizes** () is
    **smoothSizes** () which returns the sizes at which a given family and style
    will look attractive.

    If the font family is available from two or more foundries the foundry name
    is included in the family name; for example: "Helvetica [Adobe]" and
    "Helvetica [Cronyx]". When you specify a family, you can either use the old
    hyphenated "foundry-family" format or the bracketed "family [foundry]"
    format; for example: "Cronyx-Helvetica" or "Helvetica [Cronyx]". If the
    family has a foundry it is always returned using the bracketed format, as is
    the case with the value returned by **families** ().

    The **font** () function returns a **QFont**  given a family, style and
    point size.

    A family and style combination can be checked to see if it is **italic** ()
    or **bold** (), and to retrieve its **weight** (). Similarly we can call
    **isBitmapScalable** (), **isSmoothlyScalable** (), **isScalable** () and
    **isFixedPitch** ().

    Use the **styleString** () to obtain a text version of a style.

    The QFontDatabase class provides some helper functions, for example,
    **standardSizes** (). You can retrieve the description of a writing system
    using **writingSystemName** (), and a sample of characters in a writing
    system with **writingSystemSample** ().

    Example:

    **QTreeWidget**  fontTree;
        fontTree.setColumnCount(2);
    fontTree.setHeaderLabels(**QStringList** () << "Font" << "Smooth Sizes");
    const **QStringList**  fontFamilies = **QFontDatabase** ::families();
    for (const **QString**  &family : fontFamilies) {
    **QTreeWidgetItem**  *familyItem = new **QTreeWidgetItem** (&fontTree);
    familyItem->setText(0, family);

            const **QStringList**
    fontStyles = **QFontDatabase** ::styles(family);
            for (const
    **QString**  &style : fontStyles) {
                **QTreeWidgetItem**
    *styleItem = new **QTreeWidgetItem** (familyItem);
    styleItem->setText(0, style);

                **QString**  sizes;
    const **QList** <int> smoothSizes = **QFontDatabase** ::smoothSizes(family,
    style);
                for (const auto &points : smoothSizes)
    sizes += **QString** ::number(points) + ' ';
    styleItem->setText(1, sizes.trimmed());
            }
        }

    This example gets the list of font families, the list of styles for each
    family, and the point sizes that are available for each combination of
    family and style, displaying this information in a tree view.

    **See also** **QFont** , **QFontInfo** , **QFontMetrics** , and **Character
    Map Example** .
    """

    GeneralFont: QFontDatabase.SystemFont = ...
    FixedFont: QFontDatabase.SystemFont = ...
    TitleFont: QFontDatabase.SystemFont = ...
    SmallestReadableFont: QFontDatabase.SystemFont = ...
    Any: QFontDatabase.WritingSystem = ...
    Latin: QFontDatabase.WritingSystem = ...
    Greek: QFontDatabase.WritingSystem = ...
    Cyrillic: QFontDatabase.WritingSystem = ...
    Armenian: QFontDatabase.WritingSystem = ...
    Hebrew: QFontDatabase.WritingSystem = ...
    Arabic: QFontDatabase.WritingSystem = ...
    Syriac: QFontDatabase.WritingSystem = ...
    Thaana: QFontDatabase.WritingSystem = ...
    Devanagari: QFontDatabase.WritingSystem = ...
    Bengali: QFontDatabase.WritingSystem = ...
    Gurmukhi: QFontDatabase.WritingSystem = ...
    Gujarati: QFontDatabase.WritingSystem = ...
    Oriya: QFontDatabase.WritingSystem = ...
    Tamil: QFontDatabase.WritingSystem = ...
    Telugu: QFontDatabase.WritingSystem = ...
    Kannada: QFontDatabase.WritingSystem = ...
    Malayalam: QFontDatabase.WritingSystem = ...
    Sinhala: QFontDatabase.WritingSystem = ...
    Thai: QFontDatabase.WritingSystem = ...
    Lao: QFontDatabase.WritingSystem = ...
    Tibetan: QFontDatabase.WritingSystem = ...
    Myanmar: QFontDatabase.WritingSystem = ...
    Georgian: QFontDatabase.WritingSystem = ...
    Khmer: QFontDatabase.WritingSystem = ...
    SimplifiedChinese: QFontDatabase.WritingSystem = ...
    TraditionalChinese: QFontDatabase.WritingSystem = ...
    Japanese: QFontDatabase.WritingSystem = ...
    Korean: QFontDatabase.WritingSystem = ...
    Vietnamese: QFontDatabase.WritingSystem = ...
    Other: QFontDatabase.WritingSystem = ...
    Symbol: QFontDatabase.WritingSystem = ...
    Ogham: QFontDatabase.WritingSystem = ...
    Runic: QFontDatabase.WritingSystem = ...
    Nko: QFontDatabase.WritingSystem = ...
    WritingSystemsCount: QFontDatabase.WritingSystem = ...

    class SystemFont(Enum):
        GeneralFont: QFontDatabase.SystemFont = ...
        FixedFont: QFontDatabase.SystemFont = ...
        TitleFont: QFontDatabase.SystemFont = ...
        SmallestReadableFont: QFontDatabase.SystemFont = ...

    class WritingSystem(Enum):
        Any: QFontDatabase.WritingSystem = ...
        Latin: QFontDatabase.WritingSystem = ...
        Greek: QFontDatabase.WritingSystem = ...
        Cyrillic: QFontDatabase.WritingSystem = ...
        Armenian: QFontDatabase.WritingSystem = ...
        Hebrew: QFontDatabase.WritingSystem = ...
        Arabic: QFontDatabase.WritingSystem = ...
        Syriac: QFontDatabase.WritingSystem = ...
        Thaana: QFontDatabase.WritingSystem = ...
        Devanagari: QFontDatabase.WritingSystem = ...
        Bengali: QFontDatabase.WritingSystem = ...
        Gurmukhi: QFontDatabase.WritingSystem = ...
        Gujarati: QFontDatabase.WritingSystem = ...
        Oriya: QFontDatabase.WritingSystem = ...
        Tamil: QFontDatabase.WritingSystem = ...
        Telugu: QFontDatabase.WritingSystem = ...
        Kannada: QFontDatabase.WritingSystem = ...
        Malayalam: QFontDatabase.WritingSystem = ...
        Sinhala: QFontDatabase.WritingSystem = ...
        Thai: QFontDatabase.WritingSystem = ...
        Lao: QFontDatabase.WritingSystem = ...
        Tibetan: QFontDatabase.WritingSystem = ...
        Myanmar: QFontDatabase.WritingSystem = ...
        Georgian: QFontDatabase.WritingSystem = ...
        Khmer: QFontDatabase.WritingSystem = ...
        SimplifiedChinese: QFontDatabase.WritingSystem = ...
        TraditionalChinese: QFontDatabase.WritingSystem = ...
        Japanese: QFontDatabase.WritingSystem = ...
        Korean: QFontDatabase.WritingSystem = ...
        Vietnamese: QFontDatabase.WritingSystem = ...
        Other: QFontDatabase.WritingSystem = ...
        Symbol: QFontDatabase.WritingSystem = ...
        Ogham: QFontDatabase.WritingSystem = ...
        Runic: QFontDatabase.WritingSystem = ...
        Nko: QFontDatabase.WritingSystem = ...
        WritingSystemsCount: QFontDatabase.WritingSystem = ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, QFontDatabase: PySide6.QtGui.QFontDatabase) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @staticmethod
    def addApplicationFont(fileName: str) -> int:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#addApplicationFont

        **[static] int QFontDatabase::addApplicationFont(const QString &
        fileName )**

        Loads the font from the file specified by **fileName** and makes it
        available to the application. An ID is returned that can be used to
        remove the font again with **removeApplicationFont** () or to retrieve
        the list of family names contained in the font.

        The function returns -1 if the font could not be loaded.

        Currently only TrueType fonts, TrueType font collections, and OpenType
        fonts are supported.

        **Note:** Adding application fonts on Unix/X11 platforms without
        fontconfig is currently not supported.

        **See also** **addApplicationFontFromData** (),
        **applicationFontFamilies** (), and **removeApplicationFont** ().
        """
        ...

    @staticmethod
    def addApplicationFontFromData(
        fontData: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> int:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#addApplicationFontFromData

        **[static] int QFontDatabase::addApplicationFontFromData(const
        QByteArray & fontData )**

        Loads the font from binary data specified by **fontData** and makes it
        available to the application. An ID is returned that can be used to
        remove the font again with **removeApplicationFont** () or to retrieve
        the list of family names contained in the font.

        The function returns -1 if the font could not be loaded.

        Currently only TrueType fonts and TrueType font collections are
        supported.

        **Note:** Adding application fonts on Unix/X11 platforms without
        fontconfig is currently not supported.

        **See also** **addApplicationFont** (), **applicationFontFamilies** (),
        and **removeApplicationFont** ().
        """
        ...

    @staticmethod
    def applicationFontFamilies(id: int) -> List[str]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#applicationFontFamilies

        **[static] QStringList QFontDatabase::applicationFontFamilies(int id )**

        Returns a list of font families for the given application font
        identified by **id**.

        **See also** **addApplicationFont** () and
        **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def bold(family: str, style: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#bold

        **[static] bool QFontDatabase::bold(const QString & family , const
        QString & style )**

        Returns `true` if the font that has family **family** and style
        **style** is bold; otherwise returns `false`.

        **See also** **italic** () and **weight** ().
        """
        ...

    @staticmethod
    def families(
        writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem = ...,
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#families

        **[static] QStringList
        QFontDatabase::families(QFontDatabase::WritingSystem writingSystem =
        Any)**

        Returns a sorted list of the available font families which support the
        **writingSystem**.

        If a family exists in several foundries, the returned name for that font
        is in the form "family [foundry]". Examples: "Times [Adobe]", "Times
        [Cronyx]", "Palatino".

        **See also** **writingSystems** ().
        """
        ...

    @staticmethod
    def font(family: str, style: str, pointSize: int) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#font

        **[static] QFont QFontDatabase::font(const QString & family , const
        QString & style , int pointSize )**

        Returns a **QFont**  object that has family **family** , style **style**
        and point size **pointSize**. If no matching font could be created, a
        **QFont**  object that uses the application's default font is returned.
        """
        ...

    @staticmethod
    def hasFamily(family: str) -> bool:
        ...

    @staticmethod
    def isBitmapScalable(family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#isBitmapScalable

        **[static] bool QFontDatabase::isBitmapScalable(const QString & family ,
        const QString & style = QString())**

        Returns `true` if the font that has family **family** and style
        **style** is a scalable bitmap font; otherwise returns `false`. Scaling
        a bitmap font usually produces an unattractive hardly readable result,
        because the pixels of the font are scaled. If you need to scale a bitmap
        font it is better to scale it to one of the fixed sizes returned by
        **smoothSizes** ().

        **See also** **isScalable** () and **isSmoothlyScalable** ().
        """
        ...

    @staticmethod
    def isFixedPitch(family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#isFixedPitch

        **[static] bool QFontDatabase::isFixedPitch(const QString & family ,
        const QString & style = QString())**

        Returns `true` if the font that has family **family** and style
        **style** is fixed pitch; otherwise returns `false`.
        """
        ...

    @staticmethod
    def isPrivateFamily(family: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#isPrivateFamily

        **[static, since 5.5] bool QFontDatabase::isPrivateFamily(const QString
        & family )**

        Returns `true` if and only if the **family** font family is private.

        This happens, for instance, on macOS and iOS, where the system UI fonts
        are not accessible to the user. For completeness,
        **QFontDatabase::families** () returns all font families, including the
        private ones. You should use this function if you are developing a font
        selection control in order to keep private fonts hidden.

        This function was introduced in Qt 5.5.

        **See also** **families** ().
        """
        ...

    @staticmethod
    def isScalable(family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#isScalable

        **[static] bool QFontDatabase::isScalable(const QString & family , const
        QString & style = QString())**

        Returns `true` if the font that has family **family** and style
        **style** is scalable; otherwise returns `false`.

        **See also** **isBitmapScalable** () and **isSmoothlyScalable** ().
        """
        ...

    @staticmethod
    def isSmoothlyScalable(family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#isSmoothlyScalable

        **[static] bool QFontDatabase::isSmoothlyScalable(const QString & family
        , const QString & style = QString())**

        Returns `true` if the font that has family **family** and style
        **style** is smoothly scalable; otherwise returns `false`. If this
        function returns `true`, it's safe to scale this font to any size, and
        the result will always look attractive.

        **See also** **isScalable** () and **isBitmapScalable** ().
        """
        ...

    @staticmethod
    def italic(family: str, style: str) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#italic

        **[static] bool QFontDatabase::italic(const QString & family , const
        QString & style )**

        Returns `true` if the font that has family **family** and style
        **style** is italic; otherwise returns `false`.

        **See also** **weight** () and **bold** ().
        """
        ...

    @staticmethod
    def pointSizes(family: str, style: str = ...) -> List[int]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#pointSizes

        **[static] QList<int> QFontDatabase::pointSizes(const QString & family ,
        const QString & styleName = QString())**

        Returns a list of the point sizes available for the font that has family
        **family** and style **styleName**. The list may be empty.

        **See also** **smoothSizes** () and **standardSizes** ().
        """
        ...

    @staticmethod
    def removeAllApplicationFonts() -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#removeAllApplicationFonts

        **[static] bool QFontDatabase::removeAllApplicationFonts()**

        Removes all application-local fonts previously added using
        **addApplicationFont** () and **addApplicationFontFromData** ().

        Returns `true` if unloading of the fonts succeeded; otherwise returns
        `false`.

        **See also** **removeApplicationFont** (), **addApplicationFont** (),
        and **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def removeApplicationFont(id: int) -> bool:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#removeApplicationFont

        **[static] bool QFontDatabase::removeApplicationFont(int id )**

        Removes the previously loaded application font identified by **id**.
        Returns `true` if unloading of the font succeeded; otherwise returns
        `false`.

        **See also** **removeAllApplicationFonts** (), **addApplicationFont**
        (), and **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def smoothSizes(family: str, style: str) -> List[int]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#smoothSizes

        **[static] QList<int> QFontDatabase::smoothSizes(const QString & family
        , const QString & styleName )**

        Returns the point sizes of a font that has family **family** and style
        **styleName** that will look attractive. The list may be empty. For non-
        scalable fonts and bitmap scalable fonts, this function is equivalent to
        **pointSizes** ().

        **See also** **pointSizes** () and **standardSizes** ().
        """
        ...

    @staticmethod
    def standardSizes() -> List[int]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#standardSizes

        **[static] QList<int> QFontDatabase::standardSizes()**

        Returns a list of standard font sizes.

        **See also** **smoothSizes** () and **pointSizes** ().
        """
        ...

    @overload
    @staticmethod
    def styleString(font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> str:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#styleString

        **[static] QString QFontDatabase::styleString(const QFont & font )**

        Returns a string that describes the style of the **font**. For example,
        "Bold Italic", "Bold", "Italic" or "Normal". An empty string may be
        returned.
        """
        ...

    @overload
    @staticmethod
    def styleString(
        fontInfo: Union[PySide6.QtGui.QFontInfo, PySide6.QtGui.QFont]
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#styleString-1

        **[static] QString QFontDatabase::styleString(const QFontInfo & fontInfo
        )**

        Returns a string that describes the style of the **fontInfo**. For
        example, "Bold Italic", "Bold", "Italic" or "Normal". An empty string
        may be returned.
        """
        ...

    @staticmethod
    def styles(family: str) -> List[str]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#styles

        **[static] QStringList QFontDatabase::styles(const QString & family )**

        Returns a list of the styles available for the font family **family**.
        Some example styles: "Light", "Light Italic", "Bold", "Oblique", "Demi".
        The list may be empty.

        **See also** **families** ().
        """
        ...

    @staticmethod
    def systemFont(type: PySide6.QtGui.QFontDatabase.SystemFont) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#systemFont

        **[static, since 5.2] QFont
        QFontDatabase::systemFont(QFontDatabase::SystemFont type )**

        Returns the most adequate font for a given **type** case for proper
        integration with the system's look and feel.

        This function was introduced in Qt 5.2.

        **See also** **QGuiApplication::font** ().
        """
        ...

    @staticmethod
    def weight(family: str, style: str) -> int:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#weight

        **[static] int QFontDatabase::weight(const QString & family , const
        QString & style )**

        Returns the weight of the font that has family **family** and style
        **style**. If there is no such family and style combination, returns -1.

        **See also** **italic** () and **bold** ().
        """
        ...

    @staticmethod
    def writingSystemName(
        writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#writingSystemName

        **[static] QString
        QFontDatabase::writingSystemName(QFontDatabase::WritingSystem
        writingSystem )**

        Returns the names the **writingSystem** (e.g. for displaying to the user
        in a dialog).
        """
        ...

    @staticmethod
    def writingSystemSample(
        writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#writingSystemSample

        **[static] QString
        QFontDatabase::writingSystemSample(QFontDatabase::WritingSystem
        writingSystem )**

        Returns a string with sample characters from **writingSystem**.
        """
        ...

    @overload
    @staticmethod
    def writingSystems() -> List[PySide6.QtGui.QFontDatabase.WritingSystem]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#writingSystems

        **[static] QList<QFontDatabase::WritingSystem>
        QFontDatabase::writingSystems()**

        Returns a sorted list of the available writing systems. This is list
        generated from information about all installed fonts on the system.

        **See also** **families** ().
        """
        ...

    @overload
    @staticmethod
    def writingSystems(family: str) -> List[PySide6.QtGui.QFontDatabase.WritingSystem]:
        """
        https://doc.qt.io/qt-6/qfontdatabase.html#writingSystems-1

        **[static] QList<QFontDatabase::WritingSystem>
        QFontDatabase::writingSystems(const QString & family )**

        Returns a sorted list of the writing systems supported by a given font
        **family**.

        **See also** **families** ().
        """
        ...
