"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QExposeEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qexposeevent.html

    **Detailed Description**

    Expose events are sent to windows when they move between the un-exposed and
    exposed states.

    An exposed window is potentially visible to the user. If the window is moved
    off screen, is made totally obscured by another window, is minimized, or
    similar, an expose event is sent to the window, and isExposed() might change
    to false.

    Expose events should not be used to paint. Handle **QPaintEvent**  instead.

    The event handler **QWindow::exposeEvent** () receives expose events.
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QExposeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qexposeevent.html#QExposeEvent-2

        **QExposeEvent::QExposeEvent(const QRegion & exposeRegion )**

        Constructs an expose event for the given **exposeRegion** which must be
        in local coordinates.
        """
        ...

    @overload
    def __init__(
        self,
        m_region: Union[
            PySide6.QtGui.QRegion,
            PySide6.QtGui.QBitmap,
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRect,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qexposeevent.html#QExposeEvent-2

        **QExposeEvent::QExposeEvent(const QRegion & exposeRegion )**

        Constructs an expose event for the given **exposeRegion** which must be
        in local coordinates.
        """
        ...

    def clone(self) -> PySide6.QtGui.QExposeEvent:
        ...

    def region(self) -> PySide6.QtGui.QRegion:
        ...
