"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QEventPoint(object):
    """
    https://doc.qt.io/qt-6/qeventpoint.html

    **Detailed Description**
    """

    Unknown: QEventPoint.State = ...
    Pressed: QEventPoint.State = ...
    Updated: QEventPoint.State = ...
    Stationary: QEventPoint.State = ...
    Released: QEventPoint.State = ...

    class State(Enum):
        Unknown: QEventPoint.State = ...
        Pressed: QEventPoint.State = ...
        Updated: QEventPoint.State = ...
        Stationary: QEventPoint.State = ...
        Released: QEventPoint.State = ...

    @overload
    def __init__(
        self, id: int = ..., device: Optional[PySide6.QtGui.QPointingDevice] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#QEventPoint-1

        **QEventPoint::QEventPoint(int pointId , QEventPoint::State state ,
        const QPointF & scenePosition , const QPointF & globalPosition )**

        Constructs an event point with the given **pointId** , **state** ,
        **scenePosition** and **globalPosition**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtGui.QEventPoint) -> None:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#QEventPoint-2

        **QEventPoint::QEventPoint(const QEventPoint & other )**

        Constructs an event point by making a shallow copy of **other**.
        """
        ...

    @overload
    def __init__(
        self,
        pointId: int,
        state: PySide6.QtGui.QEventPoint.State,
        scenePosition: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPosition: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#QEventPoint-3

        **QEventPoint::QEventPoint(QEventPoint && other )**

        Constructs an event point by moving **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def device(self) -> PySide6.QtGui.QPointingDevice:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#device-prop

        **[read-only] device : QPointingDevice* const**

        This property holds the pointing device from which this event point
        originates.

        **Access functions:**

        const QPointingDevice * ****device** ** () const
        """
        ...

    def ellipseDiameters(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#ellipseDiameters-prop

        **[read-only] ellipseDiameters : const QSizeF**

        This property holds the width and height of the bounding ellipse of the
        touch point.

        The return value is in logical pixels. Most touchscreens do not detect
        the shape of the contact point, and no mice or tablet devices can detect
        it, so a null size is the most common value. On some touchscreens the
        diameters may be nonzero and always equal (the ellipse is approximated
        as a circle).

        **Access functions:**

        QSizeF **ellipseDiameters** () const
        """
        ...

    def globalGrabPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#globalGrabPosition-prop

        **[read-only] globalGrabPosition : const QPointF**

        This property holds the global position at which this point was grabbed.

        The global position is relative to the screen or virtual desktop.

        **Access functions:**

        QPointF **globalGrabPosition** () const

        **See also** **globalPosition** , **grabPosition** , and
        **sceneGrabPosition** .
        """
        ...

    def globalLastPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#globalLastPosition-prop

        **[read-only] globalLastPosition : const QPointF**

        This property holds the global position of this point from the previous
        press or move event.

        The global position is relative to the screen or virtual desktop.

        **Access functions:**

        QPointF **globalLastPosition** () const

        **See also** **globalPosition** , **lastPosition** , and
        **sceneLastPosition** .
        """
        ...

    def globalPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#globalPosition-prop

        **[read-only] globalPosition : const QPointF**

        This property holds the global position of this point.

        The global position is relative to the screen or virtual desktop.

        **Access functions:**

        QPointF **globalPosition** () const

        **See also** **globalPressPosition** , **position** , and
        **scenePosition** .
        """
        ...

    def globalPressPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#globalPressPosition-prop

        **[read-only] globalPressPosition : const QPointF**

        This property holds the global position at which this point was pressed.

        The global position is relative to the screen or virtual desktop.

        **Access functions:**

        QPointF **globalPressPosition** () const

        **See also** **globalPosition** , **pressPosition** , and
        **scenePressPosition** .
        """
        ...

    def grabPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#grabPosition-prop

        **[read-only] grabPosition : const QPointF**

        This property holds the position at which this point was grabbed.

        The position is relative to the widget or item that received the event.

        **Access functions:**

        QPointF **grabPosition** () const

        **See also** **position** .
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#id-prop

        **[read-only] id : const int**

        This property holds the ID number of this event point.

        **Note:** Do not assume that ID numbers start at zero or that they are
        sequential. Such an assumption is often false due to the way the
        underlying drivers work.

        **Access functions:**

        int **id** () const
        """
        ...

    def isAccepted(self) -> bool:
        ...

    def lastNormalizedPos(self) -> PySide6.QtCore.QPointF:
        ...

    def lastPos(self) -> PySide6.QtCore.QPointF:
        ...

    def lastPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#lastPosition-prop

        **[read-only] lastPosition : const QPointF**

        This property holds the position of this point from the previous press
        or move event.

        The position is relative to the widget or item that received the event.

        **Access functions:**

        QPointF **lastPosition** () const

        **See also** **position**  and **pressPosition** .
        """
        ...

    def lastScenePos(self) -> PySide6.QtCore.QPointF:
        ...

    def lastScreenPos(self) -> PySide6.QtCore.QPointF:
        ...

    def lastTimestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#lastTimestamp-prop

        **[read-only] lastTimestamp : const ulong**

        This property holds the time from the previous **QPointerEvent**  that
        contained this point.

        **Access functions:**

        ulong **lastTimestamp** () const

        **See also** **globalLastPosition** .
        """
        ...

    def normalizedPos(self) -> PySide6.QtCore.QPointF:
        ...

    def normalizedPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#normalizedPosition

        **QPointF QEventPoint::normalizedPosition() const**

        Returns the normalized position of this point.

        The coordinates are calculated by transforming **globalPosition** ()
        into the space of **QInputDevice::availableVirtualGeometry** (), i.e.
        `(0, 0)` is the top-left corner and `(1, 1)` is the bottom-right corner.

        **See also** **globalPosition** .
        """
        ...

    def pos(self) -> PySide6.QtCore.QPointF:
        ...

    def position(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#position-prop

        **[read-only] position : const QPointF**

        This property holds the position of this point.

        The position is relative to the widget or item that received the event.

        **Access functions:**

        QPointF **position** () const
        """
        ...

    def pressPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#pressPosition-prop

        **[read-only] pressPosition : const QPointF**

        This property holds the position at which this point was pressed.

        The position is relative to the widget or item that received the event.

        **Access functions:**

        QPointF **pressPosition** () const

        **See also** **position** .
        """
        ...

    def pressTimestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#pressTimestamp-prop

        **[read-only] pressTimestamp : const ulong**

        This property holds the most recent time at which this point was
        pressed.

        **Access functions:**

        ulong **pressTimestamp** () const

        **See also** **timestamp** .
        """
        ...

    def pressure(self) -> float:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#pressure-prop

        **[read-only] pressure : const qreal**

        This property holds the pressure of this point.

        The return value is in the range `0.0` to `1.0`.

        **Access functions:**

        qreal **pressure** () const
        """
        ...

    def rotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#rotation-prop

        **[read-only] rotation : const qreal**

        This property holds the angular orientation of this point.

        The return value is in degrees, where zero (the default) indicates the
        finger, token or stylus is pointing upwards, a negative angle means it's
        rotated to the left, and a positive angle means it's rotated to the
        right. Most touchscreens do not detect rotation, so zero is the most
        common value.

        **Access functions:**

        qreal **rotation** () const
        """
        ...

    def sceneGrabPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#sceneGrabPosition-prop

        **[read-only] sceneGrabPosition : const QPointF**

        This property holds the scene position at which this point was grabbed.

        The scene position is the position relative to **QQuickWindow**  if
        handled in **QQuickItem::event** (), in **QGraphicsScene**  coordinates
        if handled by an override of QGraphicsItem::touchEvent(), or the window
        position in widget applications.

        **Access functions:**

        QPointF **sceneGrabPosition** () const

        **See also** **scenePosition** , **grabPosition** , and
        **globalGrabPosition** .
        """
        ...

    def sceneLastPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#sceneLastPosition-prop

        **[read-only] sceneLastPosition : const QPointF**

        This property holds the scene position of this point from the previous
        press or move event.

        The scene position is the position relative to **QQuickWindow**  if
        handled in **QQuickItem::event** (), in **QGraphicsScene**  coordinates
        if handled by an override of QGraphicsItem::touchEvent(), or the window
        position in widget applications.

        **Access functions:**

        QPointF **sceneLastPosition** () const

        **See also** **scenePosition**  and **scenePressPosition** .
        """
        ...

    def scenePos(self) -> PySide6.QtCore.QPointF:
        ...

    def scenePosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#scenePosition-prop

        **[read-only] scenePosition : const QPointF**

        This property holds the scene position of this point.

        The scene position is the position relative to **QQuickWindow**  if
        handled in **QQuickItem::event** (), in **QGraphicsScene**  coordinates
        if handled by an override of QGraphicsItem::touchEvent(), or the window
        position in widget applications.

        **Access functions:**

        QPointF **scenePosition** () const

        **See also** **scenePressPosition** , **position** , and
        **globalPosition** .
        """
        ...

    def scenePressPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#scenePressPosition-prop

        **[read-only] scenePressPosition : const QPointF**

        This property holds the scene position at which this point was pressed.

        The scene position is the position relative to **QQuickWindow**  if
        handled in **QQuickItem::event** (), in **QGraphicsScene**  coordinates
        if handled by an override of QGraphicsItem::touchEvent(), or the window
        position in widget applications.

        **Access functions:**

        QPointF **scenePressPosition** () const

        **See also** **scenePosition** , **pressPosition** , and
        **globalPressPosition** .
        """
        ...

    def screenPos(self) -> PySide6.QtCore.QPointF:
        ...

    def setAccepted(self, accepted: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#accepted-prop

        **accepted : bool**

        This property holds the accepted state of the event point.

        In widget-based applications, this property is not used, as it's only
        meaningful for a widget to accept or reject a complete **QInputEvent** .

        In Qt Quick however, it's normal for an Item or Event Handler to accept
        only the individual points in a **QTouchEvent**  that are actually
        participating in a gesture, while other points can be delivered to other
        items or handlers. For the sake of consistency, that applies to any
        **QPointerEvent** ; and delivery is done only when all points in a
        **QPointerEvent**  have been accepted.

        **Access functions:**

        bool **isAccepted** () const
        void **setAccepted** (bool **accepted** =
        true)

        **See also** **QEvent::accepted** .
        """
        ...

    def startNormalizedPos(self) -> PySide6.QtCore.QPointF:
        ...

    def startPos(self) -> PySide6.QtCore.QPointF:
        ...

    def startScenePos(self) -> PySide6.QtCore.QPointF:
        ...

    def startScreenPos(self) -> PySide6.QtCore.QPointF:
        ...

    def state(self) -> PySide6.QtGui.QEventPoint.State:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#state-prop

        **[read-only] state : const State**

        This property holds the current state of the event point.

        **Access functions:**

        QEventPoint::State **state** () const
        """
        ...

    def swap(self, other: PySide6.QtGui.QEventPoint) -> None:
        ...

    def timeHeld(self) -> float:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#timeHeld-prop

        **[read-only] timeHeld : const qreal**

        This property holds the duration, in milliseconds, since this point was
        pressed and not released.

        **Access functions:**

        qreal **timeHeld** () const

        **See also** **pressTimestamp**  and **timestamp** .
        """
        ...

    def timestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#timestamp-prop

        **[read-only] timestamp : const ulong**

        This property holds the most recent time at which this point was
        included in a **QPointerEvent** .

        **Access functions:**

        ulong **timestamp** () const

        **See also** **QPointerEvent::timestamp** ().
        """
        ...

    def uniqueId(self) -> PySide6.QtGui.QPointingDeviceUniqueId:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#uniqueId-prop

        **[read-only] uniqueId : const QPointingDeviceUniqueId**

        This property holds the unique ID of this point or token, if any.

        It is often invalid (see **isValid** ()), because touchscreens cannot
        uniquely identify fingers.

        When it comes from a **QTabletEvent** , it identifies the serial number
        of the stylus in use.

        It may identify a specific token (fiducial object) when the TUIO driver
        is in use with a touchscreen that supports them.

        **Access functions:**

        QPointingDeviceUniqueId **uniqueId** () const
        """
        ...

    def velocity(self) -> PySide6.QtGui.QVector2D:
        """
        https://doc.qt.io/qt-6/qeventpoint.html#velocity-prop

        **[read-only] velocity : const QVector2D**

        This property holds a velocity vector, in units of pixels per second, in
        the coordinate. system of the screen or desktop.

        **Note:** If the device's capabilities include
        **QInputDevice::Velocity** , it means velocity comes from the operating
        system (perhaps the touch hardware or driver provides it). But usually
        the `Velocity` capability is not set, indicating that the velocity is
        calculated by Qt, using a simple Kalman filter to provide a smoothed
        average velocity rather than an instantaneous value. Effectively it
        tells how fast and in what direction the user has been dragging this
        point over the last few events, with the most recent event having the
        strongest influence.

        **Access functions:**

        QVector2D **velocity** () const

        **See also** **QInputDevice::capabilities** () and
        **QInputEvent::device** ().

        **Member Function Documentation**
        """
        ...
