"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QEnterEvent(PySide6.QtGui.QSinglePointEvent):
    """
    https://doc.qt.io/qt-6/qenterevent.html

    **Detailed Description**

    Enter events occur when the mouse cursor enters a window or a widget.
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QEnterEvent) -> None:
        """
        https://doc.qt.io/qt-6/qenterevent.html#QEnterEvent-2

        **QEnterEvent::QEnterEvent(const QPointF & localPos , const QPointF &
        scenePos , const QPointF & globalPos , const QPointingDevice * device =
        QPointingDevice::primaryPointingDevice())**

        Constructs an enter event object originating from **device**.

        The points **localPos** , **scenePos** and **globalPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen or desktop, respectively.
        """
        ...

    @overload
    def __init__(
        self,
        localPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        scenePos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        globalPos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        device: PySide6.QtGui.QPointingDevice = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qenterevent.html#QEnterEvent-2

        **QEnterEvent::QEnterEvent(const QPointF & localPos , const QPointF &
        scenePos , const QPointF & globalPos , const QPointingDevice * device =
        QPointingDevice::primaryPointingDevice())**

        Constructs an enter event object originating from **device**.

        The points **localPos** , **scenePos** and **globalPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen or desktop, respectively.
        """
        ...

    def clone(self) -> PySide6.QtGui.QEnterEvent:
        ...

    def globalPos(self) -> PySide6.QtCore.QPoint:
        ...

    def globalX(self) -> int:
        ...

    def globalY(self) -> int:
        ...

    def localPos(self) -> PySide6.QtCore.QPointF:
        ...

    def pos(self) -> PySide6.QtCore.QPoint:
        ...

    def screenPos(self) -> PySide6.QtCore.QPointF:
        ...

    def windowPos(self) -> PySide6.QtCore.QPointF:
        ...

    def x(self) -> int:
        ...

    def y(self) -> int:
        ...
