"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QDropEvent(PySide6.QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qdropevent.html

    **Detailed Description**

    When a widget **accepts drop events** , it will receive this event if it has
    accepted the most recent **QDragEnterEvent**  or **QDragMoveEvent**  sent to
    it.

    The drop event contains a proposed action, available from **proposedAction**
    (), for the widget to either accept or ignore. If the action can be handled
    by the widget, you should call the **acceptProposedAction** () function.
    Since the proposed action can be a combination of **Qt::DropAction**
    values, it may be useful to either select one of these values as a default
    action or ask the user to select their preferred action.

    If the proposed drop action is not suitable, perhaps because your custom
    widget does not support that action, you can replace it with any of the
    **possible drop actions**  by calling **setDropAction** () with your
    preferred action. If you set a value that is not present in the bitwise OR
    combination of values returned by **possibleActions** (), the default copy
    action will be used. Once a replacement drop action has been set, call
    **accept** () instead of **acceptProposedAction** () to complete the drop
    operation.

    The **mimeData** () function provides the data dropped on the widget in a
    **QMimeData**  object. This contains information about the MIME type of the
    data in addition to the data itself.

    **See also** **QMimeData** , **QDrag** , and **Drag and Drop** .
    """

    @overload
    def __init__(self, arg__1: PySide6.QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qdropevent.html#QDropEvent-2

        **QDropEvent::QDropEvent(const QPointF & pos , Qt::DropActions actions ,
        const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = Drop)**

        Constructs a drop event of a certain **type** corresponding to a drop at
        the point specified by **pos** in the destination widget's coordinate
        system.

        The **actions** indicate which types of drag and drop operation can be
        performed, and the drag data is stored as MIME-encoded data in **data**.

        The states of the mouse buttons and keyboard modifiers at the time of
        the drop are specified by **buttons** and **modifiers**.
        """
        ...

    @overload
    def __init__(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        actions: PySide6.QtCore.Qt.DropActions,
        data: PySide6.QtCore.QMimeData,
        buttons: PySide6.QtCore.Qt.MouseButtons,
        modifiers: PySide6.QtCore.Qt.KeyboardModifiers,
        type: PySide6.QtCore.QEvent.Type = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdropevent.html#QDropEvent-2

        **QDropEvent::QDropEvent(const QPointF & pos , Qt::DropActions actions ,
        const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = Drop)**

        Constructs a drop event of a certain **type** corresponding to a drop at
        the point specified by **pos** in the destination widget's coordinate
        system.

        The **actions** indicate which types of drag and drop operation can be
        performed, and the drag data is stored as MIME-encoded data in **data**.

        The states of the mouse buttons and keyboard modifiers at the time of
        the drop are specified by **buttons** and **modifiers**.
        """
        ...

    def acceptProposedAction(self) -> None:
        """
        https://doc.qt.io/qt-6/qdropevent.html#acceptProposedAction

        **void QDropEvent::acceptProposedAction()**

        Sets the drop action to be the proposed action.

        **See also** **setDropAction** (), **proposedAction** (), and **accept**
        ().
        """
        ...

    def buttons(self) -> PySide6.QtCore.Qt.MouseButtons:
        ...

    def clone(self) -> PySide6.QtGui.QDropEvent:
        ...

    def dropAction(self) -> PySide6.QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qdropevent.html#dropAction

        **Qt::DropAction QDropEvent::dropAction() const**

        Returns the action to be performed on the data by the target. This may
        be different from the action supplied in **proposedAction** () if you
        have called **setDropAction** () to explicitly choose a drop action.

        **See also** **setDropAction** ().
        """
        ...

    def keyboardModifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        ...

    def mimeData(self) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qdropevent.html#mimeData

        **const QMimeData *QDropEvent::mimeData() const**

        Returns the data that was dropped on the widget and its associated MIME
        type information.
        """
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        ...

    def mouseButtons(self) -> PySide6.QtCore.Qt.MouseButtons:
        ...

    def pos(self) -> PySide6.QtCore.QPoint:
        ...

    def posF(self) -> PySide6.QtCore.QPointF:
        ...

    def position(self) -> PySide6.QtCore.QPointF:
        ...

    def possibleActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qdropevent.html#possibleActions

        **Qt::DropActions QDropEvent::possibleActions() const**

        Returns an OR-combination of possible drop actions.

        **See also** **dropAction** ().
        """
        ...

    def proposedAction(self) -> PySide6.QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qdropevent.html#proposedAction

        **Qt::DropAction QDropEvent::proposedAction() const**

        Returns the proposed drop action.

        **See also** **dropAction** ().
        """
        ...

    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-6/qdropevent.html#setDropAction

        **void QDropEvent::setDropAction(Qt::DropAction action )**

        Sets the **action** to be performed on the data by the target. Use this
        to override the **proposed action**  with one of the **possible
        actions** .

        If you set a drop action that is not one of the possible actions, the
        drag and drop operation will default to a copy operation.

        Once you have supplied a replacement drop action, call **accept** ()
        instead of **acceptProposedAction** ().

        **See also** **dropAction** ().
        """
        ...

    def source(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qdropevent.html#source

        **QObject *QDropEvent::source() const**

        If the source of the drag operation is a widget in this application,
        this function returns that source; otherwise it returns `nullptr`. The
        source of the operation is the first parameter to the **QDrag**  object
        used instantiate the drag.

        This is useful if your widget needs special behavior when dragging to
        itself.

        **See also** **QDrag::QDrag** ().
        """
        ...
