"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtGui, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtGui

bytes = str


class QAccessibleTableModelChangeEvent(PySide6.QtGui.QAccessibleEvent):
    """
    https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html

    **Detailed Description**

    This class is used with **QAccessible::updateAccessibility** ().
    """

    ModelReset: QAccessibleTableModelChangeEvent.ModelChangeType = ...
    DataChanged: QAccessibleTableModelChangeEvent.ModelChangeType = ...
    RowsInserted: QAccessibleTableModelChangeEvent.ModelChangeType = ...
    ColumnsInserted: QAccessibleTableModelChangeEvent.ModelChangeType = ...
    RowsRemoved: QAccessibleTableModelChangeEvent.ModelChangeType = ...
    ColumnsRemoved: QAccessibleTableModelChangeEvent.ModelChangeType = ...

    class ModelChangeType(Enum):
        ModelReset: QAccessibleTableModelChangeEvent.ModelChangeType = ...
        DataChanged: QAccessibleTableModelChangeEvent.ModelChangeType = ...
        RowsInserted: QAccessibleTableModelChangeEvent.ModelChangeType = ...
        ColumnsInserted: QAccessibleTableModelChangeEvent.ModelChangeType = ...
        RowsRemoved: QAccessibleTableModelChangeEvent.ModelChangeType = ...
        ColumnsRemoved: QAccessibleTableModelChangeEvent.ModelChangeType = ...

    @overload
    def __init__(
        self,
        iface: PySide6.QtGui.QAccessibleInterface,
        changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#QAccessible
        TableModelChangeEvent

        **QAccessibleTableModelChangeEvent::QAccessibleTableModelChangeEvent(QOb
        ject * object , QAccessibleTableModelChangeEvent::ModelChangeType
        changeType )**

        Constructs a new QAccessibleTableModelChangeEvent for **object** of with
        **changeType**.
        """
        ...

    @overload
    def __init__(
        self,
        obj: PySide6.QtCore.QObject,
        changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#QAccessible
        TableModelChangeEvent-1

        **QAccessibleTableModelChangeEvent::QAccessibleTableModelChangeEvent(QAc
        cessibleInterface * iface ,
        QAccessibleTableModelChangeEvent::ModelChangeType changeType )**

        Constructs a new QAccessibleTableModelChangeEvent for interface
        **iface** with a model change type **changeType**.
        """
        ...

    def firstColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#firstColumn

        **int QAccessibleTableModelChangeEvent::firstColumn() const**

        Returns the first changed column.

        **See also** **setFirstColumn** ().
        """
        ...

    def firstRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#firstRow

        **int QAccessibleTableModelChangeEvent::firstRow() const**

        Returns the first changed row.

        **See also** **setFirstRow** ().
        """
        ...

    def lastColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#lastColumn

        **int QAccessibleTableModelChangeEvent::lastColumn() const**

        Returns the last changed column.

        **See also** **setLastColumn** ().
        """
        ...

    def lastRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#lastRow

        **int QAccessibleTableModelChangeEvent::lastRow() const**

        Returns the last changed row.

        **See also** **setLastRow** ().
        """
        ...

    def modelChangeType(
        self,
    ) -> PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#modelChange
        Type

        **QAccessibleTableModelChangeEvent::ModelChangeType
        QAccessibleTableModelChangeEvent::modelChangeType() const**

        Returns the type of change.

        **See also** **setModelChangeType** ().
        """
        ...

    def setFirstColumn(self, col: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#setFirstCol
        umn

        **void QAccessibleTableModelChangeEvent::setFirstColumn(int column )**

        Sets the first changed **column**.

        **See also** **firstColumn** ().
        """
        ...

    def setFirstRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#setFirstRow

        **void QAccessibleTableModelChangeEvent::setFirstRow(int row )**

        Sets the first changed **row**.

        **See also** **firstRow** ().
        """
        ...

    def setLastColumn(self, col: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#setLastColu
        mn

        **void QAccessibleTableModelChangeEvent::setLastColumn(int column )**

        Sets the last changed **column**.

        **See also** **lastColumn** ().
        """
        ...

    def setLastRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#setLastRow

        **void QAccessibleTableModelChangeEvent::setLastRow(int row )**

        Sets the last changed **row**.

        **See also** **lastRow** ().
        """
        ...

    def setModelChangeType(
        self, changeType: PySide6.QtGui.QAccessibleTableModelChangeEvent.ModelChangeType
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessibletablemodelchangeevent.html#setModelCha
        ngeType

        **void QAccessibleTableModelChangeEvent::setModelChangeType(QAccessibleT
        ableModelChangeEvent::ModelChangeType changeType )**

        Sets the type of change to **changeType**.

        **See also** **modelChangeType** ().
        """
        ...
