"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import List, Optional, Sequence, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QScatterDataProxy(PySide6.QtDataVisualization.QAbstractDataProxy):
    """
    https://doc.qt.io/qt-6/qscatterdataproxy.html

    **Detailed Description**

    A scatter data proxy handles adding, inserting, changing, and removing data
    items.

    QScatterDataProxy takes ownership of all
    QtDataVisualization::QScatterDataArray and **QScatterDataItem**  objects
    passed to it.

    **See also** **Qt Data Visualization Data Handling** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#QScatterDataProxy

        **QScatterDataProxy::QScatterDataProxy(QObject * parent = nullptr)**

        Constructs QScatterDataProxy with the given **parent**.
        """
        ...

    def addItem(
        self,
        item: Union[
            PySide6.QtDataVisualization.QScatterDataItem, PySide6.QtGui.QVector3D
        ],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#addItem

        **int QScatterDataProxy::addItem(const QScatterDataItem & item )**

        Adds the item **item** to the end of the array.

        Returns the index of the added item.
        """
        ...

    def addItems(
        self, items: Sequence[PySide6.QtDataVisualization.QScatterDataItem]
    ) -> int:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#addItems

        **int QScatterDataProxy::addItems(const QScatterDataArray & items )**

        Adds the items specified by **items** to the end of the array.

        Returns the index of the first added item.
        """
        ...

    def array(self) -> List[PySide6.QtDataVisualization.QScatterDataItem]:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#array

        **const QScatterDataArray *QScatterDataProxy::array() const**

        Returns the pointer to the data array.
        """
        ...

    def insertItem(
        self,
        index: int,
        item: Union[
            PySide6.QtDataVisualization.QScatterDataItem, PySide6.QtGui.QVector3D
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#insertItem

        **void QScatterDataProxy::insertItem(int index , const QScatterDataItem
        & item )**

        Inserts the item **item** to the position **index**. If the index is
        equal to the data array size, the item is added to the array.
        """
        ...

    def insertItems(
        self, index: int, items: Sequence[PySide6.QtDataVisualization.QScatterDataItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#insertItems

        **void QScatterDataProxy::insertItems(int index , const
        QScatterDataArray & items )**

        Inserts the items specified by **items** to the position **index**. If
        the index is equal to data array size, the items are added to the array.
        """
        ...

    def itemAt(self, index: int) -> PySide6.QtDataVisualization.QScatterDataItem:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemAt

        **const QScatterDataItem *QScatterDataProxy::itemAt(int index ) const**

        Returns the pointer to the item at the index **index**. It is guaranteed
        to be valid only until the next call that modifies data.
        """
        ...

    def itemCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemCount-prop

        **[read-only] itemCount : const int**

        This property holds the number of items in the array.

        **Access functions:**

        int **itemCount** () const

        **Notifier signal:**

        void **itemCountChanged** (int **count** )
        """
        ...

    def removeItems(self, index: int, removeCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#removeItems

        **void QScatterDataProxy::removeItems(int index , int removeCount )**

        Removes the number of items specified by **removeCount** starting at the
        position **index**. Attempting to remove items past the end of the array
        does nothing.
        """
        ...

    def resetArray(
        self, newArray: Sequence[PySide6.QtDataVisualization.QScatterDataItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#resetArray

        **void QScatterDataProxy::resetArray(QScatterDataArray * newArray )**

        Takes ownership of the array **newArray**. Clears the existing array if
        the new array differs from it. If the arrays are the same, this function
        just triggers the **arrayReset** () signal.

        Passing a null array deletes the old array and creates a new empty
        array.
        """
        ...

    def series(self) -> PySide6.QtDataVisualization.QScatter3DSeries:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#series-prop

        **[read-only] series : QScatter3DSeries* const**

        This property holds the series this proxy is attached to.

        **Access functions:**

        QScatter3DSeries * **series** () const

        **Notifier signal:**

        void **seriesChanged** (QScatter3DSeries * **series** )

        **Member Function Documentation**
        """
        ...

    def setItem(
        self,
        index: int,
        item: Union[
            PySide6.QtDataVisualization.QScatterDataItem, PySide6.QtGui.QVector3D
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#setItem

        **void QScatterDataProxy::setItem(int index , const QScatterDataItem &
        item )**

        Replaces the item at the position **index** with the item **item**.
        """
        ...

    def setItems(
        self, index: int, items: Sequence[PySide6.QtDataVisualization.QScatterDataItem]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#setItems

        **void QScatterDataProxy::setItems(int index , const QScatterDataArray &
        items )**

        Replaces the items starting from the position **index** with the items
        specified by **items**.
        """
        ...

    @property
    def arrayReset(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#arrayReset

        **[signal] void QScatterDataProxy::arrayReset()**

        This signal is emitted when the data array is reset. If the contents of
        the whole array are changed without calling **resetArray** (), this
        signal needs to be emitted to update the graph.
        """
        ...

    @property
    def itemCountChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemsAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemsAdded

        **[signal] void QScatterDataProxy::itemsAdded(int startIndex , int count
        )**

        This signal is emitted when the number of items specified by **count**
        is added starting at the position **startIndex**. If items are added to
        the array without calling **addItem** () or **addItems** (), this signal
        needs to be emitted to update the graph.
        """
        ...

    @property
    def itemsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemsChanged

        **[signal] void QScatterDataProxy::itemsChanged(int startIndex , int
        count )**

        This signal is emitted when the number of items specified by **count**
        is changed starting at the position **startIndex**. If items are changed
        in the array without calling **setItem** () or **setItems** (), this
        signal needs to be emitted to update the graph.
        """
        ...

    @property
    def itemsInserted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemsInserted

        **[signal] void QScatterDataProxy::itemsInserted(int startIndex , int
        count )**

        This signal is emitted when the number of items specified by **count**
        is inserted starting at the position **startIndex**. If items are
        inserted into the array without calling **insertItem** () or
        **insertItems** (), this signal needs to be emitted to update the graph.
        """
        ...

    @property
    def itemsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qscatterdataproxy.html#itemsRemoved

        **[signal] void QScatterDataProxy::itemsRemoved(int startIndex , int
        count )**

        This signal is emitted when the number of rows specified by **count** is
        removed starting at the position **startIndex**. The index may be larger
        than the current array size if items are removed from the end. If items
        are removed from the array without calling **removeItems** (), this
        signal needs to be emitted to update the graph.
        """
        ...

    @property
    def seriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
