"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QScatterDataItem(object):
    """
    https://doc.qt.io/qt-6/qscatterdataitem.html

    **Detailed Description**

    A scatter data item holds the data for a single rendered item in a scatter
    graph. Scatter data proxies parse data into QScatterDataItem instances for
    visualization.

    **See also** **QScatterDataProxy**  and **Qt Data Visualization C++
    Classes** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#QScatterDataItem

        **QScatterDataItem::QScatterDataItem()**

        Constructs a scatter data item.
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtDataVisualization.QScatterDataItem, PySide6.QtGui.QVector3D
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#QScatterDataItem-1

        **QScatterDataItem::QScatterDataItem(const QVector3D & position )**

        Constructs a scatter data item at the position **position**.
        """
        ...

    @overload
    def __init__(self, position: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#QScatterDataItem-2

        **QScatterDataItem::QScatterDataItem(const QVector3D & position , const
        QQuaternion & rotation )**

        Constructs a scatter data item at the position **position** with the
        rotation **rotation**.
        """
        ...

    @overload
    def __init__(
        self, position: PySide6.QtGui.QVector3D, rotation: PySide6.QtGui.QQuaternion
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#QScatterDataItem-3

        **QScatterDataItem::QScatterDataItem(const QScatterDataItem & other )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def createExtraData(self) -> None:
        ...

    def position(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#position

        **QVector3D QScatterDataItem::position() const**

        Returns the position of this data item.

        **See also** **setPosition** ().
        """
        ...

    def rotation(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#rotation

        **QQuaternion QScatterDataItem::rotation() const**

        Returns the rotation of this data item.

        **See also** **setRotation** ().
        """
        ...

    def setPosition(self, pos: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#setPosition

        **void QScatterDataItem::setPosition(const QVector3D & pos )**

        Sets the position **pos** for this data item.

        **See also** **position** ().
        """
        ...

    def setRotation(self, rot: PySide6.QtGui.QQuaternion) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#setRotation

        **void QScatterDataItem::setRotation(const QQuaternion & rot )**

        Sets the rotation **rot** for this data item. The value of **rot**
        should be a normalized **QQuaternion** . If the series also has
        rotation, item rotation is multiplied by it. Defaults to no rotation.

        **See also** **rotation** ().
        """
        ...

    def setX(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#setX

        **void QScatterDataItem::setX(float value )**

        Sets the x-coordinate of the item position to the value **value**.

        **See also** **x** ().
        """
        ...

    def setY(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#setY

        **void QScatterDataItem::setY(float value )**

        Sets the y-coordinate of the item position to the value **value**.

        **See also** **y** ().
        """
        ...

    def setZ(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#setZ

        **void QScatterDataItem::setZ(float value )**

        Sets the z-coordinate of the item position to the value **value**.

        **See also** **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#x

        **float QScatterDataItem::x() const**

        Returns the x-coordinate of the position of this data item.

        **See also** **setX** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#y

        **float QScatterDataItem::y() const**

        Returns the y-coordinate of the position of this data item.

        **See also** **setY** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qscatterdataitem.html#z

        **float QScatterDataItem::z() const**

        Returns the z-coordinate of the position of this data item.

        **See also** **setZ** ().
        """
        ...
