"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QItemModelScatterDataProxy(PySide6.QtDataVisualization.QScatterDataProxy):
    """
    https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html

    **Detailed Description**

    QItemModelScatterDataProxy allows you to use **QAbstractItemModel**  derived
    models as a data source for **Q3DScatter** . It maps roles of
    **QAbstractItemModel**  to the XYZ-values of **Q3DScatter**  points.

    The data is resolved asynchronously whenever the mapping or the model
    changes. **QScatterDataProxy::arrayReset** () is emitted when the data has
    been resolved. However, inserts, removes, and single data item changes after
    the model initialization are resolved synchronously, unless the same frame
    also contains a change that causes the whole model to be resolved.

    Mapping ignores rows and columns of the **QAbstractItemModel**  and treats
    all items equally. It requires the model to provide roles for the data items
    that can be mapped to X, Y, and Z-values for the scatter points.

    For example, assume that you have a custom **QAbstractItemModel**  for
    storing various measurements done on material samples, providing data for
    roles such as "density", "hardness", and "conductivity". You could visualize
    these properties on a scatter graph using this proxy:

    // Map "density" value to X-axis, "hardness" to Y-axis and "conductivity" to
    Z-axis.
        **QItemModelScatterDataProxy**  *proxy = new
    **QItemModelScatterDataProxy** (customModel,
    **QStringLiteral** ("density"),
    **QStringLiteral** ("hardness"),
    **QStringLiteral** ("conductivity"));

    If the fields of the model do not contain the data in the exact format you
    need, you can specify a search pattern regular expression and a replace rule
    for each role to get the value in a format you need. For more information
    how the replace using regular expressions works, see **QString::replace**
    (const **QRegularExpression**  &rx, const **QString**  &after) function
    documentation. Note that using regular expressions has an impact on the
    performance, so it's more efficient to utilize item models where doing
    search and replace is not necessary to get the desired values.

    For example about using the search patterns in conjunction with the roles,
    see **ItemModelBarDataProxy**  usage in **Qt Quick 2 Bars Example** .

    **See also** **Qt Data Visualization Data Handling** .
    """

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#QItemModelScatter
        DataProxy

        **QItemModelScatterDataProxy::QItemModelScatterDataProxy(QObject *
        parent = nullptr)**

        Constructs QItemModelScatterDataProxy with optional **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        xPosRole: str,
        yPosRole: str,
        zPosRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#QItemModelScatter
        DataProxy-1

        **QItemModelScatterDataProxy::QItemModelScatterDataProxy(QAbstractItemMo
        del * itemModel , QObject * parent = nullptr)**

        Constructs QItemModelScatterDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        xPosRole: str,
        yPosRole: str,
        zPosRole: str,
        rotationRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#QItemModelScatter
        DataProxy-2

        **QItemModelScatterDataProxy::QItemModelScatterDataProxy(QAbstractItemMo
        del * itemModel , const QString & xPosRole , const QString & yPosRole ,
        const QString & zPosRole , QObject * parent = nullptr)**

        Constructs QItemModelScatterDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The **xPosRole**
        property is set to **xPosRole** , **yPosRole**  property to **yPosRole**
        , and **zPosRole**  property to **zPosRole**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#QItemModelScatter
        DataProxy-3

        **QItemModelScatterDataProxy::QItemModelScatterDataProxy(QAbstractItemMo
        del * itemModel , const QString & xPosRole , const QString & yPosRole ,
        const QString & zPosRole , const QString & rotationRole , QObject *
        parent = nullptr)**

        Constructs QItemModelScatterDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The **xPosRole**
        property is set to **xPosRole** , **yPosRole**  property to **yPosRole**
        , **zPosRole**  property to **zPosRole** , and **rotationRole**
        property to **rotationRole**.
        """
        ...

    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#itemModel-prop

        **itemModel : QAbstractItemModel***

        This property holds the item model to use as a data source for a 3D
        scatter series.

        **Access functions:**

        QAbstractItemModel * **itemModel** () const
        void ****setItemModel** **
        (QAbstractItemModel * **itemModel** )

        **Notifier signal:**

        void **itemModelChanged** (const QAbstractItemModel * **itemModel** )
        """
        ...

    def remap(
        self, xPosRole: str, yPosRole: str, zPosRole: str, rotationRole: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#remap

        **void QItemModelScatterDataProxy::remap(const QString & xPosRole ,
        const QString & yPosRole , const QString & zPosRole , const QString &
        rotationRole )**

        Changes **xPosRole** , **yPosRole** , **zPosRole** , and
        **rotationRole** mapping.
        """
        ...

    def rotationRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRole-prop

        **rotationRole : QString**

        This property holds the item model role to map into item rotation.

        The model may supply the value for rotation as either variant that is
        directly convertible to **QQuaternion** , or as one of the string
        representations: `"scalar,x,y,z"` or `"@angle,x,y,z"`. The first will
        construct the quaternion directly with given values, and the second one
        will construct the quaternion using **QQuaternion::fromAxisAndAngle** ()
        method.

        **Access functions:**

        QString **rotationRole** () const
        void **setRotationRole** (const
        QString & **role** )

        **Notifier signal:**

        void **rotationRoleChanged** (const QString & **role** )
        """
        ...

    def rotationRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRolePatte
        rn-prop

        **rotationRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the rotation role before it is used as item rotation.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rotationRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rotationRolePattern** () const
        void
        **setRotationRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rotationRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **rotationRole**  and **rotationRoleReplace** .
        """
        ...

    def rotationRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRoleRepla
        ce-prop

        **rotationRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the rotation role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rotationRoleReplace** () const
        void
        **setRotationRoleReplace** (const QString & **replace** )

        **Notifier signal:**

        void **rotationRoleReplaceChanged** (const QString & **replace** )

        **See also** **rotationRole**  and **rotationRolePattern** .
        """
        ...

    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#setItemModel

        **void QItemModelScatterDataProxy::setItemModel(QAbstractItemModel *
        itemModel )**

        Sets **itemModel** as the item model for **Q3DScatter** . Does not take
        ownership of the model, but does connect to it to listen for changes.

        **Note:** Setter function for property **itemModel** .

        **See also** **itemModel** ().
        """
        ...

    def setRotationRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRole-prop

        **rotationRole : QString**

        This property holds the item model role to map into item rotation.

        The model may supply the value for rotation as either variant that is
        directly convertible to **QQuaternion** , or as one of the string
        representations: `"scalar,x,y,z"` or `"@angle,x,y,z"`. The first will
        construct the quaternion directly with given values, and the second one
        will construct the quaternion using **QQuaternion::fromAxisAndAngle** ()
        method.

        **Access functions:**

        QString **rotationRole** () const
        void **setRotationRole** (const
        QString & **role** )

        **Notifier signal:**

        void **rotationRoleChanged** (const QString & **role** )
        """
        ...

    def setRotationRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRolePatte
        rn-prop

        **rotationRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the rotation role before it is used as item rotation.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rotationRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rotationRolePattern** () const
        void
        **setRotationRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rotationRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **rotationRole**  and **rotationRoleReplace** .
        """
        ...

    def setRotationRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#rotationRoleRepla
        ce-prop

        **rotationRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the rotation role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rotationRoleReplace** () const
        void
        **setRotationRoleReplace** (const QString & **replace** )

        **Notifier signal:**

        void **rotationRoleReplaceChanged** (const QString & **replace** )

        **See also** **rotationRole**  and **rotationRolePattern** .
        """
        ...

    def setXPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRole-prop

        **xPosRole : QString**

        This property holds the item model role to map into the X position.

        **Access functions:**

        QString **xPosRole** () const
        void **setXPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **xPosRoleChanged** (const QString & **role** )
        """
        ...

    def setXPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRolePattern-
        prop

        **xPosRolePattern : QRegularExpression**

        This property holds whether search and replace is done on the value
        mapped by the x position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **xPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **xPosRolePattern** () const
        void
        **setXPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **xPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **xPosRole**  and **xPosRoleReplace** .
        """
        ...

    def setXPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRoleReplace-
        prop

        **xPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the x position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **xPosRoleReplace** () const
        void **setXPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **xPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **xPosRole**  and **xPosRolePattern** .
        """
        ...

    def setYPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRole-prop

        **yPosRole : QString**

        This property holds the item model role to map into the Y position.

        **Access functions:**

        QString **yPosRole** () const
        void **setYPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **yPosRoleChanged** (const QString & **role** )
        """
        ...

    def setYPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRolePattern-
        prop

        **yPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the y position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **yPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **yPosRolePattern** () const
        void
        **setYPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **yPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **yPosRole**  and **yPosRoleReplace** .
        """
        ...

    def setYPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRoleReplace-
        prop

        **yPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the y position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **yPosRoleReplace** () const
        void **setYPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **yPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **yPosRole**  and **yPosRolePattern** .
        """
        ...

    def setZPosRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRole-prop

        **zPosRole : QString**

        This property holds the item model role to map into the Z position.

        **Access functions:**

        QString **zPosRole** () const
        void **setZPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **zPosRoleChanged** (const QString & **role** )
        """
        ...

    def setZPosRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRolePattern-
        prop

        **zPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the z position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **zPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **zPosRolePattern** () const
        void
        **setZPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **zPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **zPosRole**  and **zPosRoleReplace** .
        """
        ...

    def setZPosRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRoleReplace-
        prop

        **zPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the z position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **zPosRoleReplace** () const
        void **setZPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **zPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **zPosRole**  and **zPosRolePattern** .

        **Member Function Documentation**
        """
        ...

    def xPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRole-prop

        **xPosRole : QString**

        This property holds the item model role to map into the X position.

        **Access functions:**

        QString **xPosRole** () const
        void **setXPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **xPosRoleChanged** (const QString & **role** )
        """
        ...

    def xPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRolePattern-
        prop

        **xPosRolePattern : QRegularExpression**

        This property holds whether search and replace is done on the value
        mapped by the x position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **xPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **xPosRolePattern** () const
        void
        **setXPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **xPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **xPosRole**  and **xPosRoleReplace** .
        """
        ...

    def xPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#xPosRoleReplace-
        prop

        **xPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the x position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **xPosRoleReplace** () const
        void **setXPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **xPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **xPosRole**  and **xPosRolePattern** .
        """
        ...

    def yPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRole-prop

        **yPosRole : QString**

        This property holds the item model role to map into the Y position.

        **Access functions:**

        QString **yPosRole** () const
        void **setYPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **yPosRoleChanged** (const QString & **role** )
        """
        ...

    def yPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRolePattern-
        prop

        **yPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the y position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **yPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **yPosRolePattern** () const
        void
        **setYPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **yPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **yPosRole**  and **yPosRoleReplace** .
        """
        ...

    def yPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#yPosRoleReplace-
        prop

        **yPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the y position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **yPosRoleReplace** () const
        void **setYPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **yPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **yPosRole**  and **yPosRolePattern** .
        """
        ...

    def zPosRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRole-prop

        **zPosRole : QString**

        This property holds the item model role to map into the Z position.

        **Access functions:**

        QString **zPosRole** () const
        void **setZPosRole** (const QString &
        **role** )

        **Notifier signal:**

        void **zPosRoleChanged** (const QString & **role** )
        """
        ...

    def zPosRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRolePattern-
        prop

        **zPosRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by the z position role before it is used as an item position
        value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **zPosRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **zPosRolePattern** () const
        void
        **setZPosRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **zPosRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **zPosRole**  and **zPosRoleReplace** .
        """
        ...

    def zPosRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelscatterdataproxy.html#zPosRoleReplace-
        prop

        **zPosRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        the z position role pattern.

        Defaults to an empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **zPosRoleReplace** () const
        void **setZPosRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **zPosRoleReplaceChanged** (const QString & **replace** )

        **See also** **zPosRole**  and **zPosRolePattern** .

        **Member Function Documentation**
        """
        ...

    @property
    def itemModelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def xPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def yPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def zPosRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
