"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QItemModelBarDataProxy(PySide6.QtDataVisualization.QBarDataProxy):
    """
    https://doc.qt.io/qt-6/qitemmodelbardataproxy.html

    **Detailed Description**

    QItemModelBarDataProxy allows you to use **QAbstractItemModel**  derived
    models as a data source for **Q3DBars** . It uses the defined mappings to
    map data from the model to rows, columns, and values of **Q3DBars**  graph.

    The data is resolved asynchronously whenever mappings or the model changes.
    **QBarDataProxy::arrayReset** () is emitted when the data has been resolved.
    However, when **useModelCategories**  property is set to true, single item
    changes are resolved synchronously, unless the same frame also contains a
    change that causes the whole model to be resolved.

    Mappings can be used in the following ways:

    * If **useModelCategories**  property is set to true, this proxy will map
    rows and columns of **QAbstractItemModel**  directly to rows and columns of
    **Q3DBars** , and uses the value returned for **Qt::DisplayRole**  as bar
    value by default. The value role to be used can be redefined if
    **Qt::DisplayRole**  is not suitable.
      * For models that do not have data
    already neatly sorted into rows and columns, such as **QAbstractListModel**
    based models, you can define a role from the model to map for each of row,
    column and value.
      * If you do not want to include all data contained in
    the model, or the autogenerated rows and columns are not ordered as you
    wish, you can specify which rows and columns should be included and in which
    order by defining an explicit list of categories for either or both of rows
    and columns.

    For example, assume that you have a custom **QAbstractItemModel**  for
    storing various monthly values related to a business. Each item in the model
    has the roles "year", "month", "income", and "expenses". You could do the
    following to display the data in a bar graph:

    // By defining row and column categories, you tell the mapping which row and
    column each item
        // belongs to. The categories must match the data
    stored in the model in the roles you define
        // for row and column
    mapping. In this example we expect "year" role to return four digit year
    // and "month" to return three letter designation for the month.
        //
    // An example of an item in model would be:
        // Requested role ->
    Returned data
        // "year" -> "2006" // Matches the first row category, so
    this item is added to the first row.
        // "month" -> "jan" // Matches the
    first column category, so this item is added as first item in the row.
    // "income" -> "12.1"
        // "expenses" -> "9.2"
        **QStringList**  years;
    **QStringList**  months;
        years << "2006" << "2007" << "2008" << "2009"
    << "2010" << "2011" << "2012";
        months << "jan" << "feb" << "mar" <<
    "apr" << "may" << "jun" << "jul" << "aug" << "sep" << "oct" << "nov" <<
    "dec";

        **QItemModelBarDataProxy**  *proxy = new
    **QItemModelBarDataProxy** (customModel,
    **QStringLiteral** ("year"), // Row role
    **QStringLiteral** ("month"), // Column role
    **QStringLiteral** ("income"), // Value role
    years, // Row categories
    months); // Column categories

        //...

        // To display
    different data later, you can simply change the mapping.
    proxy->setValueRole(**QStringLiteral** ("expenses"));

    If the fields of the model do not contain the data in the exact format you
    need, you can specify a search pattern regular expression and a replace rule
    for each role to get the value in a format you need. For more information
    how the replace using regular expressions works, see **QString::replace**
    (const **QRegularExpression**  &rx, const **QString**  &after) function
    documentation. Note that using regular expressions has an impact on the
    performance, so it's more efficient to utilize item models where doing
    search and replace is not necessary to get the desired values.

    For example about using the search patterns in conjunction with the roles,
    see **Qt Quick 2 Bars Example** .

    **See also** **Qt Data Visualization Data Handling** .
    """

    MMBFirst: QItemModelBarDataProxy.MultiMatchBehavior = ...
    MMBLast: QItemModelBarDataProxy.MultiMatchBehavior = ...
    MMBAverage: QItemModelBarDataProxy.MultiMatchBehavior = ...
    MMBCumulative: QItemModelBarDataProxy.MultiMatchBehavior = ...

    class MultiMatchBehavior(Enum):
        MMBFirst: QItemModelBarDataProxy.MultiMatchBehavior = ...
        MMBLast: QItemModelBarDataProxy.MultiMatchBehavior = ...
        MMBAverage: QItemModelBarDataProxy.MultiMatchBehavior = ...
        MMBCumulative: QItemModelBarDataProxy.MultiMatchBehavior = ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QObject * parent =
        nullptr)**

        Constructs QItemModelBarDataProxy with optional **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        valueRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-1

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , QObject * parent = nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        valueRole: str,
        rotationRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-2

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , const QString & valueRole , QObject * parent = nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The value role is set
        to **valueRole**. This constructor is meant to be used with models that
        have data properly sorted in rows and columns already, so it also sets
        **useModelCategories**  property to true.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        valueRole: str,
        rotationRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-3

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , const QString & rowRole , const QString & columnRole , const
        QString & valueRole , QObject * parent = nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , and **valueRole**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        rowRole: str,
        columnRole: str,
        valueRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-4

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , const QString & rowRole , const QString & columnRole , const
        QString & valueRole , const QString & rotationRole , QObject * parent =
        nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , **valueRole** , and
        **rotationRole**.
        """
        ...

    @overload
    def __init__(
        self,
        itemModel: PySide6.QtCore.QAbstractItemModel,
        valueRole: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-5

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , const QString & rowRole , const QString & columnRole , const
        QString & valueRole , const QStringList & rowCategories , const
        QStringList & columnCategories , QObject * parent = nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , and **valueRole**. Row and
        column categories are set with **rowCategories** and
        **columnCategories**. This constructor also sets **autoRowCategories**
        and **autoColumnCategories**  to false.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#QItemModelBarDataProx
        y-6

        **QItemModelBarDataProxy::QItemModelBarDataProxy(QAbstractItemModel *
        itemModel , const QString & rowRole , const QString & columnRole , const
        QString & valueRole , const QString & rotationRole , const QStringList &
        rowCategories , const QStringList & columnCategories , QObject * parent
        = nullptr)**

        Constructs QItemModelBarDataProxy with **itemModel** and optional
        **parent**. Proxy doesn't take ownership of the **itemModel** , as
        typically item models are owned by other controls. The role mappings are
        set with **rowRole** , **columnRole** , **valueRole** , and
        **rotationRole**. Row and column categories are set with
        **rowCategories** and **columnCategories**. This constructor also sets
        **autoRowCategories**  and **autoColumnCategories**  to false.
        """
        ...

    def autoColumnCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#autoColumnCategories-
        prop

        **autoColumnCategories : bool**

        This property holds whether column categories are generated
        automatically.

        When set to `true`, the mapping ignores any explicitly set column
        categories and overwrites them with automatically generated ones
        whenever the data from model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoColumnCategories** () const
        void
        **setAutoColumnCategories** (bool **enable** )

        **Notifier signal:**

        void **autoColumnCategoriesChanged** (bool **enable** )
        """
        ...

    def autoRowCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#autoRowCategories-
        prop

        **autoRowCategories : bool**

        This property holds whether row categories are generated automatically.

        When set to `true`, the mapping ignores any explicitly set row
        categories and overwrites them with automatically generated ones
        whenever the data from model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoRowCategories** () const
        void **setAutoRowCategories**
        (bool **enable** )

        **Notifier signal:**

        void **autoRowCategoriesChanged** (bool **enable** )
        """
        ...

    def columnCategories(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnCategories-prop

        **columnCategories : QStringList**

        This property holds the column categories for the mapping.

        **Access functions:**

        QStringList **columnCategories** () const
        void **setColumnCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **columnCategoriesChanged** ()
        """
        ...

    def columnCategoryIndex(self, category: str) -> int:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnCategoryIndex

        **[invokable] int QItemModelBarDataProxy::columnCategoryIndex(const
        QString & category )**

        Returns the index of the specified **category** in column categories
        list. If the category is not found, -1 is returned.

        **Note:** If the automatic column categories generation is in use, this
        method will not return a valid index before the data in the model is
        resolved for the first time.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def columnRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRole-prop

        **columnRole : QString**

        This property holds the column role for the mapping.

        **Access functions:**

        QString **columnRole** () const
        void **setColumnRole** (const QString
        & **role** )

        **Notifier signal:**

        void **columnRoleChanged** (const QString & **role** )
        """
        ...

    def columnRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRolePattern-
        prop

        **columnRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by column role before it is used as a column category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **columnRoleReplace**  property contains
        the replacement string. This is useful for example in parsing row and
        column categories from a single timestamp field in the item model.

        **Access functions:**

        QRegularExpression **columnRolePattern** () const
        void
        **setColumnRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **columnRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **columnRole**  and **columnRoleReplace** .
        """
        ...

    def columnRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRoleReplace-
        prop

        **columnRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **columnRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **columnRoleReplace** () const
        void **setColumnRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **columnRoleReplaceChanged** (const QString & **replace** )

        **See also** **columnRole**  and **columnRolePattern** .
        """
        ...

    def itemModel(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#itemModel-prop

        **itemModel : QAbstractItemModel***

        This property holds the item model.

        **Access functions:**

        QAbstractItemModel * **itemModel** () const
        void ****setItemModel** **
        (QAbstractItemModel * **itemModel** )

        **Notifier signal:**

        void **itemModelChanged** (const QAbstractItemModel * **itemModel** )
        """
        ...

    def multiMatchBehavior(
        self,
    ) -> PySide6.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#multiMatchBehavior-
        prop

        **multiMatchBehavior : MultiMatchBehavior**

        How multiple matches for each row/column combination are handled.

        Defaults to **QItemModelBarDataProxy::MMBLast** . The chosen behavior
        affects both bar value and rotation.

        For example, you might have an item model with timestamped data taken at
        irregular intervals and you want to visualize total value of data items
        on each day with a bar graph. This can be done by specifying row and
        column categories so that each bar represents a day, and setting
        multiMatchBehavior to **QItemModelBarDataProxy::MMBCumulative** .

        **Access functions:**

        QItemModelBarDataProxy::MultiMatchBehavior **multiMatchBehavior** ()
        const
        void **setMultiMatchBehavior**
        (QItemModelBarDataProxy::MultiMatchBehavior **behavior** )

        **Notifier signal:**

        void **multiMatchBehaviorChanged**
        (QItemModelBarDataProxy::MultiMatchBehavior **behavior** )
        """
        ...

    def remap(
        self,
        rowRole: str,
        columnRole: str,
        valueRole: str,
        rotationRole: str,
        rowCategories: Sequence[str],
        columnCategories: Sequence[str],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#remap

        **void QItemModelBarDataProxy::remap(const QString & rowRole , const
        QString & columnRole , const QString & valueRole , const QString &
        rotationRole , const QStringList & rowCategories , const QStringList &
        columnCategories )**

        Changes **rowRole** , **columnRole** , **valueRole** , **rotationRole**
        , **rowCategories** and **columnCategories** to the mapping.
        """
        ...

    def rotationRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRole-prop

        **rotationRole : QString**

        This property holds the rotation role for the mapping.

        **Access functions:**

        QString **rotationRole** () const
        void **setRotationRole** (const
        QString & **role** )

        **Notifier signal:**

        void **rotationRoleChanged** (const QString & **role** )
        """
        ...

    def rotationRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRolePattern-
        prop

        **rotationRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by rotation role before it is used as a bar rotation angle.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rotationRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rotationRolePattern** () const
        void
        **setRotationRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rotationRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **rotationRole**  and **rotationRoleReplace** .
        """
        ...

    def rotationRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRoleReplace-
        prop

        **rotationRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **rotationRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rotationRoleReplace** () const
        void
        **setRotationRoleReplace** (const QString & **replace** )

        **Notifier signal:**

        void **rotationRoleReplaceChanged** (const QString & **replace** )

        **See also** **rotationRole**  and **rotationRolePattern** .
        """
        ...

    def rowCategories(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowCategories-prop

        **rowCategories : QStringList**

        This property holds the row categories for the mapping.

        **Access functions:**

        QStringList **rowCategories** () const
        void **setRowCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **rowCategoriesChanged** ()
        """
        ...

    def rowCategoryIndex(self, category: str) -> int:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowCategoryIndex

        **[invokable] int QItemModelBarDataProxy::rowCategoryIndex(const QString
        & category )**

        Returns the index of the specified **category** in row categories list.
        If the row categories list is empty, -1 is returned.

        **Note:** If the automatic row categories generation is in use, this
        method will not return a valid index before the data in the model is
        resolved for the first time.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def rowRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRole-prop

        **rowRole : QString**

        This property holds the row role for the mapping.

        **Access functions:**

        QString **rowRole** () const
        void **setRowRole** (const QString &
        **role** )

        **Notifier signal:**

        void **rowRoleChanged** (const QString & **role** )
        """
        ...

    def rowRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRolePattern-prop

        **rowRolePattern : QRegularExpression**

        This property holds whether a search and replace is performed on the
        value mapped by row role before it is used as a row category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rowRoleReplace**  property contains
        the replacement string. This is useful for example in parsing row and
        column categories from a single timestamp field in the item model.

        **Access functions:**

        QRegularExpression **rowRolePattern** () const
        void
        **setRowRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rowRolePatternChanged** (const QRegularExpression & **pattern** )

        **See also** **rowRole**  and **rowRoleReplace** .
        """
        ...

    def rowRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRoleReplace-prop

        **rowRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **rowRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rowRoleReplace** () const
        void **setRowRoleReplace** (const
        QString & **replace** )

        **Notifier signal:**

        void **rowRoleReplaceChanged** (const QString & **replace** )

        **See also** **rowRole**  and **rowRolePattern** .
        """
        ...

    def setAutoColumnCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#autoColumnCategories-
        prop

        **autoColumnCategories : bool**

        This property holds whether column categories are generated
        automatically.

        When set to `true`, the mapping ignores any explicitly set column
        categories and overwrites them with automatically generated ones
        whenever the data from model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoColumnCategories** () const
        void
        **setAutoColumnCategories** (bool **enable** )

        **Notifier signal:**

        void **autoColumnCategoriesChanged** (bool **enable** )
        """
        ...

    def setAutoRowCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#autoRowCategories-
        prop

        **autoRowCategories : bool**

        This property holds whether row categories are generated automatically.

        When set to `true`, the mapping ignores any explicitly set row
        categories and overwrites them with automatically generated ones
        whenever the data from model is resolved. Defaults to `true`.

        **Access functions:**

        bool **autoRowCategories** () const
        void **setAutoRowCategories**
        (bool **enable** )

        **Notifier signal:**

        void **autoRowCategoriesChanged** (bool **enable** )
        """
        ...

    def setColumnCategories(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnCategories-prop

        **columnCategories : QStringList**

        This property holds the column categories for the mapping.

        **Access functions:**

        QStringList **columnCategories** () const
        void **setColumnCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **columnCategoriesChanged** ()
        """
        ...

    def setColumnRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRole-prop

        **columnRole : QString**

        This property holds the column role for the mapping.

        **Access functions:**

        QString **columnRole** () const
        void **setColumnRole** (const QString
        & **role** )

        **Notifier signal:**

        void **columnRoleChanged** (const QString & **role** )
        """
        ...

    def setColumnRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRolePattern-
        prop

        **columnRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by column role before it is used as a column category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **columnRoleReplace**  property contains
        the replacement string. This is useful for example in parsing row and
        column categories from a single timestamp field in the item model.

        **Access functions:**

        QRegularExpression **columnRolePattern** () const
        void
        **setColumnRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **columnRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **columnRole**  and **columnRoleReplace** .
        """
        ...

    def setColumnRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#columnRoleReplace-
        prop

        **columnRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **columnRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **columnRoleReplace** () const
        void **setColumnRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **columnRoleReplaceChanged** (const QString & **replace** )

        **See also** **columnRole**  and **columnRolePattern** .
        """
        ...

    def setItemModel(self, itemModel: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#setItemModel

        **void QItemModelBarDataProxy::setItemModel(QAbstractItemModel *
        itemModel )**

        Sets the item model to **itemModel**. Does not take ownership of the
        model, but does connect to it to listen for changes.

        **Note:** Setter function for property **itemModel** .

        **See also** **itemModel** ().
        """
        ...

    def setMultiMatchBehavior(
        self,
        behavior: PySide6.QtDataVisualization.QItemModelBarDataProxy.MultiMatchBehavior,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#multiMatchBehavior-
        prop

        **multiMatchBehavior : MultiMatchBehavior**

        How multiple matches for each row/column combination are handled.

        Defaults to **QItemModelBarDataProxy::MMBLast** . The chosen behavior
        affects both bar value and rotation.

        For example, you might have an item model with timestamped data taken at
        irregular intervals and you want to visualize total value of data items
        on each day with a bar graph. This can be done by specifying row and
        column categories so that each bar represents a day, and setting
        multiMatchBehavior to **QItemModelBarDataProxy::MMBCumulative** .

        **Access functions:**

        QItemModelBarDataProxy::MultiMatchBehavior **multiMatchBehavior** ()
        const
        void **setMultiMatchBehavior**
        (QItemModelBarDataProxy::MultiMatchBehavior **behavior** )

        **Notifier signal:**

        void **multiMatchBehaviorChanged**
        (QItemModelBarDataProxy::MultiMatchBehavior **behavior** )
        """
        ...

    def setRotationRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRole-prop

        **rotationRole : QString**

        This property holds the rotation role for the mapping.

        **Access functions:**

        QString **rotationRole** () const
        void **setRotationRole** (const
        QString & **role** )

        **Notifier signal:**

        void **rotationRoleChanged** (const QString & **role** )
        """
        ...

    def setRotationRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRolePattern-
        prop

        **rotationRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by rotation role before it is used as a bar rotation angle.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rotationRoleReplace**  property
        contains the replacement string.

        **Access functions:**

        QRegularExpression **rotationRolePattern** () const
        void
        **setRotationRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rotationRolePatternChanged** (const QRegularExpression &
        **pattern** )

        **See also** **rotationRole**  and **rotationRoleReplace** .
        """
        ...

    def setRotationRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rotationRoleReplace-
        prop

        **rotationRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **rotationRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rotationRoleReplace** () const
        void
        **setRotationRoleReplace** (const QString & **replace** )

        **Notifier signal:**

        void **rotationRoleReplaceChanged** (const QString & **replace** )

        **See also** **rotationRole**  and **rotationRolePattern** .
        """
        ...

    def setRowCategories(self, categories: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowCategories-prop

        **rowCategories : QStringList**

        This property holds the row categories for the mapping.

        **Access functions:**

        QStringList **rowCategories** () const
        void **setRowCategories**
        (const QStringList & **categories** )

        **Notifier signal:**

        void **rowCategoriesChanged** ()
        """
        ...

    def setRowRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRole-prop

        **rowRole : QString**

        This property holds the row role for the mapping.

        **Access functions:**

        QString **rowRole** () const
        void **setRowRole** (const QString &
        **role** )

        **Notifier signal:**

        void **rowRoleChanged** (const QString & **role** )
        """
        ...

    def setRowRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRolePattern-prop

        **rowRolePattern : QRegularExpression**

        This property holds whether a search and replace is performed on the
        value mapped by row role before it is used as a row category.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **rowRoleReplace**  property contains
        the replacement string. This is useful for example in parsing row and
        column categories from a single timestamp field in the item model.

        **Access functions:**

        QRegularExpression **rowRolePattern** () const
        void
        **setRowRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **rowRolePatternChanged** (const QRegularExpression & **pattern** )

        **See also** **rowRole**  and **rowRoleReplace** .
        """
        ...

    def setRowRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#rowRoleReplace-prop

        **rowRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **rowRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **rowRoleReplace** () const
        void **setRowRoleReplace** (const
        QString & **replace** )

        **Notifier signal:**

        void **rowRoleReplaceChanged** (const QString & **replace** )

        **See also** **rowRole**  and **rowRolePattern** .
        """
        ...

    def setUseModelCategories(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#useModelCategories-
        prop

        **useModelCategories : bool**

        This property holds whether row and column roles and categories are used
        for mapping.

        When set to `true`, the mapping ignores row and column roles and
        categories, and uses the rows and columns from the model instead.
        Defaults to `false`.

        **Access functions:**

        bool **useModelCategories** () const
        void **setUseModelCategories**
        (bool **enable** )

        **Notifier signal:**

        void **useModelCategoriesChanged** (bool **enable** )
        """
        ...

    def setValueRole(self, role: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRole-prop

        **valueRole : QString**

        This property holds the value role for the mapping.

        **Access functions:**

        QString **valueRole** () const
        void **setValueRole** (const QString &
        **role** )

        **Notifier signal:**

        void **valueRoleChanged** (const QString & **role** )
        """
        ...

    def setValueRolePattern(
        self, pattern: Union[PySide6.QtCore.QRegularExpression, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRolePattern-prop

        **valueRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by value role before it is used as a bar value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **valueRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **valueRolePattern** () const
        void
        **setValueRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **valueRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **valueRole**  and **valueRoleReplace** .
        """
        ...

    def setValueRoleReplace(self, replace: str) -> None:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRoleReplace-prop

        **valueRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **valueRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **valueRoleReplace** () const
        void **setValueRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **valueRoleReplaceChanged** (const QString & **replace** )

        **See also** **valueRole**  and **valueRolePattern** .

        **Member Function Documentation**
        """
        ...

    def useModelCategories(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#useModelCategories-
        prop

        **useModelCategories : bool**

        This property holds whether row and column roles and categories are used
        for mapping.

        When set to `true`, the mapping ignores row and column roles and
        categories, and uses the rows and columns from the model instead.
        Defaults to `false`.

        **Access functions:**

        bool **useModelCategories** () const
        void **setUseModelCategories**
        (bool **enable** )

        **Notifier signal:**

        void **useModelCategoriesChanged** (bool **enable** )
        """
        ...

    def valueRole(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRole-prop

        **valueRole : QString**

        This property holds the value role for the mapping.

        **Access functions:**

        QString **valueRole** () const
        void **setValueRole** (const QString &
        **role** )

        **Notifier signal:**

        void **valueRoleChanged** (const QString & **role** )
        """
        ...

    def valueRolePattern(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRolePattern-prop

        **valueRolePattern : QRegularExpression**

        This property holds whether a search and replace is done on the value
        mapped by value role before it is used as a bar value.

        This property specifies the regular expression to find the portion of
        the mapped value to replace and **valueRoleReplace**  property contains
        the replacement string.

        **Access functions:**

        QRegularExpression **valueRolePattern** () const
        void
        **setValueRolePattern** (const QRegularExpression & **pattern** )

        **Notifier signal:**

        void **valueRolePatternChanged** (const QRegularExpression & **pattern**
        )

        **See also** **valueRole**  and **valueRoleReplace** .
        """
        ...

    def valueRoleReplace(self) -> str:
        """
        https://doc.qt.io/qt-6/qitemmodelbardataproxy.html#valueRoleReplace-prop

        **valueRoleReplace : QString**

        This property holds the replace content to be used in conjunction with
        **valueRolePattern** .

        Defaults to empty string. For more information on how the search and
        replace using regular expressions works, see **QString::replace** (const
        **QRegularExpression**  &rx, const **QString**  &after) function
        documentation.

        **Access functions:**

        QString **valueRoleReplace** () const
        void **setValueRoleReplace**
        (const QString & **replace** )

        **Notifier signal:**

        void **valueRoleReplaceChanged** (const QString & **replace** )

        **See also** **valueRole**  and **valueRolePattern** .

        **Member Function Documentation**
        """
        ...

    @property
    def autoColumnCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def autoRowCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def columnRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def itemModelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def multiMatchBehaviorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rowRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def useModelCategoriesChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def valueRoleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def valueRolePatternChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def valueRoleReplaceChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
