"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QHeightMapSurfaceDataProxy(PySide6.QtDataVisualization.QSurfaceDataProxy):
    """
    https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html

    **Detailed Description**

    QHeightMapSurfaceDataProxy takes care of surface related height map data
    handling. It provides a way to give a height map to be visualized as a
    surface plot.

    Since height maps do not contain values for X or Z axes, those values need
    to be given separately using **minXValue** , **maxXValue** , **minZValue** ,
    and **maxZValue**  properties. X-value corresponds to image horizontal
    direction and Z-value to the vertical. Setting any of these properties
    triggers asynchronous re-resolving of any existing height map.

    **See also** **QSurfaceDataProxy**  and **Qt Data Visualization Data
    Handling** .
    """

    @overload
    def __init__(
        self, filename: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#QHeightMapSurface
        DataProxy

        **QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(QObject *
        parent = nullptr)**

        Constructs QHeightMapSurfaceDataProxy with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        image: Union[PySide6.QtGui.QImage, str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#QHeightMapSurface
        DataProxy-1

        **QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(const QImage &
        image , QObject * parent = nullptr)**

        Constructs QHeightMapSurfaceDataProxy with the given **image** and
        **parent**. Height map is set by calling **setHeightMap** () with
        **image**.

        **See also** **heightMap** .
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#QHeightMapSurface
        DataProxy-2

        **QHeightMapSurfaceDataProxy::QHeightMapSurfaceDataProxy(const QString &
        filename , QObject * parent = nullptr)**

        Constructs QHeightMapSurfaceDataProxy from the given image **filename**
        and **parent**. Height map is set by calling **setHeightMapFile** ()
        with **filename**.

        **See also** **heightMapFile** .
        """
        ...

    def heightMap(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#heightMap-prop

        **heightMap : QImage**

        This property holds the height map image to be visualized.

        **Access functions:**

        QImage **heightMap** () const
        void ****setHeightMap** ** (const QImage
        & **image** )

        **Notifier signal:**

        void **heightMapChanged** (const QImage & **image** )
        """
        ...

    def heightMapFile(self) -> str:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#heightMapFile-
        prop

        **heightMapFile : QString**

        This property holds the name of the file with a height map image to be
        visualized.

        **Access functions:**

        QString **heightMapFile** () const
        void ****setHeightMapFile** **
        (const QString & **filename** )

        **Notifier signal:**

        void **heightMapFileChanged** (const QString & **filename** )
        """
        ...

    def maxXValue(self) -> float:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#maxXValue-prop

        **maxXValue : float**

        This property holds the maximum X value for the generated surface
        points.

        Defaults to `10.0`.

        When setting this property the corresponding minimum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **maxXValue** () const
        void **setMaxXValue** (float **max** )

        **Notifier signal:**

        void **maxXValueChanged** (float **value** )
        """
        ...

    def maxZValue(self) -> float:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#maxZValue-prop

        **maxZValue : float**

        This property holds the maximum Z value for the generated surface
        points.

        Defaults to `10.0`.

        When setting this property the corresponding minimum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **maxZValue** () const
        void **setMaxZValue** (float **max** )

        **Notifier signal:**

        void **maxZValueChanged** (float **value** )
        """
        ...

    def minXValue(self) -> float:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#minXValue-prop

        **minXValue : float**

        This property holds the minimum X value for the generated surface
        points.

        Defaults to `0.0`.

        When setting this property the corresponding maximum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **minXValue** () const
        void **setMinXValue** (float **min** )

        **Notifier signal:**

        void **minXValueChanged** (float **value** )
        """
        ...

    def minZValue(self) -> float:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#minZValue-prop

        **minZValue : float**

        This property holds the minimum Z value for the generated surface
        points.

        Defaults to `0.0`.

        When setting this property the corresponding maximum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **minZValue** () const
        void **setMinZValue** (float **min** )

        **Notifier signal:**

        void **minZValueChanged** (float **value** )

        **Member Function Documentation**
        """
        ...

    def setHeightMap(self, image: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#setHeightMap

        **void QHeightMapSurfaceDataProxy::setHeightMap(const QImage & image )**

        Replaces current data with the height map data specified by **image**.

        There are several formats the **image** can be given in, but if it is
        not in a directly usable format, a conversion is made.

        **Note:** If the result seems wrong, the automatic conversion failed and
        you should try converting the **image** yourself before setting it.
        Preferred format is **QImage::Format_RGB32**  in grayscale.

        The height of the **image** is read from the red component of the pixels
        if the **image** is in grayscale, otherwise it is an average calculated
        from red, green, and blue components of the pixels. Using grayscale
        images may improve data conversion speed for large images.

        Not recommended formats: all mono formats (for example
        **QImage::Format_Mono** ).

        The height map is resolved asynchronously.
        **QSurfaceDataProxy::arrayReset** () is emitted when the data has been
        resolved.

        **Note:** Setter function for property **heightMap** .

        **See also** **heightMap** ().
        """
        ...

    def setHeightMapFile(self, filename: str) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#setHeightMapFile

        **void QHeightMapSurfaceDataProxy::setHeightMapFile(const QString &
        filename )**

        Replaces current data with height map data from the file specified by
        **filename**.

        **Note:** Setter function for property **heightMapFile** .

        **See also** **heightMapFile** () and **heightMap** .
        """
        ...

    def setMaxXValue(self, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#maxXValue-prop

        **maxXValue : float**

        This property holds the maximum X value for the generated surface
        points.

        Defaults to `10.0`.

        When setting this property the corresponding minimum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **maxXValue** () const
        void **setMaxXValue** (float **max** )

        **Notifier signal:**

        void **maxXValueChanged** (float **value** )
        """
        ...

    def setMaxZValue(self, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#maxZValue-prop

        **maxZValue : float**

        This property holds the maximum Z value for the generated surface
        points.

        Defaults to `10.0`.

        When setting this property the corresponding minimum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **maxZValue** () const
        void **setMaxZValue** (float **max** )

        **Notifier signal:**

        void **maxZValueChanged** (float **value** )
        """
        ...

    def setMinXValue(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#minXValue-prop

        **minXValue : float**

        This property holds the minimum X value for the generated surface
        points.

        Defaults to `0.0`.

        When setting this property the corresponding maximum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **minXValue** () const
        void **setMinXValue** (float **min** )

        **Notifier signal:**

        void **minXValueChanged** (float **value** )
        """
        ...

    def setMinZValue(self, min: float) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#minZValue-prop

        **minZValue : float**

        This property holds the minimum Z value for the generated surface
        points.

        Defaults to `0.0`.

        When setting this property the corresponding maximum value is adjusted
        if necessary, to ensure that the range remains valid.

        **Access functions:**

        float **minZValue** () const
        void **setMinZValue** (float **min** )

        **Notifier signal:**

        void **minZValueChanged** (float **value** )

        **Member Function Documentation**
        """
        ...

    def setValueRanges(
        self, minX: float, maxX: float, minZ: float, maxZ: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qheightmapsurfacedataproxy.html#setValueRanges

        **void QHeightMapSurfaceDataProxy::setValueRanges(float minX , float
        maxX , float minZ , float maxZ )**

        A convenience function for setting all minimum ( **minX** and **minZ** )
        and maximum ( **maxX** and **maxZ** ) values at the same time. The
        minimum values must be smaller than the corresponding maximum value.
        Otherwise the values get adjusted so that they are valid.
        """
        ...

    @property
    def heightMapChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def heightMapFileChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maxXValueChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maxZValueChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minXValueChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def minZValueChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
