"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QCustom3DItem(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qcustom3ditem.html

    **Detailed Description**

    A custom item has a custom mesh, position, scaling, rotation, and an
    optional texture.

    **See also** **QAbstract3DGraph::addCustomItem** ().
    """

    @overload
    def __init__(
        self,
        meshFile: str,
        position: PySide6.QtGui.QVector3D,
        scaling: PySide6.QtGui.QVector3D,
        rotation: PySide6.QtGui.QQuaternion,
        texture: Union[PySide6.QtGui.QImage, str],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#QCustom3DItem

        **QCustom3DItem::QCustom3DItem(QObject * parent = nullptr)**

        Constructs a custom 3D item with the specified **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#QCustom3DItem-1

        **QCustom3DItem::QCustom3DItem(const QString & meshFile , const
        QVector3D & position , const QVector3D & scaling , const QQuaternion &
        rotation , const QImage & texture , QObject * parent = nullptr)**

        Constructs a custom 3D item with the specified **meshFile** ,
        **position** , **scaling** , **rotation** , **texture** image, and
        optional **parent**.
        """
        ...

    def isPositionAbsolute(self) -> bool:
        ...

    def isScalingAbsolute(self) -> bool:
        ...

    def isShadowCasting(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def meshFile(self) -> str:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#meshFile-prop

        **meshFile : QString**

        This property holds the item mesh file name.

        The item in the file must be in Wavefront OBJ format and include
        vertices, normals, and UVs. It also needs to be in triangles.

        **Access functions:**

        QString **meshFile** () const
        void **setMeshFile** (const QString &
        **meshFile** )

        **Notifier signal:**

        void **meshFileChanged** (const QString & **meshFile** )
        """
        ...

    def position(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#position-prop

        **position : QVector3D**

        This property holds the item position as a **QVector3D** .

        Defaults to `QVector3D(0.0, 0.0, 0.0)`.

        Item position is specified either in data coordinates or in absolute
        coordinates, depending on the **positionAbsolute**  property. When using
        absolute coordinates, values between `-1.0...1.0` are within axis
        ranges.

        **Note:** Items positioned outside any axis range are not rendered if
        **positionAbsolute**  is `false`, unless the item is a
        **QCustom3DVolume**  that would be partially visible and
        **scalingAbsolute**  is also `false`. In that case, the visible portion
        of the volume will be rendered.

        **Access functions:**

        QVector3D **position** () const
        void **setPosition** (const QVector3D
        & **position** )

        **Notifier signal:**

        void **positionChanged** (const QVector3D & **position** )

        **See also** **positionAbsolute** .
        """
        ...

    def rotation(self) -> PySide6.QtGui.QQuaternion:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#rotation-prop

        **rotation : QQuaternion**

        This property holds the item rotation as a **QQuaternion** .

        Defaults to `QQuaternion(0.0, 0.0, 0.0, 0.0)`.

        **Access functions:**

        QQuaternion **rotation** ()
        void **setRotation** (const QQuaternion &
        **rotation** )

        **Notifier signal:**

        void **rotationChanged** (const QQuaternion & **rotation** )
        """
        ...

    def scaling(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#scaling-prop

        **scaling : QVector3D**

        This property holds the item scaling as a **QVector3D** .

        Defaults to `QVector3D(0.1, 0.1, 0.1)`.

        Item scaling is either in data values or in absolute values, depending
        on the **scalingAbsolute**  property. The default vector interpreted as
        absolute values sets the item to 10% of the height of the graph,
        provided the item mesh is normalized and the graph aspect ratios have
        not been changed from the defaults.

        **Access functions:**

        QVector3D **scaling** () const
        void **setScaling** (const QVector3D &
        **scaling** )

        **Notifier signal:**

        void **scalingChanged** (const QVector3D & **scaling** )

        **See also** **scalingAbsolute** .
        """
        ...

    def setMeshFile(self, meshFile: str) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#meshFile-prop

        **meshFile : QString**

        This property holds the item mesh file name.

        The item in the file must be in Wavefront OBJ format and include
        vertices, normals, and UVs. It also needs to be in triangles.

        **Access functions:**

        QString **meshFile** () const
        void **setMeshFile** (const QString &
        **meshFile** )

        **Notifier signal:**

        void **meshFileChanged** (const QString & **meshFile** )
        """
        ...

    def setPosition(self, position: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#position-prop

        **position : QVector3D**

        This property holds the item position as a **QVector3D** .

        Defaults to `QVector3D(0.0, 0.0, 0.0)`.

        Item position is specified either in data coordinates or in absolute
        coordinates, depending on the **positionAbsolute**  property. When using
        absolute coordinates, values between `-1.0...1.0` are within axis
        ranges.

        **Note:** Items positioned outside any axis range are not rendered if
        **positionAbsolute**  is `false`, unless the item is a
        **QCustom3DVolume**  that would be partially visible and
        **scalingAbsolute**  is also `false`. In that case, the visible portion
        of the volume will be rendered.

        **Access functions:**

        QVector3D **position** () const
        void **setPosition** (const QVector3D
        & **position** )

        **Notifier signal:**

        void **positionChanged** (const QVector3D & **position** )

        **See also** **positionAbsolute** .
        """
        ...

    def setPositionAbsolute(self, positionAbsolute: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#positionAbsolute-prop

        **positionAbsolute : bool**

        This property holds whether item position is to be handled in data
        coordinates or in absolute coordinates.

        Defaults to `false`. Items with absolute coordinates will always be
        rendered, whereas items with data coordinates are only rendered if they
        are within axis ranges.

        **Access functions:**

        bool **isPositionAbsolute** () const
        void **setPositionAbsolute**
        (bool **positionAbsolute** )

        **Notifier signal:**

        void **positionAbsoluteChanged** (bool **positionAbsolute** )

        **See also** **position** .
        """
        ...

    def setRotation(self, rotation: PySide6.QtGui.QQuaternion) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#rotation-prop

        **rotation : QQuaternion**

        This property holds the item rotation as a **QQuaternion** .

        Defaults to `QQuaternion(0.0, 0.0, 0.0, 0.0)`.

        **Access functions:**

        QQuaternion **rotation** ()
        void **setRotation** (const QQuaternion &
        **rotation** )

        **Notifier signal:**

        void **rotationChanged** (const QQuaternion & **rotation** )
        """
        ...

    def setRotationAxisAndAngle(
        self, axis: PySide6.QtGui.QVector3D, angle: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#setRotationAxisAndAngle

        **[invokable] void QCustom3DItem::setRotationAxisAndAngle(const
        QVector3D & axis , float angle )**

        A convenience function to construct the rotation quaternion from
        **axis** and **angle**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **rotation** .
        """
        ...

    def setScaling(self, scaling: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#scaling-prop

        **scaling : QVector3D**

        This property holds the item scaling as a **QVector3D** .

        Defaults to `QVector3D(0.1, 0.1, 0.1)`.

        Item scaling is either in data values or in absolute values, depending
        on the **scalingAbsolute**  property. The default vector interpreted as
        absolute values sets the item to 10% of the height of the graph,
        provided the item mesh is normalized and the graph aspect ratios have
        not been changed from the defaults.

        **Access functions:**

        QVector3D **scaling** () const
        void **setScaling** (const QVector3D &
        **scaling** )

        **Notifier signal:**

        void **scalingChanged** (const QVector3D & **scaling** )

        **See also** **scalingAbsolute** .
        """
        ...

    def setScalingAbsolute(self, scalingAbsolute: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#scalingAbsolute-prop

        **[since QtDataVisualization 1.2] scalingAbsolute : bool**

        This property holds whether item scaling is to be handled in data values
        or in absolute values.

        Defaults to `true`.

        Items with absolute scaling will be rendered at the same size,
        regardless of axis ranges. Items with data scaling will change their
        apparent size according to the axis ranges. If **positionAbsolute**  is
        `true`, this property is ignored and scaling is interpreted as an
        absolute value. If the item has rotation, the data scaling is calculated
        on the unrotated item. Similarly, for **QCustom3DVolume**  items, the
        range clipping is calculated on the unrotated item.

        **Note:** Only absolute scaling is supported for **QCustom3DLabel**
        items or for custom items used in **polar**  graphs.

        **Note:** The custom item's mesh must be normalized to the range `[-1
        ,1]`, or the data scaling will not be accurate.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isScalingAbsolute** () const
        void **setScalingAbsolute** (bool
        **scalingAbsolute** )

        **Notifier signal:**

        void **scalingAbsoluteChanged** (bool **scalingAbsolute** )

        **See also** **scaling**  and **positionAbsolute** .
        """
        ...

    def setShadowCasting(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#shadowCasting-prop

        **shadowCasting : bool**

        This property holds whether shadow casting for the item is enabled.

        Defaults to `true`. If `false`, the item does not cast shadows
        regardless of **QAbstract3DGraph::ShadowQuality** .

        **Access functions:**

        bool **isShadowCasting** () const
        void **setShadowCasting** (bool
        **enabled** )

        **Notifier signal:**

        void **shadowCastingChanged** (bool **shadowCasting** )
        """
        ...

    def setTextureFile(self, textureFile: str) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#textureFile-prop

        **textureFile : QString**

        This property holds the texture file name for the item.

        If both this property and the texture image are unset, a solid gray
        texture will be used.

        **Note:** To conserve memory, the **QImage**  loaded from the file is
        cleared after a texture is created.

        **Access functions:**

        QString **textureFile** () const
        void **setTextureFile** (const
        QString & **textureFile** )

        **Notifier signal:**

        void **textureFileChanged** (const QString & **textureFile** )
        """
        ...

    def setTextureImage(self, textureImage: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#setTextureImage

        **void QCustom3DItem::setTextureImage(const QImage & textureImage )**

        Sets the value of **textureImage** as a **QImage**  for the item. The
        texture defaults to solid gray.

        **Note:** To conserve memory, the given **QImage**  is cleared after a
        texture is created.
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#visible-prop

        **visible : bool**

        This property holds the visibility of the item.

        Defaults to `true`.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Notifier signal:**

        void **visibleChanged** (bool **visible** )

        **Member Function Documentation**
        """
        ...

    def textureFile(self) -> str:
        """
        https://doc.qt.io/qt-6/qcustom3ditem.html#textureFile-prop

        **textureFile : QString**

        This property holds the texture file name for the item.

        If both this property and the texture image are unset, a solid gray
        texture will be used.

        **Note:** To conserve memory, the **QImage**  loaded from the file is
        cleared after a texture is created.

        **Access functions:**

        QString **textureFile** () const
        void **setTextureFile** (const
        QString & **textureFile** )

        **Notifier signal:**

        void **textureFileChanged** (const QString & **textureFile** )
        """
        ...

    @property
    def meshFileChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def positionAbsoluteChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def positionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def rotationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def scalingAbsoluteChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def scalingChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def shadowCastingChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def textureFileChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
