"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtDataVisualization, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtDataVisualization

bytes = str


class QAbstract3DGraph(PySide6.QtGui.QWindow):
    """
    https://doc.qt.io/qt-6/qabstract3dgraph.html

    **Detailed Description**

    This class subclasses a **QWindow**  and provides render loop for graphs
    inheriting it.

    You should not need to use this class directly, but one of its subclasses
    instead.

    Anti-aliasing is turned on by default on C++, except in OpenGL ES2
    environments, where anti-aliasing is not supported by Qt Data Visualization.
    To specify non-default anti-aliasing for a graph, give a custom surface
    format as a constructor parameter. You can use the convenience function
    `qDefaultSurfaceFormat()` to create the surface format object.

    **Note:** QAbstract3DGraph sets window flag `Qt::FramelessWindowHint` on by
    default. If you want to display graph windows as standalone windows with
    regular window frame, clear this flag after constructing the graph. For
    example:

    **Q3DBars**  *graphWindow = new **Q3DBars** ;
    graphWindow->setFlags(graphWindow->flags() ^ Qt::FramelessWindowHint);

    **See also** **Q3DBars** , **Q3DScatter** , **Q3DSurface** , and **Qt Data
    Visualization C++ Classes** .
    """

    ElementNone: QAbstract3DGraph.ElementType = ...
    ElementSeries: QAbstract3DGraph.ElementType = ...
    ElementAxisXLabel: QAbstract3DGraph.ElementType = ...
    ElementAxisYLabel: QAbstract3DGraph.ElementType = ...
    ElementAxisZLabel: QAbstract3DGraph.ElementType = ...
    ElementCustomItem: QAbstract3DGraph.ElementType = ...
    OptimizationDefault: QAbstract3DGraph.OptimizationHint = ...
    OptimizationStatic: QAbstract3DGraph.OptimizationHint = ...
    SelectionNone: QAbstract3DGraph.SelectionFlag = ...
    SelectionItem: QAbstract3DGraph.SelectionFlag = ...
    SelectionRow: QAbstract3DGraph.SelectionFlag = ...
    SelectionItemAndRow: QAbstract3DGraph.SelectionFlag = ...
    SelectionColumn: QAbstract3DGraph.SelectionFlag = ...
    SelectionItemAndColumn: QAbstract3DGraph.SelectionFlag = ...
    SelectionRowAndColumn: QAbstract3DGraph.SelectionFlag = ...
    SelectionItemRowAndColumn: QAbstract3DGraph.SelectionFlag = ...
    SelectionSlice: QAbstract3DGraph.SelectionFlag = ...
    SelectionMultiSeries: QAbstract3DGraph.SelectionFlag = ...
    ShadowQualityNone: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualityLow: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualityMedium: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualityHigh: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualitySoftLow: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualitySoftMedium: QAbstract3DGraph.ShadowQuality = ...
    ShadowQualitySoftHigh: QAbstract3DGraph.ShadowQuality = ...

    class ElementType(Enum):
        ElementNone: QAbstract3DGraph.ElementType = ...
        ElementSeries: QAbstract3DGraph.ElementType = ...
        ElementAxisXLabel: QAbstract3DGraph.ElementType = ...
        ElementAxisYLabel: QAbstract3DGraph.ElementType = ...
        ElementAxisZLabel: QAbstract3DGraph.ElementType = ...
        ElementCustomItem: QAbstract3DGraph.ElementType = ...

    class OptimizationHint(Enum):
        OptimizationDefault: QAbstract3DGraph.OptimizationHint = ...
        OptimizationStatic: QAbstract3DGraph.OptimizationHint = ...

    class OptimizationHints(object):
        ...

    class SelectionFlag(Enum):
        SelectionNone: QAbstract3DGraph.SelectionFlag = ...
        SelectionItem: QAbstract3DGraph.SelectionFlag = ...
        SelectionRow: QAbstract3DGraph.SelectionFlag = ...
        SelectionItemAndRow: QAbstract3DGraph.SelectionFlag = ...
        SelectionColumn: QAbstract3DGraph.SelectionFlag = ...
        SelectionItemAndColumn: QAbstract3DGraph.SelectionFlag = ...
        SelectionRowAndColumn: QAbstract3DGraph.SelectionFlag = ...
        SelectionItemRowAndColumn: QAbstract3DGraph.SelectionFlag = ...
        SelectionSlice: QAbstract3DGraph.SelectionFlag = ...
        SelectionMultiSeries: QAbstract3DGraph.SelectionFlag = ...

    class SelectionFlags(object):
        ...

    class ShadowQuality(Enum):
        ShadowQualityNone: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualityLow: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualityMedium: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualityHigh: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualitySoftLow: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualitySoftMedium: QAbstract3DGraph.ShadowQuality = ...
        ShadowQualitySoftHigh: QAbstract3DGraph.ShadowQuality = ...

    def activeInputHandler(self) -> PySide6.QtDataVisualization.QAbstract3DInputHandler:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#activeInputHandler-prop

        **activeInputHandler : QAbstract3DInputHandler***

        This property holds the active input handler used in the graph.

        **Access functions:**

        QAbstract3DInputHandler * **activeInputHandler** () const
        void
        ****setActiveInputHandler** ** (QAbstract3DInputHandler *
        **inputHandler** )

        **Notifier signal:**

        void **activeInputHandlerChanged** (QAbstract3DInputHandler *
        **inputHandler** )
        """
        ...

    def activeTheme(self) -> PySide6.QtDataVisualization.Q3DTheme:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#activeTheme-prop

        **activeTheme : Q3DTheme***

        This property holds the active theme of the graph.

        **Access functions:**

        Q3DTheme * **activeTheme** () const
        void ****setActiveTheme** **
        (Q3DTheme * **theme** )

        **Notifier signal:**

        void **activeThemeChanged** (Q3DTheme * **theme** )
        """
        ...

    def addCustomItem(self, item: PySide6.QtDataVisualization.QCustom3DItem) -> int:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#addCustomItem

        **[since QtDataVisualization 1.1] int
        QAbstract3DGraph::addCustomItem(QCustom3DItem * item )**

        Adds a **QCustom3DItem**  **item** to the graph. Graph takes ownership
        of the added item.

        Returns the index to the added item if the add operation was successful,
        -1 if trying to add a null item, and the index of the item if trying to
        add an already added item.

        Items are rendered in the order they have been inserted. The rendering
        order needs to be taken into account when having solid and transparent
        items.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **removeCustomItems** (), **removeCustomItem** (),
        **removeCustomItemAt** (), and **customItems** ().
        """
        ...

    def addInputHandler(
        self, inputHandler: PySide6.QtDataVisualization.QAbstract3DInputHandler
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#addInputHandler

        **void QAbstract3DGraph::addInputHandler(QAbstract3DInputHandler *
        inputHandler )**

        Adds the given **inputHandler** to the graph. The input handlers added
        via addInputHandler are not taken in to use directly. Only the ownership
        of the **inputHandler** is given to the graph. The **inputHandler** must
        not be null or already added to another graph.

        **See also** **releaseInputHandler** () and **setActiveInputHandler**
        ().
        """
        ...

    def addTheme(self, theme: PySide6.QtDataVisualization.Q3DTheme) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#addTheme

        **void QAbstract3DGraph::addTheme(Q3DTheme * theme )**

        Adds the given **theme** to the graph. The themes added via addTheme are
        not taken in to use directly. Only the ownership of the theme is given
        to the graph. The **theme** must not be null or already added to another
        graph.

        **See also** **releaseTheme** () and **setActiveTheme** ().
        """
        ...

    def aspectRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#aspectRatio-prop

        **[since QtDataVisualization 1.1] aspectRatio : qreal**

        This property holds the ratio of the graph scaling between the longest
        axis on the horizontal plane and the y-axis.

        Defaults to `2.0`.

        **Note:** Has no effect on **Q3DBars** .

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        qreal **aspectRatio** () const
        void **setAspectRatio** (qreal
        **ratio** )

        **Notifier signal:**

        void **aspectRatioChanged** (qreal **ratio** )

        **See also** **horizontalAspectRatio** .
        """
        ...

    def clearSelection(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#clearSelection

        **void QAbstract3DGraph::clearSelection()**

        Clears selection from all attached series.
        """
        ...

    def currentFps(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#currentFps-prop

        **[read-only, since QtDataVisualization 1.1] currentFps : const qreal**

        This property holds the rendering results for the last second.

        The results are stored in this read-only property when FPS measuring is
        enabled. It takes at least a second before this value is updated after
        measuring is activated.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        qreal **currentFps** () const

        **Notifier signal:**

        void **currentFpsChanged** (qreal **fps** )

        **See also** **measureFps** .
        """
        ...

    def customItems(self) -> List[PySide6.QtDataVisualization.QCustom3DItem]:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#customItems

        **[since QtDataVisualization 1.2] QList<QCustom3DItem *>
        QAbstract3DGraph::customItems() const**

        Returns the list of all added custom items.

        This function was introduced in QtDataVisualization 1.2.

        **See also** **addCustomItem** ().
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        ...

    def exposeEvent(self, event: PySide6.QtGui.QExposeEvent) -> None:
        ...

    def hasContext(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#hasContext

        **bool QAbstract3DGraph::hasContext() const**

        Returns `true` if the OpenGL context of the graph has been successfully
        initialized. Trying to use a graph when the context initialization has
        failed typically results in a crash. A common reason for a context
        initialization failure is lack of sufficient platform support for
        OpenGL.
        """
        ...

    def horizontalAspectRatio(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#horizontalAspectRatio-prop

        **[since QtDataVisualization 1.2] horizontalAspectRatio : qreal**

        This property holds the ratio of the graph scaling between the x-axis
        and z-axis.

        The value of `0.0` indicates automatic scaling according to axis ranges.
        Defaults to `0.0`.

        Has no effect on **Q3DBars** , which handles scaling on the horizontal
        plane via the **barThickness**  and **barSpacing**  properties. Polar
        graphs also ignore this property.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **horizontalAspectRatio** () const
        void
        **setHorizontalAspectRatio** (qreal **ratio** )

        **Notifier signal:**

        void **horizontalAspectRatioChanged** (qreal **ratio** )

        **See also** **aspectRatio** , **polar** , **Q3DBars::barThickness** ,
        and **Q3DBars::barSpacing** .
        """
        ...

    def inputHandlers(
        self,
    ) -> List[PySide6.QtDataVisualization.QAbstract3DInputHandler]:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#inputHandlers

        **QList<QAbstract3DInputHandler *> QAbstract3DGraph::inputHandlers()
        const**

        Returns the list of all added input handlers.

        **See also** **addInputHandler** ().
        """
        ...

    def isOrthoProjection(self) -> bool:
        ...

    def isPolar(self) -> bool:
        ...

    def isReflection(self) -> bool:
        ...

    def locale(self) -> PySide6.QtCore.QLocale:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#locale-prop

        **[since QtDataVisualization 1.2] locale : QLocale**

        This property holds the locale used for formatting various numeric
        labels.

        Defaults to the `"C"` locale.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        QLocale **locale** () const
        void **setLocale** (const QLocale &
        **locale** )

        **Notifier signal:**

        void **localeChanged** (const QLocale & **locale** )

        **See also** **QValue3DAxis::labelFormat** .
        """
        ...

    def margin(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#margin-prop

        **[since QtDataVisualization 1.2] margin : qreal**

        This property holds the absolute value used for the space left between
        the edge of the plottable graph area and the edge of the graph
        background.

        If the margin value is negative, the margins are determined
        automatically and can vary according to the size of the items in the
        series and the type of the graph. The value is interpreted as a fraction
        of the y-axis range if the graph aspect ratios have not beed changed
        from the default values. Defaults to `-1.0`.

        **Note:** Setting a smaller margin for a scatter graph than the
        automatically determined margin can cause the scatter items at the edges
        of the graph to overlap with the graph background.

        **Note:** On scatter and surface graphs, if the margin is small in
        comparison to the axis label size, the positions of the edge labels of
        the axes are adjusted to avoid overlap with the edge labels of the
        neighboring axes.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **margin** () const
        void **setMargin** (qreal **margin** )

        **Notifier signal:**

        void **marginChanged** (qreal **margin** )
        """
        ...

    def measureFps(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#measureFps-prop

        **[since QtDataVisualization 1.1] measureFps : bool**

        This property holds whether rendering is done continuously instead of on
        demand.

        If `true`, rendering is continuous and the value of the **currentFps**
        property is updated. Defaults to `false`.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        bool **measureFps** () const
        void **setMeasureFps** (bool **enable** )

        **Notifier signal:**

        void **measureFpsChanged** (bool **enabled** )

        **See also** **currentFps** .
        """
        ...

    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        ...

    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        ...

    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        ...

    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None:
        ...

    def optimizationHints(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DGraph.OptimizationHints:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#optimizationHints-prop

        **optimizationHints : OptimizationHints**

        This property holds whether the default or static mode is used for
        rendering optimization.

        The default mode provides the full feature set at a reasonable level of
        performance. The static mode optimizes graph rendering and is ideal for
        large non-changing data sets. It is slower with dynamic data changes and
        item rotations. Selection is not optimized, so using the static mode
        with massive data sets is not advisable. Static optimization works only
        on scatter graphs. Defaults to **OptimizationDefault** .

        **Note:** On some environments, large graphs using static optimization
        may not render, because all of the items are rendered using a single
        draw call, and different graphics drivers support different maximum
        vertice counts per call. This is mostly an issue on 32bit and OpenGL ES2
        platforms. To work around this issue, choose an item mesh with a low
        vertex count or use the point mesh.

        **Access functions:**

        QAbstract3DGraph::OptimizationHints **optimizationHints** () const
        void **setOptimizationHints** (QAbstract3DGraph::OptimizationHints
        **hints** )

        **Notifier signal:**

        void **optimizationHintsChanged** (QAbstract3DGraph::OptimizationHints
        **hints** )

        **See also** **QAbstract3DSeries::mesh** .
        """
        ...

    def queriedGraphPosition(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#queriedGraphPosition-prop

        **[read-only, since QtDataVisualization 1.2] queriedGraphPosition :
        const QVector3D**

        This property holds the latest queried graph position values along each
        axis.

        This read-only property contains the results from
        **Q3DScene::graphPositionQuery** . The values are normalized to the
        range `[-1, 1]`. If the queried position was outside the graph bounds,
        the values will not reflect the real position, but will instead indicate
        an undefined position outside the range `[-1, 1]`. The value will be
        undefined until a query is made.

        There is no single correct 3D coordinate to match a particular screen
        position, so to be consistent, the queries are always done against the
        inner sides of an invisible box surrounding the graph.

        **Note:** Bar graphs only allow querying graph position at the graph
        floor level, so the y-value is always zero for bar graphs and the valid
        queries can be only made at screen positions that contain the floor of
        the graph.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        QVector3D **queriedGraphPosition** () const

        **Notifier signal:**

        void **queriedGraphPositionChanged** (const QVector3D & **data** )

        **See also** **Q3DScene::graphPositionQuery** .
        """
        ...

    def radialLabelOffset(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#radialLabelOffset-prop

        **[since QtDataVisualization 1.2] radialLabelOffset : float**

        This property holds the normalized horizontal offset for the axis labels
        of the radial polar axis.

        The value `0.0` indicates that the labels should be drawn next to the
        0-angle angular axis grid line. The value `1.0` indicates that the
        labels are drawn in their usual place at the edge of the graph
        background. Defaults to `1.0`.

        This property is ignored if the **polar**  property value is `false`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        float **radialLabelOffset** () const
        void **setRadialLabelOffset**
        (float **offset** )

        **Notifier signal:**

        void **radialLabelOffsetChanged** (float **offset** )

        **See also** **polar** .
        """
        ...

    def reflectivity(self) -> float:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#reflectivity-prop

        **[since QtDataVisualization 1.2] reflectivity : qreal**

        Floor reflectivity.

        Larger numbers make the floor more reflective. The valid range is
        `[0...1]`. Defaults to `0.5`.

        **Note:** Affects only **Q3DBars** .

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **reflectivity** () const
        void **setReflectivity** (qreal
        **reflectivity** )

        **Notifier signal:**

        void **reflectivityChanged** (qreal **reflectivity** )

        **See also** **reflection** .
        """
        ...

    def releaseCustomItem(
        self, item: PySide6.QtDataVisualization.QCustom3DItem
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#releaseCustomItem

        **[since QtDataVisualization 1.1] void
        QAbstract3DGraph::releaseCustomItem(QCustom3DItem * item )**

        Gets ownership of given **item** back and removes the **item** from the
        graph.

        **Note:** If the same item is added back to the graph, the texture or
        the texture file needs to be re-set.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **QCustom3DItem::setTextureImage** () and
        **QCustom3DItem::setTextureFile** ().
        """
        ...

    def releaseInputHandler(
        self, inputHandler: PySide6.QtDataVisualization.QAbstract3DInputHandler
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#releaseInputHandler

        **void QAbstract3DGraph::releaseInputHandler(QAbstract3DInputHandler *
        inputHandler )**

        Releases the ownership of the **inputHandler** back to the caller, if it
        was added to this graph. If the released **inputHandler** is in use
        there will be no input handler active after this call.

        If the default input handler is released and added back later, it
        behaves as any other input handler would.

        **See also** **addInputHandler** () and **setActiveInputHandler** ().
        """
        ...

    def releaseTheme(self, theme: PySide6.QtDataVisualization.Q3DTheme) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#releaseTheme

        **void QAbstract3DGraph::releaseTheme(Q3DTheme * theme )**

        Releases the ownership of the **theme** back to the caller, if it was
        added to this graph. If the released **theme** is in use, a new default
        theme will be created and set active.

        If the default theme is released and added back later, it behaves as any
        other theme would.

        **See also** **addTheme** () and **setActiveTheme** ().
        """
        ...

    def removeCustomItem(self, item: PySide6.QtDataVisualization.QCustom3DItem) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#removeCustomItem

        **[since QtDataVisualization 1.1] void
        QAbstract3DGraph::removeCustomItem(QCustom3DItem * item )**

        Removes the custom **item**. Deletes the resources allocated to it.

        This function was introduced in QtDataVisualization 1.1.
        """
        ...

    def removeCustomItemAt(self, position: PySide6.QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#removeCustomItemAt

        **[since QtDataVisualization 1.1] void
        QAbstract3DGraph::removeCustomItemAt(const QVector3D & position )**

        Removes all custom items at **position**. Deletes the resources
        allocated to them.

        This function was introduced in QtDataVisualization 1.1.
        """
        ...

    def removeCustomItems(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#removeCustomItems

        **[since QtDataVisualization 1.1] void
        QAbstract3DGraph::removeCustomItems()**

        Removes all custom items. Deletes the resources allocated to them.

        This function was introduced in QtDataVisualization 1.1.
        """
        ...

    def renderToImage(
        self, msaaSamples: int = ..., imageSize: PySide6.QtCore.QSize = ...
    ) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#renderToImage

        **[since QtDataVisualization 1.1] QImage
        QAbstract3DGraph::renderToImage(int msaaSamples = 0, const QSize &
        imageSize = QSize())**

        Renders current frame to an image of **imageSize**. Default size is the
        window size. Image is rendered with antialiasing level given in
        **msaaSamples**. Default level is `0`.

        Returns the rendered image.

        **Note:** OpenGL ES2 does not support anitialiasing, so **msaaSamples**
        is always forced to `0`.

        This function was introduced in QtDataVisualization 1.1.
        """
        ...

    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None:
        ...

    def scene(self) -> PySide6.QtDataVisualization.Q3DScene:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#scene-prop

        **[read-only] scene : Q3DScene* const**

        This property holds the **Q3DScene**  pointer that can be used to
        manipulate the scene and access the scene elements, such as the active
        camera.

        This property is read-only.

        **Access functions:**

        Q3DScene * **scene** () const
        """
        ...

    def selectedAxis(self) -> PySide6.QtDataVisualization.QAbstract3DAxis:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectedAxis

        **[since QtDataVisualization 1.1] QAbstract3DAxis
        *QAbstract3DGraph::selectedAxis() const**

        Can be used to get the selected axis after receiving
        `selectedElementChanged` signal with any label type. Selection is valid
        until the next `selectedElementChanged` signal.

        Returns the pointer to the selected axis, or null.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **selectedElement** .
        """
        ...

    def selectedCustomItem(self) -> PySide6.QtDataVisualization.QCustom3DItem:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectedCustomItem

        **[since QtDataVisualization 1.1] QCustom3DItem
        *QAbstract3DGraph::selectedCustomItem() const**

        Can be used to get the selected custom item after receiving
        `selectedElementChanged` signal with
        **QAbstract3DGraph::ElementCustomItem**  type. Ownership of the item
        remains with the graph. Selection is valid until the next
        `selectedElementChanged` signal.

        Returns the pointer to the selected custom item, or null.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **selectedElement** .
        """
        ...

    def selectedCustomItemIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectedCustomItemIndex

        **[since QtDataVisualization 1.1] int
        QAbstract3DGraph::selectedCustomItemIndex() const**

        Can be used to query the index of the selected custom item after
        receiving `selectedElementChanged` signal with
        **QAbstract3DGraph::ElementCustomItem**  type. Selection is valid until
        the next `selectedElementChanged` signal.

        Returns the index of the selected custom item, or -1.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **selectedElement** .
        """
        ...

    def selectedElement(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DGraph.ElementType:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectedElement-prop

        **[read-only, since QtDataVisualization 1.1] selectedElement : const
        ElementType**

        This property holds the element selected in the graph.

        This property can be used to query the selected element type. The type
        is valid until a new selection is made in the graph and the
        `selectedElementChanged` signal is emitted.

        The signal can be used for example for implementing custom input
        handlers, as demonstrated by the **Axis Range Dragging With Labels
        Example** .

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        QAbstract3DGraph::ElementType **selectedElement** () const

        **Notifier signal:**

        void **selectedElementChanged** (QAbstract3DGraph::ElementType **type**
        )

        **See also** **selectedLabelIndex** (), **selectedAxis** (),
        **selectedCustomItemIndex** (), **selectedCustomItem** (),
        **Q3DBars::selectedSeries** (), **Q3DScatter::selectedSeries** (),
        **Q3DSurface::selectedSeries** (), and
        **Q3DScene::setSelectionQueryPosition** ().
        """
        ...

    def selectedLabelIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectedLabelIndex

        **[since QtDataVisualization 1.1] int
        QAbstract3DGraph::selectedLabelIndex() const**

        Can be used to query the index of the selected label after receiving
        `selectedElementChanged` signal with any label type. Selection is valid
        until the next `selectedElementChanged` signal.

        Returns the index of the selected label, or -1.

        This function was introduced in QtDataVisualization 1.1.

        **See also** **selectedElement** .
        """
        ...

    def selectionMode(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DGraph.SelectionFlags:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectionMode-prop

        **selectionMode : SelectionFlags**

        Item selection mode.

        A combination of **SelectionFlags** . By default, `SelectionItem`.
        Different graph types support different selection modes.

        **Access functions:**

        QAbstract3DGraph::SelectionFlags **selectionMode** () const
        void
        **setSelectionMode** (QAbstract3DGraph::SelectionFlags **mode** )

        **Notifier signal:**

        void **selectionModeChanged** (QAbstract3DGraph::SelectionFlags **mode**
        )

        **See also** **SelectionFlags** .
        """
        ...

    def setActiveInputHandler(
        self, inputHandler: PySide6.QtDataVisualization.QAbstract3DInputHandler
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#setActiveInputHandler

        **void QAbstract3DGraph::setActiveInputHandler(QAbstract3DInputHandler *
        inputHandler )**

        Sets **inputHandler** as the active input handler used in the graph.
        Implicitly calls **addInputHandler** () to transfer ownership of
        **inputHandler** to this graph.

        If **inputHandler** is null, no input handler will be active after this
        call.

        **Note:** Setter function for property **activeInputHandler** .

        **See also** **activeInputHandler** (), **addInputHandler** (), and
        **releaseInputHandler** ().
        """
        ...

    def setActiveTheme(self, theme: PySide6.QtDataVisualization.Q3DTheme) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#setActiveTheme

        **void QAbstract3DGraph::setActiveTheme(Q3DTheme * theme )**

        Sets **theme** as the active theme to be used for the graph. Implicitly
        calls **addTheme** () to transfer the ownership of the theme to this
        graph.

        If **theme** is null, a temporary default theme is created. This
        temporary theme is destroyed if any theme is explicitly set later.
        Properties of the theme can be modified even after setting it, and the
        modifications take effect immediately.

        **Note:** Setter function for property **activeTheme** .

        **See also** **activeTheme** ().
        """
        ...

    def setAspectRatio(self, ratio: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#aspectRatio-prop

        **[since QtDataVisualization 1.1] aspectRatio : qreal**

        This property holds the ratio of the graph scaling between the longest
        axis on the horizontal plane and the y-axis.

        Defaults to `2.0`.

        **Note:** Has no effect on **Q3DBars** .

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        qreal **aspectRatio** () const
        void **setAspectRatio** (qreal
        **ratio** )

        **Notifier signal:**

        void **aspectRatioChanged** (qreal **ratio** )

        **See also** **horizontalAspectRatio** .
        """
        ...

    def setHorizontalAspectRatio(self, ratio: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#horizontalAspectRatio-prop

        **[since QtDataVisualization 1.2] horizontalAspectRatio : qreal**

        This property holds the ratio of the graph scaling between the x-axis
        and z-axis.

        The value of `0.0` indicates automatic scaling according to axis ranges.
        Defaults to `0.0`.

        Has no effect on **Q3DBars** , which handles scaling on the horizontal
        plane via the **barThickness**  and **barSpacing**  properties. Polar
        graphs also ignore this property.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **horizontalAspectRatio** () const
        void
        **setHorizontalAspectRatio** (qreal **ratio** )

        **Notifier signal:**

        void **horizontalAspectRatioChanged** (qreal **ratio** )

        **See also** **aspectRatio** , **polar** , **Q3DBars::barThickness** ,
        and **Q3DBars::barSpacing** .
        """
        ...

    def setLocale(
        self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#locale-prop

        **[since QtDataVisualization 1.2] locale : QLocale**

        This property holds the locale used for formatting various numeric
        labels.

        Defaults to the `"C"` locale.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        QLocale **locale** () const
        void **setLocale** (const QLocale &
        **locale** )

        **Notifier signal:**

        void **localeChanged** (const QLocale & **locale** )

        **See also** **QValue3DAxis::labelFormat** .
        """
        ...

    def setMargin(self, margin: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#margin-prop

        **[since QtDataVisualization 1.2] margin : qreal**

        This property holds the absolute value used for the space left between
        the edge of the plottable graph area and the edge of the graph
        background.

        If the margin value is negative, the margins are determined
        automatically and can vary according to the size of the items in the
        series and the type of the graph. The value is interpreted as a fraction
        of the y-axis range if the graph aspect ratios have not beed changed
        from the default values. Defaults to `-1.0`.

        **Note:** Setting a smaller margin for a scatter graph than the
        automatically determined margin can cause the scatter items at the edges
        of the graph to overlap with the graph background.

        **Note:** On scatter and surface graphs, if the margin is small in
        comparison to the axis label size, the positions of the edge labels of
        the axes are adjusted to avoid overlap with the edge labels of the
        neighboring axes.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **margin** () const
        void **setMargin** (qreal **margin** )

        **Notifier signal:**

        void **marginChanged** (qreal **margin** )
        """
        ...

    def setMeasureFps(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#measureFps-prop

        **[since QtDataVisualization 1.1] measureFps : bool**

        This property holds whether rendering is done continuously instead of on
        demand.

        If `true`, rendering is continuous and the value of the **currentFps**
        property is updated. Defaults to `false`.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        bool **measureFps** () const
        void **setMeasureFps** (bool **enable** )

        **Notifier signal:**

        void **measureFpsChanged** (bool **enabled** )

        **See also** **currentFps** .
        """
        ...

    def setOptimizationHints(
        self, hints: PySide6.QtDataVisualization.QAbstract3DGraph.OptimizationHints
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#optimizationHints-prop

        **optimizationHints : OptimizationHints**

        This property holds whether the default or static mode is used for
        rendering optimization.

        The default mode provides the full feature set at a reasonable level of
        performance. The static mode optimizes graph rendering and is ideal for
        large non-changing data sets. It is slower with dynamic data changes and
        item rotations. Selection is not optimized, so using the static mode
        with massive data sets is not advisable. Static optimization works only
        on scatter graphs. Defaults to **OptimizationDefault** .

        **Note:** On some environments, large graphs using static optimization
        may not render, because all of the items are rendered using a single
        draw call, and different graphics drivers support different maximum
        vertice counts per call. This is mostly an issue on 32bit and OpenGL ES2
        platforms. To work around this issue, choose an item mesh with a low
        vertex count or use the point mesh.

        **Access functions:**

        QAbstract3DGraph::OptimizationHints **optimizationHints** () const
        void **setOptimizationHints** (QAbstract3DGraph::OptimizationHints
        **hints** )

        **Notifier signal:**

        void **optimizationHintsChanged** (QAbstract3DGraph::OptimizationHints
        **hints** )

        **See also** **QAbstract3DSeries::mesh** .
        """
        ...

    def setOrthoProjection(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#orthoProjection-prop

        **[since QtDataVisualization 1.1] orthoProjection : bool**

        This property holds whether orthographic projection is used for
        displaying the graph.

        Defaults to `false`.

        **Note:** Shadows will be disabled when set to `true`.

        This property was introduced in QtDataVisualization 1.1.

        **Access functions:**

        bool **isOrthoProjection** () const
        void **setOrthoProjection** (bool
        **enable** )

        **Notifier signal:**

        void **orthoProjectionChanged** (bool **enabled** )

        **See also** **QAbstract3DAxis::labelAutoRotation**  and
        **Q3DCamera::cameraPreset** .
        """
        ...

    def setPolar(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#polar-prop

        **[since QtDataVisualization 1.2] polar : bool**

        This property holds whether horizontal axes are changed into polar axes.

        If `true`, the x-axis becomes the angular axis and the z-axis becomes
        the radial axis. Polar mode is not available for bar graphs.

        Defaults to `false`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isPolar** () const
        void **setPolar** (bool **enable** )

        **Notifier signal:**

        void **polarChanged** (bool **enabled** )

        **See also** **orthoProjection**  and **radialLabelOffset** .
        """
        ...

    def setRadialLabelOffset(self, offset: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#radialLabelOffset-prop

        **[since QtDataVisualization 1.2] radialLabelOffset : float**

        This property holds the normalized horizontal offset for the axis labels
        of the radial polar axis.

        The value `0.0` indicates that the labels should be drawn next to the
        0-angle angular axis grid line. The value `1.0` indicates that the
        labels are drawn in their usual place at the edge of the graph
        background. Defaults to `1.0`.

        This property is ignored if the **polar**  property value is `false`.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        float **radialLabelOffset** () const
        void **setRadialLabelOffset**
        (float **offset** )

        **Notifier signal:**

        void **radialLabelOffsetChanged** (float **offset** )

        **See also** **polar** .
        """
        ...

    def setReflection(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#reflection-prop

        **[since QtDataVisualization 1.2] reflection : bool**

        This property holds whether floor reflections are on or off.

        Defaults to `false`.

        Affects only **Q3DBars** . However, in **Q3DBars**  graphs holding both
        positive and negative values, reflections are not supported for custom
        items that intersect the floor plane. In that case, reflections should
        be turned off to avoid incorrect rendering.

        If using a custom surface format, the stencil buffer needs to be defined
        (**QSurfaceFormat::setStencilBufferSize** ()) for reflections to work.

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        bool **isReflection** () const
        void **setReflection** (bool **enable**
        )

        **Notifier signal:**

        void **reflectionChanged** (bool **enabled** )

        **See also** **reflectivity** .
        """
        ...

    def setReflectivity(self, reflectivity: float) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#reflectivity-prop

        **[since QtDataVisualization 1.2] reflectivity : qreal**

        Floor reflectivity.

        Larger numbers make the floor more reflective. The valid range is
        `[0...1]`. Defaults to `0.5`.

        **Note:** Affects only **Q3DBars** .

        This property was introduced in QtDataVisualization 1.2.

        **Access functions:**

        qreal **reflectivity** () const
        void **setReflectivity** (qreal
        **reflectivity** )

        **Notifier signal:**

        void **reflectivityChanged** (qreal **reflectivity** )

        **See also** **reflection** .
        """
        ...

    def setSelectionMode(
        self, mode: PySide6.QtDataVisualization.QAbstract3DGraph.SelectionFlags
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#selectionMode-prop

        **selectionMode : SelectionFlags**

        Item selection mode.

        A combination of **SelectionFlags** . By default, `SelectionItem`.
        Different graph types support different selection modes.

        **Access functions:**

        QAbstract3DGraph::SelectionFlags **selectionMode** () const
        void
        **setSelectionMode** (QAbstract3DGraph::SelectionFlags **mode** )

        **Notifier signal:**

        void **selectionModeChanged** (QAbstract3DGraph::SelectionFlags **mode**
        )

        **See also** **SelectionFlags** .
        """
        ...

    def setShadowQuality(
        self, quality: PySide6.QtDataVisualization.QAbstract3DGraph.ShadowQuality
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#shadowQuality-prop

        **shadowQuality : ShadowQuality**

        This property holds the quality of the shadow.

        One of the **ShadowQuality**  enum values. By default,
        `ShadowQualityMedium`.

        **Note:** If setting the shadow quality to a certain level fails, the
        level is lowered until it is successfully set. The
        `shadowQualityChanged` signal is emitted each time a change is made.

        **Access functions:**

        QAbstract3DGraph::ShadowQuality **shadowQuality** () const
        void
        **setShadowQuality** (QAbstract3DGraph::ShadowQuality **quality** )

        **Notifier signal:**

        void **shadowQualityChanged** (QAbstract3DGraph::ShadowQuality
        **quality** )

        **See also** **ShadowQuality** .

        **Member Function Documentation**
        """
        ...

    def shadowQuality(
        self,
    ) -> PySide6.QtDataVisualization.QAbstract3DGraph.ShadowQuality:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#shadowQuality-prop

        **shadowQuality : ShadowQuality**

        This property holds the quality of the shadow.

        One of the **ShadowQuality**  enum values. By default,
        `ShadowQualityMedium`.

        **Note:** If setting the shadow quality to a certain level fails, the
        level is lowered until it is successfully set. The
        `shadowQualityChanged` signal is emitted each time a change is made.

        **Access functions:**

        QAbstract3DGraph::ShadowQuality **shadowQuality** () const
        void
        **setShadowQuality** (QAbstract3DGraph::ShadowQuality **quality** )

        **Notifier signal:**

        void **shadowQualityChanged** (QAbstract3DGraph::ShadowQuality
        **quality** )

        **See also** **ShadowQuality** .

        **Member Function Documentation**
        """
        ...

    def shadowsSupported(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#shadowsSupported

        **[virtual] bool QAbstract3DGraph::shadowsSupported() const**

        Returns `true` if shadows are supported with the current configuration.
        OpenGL ES2 configurations do not support shadows.
        """
        ...

    def themes(self) -> List[PySide6.QtDataVisualization.Q3DTheme]:
        """
        https://doc.qt.io/qt-6/qabstract3dgraph.html#themes

        **QList<Q3DTheme *> QAbstract3DGraph::themes() const**

        Returns the list of all added themes.

        **See also** **addTheme** ().
        """
        ...

    def touchEvent(self, event: PySide6.QtGui.QTouchEvent) -> None:
        ...

    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None:
        ...

    @property
    def activeInputHandlerChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def activeThemeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def aspectRatioChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def currentFpsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def horizontalAspectRatioChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def localeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def marginChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def measureFpsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def optimizationHintsChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def orthoProjectionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def polarChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def queriedGraphPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def radialLabelOffsetChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def reflectionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def reflectivityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectedElementChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectionModeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def shadowQualityChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
