"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore

bytes = str


class QSystemSemaphore(object):
    """
    https://doc.qt.io/qt-6/qsystemsemaphore.html

    **Detailed Description**

    A semaphore is a generalization of a mutex. While a mutex can be locked only
    once, a semaphore can be acquired multiple times. Typically, a semaphore is
    used to protect a certain number of identical resources.

    Like its lighter counterpart **QSemaphore** , a QSystemSemaphore can be
    accessed from multiple **threads** . Unlike **QSemaphore** , a
    QSystemSemaphore can also be accessed from multiple **processes** . This
    means QSystemSemaphore is a much heavier class, so if your application
    doesn't need to access your semaphores across multiple processes, you will
    probably want to use **QSemaphore** .

    Semaphores support two fundamental operations, **acquire** () and
    **release** ():

    **acquire** () tries to acquire one resource. If there isn't a resource
    available, the call blocks until a resource becomes available. Then the
    resource is acquired and the call returns.

    **release** () releases one resource so it can be acquired by another
    process. The function can also be called with a parameter n > 1, which
    releases n resources.

    A system semaphore is created with a string key that other processes can use
    to use the same semaphore.

    Example: Create a system semaphore

    **QSystemSemaphore**  sem("market", 3, **QSystemSemaphore** ::Create);
    // resources available == 3
        sem.acquire();               // resources
    available == 2
        sem.acquire();               // resources available == 1
    sem.acquire();               // resources available == 0
        sem.release();
    // resources available == 1
        sem.release(2);              // resources
    available == 3

    A typical application of system semaphores is for controlling access to a
    circular buffer shared by a producer process and a consumer processes.

    **Platform-Specific Behavior**

    When using this class, be aware of the following platform differences:

    **Windows:** QSystemSemaphore does not own its underlying system semaphore.
    Windows owns it. This means that when all instances of QSystemSemaphore for
    a particular key have been destroyed, either by having their destructors
    called, or because one or more processes crash, Windows removes the
    underlying system semaphore.

    **Unix:**

    * QSystemSemaphore owns the underlying system semaphore in Unix systems.
    This means that the last process having an instance of QSystemSemaphore for
    a particular key must remove the underlying system semaphore in its
    destructor. If the last process crashes without running the QSystemSemaphore
    destructor, Unix does not automatically remove the underlying system
    semaphore, and the semaphore survives the crash. A subsequent process that
    constructs a QSystemSemaphore with the same key will then be given the
    existing system semaphore. In that case, if the QSystemSemaphore constructor
    has specified its **access mode**  as **Open** , its initial resource count
    will not be reset to the one provided but remain set to the value it
    received in the crashed process. To protect against this, the first process
    to create a semaphore for a particular key (usually a server), must pass its
    **access mode**  as **Create** , which will force Unix to reset the resource
    count in the underlying system semaphore.
      * When a process using
    QSystemSemaphore terminates for any reason, Unix automatically reverses the
    effect of all acquire operations that were not released. Thus if the process
    acquires a resource and then exits without releasing it, Unix will release
    that resource.

    **Apple platforms:** Sandboxed applications (including apps shipped through
    the Apple App Store) require the key to be in the form `<application group
    identifier>/<custom identifier>`, as documented **here**  and **here** , and
    the key length is limited to 30 characters.

    **See also** **QSharedMemory**  and **QSemaphore** .
    """

    Open: QSystemSemaphore.AccessMode = ...
    Create: QSystemSemaphore.AccessMode = ...
    NoError: QSystemSemaphore.SystemSemaphoreError = ...
    PermissionDenied: QSystemSemaphore.SystemSemaphoreError = ...
    KeyError: QSystemSemaphore.SystemSemaphoreError = ...
    AlreadyExists: QSystemSemaphore.SystemSemaphoreError = ...
    NotFound: QSystemSemaphore.SystemSemaphoreError = ...
    OutOfResources: QSystemSemaphore.SystemSemaphoreError = ...
    UnknownError: QSystemSemaphore.SystemSemaphoreError = ...

    class AccessMode(Enum):
        Open: QSystemSemaphore.AccessMode = ...
        Create: QSystemSemaphore.AccessMode = ...

    class SystemSemaphoreError(Enum):
        NoError: QSystemSemaphore.SystemSemaphoreError = ...
        PermissionDenied: QSystemSemaphore.SystemSemaphoreError = ...
        KeyError: QSystemSemaphore.SystemSemaphoreError = ...
        AlreadyExists: QSystemSemaphore.SystemSemaphoreError = ...
        NotFound: QSystemSemaphore.SystemSemaphoreError = ...
        OutOfResources: QSystemSemaphore.SystemSemaphoreError = ...
        UnknownError: QSystemSemaphore.SystemSemaphoreError = ...

    def __init__(
        self,
        key: str,
        initialValue: int = ...,
        mode: PySide6.QtCore.QSystemSemaphore.AccessMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#QSystemSemaphore

        **QSystemSemaphore::QSystemSemaphore(const QString & key , int
        initialValue = 0, QSystemSemaphore::AccessMode mode = Open)**

        Requests a system semaphore for the specified **key**. The parameters
        **initialValue** and **mode** are used according to the following rules,
        which are system dependent.

        In Unix, if the **mode** is **Open**  and the system already has a
        semaphore identified by **key** , that semaphore is used, and the
        semaphore's resource count is not changed, i.e., **initialValue** is
        ignored. But if the system does not already have a semaphore identified
        by **key** , it creates a new semaphore for that key and sets its
        resource count to **initialValue**.

        In Unix, if the **mode** is **Create**  and the system already has a
        semaphore identified by **key** , that semaphore is used, and its
        resource count is set to **initialValue**. If the system does not
        already have a semaphore identified by **key** , it creates a new
        semaphore for that key and sets its resource count to **initialValue**.

        In Windows, **mode** is ignored, and the system always tries to create a
        semaphore for the specified **key**. If the system does not already have
        a semaphore identified as **key** , it creates the semaphore and sets
        its resource count to **initialValue**. But if the system already has a
        semaphore identified as **key** it uses that semaphore and ignores
        **initialValue**.

        The **mode**  parameter is only used in Unix systems to handle the case
        where a semaphore survives a process crash. In that case, the next
        process to allocate a semaphore with the same **key** will get the
        semaphore that survived the crash, and unless **mode** is **Create** ,
        the resource count will not be reset to **initialValue** but will retain
        the initial value it had been given by the crashed process.

        **See also** **acquire** () and **key** ().
        """
        ...

    def acquire(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#acquire

        **bool QSystemSemaphore::acquire()**

        Acquires one of the resources guarded by this semaphore, if there is one
        available, and returns `true`. If all the resources guarded by this
        semaphore have already been acquired, the call blocks until one of them
        is released by another process or thread having a semaphore with the
        same key.

        If false is returned, a system error has occurred. Call **error** () to
        get a value of **QSystemSemaphore::SystemSemaphoreError**  that
        indicates which error occurred.

        **See also** **release** ().
        """
        ...

    def error(self) -> PySide6.QtCore.QSystemSemaphore.SystemSemaphoreError:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#error

        **QSystemSemaphore::SystemSemaphoreError QSystemSemaphore::error()
        const**

        Returns a value indicating whether an error occurred, and, if so, which
        error it was.

        **See also** **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#errorString

        **QString QSystemSemaphore::errorString() const**

        Returns a text description of the last error that occurred. If **error**
        () returns an **error value** , call this function to get a text string
        that describes the error.

        **See also** **error** ().
        """
        ...

    def key(self) -> str:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#key

        **QString QSystemSemaphore::key() const**

        Returns the key assigned to this system semaphore. The key is the name
        by which the semaphore can be accessed from other processes.

        **See also** **setKey** ().
        """
        ...

    def release(self, n: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#release

        **bool QSystemSemaphore::release(int n = 1)**

        Releases **n** resources guarded by the semaphore. Returns `true` unless
        there is a system error.

        Example: Create a system semaphore having five resources; acquire them
        all and then release them all.

        **QSystemSemaphore**  sem("market", 5, **QSystemSemaphore** ::Create);
        for (int i = 0; i < 5; ++i)  // acquire all 5 resources
        sem.acquire();
            sem.release(5);              // release the 5
        resources

        This function can also "create" resources. For example, immediately
        following the sequence of statements above, suppose we add the
        statement:

        sem.release(10);          // "create" 10 new resources

        Ten new resources are now guarded by the semaphore, in addition to the
        five that already existed. You would not normally use this function to
        create more resources.

        **See also** **acquire** ().
        """
        ...

    def setKey(
        self,
        key: str,
        initialValue: int = ...,
        mode: PySide6.QtCore.QSystemSemaphore.AccessMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsystemsemaphore.html#setKey

        **void QSystemSemaphore::setKey(const QString & key , int initialValue =
        0, QSystemSemaphore::AccessMode mode = Open)**

        This function works the same as the constructor. It reconstructs this
        **QSystemSemaphore**  object. If the new **key** is different from the
        old key, calling this function is like calling the destructor of the
        semaphore with the old key, then calling the constructor to create a new
        semaphore with the new **key**. The **initialValue** and **mode**
        parameters are as defined for the constructor.

        **See also** **QSystemSemaphore** () and **key** ().
        """
        ...
