"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore

bytes = str


class QSaveFile(PySide6.QtCore.QFileDevice):
    """
    https://doc.qt.io/qt-6/qsavefile.html

    **Detailed Description**

    QSaveFile is an I/O device for writing text and binary files, without losing
    existing data if the writing operation fails.

    While writing, the contents will be written to a temporary file, and if no
    error happened, **commit** () will move it to the final file. This ensures
    that no data at the final file is lost in case an error happens while
    writing, and no partially-written file is ever present at the final
    location. Always use QSaveFile when saving entire documents to disk.

    QSaveFile automatically detects errors while writing, such as the full
    partition situation, where **write** () cannot write all the bytes. It will
    remember that an error happened, and will discard the temporary file in
    **commit** ().

    Much like with **QFile** , the file is opened with **open** (). Data is
    usually read and written using **QDataStream**  or **QTextStream** , but you
    can also call the **QIODevice** -inherited functions **read** (),
    **readLine** (), **readAll** (), **write** ().

    Unlike **QFile** , calling **close** () is not allowed. **commit** ()
    replaces it. If **commit** () was not called and the QSaveFile instance is
    destroyed, the temporary file is discarded.

    To abort saving due to an application error, call **cancelWriting** (), so
    that even a call to **commit** () later on will not save.

    **See also** **QTextStream** , **QDataStream** , **QFileInfo** , **QDir** ,
    **QFile** , and **QTemporaryFile** .
    """

    @overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#QSaveFile

        **QSaveFile::QSaveFile(const QString & name )**

        Constructs a new file object to represent the file with the given
        **name**.
        """
        ...

    @overload
    def __init__(self, name: str, parent: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#QSaveFile-1

        **QSaveFile::QSaveFile(QObject * parent = nullptr)**

        Constructs a new file object with the given **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#QSaveFile-2

        **QSaveFile::QSaveFile(const QString & name , QObject * parent )**

        Constructs a new file object with the given **parent** to represent the
        file with the specified **name**.
        """
        ...

    def cancelWriting(self) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#cancelWriting

        **void QSaveFile::cancelWriting()**

        Cancels writing the new file.

        If the application changes its mind while saving, it can call
        cancelWriting(), which sets an error code so that **commit** () will
        discard the temporary file.

        Alternatively, it can simply make sure not to call **commit** ().

        Further write operations are possible after calling this method, but
        none of it will have any effect, the written file will be discarded.

        This method has no effect when direct write fallback is used. This is
        the case when saving over an existing file in a readonly directory: no
        temporary file can be created, so the existing file is overwritten no
        matter what, and cancelWriting() cannot do anything about that, the
        contents of the existing file will be lost.

        **See also** **commit** ().
        """
        ...

    def close(self) -> None:
        ...

    def commit(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsavefile.html#commit

        **bool QSaveFile::commit()**

        Commits the changes to disk, if all previous writes were successful.

        It is mandatory to call this at the end of the saving operation,
        otherwise the file will be discarded.

        If an error happened during writing, deletes the temporary file and
        returns `false`. Otherwise, renames it to the final **fileName**  and
        returns `true` on success. Finally, closes the device.

        **See also** **cancelWriting** ().
        """
        ...

    def directWriteFallback(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsavefile.html#directWriteFallback

        **bool QSaveFile::directWriteFallback() const**

        Returns `true` if the fallback solution for saving files in read-only
        directories is enabled.

        **See also** **setDirectWriteFallback** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsavefile.html#fileName

        **[override virtual] QString QSaveFile::fileName() const**

        Reimplements: **QFileDevice::fileName() const** .

        Returns the name set by **setFileName** () or to the **QSaveFile**
        constructor.

        **See also** **setFileName** ().
        """
        ...

    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenMode) -> bool:
        """
        https://doc.qt.io/qt-6/qsavefile.html#open

        **[override virtual] bool QSaveFile::open(QIODeviceBase::OpenMode mode
        )**

        Reimplements: **QIODevice::open** (QIODeviceBase::OpenMode mode).

        Opens the file using OpenMode **mode** , returning true if successful;
        otherwise false.

        Important: the **mode** must include QIODevice::WriteOnly. It may also
        have additional flags, such as QIODevice::Text and
        QIODevice::Unbuffered.

        QIODevice::ReadWrite, QIODevice::Append, QIODevice::NewOnly and
        QIODevice::ExistingOnly are not supported at the moment.

        **See also** **QIODevice::OpenMode**  and **setFileName** ().
        """
        ...

    def setDirectWriteFallback(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#setDirectWriteFallback

        **void QSaveFile::setDirectWriteFallback(bool enabled )**

        Allows writing over the existing file if necessary.

        **QSaveFile**  creates a temporary file in the same directory as the
        final file and atomically renames it. However this is not possible if
        the directory permissions do not allow creating new files. In order to
        preserve atomicity guarantees, **open** () fails when it cannot create
        the temporary file.

        In order to allow users to edit files with write permissions in a
        directory with restricted permissions, call setDirectWriteFallback()
        with **enabled** set to true, and the following calls to **open** ()
        will fallback to opening the existing file directly and writing into it,
        without the use of a temporary file. This does not have atomicity
        guarantees, i.e. an application crash or for instance a power failure
        could lead to a partially-written file on disk. It also means
        **cancelWriting** () has no effect, in such a case.

        Typically, to save documents edited by the user, call
        setDirectWriteFallback(true), and to save application internal files
        (configuration files, data files, ...), keep the default setting which
        ensures atomicity.

        **See also** **directWriteFallback** ().
        """
        ...

    def setFileName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsavefile.html#setFileName

        **void QSaveFile::setFileName(const QString & name )**

        Sets the **name** of the file. The name can have no path, a relative
        path, or an absolute path.

        **See also** **QFile::setFileName** () and **fileName** ().
        """
        ...

    def writeData(self, data: bytes, len: int) -> int:
        """
        https://doc.qt.io/qt-6/qsavefile.html#writeData

        **[override virtual protected] qint64 QSaveFile::writeData(const char *
        data , qint64 len )**

        Reimplements: **QFileDevice::writeData** (const char *data, qint64 len).
        """
        ...
