"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore

bytes = str


class QRegularExpressionMatchIterator(object):
    """
    https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html

    **Detailed Description**

    A QRegularExpressionMatchIterator object is a forward only Java-like
    iterator; it can be obtained by calling the
    **QRegularExpression::globalMatch** () function. A new
    QRegularExpressionMatchIterator will be positioned before the first result.
    You can then call the **hasNext** () function to check if there are more
    results available; if so, the **next** () function will return the next
    result and advance the iterator.

    Each result is a **QRegularExpressionMatch**  object holding all the
    information for that result (including captured substrings).

    For instance:

    // extracts the words
        **QRegularExpression**  re("(\\\\w+)");
    **QString**  subject("the quick fox");
    **QRegularExpressionMatchIterator**  i = re.globalMatch(subject);
        while
    (i.hasNext()) {
            **QRegularExpressionMatch**  match = i.next();
    // ...
        }

    Moreover, QRegularExpressionMatchIterator offers a **peekNext** () function
    to get the next result **without** advancing the iterator.

    Starting with Qt 6.0, it is also possible to simply use the result of
    **QRegularExpression::globalMatch**  in a range-based for loop, for instance
    like this:

    // using a raw string literal, R"(raw_characters)", to be able to use "\\w"
    // without having to escape the backslash as "\\\\w"
    **QRegularExpression**  re(R"(\\w+)");
        **QString**  subject("the quick
    fox");
        for (const **QRegularExpressionMatch**  &match :
    re.globalMatch(subject)) {
            // ...
        }

    You can retrieve the **QRegularExpression**  object the subject string was
    matched against by calling the **regularExpression** () function; the match
    type and the match options are available as well by calling the
    **matchType** () and the **matchOptions** () respectively.

    Please refer to the **QRegularExpression**  documentation for more
    information about the Qt regular expression classes.

    **See also** **QRegularExpression**  and **QRegularExpressionMatch** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#QRegularExpr
        essionMatchIterator

        **[since 5.1]
        QRegularExpressionMatchIterator::QRegularExpressionMatchIterator()**

        Constructs an empty, valid QRegularExpressionMatchIterator object. The
        regular expression is set to a default-constructed one; the match type
        to **QRegularExpression::NoMatch**  and the match options to
        **QRegularExpression::NoMatchOption** .

        Invoking the **hasNext** () member function on the constructed object
        will return false, as the iterator is not iterating on a valid sequence
        of matches.

        This function was introduced in Qt 5.1.
        """
        ...

    @overload
    def __init__(
        self, iterator: PySide6.QtCore.QRegularExpressionMatchIterator
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#QRegularExpr
        essionMatchIterator-1

        **QRegularExpressionMatchIterator::QRegularExpressionMatchIterator(const
        QRegularExpressionMatchIterator & iterator )**

        Constructs a QRegularExpressionMatchIterator object as a copy of
        **iterator**.

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def hasNext(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#hasNext

        **bool QRegularExpressionMatchIterator::hasNext() const**

        Returns `true` if there is at least one match result ahead of the
        iterator; otherwise it returns `false`.

        **See also** **next** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#isValid

        **bool QRegularExpressionMatchIterator::isValid() const**

        Returns `true` if the iterator object was obtained as a result from the
        **QRegularExpression::globalMatch** () function invoked on a valid
        **QRegularExpression**  object; returns `false` if the
        **QRegularExpression**  was invalid.

        **See also** **QRegularExpression::globalMatch** () and
        **QRegularExpression::isValid** ().
        """
        ...

    def matchOptions(self) -> PySide6.QtCore.QRegularExpression.MatchOptions:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#matchOptions

        **QRegularExpression::MatchOptions
        QRegularExpressionMatchIterator::matchOptions() const**

        Returns the match options that were used to get this
        **QRegularExpressionMatchIterator**  object, that is, the match options
        that were passed to **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::globalMatch** (),
        **regularExpression** (), and **matchType** ().
        """
        ...

    def matchType(self) -> PySide6.QtCore.QRegularExpression.MatchType:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#matchType

        **QRegularExpression::MatchType
        QRegularExpressionMatchIterator::matchType() const**

        Returns the match type that was used to get this
        **QRegularExpressionMatchIterator**  object, that is, the match type
        that was passed to **QRegularExpression::globalMatch** ().

        **See also** **QRegularExpression::globalMatch** (),
        **regularExpression** (), and **matchOptions** ().
        """
        ...

    def next(self) -> PySide6.QtCore.QRegularExpressionMatch:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#next

        **QRegularExpressionMatch QRegularExpressionMatchIterator::next()**

        Returns the next match result and advances the iterator by one position.

        **Note:** Calling this function when the iterator is at the end of the
        result set leads to undefined results.
        """
        ...

    def peekNext(self) -> PySide6.QtCore.QRegularExpressionMatch:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#peekNext

        **QRegularExpressionMatch QRegularExpressionMatchIterator::peekNext()
        const**

        Returns the next match result without moving the iterator.

        **Note:** Calling this function when the iterator is at the end of the
        result set leads to undefined results.
        """
        ...

    def regularExpression(self) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#regularExpre
        ssion

        **QRegularExpression
        QRegularExpressionMatchIterator::regularExpression() const**

        Returns the **QRegularExpression**  object whose globalMatch() function
        returned this object.

        **See also** **QRegularExpression::globalMatch** (), **matchType** (),
        and **matchOptions** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QRegularExpressionMatchIterator) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionmatchiterator.html#swap

        **void
        QRegularExpressionMatchIterator::swap(QRegularExpressionMatchIterator &
        other )**

        Swaps the iterator **other** with this iterator object. This operation
        is very fast and never fails.
        """
        ...
