"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
bytes = str


class QRecursiveMutex(object):
    """
    https://doc.qt.io/qt-6/qrecursivemutex.html

    **Detailed Description**

    The QRecursiveMutex class is a mutex, like **QMutex** , with which it is
    API-compatible. It differs from **QMutex**  by accepting **lock** () calls
    from the same thread any number of times. **QMutex**  would deadlock in this
    situation.

    QRecursiveMutex is much more expensive to construct and operate on, so use a
    plain **QMutex**  whenever you can. Sometimes, one public function, however,
    calls another public function, and they both need to lock the same mutex. In
    this case, you have two options:

    * Factor the code that needs mutex protection into private functions, which
    assume that the mutex is held when they are called, and lock a plain
    **QMutex**  in the public functions before you call the private
    implementation ones.
      * Or use a recursive mutex, so it doesn't matter that
    the first public function has already locked the mutex when the second one
    wishes to do so.

    **See also** **QMutex** , **QMutexLocker** , **QReadWriteLock** ,
    **QSemaphore** , and **QWaitCondition** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qrecursivemutex.html#QRecursiveMutex-2

        **QRecursiveMutex::QRecursiveMutex()**

        Constructs a new recursive mutex. The mutex is created in an unlocked
        state.

        **See also** **lock** () and **unlock** ().
        """
        ...

    def lock(self) -> None:
        """
        https://doc.qt.io/qt-6/qrecursivemutex.html#lock

        **void QRecursiveMutex::lock()**

        Locks the mutex. If another thread has locked the mutex then this call
        will block until that thread has unlocked it.

        Calling this function multiple times on the same mutex from the same
        thread is allowed.

        **See also** **unlock** ().
        """
        ...

    def tryLock(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qrecursivemutex.html#tryLock

        **bool QRecursiveMutex::tryLock(int timeout = 0)**

        Attempts to lock the mutex. This function returns `true` if the lock was
        obtained; otherwise it returns `false`. If another thread has locked the
        mutex, this function will wait for at most **timeout** milliseconds for
        the mutex to become available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **lock** (), i.e. this function will wait forever until mutex
        can be locked if **timeout** is negative.

        If the lock was obtained, the mutex must be unlocked with **unlock** ()
        before another thread can successfully lock it.

        Calling this function multiple times on the same mutex from the same
        thread is allowed.

        **See also** **lock** () and **unlock** ().
        """
        ...

    def try_lock(self) -> bool:
        """
        https://doc.qt.io/qt-6/qrecursivemutex.html#try_lock

        **[since 5.8] bool QRecursiveMutex::try_lock()**

        Attempts to lock the mutex. This function returns `true` if the lock was
        obtained; otherwise it returns `false`.

        This function is provided for compatibility with the Standard Library
        concept `Lockable`. It is equivalent to **tryLock** ().

        This function was introduced in Qt 5.8.
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qrecursivemutex.html#unlock

        **void QRecursiveMutex::unlock()**

        Unlocks the mutex. Attempting to unlock a mutex in a different thread to
        the one that locked it results in an error. Unlocking a mutex that is
        not locked results in undefined behavior.

        **See also** **lock** ().
        """
        ...
