"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union, overload
import PySide6.QtCore

bytes = str


class QPropertyAnimation(PySide6.QtCore.QVariantAnimation):
    """
    https://doc.qt.io/qt-6/qpropertyanimation.html

    **Detailed Description**

    QPropertyAnimation interpolates over **Qt properties** . As property values
    are stored in **QVariant** s, the class inherits **QVariantAnimation** , and
    supports animation of the same **meta types**  as its super class.

    A class declaring properties must be a **QObject** . To make it possible to
    animate a property, it must provide a setter (so that QPropertyAnimation can
    set the property's value). Note that this makes it possible to animate many
    of Qt's widgets. Let's look at an example:

    **QPropertyAnimation**  *animation = new **QPropertyAnimation** (myWidget,
    "geometry");
            animation->setDuration(10000);
    animation->setStartValue(**QRect** (0, 0, 100, 30));
    animation->setEndValue(**QRect** (250, 250, 100, 30));
    animation->start();

    The property name and the **QObject**  instance of which property should be
    animated are passed to the constructor. You can then specify the start and
    end value of the property. The procedure is equal for properties in classes
    you have implemented yourself--just check with **QVariantAnimation**  that
    your **QVariant**  type is supported.

    The **QVariantAnimation**  class description explains how to set up the
    animation in detail. Note, however, that if a start value is not set, the
    property will start at the value it had when the QPropertyAnimation instance
    was created.

    QPropertyAnimation works like a charm on its own. For complex animations
    that, for instance, contain several objects, **QAnimationGroup**  is
    provided. An animation group is an animation that can contain other
    animations, and that can manage when its animations are played. Look at
    **QParallelAnimationGroup**  for an example.

    **See also** **QVariantAnimation** , **QAnimationGroup** , and **The
    Animation Framework** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#QPropertyAnimation

        **QPropertyAnimation::QPropertyAnimation(QObject * parent = nullptr)**

        Construct a QPropertyAnimation object. **parent** is passed to
        **QObject** 's constructor.
        """
        ...

    @overload
    def __init__(
        self,
        target: PySide6.QtCore.QObject,
        propertyName: Union[PySide6.QtCore.QByteArray, bytes],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#QPropertyAnimation-1

        **QPropertyAnimation::QPropertyAnimation(QObject * target , const
        QByteArray & propertyName , QObject * parent = nullptr)**

        Construct a QPropertyAnimation object. **parent** is passed to
        **QObject** 's constructor. The animation changes the property
        **propertyName** on **target**. The default duration is 250ms.

        **See also** **targetObject**  and **propertyName** .
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#event

        **[override virtual protected] bool QPropertyAnimation::event(QEvent *
        event )**

        Reimplements: **QVariantAnimation::event** (QEvent *event).
        """
        ...

    def propertyName(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#propertyName-prop

        **[bindable] propertyName : QByteArray**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the target property name for this animation

        This property defines the target property name for this animation. The
        property name is required for the animation to operate.
        """
        ...

    def setPropertyName(
        self, propertyName: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#propertyName-prop

        **[bindable] propertyName : QByteArray**

        **Note:** This property supports **QProperty**  bindings.

        This property holds the target property name for this animation

        This property defines the target property name for this animation. The
        property name is required for the animation to operate.
        """
        ...

    def setTargetObject(self, target: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#targetObject-prop

        **[bindable] targetObject : QObject***

        **Note:** This property supports **QProperty**  bindings.

        This property holds the target **QObject**  for this animation.

        This property defines the target **QObject**  for this animation.

        **Member Function Documentation**
        """
        ...

    def targetObject(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#targetObject-prop

        **[bindable] targetObject : QObject***

        **Note:** This property supports **QProperty**  bindings.

        This property holds the target **QObject**  for this animation.

        This property defines the target **QObject**  for this animation.

        **Member Function Documentation**
        """
        ...

    def updateCurrentValue(self, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#updateCurrentValue

        **[override virtual protected] void
        QPropertyAnimation::updateCurrentValue(const QVariant & value )**

        Reimplements: **QVariantAnimation::updateCurrentValue** (const QVariant
        &value).

        This virtual function is called by **QVariantAnimation**  whenever the
        current value changes. **value** is the new, updated value. It updates
        the current value of the property on the target object.

        **See also** **currentValue**  and **currentTime** .
        """
        ...

    def updateState(
        self,
        newState: PySide6.QtCore.QAbstractAnimation.State,
        oldState: PySide6.QtCore.QAbstractAnimation.State,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpropertyanimation.html#updateState

        **[override virtual protected] void
        QPropertyAnimation::updateState(QAbstractAnimation::State newState ,
        QAbstractAnimation::State oldState )**

        Reimplements: **QVariantAnimation::updateState**
        (QAbstractAnimation::State newState, QAbstractAnimation::State
        oldState).

        If the startValue is not defined when the state of the animation changes
        from Stopped to Running, the current property value is used as the
        initial value for the animation.
        """
        ...
