"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QPointF(object):
    """
    https://doc.qt.io/qt-6/qpointf.html

    **Detailed Description**

    A point is specified by a x coordinate and an y coordinate which can be
    accessed using the **x** () and **y** () functions. The coordinates of the
    point are specified using finite floating point numbers for accuracy. The
    **isNull** () function returns `true` if both x and y are set to 0.0. The
    coordinates can be set (or altered) using the **setX** () and **setY** ()
    functions, or alternatively the **rx** () and **ry** () functions which
    return references to the coordinates (allowing direct manipulation).

    Given a point **p** , the following statements are all equivalent:

    **QPointF**  p;

        p.setX(p.x() + 1.0);
        p += **QPointF** (1.0,
    0.0);
        p.rx()++;

    A QPointF object can also be used as a vector: Addition and subtraction are
    defined as for vectors (each component is added separately). A QPointF
    object can also be divided or multiplied by an `int` or a `qreal`.

    In addition, the QPointF class provides a constructor converting a
    **QPoint**  object into a QPointF object, and a corresponding **toPoint** ()
    function which returns a **QPoint**  copy of **this** point. Finally,
    QPointF objects can be streamed as well as compared.

    **See also** **QPoint**  and **QPolygonF** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#QPointF

        **QPointF::QPointF()**

        Constructs a null point, i.e. with coordinates (0.0, 0.0)

        **See also** **isNull** ().
        """
        ...

    @overload
    def __init__(
        self, QPointF: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#QPointF-1

        **QPointF::QPointF(const QPoint & point )**

        Constructs a copy of the given **point**.

        **See also** **toPoint** ().
        """
        ...

    @overload
    def __init__(self, p: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#QPointF-2

        **QPointF::QPointF(qreal xpos , qreal ypos )**

        Constructs a point with the given coordinates ( **xpos** , **ypos** ).

        **See also** **setX** () and **setY** ().
        """
        ...

    @overload
    def __init__(self, xpos: float, ypos: float) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#QPointF

        **QPointF::QPointF()**

        Constructs a null point, i.e. with coordinates (0.0, 0.0)

        **See also** **isNull** ().
        """
        ...

    def __add__(
        self, p2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint]
    ) -> PySide6.QtCore.QPointF:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __iadd__(
        self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint]
    ) -> PySide6.QtCore.QPointF:
        ...

    def __imul__(self, c: float) -> PySide6.QtCore.QPointF:
        ...

    def __isub__(
        self, p: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint]
    ) -> PySide6.QtCore.QPointF:
        ...

    def __mul__(self, c: float) -> PySide6.QtCore.QPointF:
        ...

    def __neg__(self) -> PySide6.QtCore.QPointF:
        ...

    def __pos__(self) -> PySide6.QtCore.QPointF:
        ...

    def __reduce__(self) -> object:
        ...

    def __repr__(self) -> object:
        ...

    def __sub__(
        self, p2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint]
    ) -> PySide6.QtCore.QPointF:
        ...

    @staticmethod
    def dotProduct(
        p1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint],
        p2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint],
    ) -> float:
        """
        https://doc.qt.io/qt-6/qpointf.html#dotProduct

        **[static, since 5.1] qreal QPointF::dotProduct(const QPointF & p1 ,
        const QPointF & p2 )**

        **QPointF**  p( 3.1, 7.1);
            **QPointF**  q(-1.0, 4.1);
            int
        lengthSquared = **QPointF** ::dotProduct(p, q);   // lengthSquared
        becomes 26.01

        Returns the dot product of **p1** and **p2**.

        This function was introduced in Qt 5.1.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpointf.html#isNull

        **bool QPointF::isNull() const**

        Returns `true` if both the x and y coordinates are set to 0.0 (ignoring
        the sign); otherwise returns `false`.
        """
        ...

    def manhattanLength(self) -> float:
        """
        https://doc.qt.io/qt-6/qpointf.html#manhattanLength

        **qreal QPointF::manhattanLength() const**

        Returns the sum of the absolute values of **x** () and **y** (),
        traditionally known as the "Manhattan length" of the vector from the
        origin to the point.

        **See also** **QPoint::manhattanLength** ().
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#setX

        **void QPointF::setX(qreal x )**

        Sets the x coordinate of this point to the given finite **x**
        coordinate.

        **See also** **x** () and **setY** ().
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qpointf.html#setY

        **void QPointF::setY(qreal y )**

        Sets the y coordinate of this point to the given finite **y**
        coordinate.

        **See also** **y** () and **setX** ().
        """
        ...

    def toPoint(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qpointf.html#toPoint

        **QPoint QPointF::toPoint() const**

        Rounds the coordinates of this point to the nearest integer, and returns
        a **QPoint**  object with the rounded coordinates.

        **See also** **QPointF** ().
        """
        ...

    def toTuple(self) -> object:
        ...

    def transposed(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qpointf.html#transposed

        **[since 5.14] QPointF QPointF::transposed() const**

        Returns a point with x and y coordinates exchanged:

        **QPointF** {1.0, 2.0}.transposed() // {2.0, 1.0}

        This function was introduced in Qt 5.14.

        **See also** **x** (), **y** (), **setX** (), and **setY** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qpointf.html#x

        **qreal QPointF::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** () and **rx** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qpointf.html#y

        **qreal QPointF::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** () and **ry** ().
        """
        ...
