"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Dict, List, Optional, overload
import PySide6.QtCore

bytes = str


class QPluginLoader(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qpluginloader.html

    **Detailed Description**

    QPluginLoader provides access to a **Qt plugin** . A Qt plugin is stored in
    a shared library (a DLL) and offers these benefits over shared libraries
    accessed using **QLibrary** :

    * QPluginLoader checks that a plugin is linked against the same version of
    Qt as the application.
      * QPluginLoader provides direct access to a root
    component object (**instance** ()), instead of forcing you to resolve a C
    function manually.

    An instance of a QPluginLoader object operates on a single shared library
    file, which we call a plugin. It provides access to the functionality in the
    plugin in a platform-independent way. To specify which plugin to load,
    either pass a file name in the constructor or set it with **setFileName**
    ().

    The most important functions are **load** () to dynamically load the plugin
    file, **isLoaded** () to check whether loading was successful, and
    **instance** () to access the root component in the plugin. The **instance**
    () function implicitly tries to load the plugin if it has not been loaded
    yet. Multiple instances of QPluginLoader can be used to access the same
    physical plugin.

    Once loaded, plugins remain in memory until all instances of QPluginLoader
    has been unloaded, or until the application terminates. You can attempt to
    unload a plugin using **unload** (), but if other instances of QPluginLoader
    are using the same library, the call will fail, and unloading will only
    happen when every instance has called **unload** (). Right before the
    unloading happens, the root component will also be deleted.

    See **How to Create Qt Plugins**  for more information about how to make
    your application extensible through plugins.

    Note that the QPluginLoader cannot be used if your application is statically
    linked against Qt. In this case, you will also have to link to plugins
    statically. You can use **QLibrary**  if you need to load dynamic libraries
    in a statically linked application.

    **See also** **QLibrary**  and **Plug & Paint Example** .
    """

    @overload
    def __init__(
        self, fileName: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#QPluginLoader

        **QPluginLoader::QPluginLoader(QObject * parent = nullptr)**

        Constructs a plugin loader with the given **parent**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#QPluginLoader-1

        **QPluginLoader::QPluginLoader(const QString & fileName , QObject *
        parent = nullptr)**

        Constructs a plugin loader with the given **parent** that will load the
        plugin specified by **fileName**.

        To be loadable, the file's suffix must be a valid suffix for a loadable
        library in accordance with the platform, e.g. `.so` on Unix, - `.dylib`
        on macOS and iOS, and `.dll` on Windows. The suffix can be verified with
        **QLibrary::isLibrary** ().

        **See also** **setFileName** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#errorString

        **QString QPluginLoader::errorString() const**

        Returns a text string with the description of the last error that
        occurred.
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#fileName-prop

        **fileName : QString**

        This property holds the file name of the plugin

        We recommend omitting the file's suffix in the file name, since
        **QPluginLoader**  will automatically look for the file with the
        appropriate suffix (see **QLibrary::isLibrary** ()).

        When loading the plugin, **QPluginLoader**  searches in all plugin
        locations specified by **QCoreApplication::libraryPaths** (), unless the
        file name has an absolute path. After loading the plugin successfully,
        fileName() returns the fully-qualified file name of the plugin,
        including the full path to the plugin if one was given in the
        constructor or passed to setFileName().

        If the file name does not exist, it will not be set. This property will
        then contain an empty string.

        By default, this property contains an empty string.

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **load** ().
        """
        ...

    def instance(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#instance

        **QObject *QPluginLoader::instance()**

        Returns the root component object of the plugin. The plugin is loaded if
        necessary. The function returns `nullptr` if the plugin could not be
        loaded or if the root component object could not be instantiated.

        If the root component object was destroyed, calling this function
        creates a new instance.

        The root component, returned by this function, is not deleted when the
        **QPluginLoader**  is destroyed. If you want to ensure that the root
        component is deleted, you should call **unload** () as soon you don't
        need to access the core component anymore. When the library is finally
        unloaded, the root component will automatically be deleted.

        The component object is a **QObject** . Use **qobject_cast** () to
        access interfaces you are interested in.

        **See also** **load** ().
        """
        ...

    def isLoaded(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#isLoaded

        **bool QPluginLoader::isLoaded() const**

        Returns `true` if the plugin is loaded; otherwise returns `false`.

        **See also** **load** ().
        """
        ...

    def load(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#load

        **bool QPluginLoader::load()**

        Loads the plugin and returns `true` if the plugin was loaded
        successfully; otherwise returns `false`. Since **instance** () always
        calls this function before resolving any symbols it is not necessary to
        call it explicitly. In some situations you might want the plugin loaded
        in advance, in which case you would use this function.

        **See also** **unload** ().
        """
        ...

    def loadHints(self) -> PySide6.QtCore.QLibrary.LoadHints:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#loadHints-prop

        **loadHints : QLibrary::LoadHints**

        Give the **load** () function some hints on how it should behave.

        You can give hints on how the symbols in the plugin are resolved. By
        default since Qt 5.7, **QLibrary::PreventUnloadHint**  is set.

        See the documentation of **QLibrary::loadHints**  for a complete
        description of how this property works.

        **Access functions:**

        QLibrary::LoadHints **loadHints** () const
        void **setLoadHints**
        (QLibrary::LoadHints **loadHints** )

        **See also** **QLibrary::loadHints** .

        **Member Function Documentation**
        """
        ...

    def metaData(self) -> Dict[str, PySide6.QtCore.QJsonValue]:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#metaData

        **QJsonObject QPluginLoader::metaData() const**

        Returns the meta data for this plugin. The meta data is data specified
        in a json format using the **Q_PLUGIN_METADATA** () macro when compiling
        the plugin.

        The meta data can be queried in a fast and inexpensive way without
        actually loading the plugin. This makes it possible to e.g. store
        capabilities of the plugin in there, and make the decision whether to
        load the plugin dependent on this meta data.
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#fileName-prop

        **fileName : QString**

        This property holds the file name of the plugin

        We recommend omitting the file's suffix in the file name, since
        **QPluginLoader**  will automatically look for the file with the
        appropriate suffix (see **QLibrary::isLibrary** ()).

        When loading the plugin, **QPluginLoader**  searches in all plugin
        locations specified by **QCoreApplication::libraryPaths** (), unless the
        file name has an absolute path. After loading the plugin successfully,
        fileName() returns the fully-qualified file name of the plugin,
        including the full path to the plugin if one was given in the
        constructor or passed to setFileName().

        If the file name does not exist, it will not be set. This property will
        then contain an empty string.

        By default, this property contains an empty string.

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **load** ().
        """
        ...

    def setLoadHints(self, loadHints: PySide6.QtCore.QLibrary.LoadHints) -> None:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#loadHints-prop

        **loadHints : QLibrary::LoadHints**

        Give the **load** () function some hints on how it should behave.

        You can give hints on how the symbols in the plugin are resolved. By
        default since Qt 5.7, **QLibrary::PreventUnloadHint**  is set.

        See the documentation of **QLibrary::loadHints**  for a complete
        description of how this property works.

        **Access functions:**

        QLibrary::LoadHints **loadHints** () const
        void **setLoadHints**
        (QLibrary::LoadHints **loadHints** )

        **See also** **QLibrary::loadHints** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def staticInstances() -> List[PySide6.QtCore.QObject]:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#staticInstances

        **[static] QObjectList QPluginLoader::staticInstances()**

        Returns a list of static plugin instances (root components) held by the
        plugin loader.

        **See also** **staticPlugins** ().
        """
        ...

    def unload(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpluginloader.html#unload

        **bool QPluginLoader::unload()**

        Unloads the plugin and returns `true` if the plugin could be unloaded;
        otherwise returns `false`.

        This happens automatically on application termination, so you shouldn't
        normally need to call this function.

        If other instances of **QPluginLoader**  are using the same plugin, the
        call will fail, and unloading will only happen when every instance has
        called unload().

        Don't try to delete the root component. Instead rely on that unload()
        will automatically delete it when needed.

        **See also** **instance** () and **load** ().
        """
        ...
