"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Union, overload
import PySide6.QtCore

bytes = str


class QMimeDatabase(object):
    """
    https://doc.qt.io/qt-6/qmimedatabase.html

    **Detailed Description**

    The MIME type database is provided by the freedesktop.org shared-mime-info
    project. If the MIME type database cannot be found on the system, as is the
    case on most Windows, macOS, and iOS systems, Qt will use its own copy of
    it.

    Applications which want to define custom MIME types need to install an XML
    file into the locations searched for MIME definitions. These locations can
    be queried with

    **QStandardPaths** ::locateAll(**QStandardPaths** ::GenericDataLocation,
    QLatin1String("mime/packages"),
    **QStandardPaths** ::LocateDirectory);

    On a typical Unix system, this will be /usr/share/mime/packages/, but it is
    also possible to extend the list of directories by setting the environment
    variable `XDG_DATA_DIRS`. For instance adding /opt/myapp/share to
    `XDG_DATA_DIRS` will result in /opt/myapp/share/mime/packages/ being
    searched for MIME definitions.

    Here is an example of MIME XML:

    <?xml version="1.0" encoding="UTF-8"?>
        <mime-info
    xmlns="http://www.freedesktop.org/standards/shared-mime-info">
          <mime-
    type type="application/vnd.qt.qmakeprofile">
            <comment
    xml:lang="en">Qt qmake Profile</comment>
            <glob pattern="*.pro"
    weight="50"/>
          </mime-type>
        </mime-info>

    For more details about the syntax of XML MIME definitions, including
    defining "magic" in order to detect MIME types based on data as well, read
    the Shared Mime Info specification at
    http://standards.freedesktop.org/shared-mime-info-spec/shared-mime-info-
    spec-latest.html

    On Unix systems, a binary cache is used for more performance. This cache is
    generated by the command "update-mime-database path", where path would be
    /opt/myapp/share/mime in the above example. Make sure to run this command
    when installing the MIME type definition file.

    QMimeDatabase db;
        **QMimeType**  mime = db.mimeTypeForFile(fileName);
    if (mime.inherits("text/plain")) {
            // The file is plain text, we can
    display it in a QTextEdit
        }

    **See also** **QMimeType**  and **MIME Type Browser Example** .
    """

    MatchDefault: QMimeDatabase.MatchMode = ...
    MatchExtension: QMimeDatabase.MatchMode = ...
    MatchContent: QMimeDatabase.MatchMode = ...

    class MatchMode(Enum):
        MatchDefault: QMimeDatabase.MatchMode = ...
        MatchExtension: QMimeDatabase.MatchMode = ...
        MatchContent: QMimeDatabase.MatchMode = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#QMimeDatabase-1

        **QMimeDatabase::QMimeDatabase()**

        Constructs a QMimeDatabase object.

        It is perfectly OK to create an instance of QMimeDatabase every time you
        need to perform a lookup. The parsing of mimetypes is done on demand
        (when shared-mime-info is installed) or when the very first instance is
        constructed (when parsing XML files directly).
        """
        ...

    def allMimeTypes(self) -> List[PySide6.QtCore.QMimeType]:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#allMimeTypes

        **QList<QMimeType> QMimeDatabase::allMimeTypes() const**

        Returns the list of all available MIME types.

        This can be useful for showing all MIME types to the user, for instance
        in a MIME type editor. Do not use unless really necessary in other cases
        though, prefer using the **mimeTypeForXxx** () methods for performance
        reasons.
        """
        ...

    @overload
    def mimeTypeForData(
        self, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForData

        **QMimeType QMimeDatabase::mimeTypeForData(const QByteArray & data )
        const**

        Returns a MIME type for **data**.

        A valid MIME type is always returned. If **data** doesn't match any
        known MIME type data, the default MIME type (application/octet-stream)
        is returned.
        """
        ...

    @overload
    def mimeTypeForData(
        self, device: PySide6.QtCore.QIODevice
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForData-1

        **QMimeType QMimeDatabase::mimeTypeForData(QIODevice * device ) const**

        Returns a MIME type for the data in **device**.

        A valid MIME type is always returned. If the data in **device** doesn't
        match any known MIME type data, the default MIME type
        (application/octet-stream) is returned.
        """
        ...

    @overload
    def mimeTypeForFile(
        self,
        fileInfo: PySide6.QtCore.QFileInfo,
        mode: PySide6.QtCore.QMimeDatabase.MatchMode = ...,
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForFile

        **QMimeType QMimeDatabase::mimeTypeForFile(const QFileInfo & fileInfo ,
        QMimeDatabase::MatchMode mode = MatchDefault) const**

        Returns a MIME type for **fileInfo**.

        A valid MIME type is always returned.

        The default matching algorithm looks at both the file name and the file
        contents, if necessary. The file extension has priority over the
        contents, but the contents will be used if the file extension is
        unknown, or matches multiple MIME types. If **fileInfo** is a Unix
        symbolic link, the file that it refers to will be used instead. If the
        file doesn't match any known pattern or data, the default MIME type
        (application/octet-stream) is returned.

        When **mode** is set to **MatchExtension** , only the file name is used,
        not the file contents. The file doesn't even have to exist. If the file
        name doesn't match any known pattern, the default MIME type
        (application/octet-stream) is returned. If multiple MIME types match
        this file, the first one (alphabetically) is returned.

        When **mode** is set to **MatchContent** , and the file is readable,
        only the file contents are used to determine the MIME type. This is
        equivalent to calling **mimeTypeForData**  with a **QFile**  as input
        device.

        **fileInfo** may refer to an absolute or relative path.

        **See also** **QMimeType::isDefault** () and **mimeTypeForData** ().
        """
        ...

    @overload
    def mimeTypeForFile(
        self, fileName: str, mode: PySide6.QtCore.QMimeDatabase.MatchMode = ...
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForFile-1

        **QMimeType QMimeDatabase::mimeTypeForFile(const QString & fileName ,
        QMimeDatabase::MatchMode mode = MatchDefault) const**

        Returns a MIME type for the file named **fileName** using **mode**.

        This is an overloaded function.
        """
        ...

    @overload
    def mimeTypeForFileNameAndData(
        self, fileName: str, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForFileNameAndData

        **QMimeType QMimeDatabase::mimeTypeForFileNameAndData(const QString &
        fileName , QIODevice * device ) const**

        Returns a MIME type for the given **fileName** and **device** data.

        This overload can be useful when the file is remote, and we started to
        download some of its data in a device. This allows to do full MIME type
        matching for remote files as well.

        If the device is not open, it will be opened by this function, and
        closed after the MIME type detection is completed.

        A valid MIME type is always returned. If **device** data doesn't match
        any known MIME type data, the default MIME type (application/octet-
        stream) is returned.

        This method looks at both the file name and the file contents, if
        necessary. The file extension has priority over the contents, but the
        contents will be used if the file extension is unknown, or matches
        multiple MIME types.
        """
        ...

    @overload
    def mimeTypeForFileNameAndData(
        self, fileName: str, device: PySide6.QtCore.QIODevice
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForFileNameAndData-1

        **QMimeType QMimeDatabase::mimeTypeForFileNameAndData(const QString &
        fileName , const QByteArray & data ) const**

        Returns a MIME type for the given **fileName** and device **data**.

        This overload can be useful when the file is remote, and we started to
        download some of its data. This allows to do full MIME type matching for
        remote files as well.

        A valid MIME type is always returned. If **data** doesn't match any
        known MIME type data, the default MIME type (application/octet-stream)
        is returned.

        This method looks at both the file name and the file contents, if
        necessary. The file extension has priority over the contents, but the
        contents will be used if the file extension is unknown, or matches
        multiple MIME types.
        """
        ...

    def mimeTypeForName(self, nameOrAlias: str) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForName

        **QMimeType QMimeDatabase::mimeTypeForName(const QString & nameOrAlias )
        const**

        Returns a MIME type for **nameOrAlias** or an invalid one if none found.
        """
        ...

    def mimeTypeForUrl(
        self, url: Union[PySide6.QtCore.QUrl, str]
    ) -> PySide6.QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypeForUrl

        **QMimeType QMimeDatabase::mimeTypeForUrl(const QUrl & url ) const**

        Returns a MIME type for **url**.

        If the URL is a local file, this calls **mimeTypeForFile** .

        Otherwise the matching is done based on the file name only, except for
        schemes where file names don't mean much, like HTTP. This method always
        returns the default mimetype for HTTP URLs, use
        **QNetworkAccessManager**  to handle HTTP URLs properly.

        A valid MIME type is always returned. If **url** doesn't match any known
        MIME type data, the default MIME type (application/octet-stream) is
        returned.
        """
        ...

    def mimeTypesForFileName(self, fileName: str) -> List[PySide6.QtCore.QMimeType]:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#mimeTypesForFileName

        **QList<QMimeType> QMimeDatabase::mimeTypesForFileName(const QString &
        fileName ) const**

        Returns the MIME types for the file name **fileName**.

        If the file name doesn't match any known pattern, an empty list is
        returned. If multiple MIME types match this file, they are all returned.

        This function does not try to open the file. To also use the content
        when determining the MIME type, use **mimeTypeForFile** () or
        **mimeTypeForFileNameAndData** () instead.

        **See also** **mimeTypeForFile** ().
        """
        ...

    def suffixForFileName(self, fileName: str) -> str:
        """
        https://doc.qt.io/qt-6/qmimedatabase.html#suffixForFileName

        **QString QMimeDatabase::suffixForFileName(const QString & fileName )
        const**

        Returns the suffix for the file **fileName** , as known by the MIME
        database.

        This allows to pre-select "tar.bz2" for foo.tar.bz2, but still only
        "txt" for my.file.with.dots.txt.
        """
        ...
