"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Tuple, Union, overload
import PySide6.QtCore

bytes = str


class QMetaType(object):
    """
    https://doc.qt.io/qt-6/qmetatype.html

    **Detailed Description**

    The class is used as a helper to marshall types in **QVariant**  and in
    queued signals and slots connections. It associates a type name to a type so
    that it can be created and destructed dynamically at run-time. Declare new
    types with **Q_DECLARE_METATYPE** () to make them available to **QVariant**
    and other template-based functions. Call **qRegisterMetaType** () to make
    types available to non-template based functions, such as the queued signal
    and slot connections.

    Any class or struct that has a public default constructor, a public copy
    constructor, and a public destructor can be registered.

    The following code allocates and destructs an instance of `MyClass`:

    int id = **QMetaType** ::type("MyClass");
        if (id != **QMetaType**
    ::UnknownType) {
            void *myClassPtr = **QMetaType** ::create(id);
    ...
            **QMetaType** ::destroy(id, myClassPtr);
            myClassPtr = 0;
    }

    If we want the stream operators `operator<<()` and `operator>>()` to work on
    **QVariant**  objects that store custom types, the custom type must provide
    `operator<<()` and `operator>>()` operators.

    **See also** **Q_DECLARE_METATYPE** (), **QVariant::setValue** (),
    **QVariant::value** (), and **QVariant::fromValue** ().
    """

    UnknownType: QMetaType.Type = ...
    Bool: QMetaType.Type = ...
    FirstCoreType: QMetaType.Type = ...
    Int: QMetaType.Type = ...
    UInt: QMetaType.Type = ...
    LongLong: QMetaType.Type = ...
    ULongLong: QMetaType.Type = ...
    Double: QMetaType.Type = ...
    QReal: QMetaType.Type = ...
    QChar: QMetaType.Type = ...
    QVariantMap: QMetaType.Type = ...
    QVariantList: QMetaType.Type = ...
    QString: QMetaType.Type = ...
    QStringList: QMetaType.Type = ...
    QByteArray: QMetaType.Type = ...
    QBitArray: QMetaType.Type = ...
    QDate: QMetaType.Type = ...
    QTime: QMetaType.Type = ...
    QDateTime: QMetaType.Type = ...
    QUrl: QMetaType.Type = ...
    QLocale: QMetaType.Type = ...
    QRect: QMetaType.Type = ...
    QRectF: QMetaType.Type = ...
    QSize: QMetaType.Type = ...
    QSizeF: QMetaType.Type = ...
    QLine: QMetaType.Type = ...
    QLineF: QMetaType.Type = ...
    QPoint: QMetaType.Type = ...
    QPointF: QMetaType.Type = ...
    QVariantHash: QMetaType.Type = ...
    QEasingCurve: QMetaType.Type = ...
    QUuid: QMetaType.Type = ...
    VoidStar: QMetaType.Type = ...
    Long: QMetaType.Type = ...
    Short: QMetaType.Type = ...
    Char: QMetaType.Type = ...
    ULong: QMetaType.Type = ...
    UShort: QMetaType.Type = ...
    UChar: QMetaType.Type = ...
    Float: QMetaType.Type = ...
    QObjectStar: QMetaType.Type = ...
    SChar: QMetaType.Type = ...
    QVariant: QMetaType.Type = ...
    QModelIndex: QMetaType.Type = ...
    Void: QMetaType.Type = ...
    QRegularExpression: QMetaType.Type = ...
    QJsonValue: QMetaType.Type = ...
    QJsonObject: QMetaType.Type = ...
    QJsonArray: QMetaType.Type = ...
    QJsonDocument: QMetaType.Type = ...
    QByteArrayList: QMetaType.Type = ...
    QPersistentModelIndex: QMetaType.Type = ...
    Nullptr: QMetaType.Type = ...
    QCborSimpleType: QMetaType.Type = ...
    QCborValue: QMetaType.Type = ...
    QCborArray: QMetaType.Type = ...
    QCborMap: QMetaType.Type = ...
    Char16: QMetaType.Type = ...
    Char32: QMetaType.Type = ...
    LastCoreType: QMetaType.Type = ...
    QVariantPair: QMetaType.Type = ...
    FirstGuiType: QMetaType.Type = ...
    QFont: QMetaType.Type = ...
    QPixmap: QMetaType.Type = ...
    QBrush: QMetaType.Type = ...
    QColor: QMetaType.Type = ...
    QPalette: QMetaType.Type = ...
    QIcon: QMetaType.Type = ...
    QImage: QMetaType.Type = ...
    QPolygon: QMetaType.Type = ...
    QRegion: QMetaType.Type = ...
    QBitmap: QMetaType.Type = ...
    QCursor: QMetaType.Type = ...
    QKeySequence: QMetaType.Type = ...
    QPen: QMetaType.Type = ...
    QTextLength: QMetaType.Type = ...
    QTextFormat: QMetaType.Type = ...
    QTransform: QMetaType.Type = ...
    QMatrix4x4: QMetaType.Type = ...
    QVector2D: QMetaType.Type = ...
    QVector3D: QMetaType.Type = ...
    QVector4D: QMetaType.Type = ...
    QQuaternion: QMetaType.Type = ...
    QPolygonF: QMetaType.Type = ...
    LastGuiType: QMetaType.Type = ...
    QColorSpace: QMetaType.Type = ...
    FirstWidgetsType: QMetaType.Type = ...
    HighestInternalId: QMetaType.Type = ...
    LastWidgetsType: QMetaType.Type = ...
    QSizePolicy: QMetaType.Type = ...
    User: QMetaType.Type = ...
    NeedsConstruction: QMetaType.TypeFlag = ...
    NeedsDestruction: QMetaType.TypeFlag = ...
    MovableType: QMetaType.TypeFlag = ...
    RelocatableType: QMetaType.TypeFlag = ...
    PointerToQObject: QMetaType.TypeFlag = ...
    IsEnumeration: QMetaType.TypeFlag = ...
    SharedPointerToQObject: QMetaType.TypeFlag = ...
    WeakPointerToQObject: QMetaType.TypeFlag = ...
    TrackingPointerToQObject: QMetaType.TypeFlag = ...
    IsUnsignedEnumeration: QMetaType.TypeFlag = ...
    IsGadget: QMetaType.TypeFlag = ...
    PointerToGadget: QMetaType.TypeFlag = ...
    IsPointer: QMetaType.TypeFlag = ...
    IsQmlList: QMetaType.TypeFlag = ...
    IsConst: QMetaType.TypeFlag = ...

    class Type(Enum):
        UnknownType: QMetaType.Type = ...
        Bool: QMetaType.Type = ...
        FirstCoreType: QMetaType.Type = ...
        Int: QMetaType.Type = ...
        UInt: QMetaType.Type = ...
        LongLong: QMetaType.Type = ...
        ULongLong: QMetaType.Type = ...
        Double: QMetaType.Type = ...
        QReal: QMetaType.Type = ...
        QChar: QMetaType.Type = ...
        QVariantMap: QMetaType.Type = ...
        QVariantList: QMetaType.Type = ...
        QString: QMetaType.Type = ...
        QStringList: QMetaType.Type = ...
        QByteArray: QMetaType.Type = ...
        QBitArray: QMetaType.Type = ...
        QDate: QMetaType.Type = ...
        QTime: QMetaType.Type = ...
        QDateTime: QMetaType.Type = ...
        QUrl: QMetaType.Type = ...
        QLocale: QMetaType.Type = ...
        QRect: QMetaType.Type = ...
        QRectF: QMetaType.Type = ...
        QSize: QMetaType.Type = ...
        QSizeF: QMetaType.Type = ...
        QLine: QMetaType.Type = ...
        QLineF: QMetaType.Type = ...
        QPoint: QMetaType.Type = ...
        QPointF: QMetaType.Type = ...
        QVariantHash: QMetaType.Type = ...
        QEasingCurve: QMetaType.Type = ...
        QUuid: QMetaType.Type = ...
        VoidStar: QMetaType.Type = ...
        Long: QMetaType.Type = ...
        Short: QMetaType.Type = ...
        Char: QMetaType.Type = ...
        ULong: QMetaType.Type = ...
        UShort: QMetaType.Type = ...
        UChar: QMetaType.Type = ...
        Float: QMetaType.Type = ...
        QObjectStar: QMetaType.Type = ...
        SChar: QMetaType.Type = ...
        QVariant: QMetaType.Type = ...
        QModelIndex: QMetaType.Type = ...
        Void: QMetaType.Type = ...
        QRegularExpression: QMetaType.Type = ...
        QJsonValue: QMetaType.Type = ...
        QJsonObject: QMetaType.Type = ...
        QJsonArray: QMetaType.Type = ...
        QJsonDocument: QMetaType.Type = ...
        QByteArrayList: QMetaType.Type = ...
        QPersistentModelIndex: QMetaType.Type = ...
        Nullptr: QMetaType.Type = ...
        QCborSimpleType: QMetaType.Type = ...
        QCborValue: QMetaType.Type = ...
        QCborArray: QMetaType.Type = ...
        QCborMap: QMetaType.Type = ...
        Char16: QMetaType.Type = ...
        Char32: QMetaType.Type = ...
        LastCoreType: QMetaType.Type = ...
        QVariantPair: QMetaType.Type = ...
        FirstGuiType: QMetaType.Type = ...
        QFont: QMetaType.Type = ...
        QPixmap: QMetaType.Type = ...
        QBrush: QMetaType.Type = ...
        QColor: QMetaType.Type = ...
        QPalette: QMetaType.Type = ...
        QIcon: QMetaType.Type = ...
        QImage: QMetaType.Type = ...
        QPolygon: QMetaType.Type = ...
        QRegion: QMetaType.Type = ...
        QBitmap: QMetaType.Type = ...
        QCursor: QMetaType.Type = ...
        QKeySequence: QMetaType.Type = ...
        QPen: QMetaType.Type = ...
        QTextLength: QMetaType.Type = ...
        QTextFormat: QMetaType.Type = ...
        QTransform: QMetaType.Type = ...
        QMatrix4x4: QMetaType.Type = ...
        QVector2D: QMetaType.Type = ...
        QVector3D: QMetaType.Type = ...
        QVector4D: QMetaType.Type = ...
        QQuaternion: QMetaType.Type = ...
        QPolygonF: QMetaType.Type = ...
        LastGuiType: QMetaType.Type = ...
        QColorSpace: QMetaType.Type = ...
        FirstWidgetsType: QMetaType.Type = ...
        HighestInternalId: QMetaType.Type = ...
        LastWidgetsType: QMetaType.Type = ...
        QSizePolicy: QMetaType.Type = ...
        User: QMetaType.Type = ...

    class TypeFlag(Enum):
        NeedsConstruction: QMetaType.TypeFlag = ...
        NeedsDestruction: QMetaType.TypeFlag = ...
        MovableType: QMetaType.TypeFlag = ...
        RelocatableType: QMetaType.TypeFlag = ...
        PointerToQObject: QMetaType.TypeFlag = ...
        IsEnumeration: QMetaType.TypeFlag = ...
        SharedPointerToQObject: QMetaType.TypeFlag = ...
        WeakPointerToQObject: QMetaType.TypeFlag = ...
        TrackingPointerToQObject: QMetaType.TypeFlag = ...
        IsUnsignedEnumeration: QMetaType.TypeFlag = ...
        IsGadget: QMetaType.TypeFlag = ...
        PointerToGadget: QMetaType.TypeFlag = ...
        IsPointer: QMetaType.TypeFlag = ...
        IsQmlList: QMetaType.TypeFlag = ...
        IsConst: QMetaType.TypeFlag = ...

    class TypeFlags(object):
        ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#QMetaType

        **[since 5.0] QMetaType::QMetaType(int typeId )**

        Constructs a QMetaType object that contains all information about type
        **typeId**.

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    def __init__(self, type: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#QMetaType

        **[since 5.0] QMetaType::QMetaType(int typeId )**

        Constructs a QMetaType object that contains all information about type
        **typeId**.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def alignOf(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#alignOf

        **[since 6.0] qsizetype QMetaType::alignOf() const**

        Returns the alignment of the type in bytes (i.e. alignof(T), where T is
        the actual type for which this **QMetaType**  instance was constructed
        for).

        This function is typically used together with construct() to perform
        low-level management of the memory used by a type.

        This function was introduced in Qt 6.0.

        **See also** **QMetaType::construct** () and **QMetaType::sizeOf** ().
        """
        ...

    @staticmethod
    def canConvert(
        fromType: PySide6.QtCore.QMetaType, toType: PySide6.QtCore.QMetaType
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#canConvert

        **[static] bool QMetaType::canConvert(QMetaType fromType , QMetaType
        toType )**

        Returns `true` if **QMetaType::convert**  can convert from **fromType**
        to **toType**.

        The following conversions are supported by Qt:

        TypeAutomatically Cast To
        **QMetaType::Bool** **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QByteArray** **QMetaType::Double** , **QMetaType::Int** ,
        **QMetaType::LongLong** , **QMetaType::QString** , **QMetaType::UInt** ,
        **QMetaType::ULongLong** , **QMetaType::QUuid**
        **QMetaType::QChar**
        **QMetaType::Bool** , **QMetaType::Int** , **QMetaType::UInt** ,
        **QMetaType::LongLong** , **QMetaType::ULongLong**
        **QMetaType::QColor** **QMetaType::QString**
        **QMetaType::QDate**
        **QMetaType::QDateTime** , **QMetaType::QString**
        **QMetaType::QDateTime** **QMetaType::QDate** , **QMetaType::QString** ,
        **QMetaType::QTime**
        **QMetaType::Double** **QMetaType::Bool** ,
        **QMetaType::Int** , **QMetaType::LongLong** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QFont**
        **QMetaType::QString**
        **QMetaType::Int** **QMetaType::Bool** ,
        **QMetaType::QChar** , **QMetaType::Double** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QKeySequence** **QMetaType::Int** , **QMetaType::QString**
        **QMetaType::QVariantList** **QMetaType::QStringList**  (if the list's
        items can be converted to QStrings)
        **QMetaType::LongLong**
        **QMetaType::Bool** , **QMetaType::QByteArray** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QPoint**
        **QMetaType::QPointF**
        **QMetaType::QRect** **QMetaType::QRectF**
        **QMetaType::QString** **QMetaType::Bool** , **QMetaType::QByteArray** ,
        **QMetaType::QChar** , **QMetaType::QColor** , **QMetaType::QDate** ,
        **QMetaType::QDateTime** , **QMetaType::Double** , **QMetaType::QFont**
        , **QMetaType::Int** , **QMetaType::QKeySequence** ,
        **QMetaType::LongLong** , **QMetaType::QStringList** ,
        **QMetaType::QTime** , **QMetaType::UInt** , **QMetaType::ULongLong** ,
        **QMetaType::QUuid**
        **QMetaType::QStringList**
        **QMetaType::QVariantList** , **QMetaType::QString**  (if the list
        contains exactly one item)
        **QMetaType::QTime** **QMetaType::QString**
        **QMetaType::UInt** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::ULongLong**
        **QMetaType::ULongLong** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt**
        **QMetaType::QUuid**
        **QMetaType::QByteArray** , **QMetaType::QString**

        Casting between primitive type (int, float, bool etc.) is supported.

        Converting between pointers of types derived from **QObject**  will also
        return true for this function if a **qobject_cast**  from the type
        described by **fromType** to the type described by **toType** would
        succeed.

        A cast from a sequential container will also return true for this
        function if the **toType** is **QVariantList** .

        Similarly, a cast from an associative container will also return true
        for this function the **toType** is **QVariantHash**  or **QVariantMap**
        .

        **See also** **convert** (), **QSequentialIterable** ,
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** (), **QAssociativeIterable**
        , and **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().
        """
        ...

    @staticmethod
    def canView(
        fromType: PySide6.QtCore.QMetaType, toType: PySide6.QtCore.QMetaType
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#canView

        **[static] bool QMetaType::canView(QMetaType fromType , QMetaType toType
        )**

        Returns `true` if **QMetaType::view**  can create a mutable view of type
        **toType** on type **fromType**.

        Converting between pointers of types derived from **QObject**  will
        return true for this function if a **qobject_cast**  from the type
        described by **fromType** to the type described by **toType** would
        succeed.

        You can create a mutable view of type **QSequentialIterable**  on any
        container registered with **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE**
        ().

        Similarly you can create a mutable view of type **QAssociativeIterable**
        on any container registered with
        **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().

        **See also** **convert** (), **QSequentialIterable** ,
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** (), **QAssociativeIterable**
        , and **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().
        """
        ...

    @staticmethod
    def compare(lhs: int, rhs: int, typeId: int) -> Tuple[bool, int]:
        """
        https://doc.qt.io/qt-6/qmetatype.html#compare

        **[since 6.0] QPartialOrdering QMetaType::compare(const void * lhs ,
        const void * rhs ) const**

        Compares the objects at **lhs** and **rhs** for ordering.

        Returns **QPartialOrdering::Unordered**  if comparison is not supported
        or the values are unordered. Otherwise, returns
        **QPartialOrdering::Less** , **QPartialOrdering::Equivalent**  or
        **QPartialOrdering::Greater**  if **lhs** is less than, equivalent to or
        greater than **rhs** , respectively.

        Both objects must be of the type described by this metatype. If either
        **lhs** or **rhs** is `nullptr`, the values are unordered. Comparison is
        only supported if the type's less than operator was visible to the
        metatype declaration.

        If the type's equality operator was also visible, values will only
        compare equal if the equality operator says they are. In the absence of
        an equality operator, when neither value is less than the other, values
        are considered equal; if equality is also available and two such values
        are not equal, they are considered unordered, just as NaN (not a number)
        values of a floating point type lie outside its ordering.

        **Note:** If no less than operator was visible to the metatype
        declaration, values are unordered even if an equality operator visible
        to the declaration considers them equal: `compare() == 0` only agrees
        with **equals** () if the less than operator was visible.

        This function was introduced in Qt 6.0.

        **See also** **equals** () and **isOrdered** ().
        """
        ...

    @overload
    def construct(self, where: int, copy: Optional[int] = ...) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#construct-1

        **[since 5.0] void *QMetaType::construct(void * where , const void *
        copy = nullptr) const**

        Constructs a value of the type that this **QMetaType**  instance was
        constructed for in the existing memory addressed by **where** , that is
        a copy of **copy** , and returns **where**. If **copy** is zero, the
        value is default constructed.

        This is a low-level function for explicitly managing the memory used to
        store the type. Consider calling create() if you don't need this level
        of control (that is, use "new" rather than "placement new").

        You must ensure that **where** points to a location where the new value
        can be stored and that **where** is suitably aligned. The type's size
        can be queried by calling **sizeOf** ().

        The rule of thumb for alignment is that a type is aligned to its natural
        boundary, which is the smallest power of 2 that is bigger than the type,
        unless that alignment is larger than the maximum useful alignment for
        the platform. For practical purposes, alignment larger than 2 *
        sizeof(void*) is only necessary for special hardware instructions (e.g.,
        aligned SSE loads and stores on x86).

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    @staticmethod
    def construct(type: int, where: int, copy: int) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#construct-1

        **[since 5.0] void *QMetaType::construct(void * where , const void *
        copy = nullptr) const**

        Constructs a value of the type that this **QMetaType**  instance was
        constructed for in the existing memory addressed by **where** , that is
        a copy of **copy** , and returns **where**. If **copy** is zero, the
        value is default constructed.

        This is a low-level function for explicitly managing the memory used to
        store the type. Consider calling create() if you don't need this level
        of control (that is, use "new" rather than "placement new").

        You must ensure that **where** points to a location where the new value
        can be stored and that **where** is suitably aligned. The type's size
        can be queried by calling **sizeOf** ().

        The rule of thumb for alignment is that a type is aligned to its natural
        boundary, which is the smallest power of 2 that is bigger than the type,
        unless that alignment is larger than the maximum useful alignment for
        the platform. For practical purposes, alignment larger than 2 *
        sizeof(void*) is only necessary for special hardware instructions (e.g.,
        aligned SSE loads and stores on x86).

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    @staticmethod
    def convert(from_: int, fromTypeId: int, to: int, toTypeId: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#convert

        **[static, since 5.2] bool QMetaType::convert(QMetaType fromType , const
        void * from , QMetaType toType , void * to )**

        Converts the object at **from** from **fromType** to the preallocated
        space at **to** typed **toType**. Returns `true`, if the conversion
        succeeded, otherwise false.

        Both **from** and **to** have to be valid pointers.

        This function was introduced in Qt 5.2.
        """
        ...

    @overload
    @staticmethod
    def convert(
        fromType: PySide6.QtCore.QMetaType,
        from_: int,
        toType: PySide6.QtCore.QMetaType,
        to: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#convert

        **[static, since 5.2] bool QMetaType::convert(QMetaType fromType , const
        void * from , QMetaType toType , void * to )**

        Converts the object at **from** from **fromType** to the preallocated
        space at **to** typed **toType**. Returns `true`, if the conversion
        succeeded, otherwise false.

        Both **from** and **to** have to be valid pointers.

        This function was introduced in Qt 5.2.
        """
        ...

    @overload
    def create(self, copy: Optional[int] = ...) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#create-1

        **[since 5.0] void *QMetaType::create(const void * copy = nullptr)
        const**

        Returns a copy of **copy** , assuming it is of the type that this
        **QMetaType**  instance was created for. If **copy** is `nullptr`,
        creates a default constructed instance.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::destroy** ().
        """
        ...

    @overload
    @staticmethod
    def create(type: int, copy: Optional[int] = ...) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#create-1

        **[since 5.0] void *QMetaType::create(const void * copy = nullptr)
        const**

        Returns a copy of **copy** , assuming it is of the type that this
        **QMetaType**  instance was created for. If **copy** is `nullptr`,
        creates a default constructed instance.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::destroy** ().
        """
        ...

    @overload
    def destroy(self, data: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#destroy-1

        **[since 5.0] void QMetaType::destroy(void * data ) const**

        Destroys the **data** , assuming it is of the type that this
        **QMetaType**  instance was created for.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::create** ().
        """
        ...

    @overload
    @staticmethod
    def destroy(type: int, data: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#destroy-1

        **[since 5.0] void QMetaType::destroy(void * data ) const**

        Destroys the **data** , assuming it is of the type that this
        **QMetaType**  instance was created for.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::create** ().
        """
        ...

    @overload
    def destruct(self, data: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#destruct-1

        **[since 5.0] void QMetaType::destruct(void * data ) const**

        Destructs the value, located at **data** , assuming that it is of the
        type for which this **QMetaType**  instance was constructed for.

        Unlike destroy(), this function only invokes the type's destructor, it
        doesn't invoke the delete operator.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::construct** ().
        """
        ...

    @overload
    @staticmethod
    def destruct(type: int, where: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#destruct-1

        **[since 5.0] void QMetaType::destruct(void * data ) const**

        Destructs the value, located at **data** , assuming that it is of the
        type for which this **QMetaType**  instance was constructed for.

        Unlike destroy(), this function only invokes the type's destructor, it
        doesn't invoke the delete operator.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::construct** ().
        """
        ...

    @overload
    @staticmethod
    def equals(lhs: int, rhs: int, typeId: int) -> Tuple[bool, int]:
        """
        https://doc.qt.io/qt-6/qmetatype.html#equals

        **[since 6.0] bool QMetaType::equals(const void * lhs , const void * rhs
        ) const**

        Compares the objects at **lhs** and **rhs** for equality.

        Both objects must be of the type described by this metatype. Can only
        compare the two objects if a less than or equality operator for the type
        was visible to the metatype declaration. Otherwise, the metatype never
        considers values equal. When an equality operator was visible to the
        metatype declaration, it is authoritative; otherwise, if less than is
        visible, when neither value is less than the other, the two are
        considered equal. If values are unordered (see **compare** () for
        details) they are not equal.

        Returns true if the two objects compare equal, otherwise false.

        This function was introduced in Qt 6.0.

        **See also** **isEqualityComparable** () and **compare** ().
        """
        ...

    @overload
    def equals(self, lhs: int, rhs: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#equals

        **[since 6.0] bool QMetaType::equals(const void * lhs , const void * rhs
        ) const**

        Compares the objects at **lhs** and **rhs** for equality.

        Both objects must be of the type described by this metatype. Can only
        compare the two objects if a less than or equality operator for the type
        was visible to the metatype declaration. Otherwise, the metatype never
        considers values equal. When an equality operator was visible to the
        metatype declaration, it is authoritative; otherwise, if less than is
        visible, when neither value is less than the other, the two are
        considered equal. If values are unordered (see **compare** () for
        details) they are not equal.

        Returns true if the two objects compare equal, otherwise false.

        This function was introduced in Qt 6.0.

        **See also** **isEqualityComparable** () and **compare** ().
        """
        ...

    def flags(self) -> PySide6.QtCore.QMetaType.TypeFlags:
        """
        https://doc.qt.io/qt-6/qmetatype.html#flags

        **[since 5.0] QMetaType::TypeFlags QMetaType::flags() const**

        Returns flags of the type for which this **QMetaType**  instance was
        constructed.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::TypeFlags**  and QMetaType::flags().
        """
        ...

    @staticmethod
    def fromName(
        name: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QMetaType:
        """
        https://doc.qt.io/qt-6/qmetatype.html#fromName

        **[static] QMetaType QMetaType::fromName(QByteArrayView typeName )**

        Returns a **QMetaType**  matching **typeName**. The returned object is
        not valid if the typeName is not known to **QMetaType**
        """
        ...

    @staticmethod
    def hasRegisteredConverterFunction(
        fromType: PySide6.QtCore.QMetaType, toType: PySide6.QtCore.QMetaType
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredConverterFunction

        **[static, since 5.2] bool
        QMetaType::hasRegisteredConverterFunction(QMetaType fromType , QMetaType
        toType )**

        Returns `true`, if the meta type system has a registered conversion from
        meta type id **fromType** to **toType**

        This function was introduced in Qt 5.2.
        """
        ...

    def hasRegisteredDataStreamOperators(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredDataStreamOperators

        **[since 6.1] bool QMetaType::hasRegisteredDataStreamOperators() const**

        Returns `true`, if the meta type system has registered data stream
        operators for this meta type.

        This function was introduced in Qt 6.1.
        """
        ...

    @overload
    def hasRegisteredDebugStreamOperator(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredDebugStreamOperator

        **[since 6.0] bool QMetaType::hasRegisteredDebugStreamOperator() const**

        Returns `true`, if the meta type system has a registered debug stream
        operator for this meta type.

        This function was introduced in Qt 6.0.
        """
        ...

    @overload
    @staticmethod
    def hasRegisteredDebugStreamOperator(typeId: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredDebugStreamOperator

        **[since 6.0] bool QMetaType::hasRegisteredDebugStreamOperator() const**

        Returns `true`, if the meta type system has a registered debug stream
        operator for this meta type.

        This function was introduced in Qt 6.0.
        """
        ...

    @staticmethod
    def hasRegisteredMutableViewFunction(
        fromType: PySide6.QtCore.QMetaType, toType: PySide6.QtCore.QMetaType
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredMutableViewFunction

        **[static, since 5.2] bool
        QMetaType::hasRegisteredMutableViewFunction(QMetaType fromType ,
        QMetaType toType )**

        Returns `true`, if the meta type system has a registered mutable view on
        meta type id **fromType** of meta type id **toType**.

        This function was introduced in Qt 5.2.
        """
        ...

    def id(self, arg__1: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#id

        **[since 5.13] int QMetaType::id() const**

        Returns id type hold by this QMetatype instance.

        This function was introduced in Qt 5.13.
        """
        ...

    def isEqualityComparable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isEqualityComparable

        **bool QMetaType::isEqualityComparable() const**

        Returns `true` if a less than or equality operator for the type
        described by this metatype was visible to the metatype declaration,
        otherwise `false`.

        **See also** **equals** () and **isOrdered** ().
        """
        ...

    def isOrdered(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isOrdered

        **bool QMetaType::isOrdered() const**

        Returns `true` if a less than operator for the type described by this
        metatype was visible to the metatype declaration, otherwise `false`.

        **See also** **compare** () and **isEqualityComparable** ().
        """
        ...

    @overload
    def isRegistered(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isRegistered

        **[static] bool QMetaType::isRegistered(int type )**

        Returns `true` if the datatype with ID **type** is registered; otherwise
        returns `false`.

        **See also** **type** (), **typeName** (), and **Type** .
        """
        ...

    @overload
    @staticmethod
    def isRegistered(type: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isRegistered-1

        **[since 5.0] bool QMetaType::isRegistered() const**

        Returns `true` if this **QMetaType**  object contains valid information
        about a type, false otherwise.

        This function was introduced in Qt 5.0.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isValid

        **[since 5.0] bool QMetaType::isValid() const**

        Returns `true` if this **QMetaType**  object contains valid information
        about a type, false otherwise.

        This function was introduced in Qt 5.0.
        """
        ...

    @overload
    def load(self, stream: PySide6.QtCore.QDataStream, data: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#load

        **bool QMetaType::load(QDataStream & stream , void * data ) const**

        Reads the object of this type from the given **stream** into **data**.
        Returns `true` if the object is loaded successfully; otherwise returns
        `false`.

        The type must have been registered with **Q_DECLARE_METATYPE** ()
        beforehand.

        Normally, you should not need to call this function directly. Instead,
        use **QVariant** 's `operator>>()`, which relies on load() to stream
        custom types.

        **See also** **save** ().
        """
        ...

    @overload
    @staticmethod
    def load(stream: PySide6.QtCore.QDataStream, type: int, data: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#load

        **bool QMetaType::load(QDataStream & stream , void * data ) const**

        Reads the object of this type from the given **stream** into **data**.
        Returns `true` if the object is loaded successfully; otherwise returns
        `false`.

        The type must have been registered with **Q_DECLARE_METATYPE** ()
        beforehand.

        Normally, you should not need to call this function directly. Instead,
        use **QVariant** 's `operator>>()`, which relies on load() to stream
        custom types.

        **See also** **save** ().
        """
        ...

    @staticmethod
    def metaObjectForType(type: int) -> PySide6.QtCore.QMetaObject:
        ...

    def name(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetatype.html#name

        **[since 5.15] const char *QMetaType::name() const**

        Returns the type name associated with this **QMetaType** , or a null
        pointer if no matching type was found. The returned pointer must not be
        deleted.

        This function was introduced in Qt 5.15.

        **See also** **typeName** ().
        """
        ...

    @overload
    def save(self, stream: PySide6.QtCore.QDataStream, data: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#save

        **bool QMetaType::save(QDataStream & stream , const void * data )
        const**

        Writes the object pointed to by **data** to the given **stream**.
        Returns `true` if the object is saved successfully; otherwise returns
        `false`.

        The type must have been registered with **Q_DECLARE_METATYPE** ()
        beforehand.

        Normally, you should not need to call this function directly. Instead,
        use **QVariant** 's `operator<<()`, which relies on save() to stream
        custom types.

        **See also** **load** ().
        """
        ...

    @overload
    @staticmethod
    def save(stream: PySide6.QtCore.QDataStream, type: int, data: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#save

        **bool QMetaType::save(QDataStream & stream , const void * data )
        const**

        Writes the object pointed to by **data** to the given **stream**.
        Returns `true` if the object is saved successfully; otherwise returns
        `false`.

        The type must have been registered with **Q_DECLARE_METATYPE** ()
        beforehand.

        Normally, you should not need to call this function directly. Instead,
        use **QVariant** 's `operator<<()`, which relies on save() to stream
        custom types.

        **See also** **load** ().
        """
        ...

    @overload
    def sizeOf(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#sizeOf-1

        **[since 5.0] qsizetype QMetaType::sizeOf() const**

        Returns the size of the type in bytes (i.e. sizeof(T), where T is the
        actual type for which this **QMetaType**  instance was constructed for).

        This function is typically used together with construct() to perform
        low-level management of the memory used by a type.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::construct** (), QMetaType::sizeOf(), and
        **QMetaType::alignOf** ().
        """
        ...

    @overload
    @staticmethod
    def sizeOf(type: int) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#sizeOf-1

        **[since 5.0] qsizetype QMetaType::sizeOf() const**

        Returns the size of the type in bytes (i.e. sizeof(T), where T is the
        actual type for which this **QMetaType**  instance was constructed for).

        This function is typically used together with construct() to perform
        low-level management of the memory used by a type.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::construct** (), QMetaType::sizeOf(), and
        **QMetaType::alignOf** ().
        """
        ...

    @staticmethod
    def type(typeName: bytes) -> int:
        ...

    @staticmethod
    def typeFlags(type: int) -> PySide6.QtCore.QMetaType.TypeFlags:
        ...

    @staticmethod
    def typeName(type: int) -> bytes:
        ...

    @staticmethod
    def unregisterConverterFunction(
        from_: PySide6.QtCore.QMetaType, to: PySide6.QtCore.QMetaType
    ) -> None:
        ...

    @staticmethod
    def unregisterMetaType(type: PySide6.QtCore.QMetaType) -> None:
        ...

    @staticmethod
    def unregisterMutableViewFunction(
        from_: PySide6.QtCore.QMetaType, to: PySide6.QtCore.QMetaType
    ) -> None:
        ...

    @staticmethod
    def view(
        fromType: PySide6.QtCore.QMetaType,
        from_: int,
        toType: PySide6.QtCore.QMetaType,
        to: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#view

        **[static, since 6.0] bool QMetaType::view(QMetaType fromType , void *
        from , QMetaType toType , void * to )**

        Creates a mutable view on the object at **from** of **fromType** in the
        preallocated space at **to** typed **toType**. Returns `true` if the
        conversion succeeded, otherwise false.

        This function was introduced in Qt 6.0.
        """
        ...
