"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Tuple, overload
import PySide6.QtCore

bytes = str


class QMetaEnum(object):
    """
    https://doc.qt.io/qt-6/qmetaenum.html

    **Detailed Description**

    Use **name** () for the enumerator's name. The enumerator's keys (names of
    each enumerated item) are returned by **key** (); use **keyCount** () to
    find the number of keys. **isFlag** () returns whether the enumerator is
    meant to be used as a flag, meaning that its values can be combined using
    the OR operator.

    The conversion functions **keyToValue** (), **valueToKey** (),
    **keysToValue** (), and **valueToKeys** () allow conversion between the
    integer representation of an enumeration or set value and its literal
    representation. The **scope** () function returns the class scope this
    enumerator was declared in.

    **See also** **QMetaObject** , **QMetaMethod** , and **QMetaProperty** .
    """

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, QMetaEnum: PySide6.QtCore.QMetaEnum) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def enumName(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#enumName

        **[since 5.12] const char *QMetaEnum::enumName() const**

        Returns the enum name of the flag (without the scope).

        For example, the **Qt::AlignmentFlag**  flag has `AlignmentFlag` as the
        enum name, but `Alignment` as as the type name. Non flag enums has the
        same type and enum names.

        Enum names have the same scope as the type name.

        This function was introduced in Qt 5.12.

        **See also** **isValid** () and **name** ().
        """
        ...

    def isFlag(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#isFlag

        **bool QMetaEnum::isFlag() const**

        Returns `true` if this enumerator is used as a flag; otherwise returns
        false.

        When used as flags, enumerators can be combined using the OR operator.

        **See also** **keysToValue** () and **valueToKeys** ().
        """
        ...

    def isScoped(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#isScoped

        **[since 5.8] bool QMetaEnum::isScoped() const**

        Returns `true` if this enumerator is declared as a C++11 enum class;
        otherwise returns false.

        This function was introduced in Qt 5.8.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#isValid

        **bool QMetaEnum::isValid() const**

        Returns `true` if this enum is valid (has a name); otherwise returns
        false.

        **See also** **name** ().
        """
        ...

    def key(self, index: int) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#key

        **const char *QMetaEnum::key(int index ) const**

        Returns the key with the given **index** , or `nullptr` if no such key
        exists.

        **See also** **keyCount** (), **value** (), and **valueToKey** ().
        """
        ...

    def keyCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#keyCount

        **int QMetaEnum::keyCount() const**

        Returns the number of keys.

        **See also** **key** ().
        """
        ...

    def keyToValue(self, key: bytes) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#keyToValue

        **int QMetaEnum::keyToValue(const char * key , bool * ok = nullptr)
        const**

        Returns the integer value of the given enumeration **key** , or -1 if
        **key** is not defined.

        If **key** is not defined, * **ok** is set to false; otherwise * **ok**
        is set to true.

        For flag types, use **keysToValue** ().

        **See also** **valueToKey** (), **isFlag** (), and **keysToValue** ().
        """
        ...

    def keysToValue(self, keys: bytes) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#keysToValue

        **int QMetaEnum::keysToValue(const char * keys , bool * ok = nullptr)
        const**

        Returns the value derived from combining together the values of the
        **keys** using the OR operator, or -1 if **keys** is not defined. Note
        that the strings in **keys** must be '|'-separated.

        If **keys** is not defined, * **ok** is set to false; otherwise * **ok**
        is set to true.

        **See also** **isFlag** (), **valueToKey** (), and **valueToKeys** ().
        """
        ...

    def name(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#name

        **const char *QMetaEnum::name() const**

        Returns the name of the type (without the scope).

        For example, the **Qt::Key**  enumeration has `Key` as the type name and
        **Qt**  as the scope.

        For flags this returns the name of the flag type, not the name of the
        enum type.

        **See also** **isValid** (), **scope** (), and **enumName** ().
        """
        ...

    def scope(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#scope

        **const char *QMetaEnum::scope() const**

        Returns the scope this enumerator was declared in.

        For example, the **Qt::AlignmentFlag**  enumeration has `Qt` as the
        scope and `AlignmentFlag` as the name.

        **See also** **name** ().
        """
        ...

    def value(self, index: int) -> int:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#value

        **int QMetaEnum::value(int index ) const**

        Returns the value with the given **index** ; or returns -1 if there is
        no such value.

        **See also** **keyCount** (), **key** (), and **keyToValue** ().
        """
        ...

    def valueToKey(self, value: int) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#valueToKey

        **const char *QMetaEnum::valueToKey(int value ) const**

        Returns the string that is used as the name of the given enumeration
        **value** , or `nullptr` if **value** is not defined.

        For flag types, use **valueToKeys** ().

        **See also** **isFlag** () and **valueToKeys** ().
        """
        ...

    def valueToKeys(self, value: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qmetaenum.html#valueToKeys

        **QByteArray QMetaEnum::valueToKeys(int value ) const**

        Returns a byte array of '|'-separated keys that represents the given
        **value**.

        **See also** **isFlag** (), **valueToKey** (), and **keysToValue** ().
        """
        ...
