"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, overload
import PySide6.QtCore

bytes = str


class QLibrary(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qlibrary.html

    **Detailed Description**

    An instance of a QLibrary object operates on a single shared object file
    (which we call a "library", but is also known as a "DLL"). A QLibrary
    provides access to the functionality in the library in a platform
    independent way. You can either pass a file name in the constructor, or set
    it explicitly with **setFileName** (). When loading the library, QLibrary
    searches in all the system-specific library locations (e.g.
    `LD_LIBRARY_PATH` on Unix), unless the file name has an absolute path.

    If the file name is an absolute path then an attempt is made to load this
    path first. If the file cannot be found, QLibrary tries the name with
    different platform-specific file prefixes, like "lib" on Unix and Mac, and
    suffixes, like ".so" on Unix, ".dylib" on the Mac, or ".dll" on Windows.

    If the file path is not absolute then QLibrary modifies the search order to
    try the system-specific prefixes and suffixes first, followed by the file
    path specified.

    This makes it possible to specify shared libraries that are only identified
    by their basename (i.e. without their suffix), so the same code will work on
    different operating systems yet still minimise the number of attempts to
    find the library.

    The most important functions are **load** () to dynamically load the library
    file, **isLoaded** () to check whether loading was successful, and
    **resolve** () to resolve a symbol in the library. The **resolve** ()
    function implicitly tries to load the library if it has not been loaded yet.
    Multiple instances of QLibrary can be used to access the same physical
    library. Once loaded, libraries remain in memory until the application
    terminates. You can attempt to unload a library using **unload** (), but if
    other instances of QLibrary are using the same library, the call will fail,
    and unloading will only happen when every instance has called **unload** ().

    A typical use of QLibrary is to resolve an exported symbol in a library, and
    to call the C function that this symbol represents. This is called "explicit
    linking" in contrast to "implicit linking", which is done by the link step
    in the build process when linking an executable against a library.

    The following code snippet loads a library, resolves the symbol "mysymbol",
    and calls the function if everything succeeded. If something goes wrong,
    e.g. the library file does not exist or the symbol is not defined, the
    function pointer will be `nullptr` and won't be called.

    **QLibrary**  myLib("mylib");
        typedef void (*MyPrototype)();
    MyPrototype myFunction = (MyPrototype) myLib.resolve("mysymbol");
        if
    (myFunction)
            myFunction();

    The symbol must be exported as a C function from the library for **resolve**
    () to work. This means that the function must be wrapped in an `extern "C"`
    block if the library is compiled with a C++ compiler. On Windows, this also
    requires the use of a `dllexport` macro; see **resolve** () for the details
    of how this is done. For convenience, there is a static **resolve** ()
    function which you can use if you just want to call a function in a library
    without explicitly loading the library first:

    typedef void (*MyPrototype)();
        MyPrototype myFunction =
    (MyPrototype) **QLibrary** ::resolve("mylib", "mysymbol");
        if
    (myFunction)
            myFunction();

    **See also** **QPluginLoader** .
    """

    ResolveAllSymbolsHint: QLibrary.LoadHint = ...
    ExportExternalSymbolsHint: QLibrary.LoadHint = ...
    LoadArchiveMemberHint: QLibrary.LoadHint = ...
    PreventUnloadHint: QLibrary.LoadHint = ...
    DeepBindHint: QLibrary.LoadHint = ...

    class LoadHint(Enum):
        ResolveAllSymbolsHint: QLibrary.LoadHint = ...
        ExportExternalSymbolsHint: QLibrary.LoadHint = ...
        LoadArchiveMemberHint: QLibrary.LoadHint = ...
        PreventUnloadHint: QLibrary.LoadHint = ...
        DeepBindHint: QLibrary.LoadHint = ...

    class LoadHints(object):
        ...

    @overload
    def __init__(
        self, fileName: str, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#QLibrary

        **QLibrary::QLibrary(QObject * parent = nullptr)**

        Constructs a library with the given **parent**.
        """
        ...

    @overload
    def __init__(
        self, fileName: str, verNum: int, parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#QLibrary-1

        **QLibrary::QLibrary(const QString & fileName , QObject * parent =
        nullptr)**

        Constructs a library object with the given **parent** that will load the
        library specified by **fileName**.

        We recommend omitting the file's suffix in **fileName** , since QLibrary
        will automatically look for the file with the appropriate suffix in
        accordance with the platform, e.g. ".so" on Unix, ".dylib" on macOS and
        iOS, and ".dll" on Windows. (See **fileName** .)
        """
        ...

    @overload
    def __init__(
        self,
        fileName: str,
        version: str,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#QLibrary-2

        **QLibrary::QLibrary(const QString & fileName , int verNum , QObject *
        parent = nullptr)**

        Constructs a library object with the given **parent** that will load the
        library specified by **fileName** and major version number **verNum**.
        Currently, the version number is ignored on Windows.

        We recommend omitting the file's suffix in **fileName** , since QLibrary
        will automatically look for the file with the appropriate suffix in
        accordance with the platform, e.g. ".so" on Unix, ".dylib" on macOS and
        iOS, and ".dll" on Windows. (See **fileName** .)
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#QLibrary-3

        **QLibrary::QLibrary(const QString & fileName , const QString & version
        , QObject * parent = nullptr)**

        Constructs a library object with the given **parent** that will load the
        library specified by **fileName** and full version number **version**.
        Currently, the version number is ignored on Windows.

        We recommend omitting the file's suffix in **fileName** , since QLibrary
        will automatically look for the file with the appropriate suffix in
        accordance with the platform, e.g. ".so" on Unix, ".dylib" on macOS and
        iOS, and ".dll" on Windows. (See **fileName** .)
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qlibrary.html#errorString

        **QString QLibrary::errorString() const**

        Returns a text string with the description of the last error that
        occurred. Currently, errorString will only be set if **load** (),
        **unload** () or **resolve** () for some reason fails.
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlibrary.html#fileName-prop

        **fileName : QString**

        This property holds the file name of the library

        We recommend omitting the file's suffix in the file name, since
        **QLibrary**  will automatically look for the file with the appropriate
        suffix (see **isLibrary** ()).

        When loading the library, **QLibrary**  searches in all system-specific
        library locations (for example, `LD_LIBRARY_PATH` on Unix), unless the
        file name has an absolute path. After loading the library successfully,
        fileName() returns the fully-qualified file name of the library,
        including the full path to the library if one was given in the
        constructor or passed to setFileName().

        For example, after successfully loading the "GL" library on Unix
        platforms, fileName() will return "libGL.so". If the file name was
        originally passed as "/usr/lib/libGL", fileName() will return
        "/usr/lib/libGL.so".

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )
        """
        ...

    @staticmethod
    def isLibrary(fileName: str) -> bool:
        """
        https://doc.qt.io/qt-6/qlibrary.html#isLibrary

        **[static] bool QLibrary::isLibrary(const QString & fileName )**

        Returns `true` if **fileName** has a valid suffix for a loadable
        library; otherwise returns `false`.

        PlatformValid suffixes
        Windows`.dll`, `.DLL`
        Unix/Linux`.so`
        AIX`.a`
        HP-UX`.sl`, `.so` (HP-UXi)
        macOS and iOS`.dylib`, `.bundle`,
        `.so`

        Trailing versioning numbers on Unix are ignored.
        """
        ...

    def isLoaded(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlibrary.html#isLoaded

        **bool QLibrary::isLoaded() const**

        Returns `true` if the library is loaded; otherwise returns `false`.

        **See also** **load** ().
        """
        ...

    def load(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlibrary.html#load

        **bool QLibrary::load()**

        Loads the library and returns `true` if the library was loaded
        successfully; otherwise returns `false`. Since **resolve** () always
        calls this function before resolving any symbols it is not necessary to
        call it explicitly. In some situations you might want the library loaded
        in advance, in which case you would use this function.

        **See also** **unload** ().
        """
        ...

    def loadHints(self) -> PySide6.QtCore.QLibrary.LoadHints:
        """
        https://doc.qt.io/qt-6/qlibrary.html#loadHints-prop

        **loadHints : LoadHints**

        Give the **load** () function some hints on how it should behave.

        You can give some hints on how the symbols are resolved. Usually, the
        symbols are not resolved at load time, but resolved lazily, (that is,
        when **resolve** () is called). If you set the loadHints to
        **ResolveAllSymbolsHint** , then all symbols will be resolved at load
        time if the platform supports it.

        Setting **ExportExternalSymbolsHint**  will make the external symbols in
        the library available for resolution in subsequent loaded libraries.

        If **LoadArchiveMemberHint**  is set, the file name is composed of two
        components: A path which is a reference to an archive file followed by
        the second component which is the reference to the archive member. For
        instance, the **fileName**  `libGL.a(shr_64.o)` will refer to the
        library `shr_64.o` in the archive file named `libGL.a`. This is only
        supported on the AIX platform.

        The interpretation of the load hints is platform dependent, and if you
        use it you are probably making some assumptions on which platform you
        are compiling for, so use them only if you understand the consequences
        of them.

        By default, none of these flags are set, so libraries will be loaded
        with lazy symbol resolution, and will not export external symbols for
        resolution in other dynamically-loaded libraries.

        **Note:** Setting this property after the library has been loaded has no
        effect and loadHints() will not reflect those changes.

        **Note:** This property is shared among all **QLibrary**  instances that
        refer to the same library.

        **Access functions:**

        QLibrary::LoadHints **loadHints** () const
        void **setLoadHints**
        (QLibrary::LoadHints **hints** )

        **Member Function Documentation**
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#fileName-prop

        **fileName : QString**

        This property holds the file name of the library

        We recommend omitting the file's suffix in the file name, since
        **QLibrary**  will automatically look for the file with the appropriate
        suffix (see **isLibrary** ()).

        When loading the library, **QLibrary**  searches in all system-specific
        library locations (for example, `LD_LIBRARY_PATH` on Unix), unless the
        file name has an absolute path. After loading the library successfully,
        fileName() returns the fully-qualified file name of the library,
        including the full path to the library if one was given in the
        constructor or passed to setFileName().

        For example, after successfully loading the "GL" library on Unix
        platforms, fileName() will return "libGL.so". If the file name was
        originally passed as "/usr/lib/libGL", fileName() will return
        "/usr/lib/libGL.so".

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )
        """
        ...

    @overload
    def setFileNameAndVersion(self, fileName: str, verNum: int) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#setFileNameAndVersion

        **void QLibrary::setFileNameAndVersion(const QString & fileName , int
        versionNumber )**

        Sets the **fileName**  property and major version number to **fileName**
        and **versionNumber** respectively. The **versionNumber** is ignored on
        Windows.

        **See also** **setFileName** ().
        """
        ...

    @overload
    def setFileNameAndVersion(self, fileName: str, version: str) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#setFileNameAndVersion-1

        **void QLibrary::setFileNameAndVersion(const QString & fileName , const
        QString & version )**

        Sets the **fileName**  property and full version number to **fileName**
        and **version** respectively. The **version** parameter is ignored on
        Windows.

        **See also** **setFileName** ().
        """
        ...

    def setLoadHints(self, hints: PySide6.QtCore.QLibrary.LoadHints) -> None:
        """
        https://doc.qt.io/qt-6/qlibrary.html#loadHints-prop

        **loadHints : LoadHints**

        Give the **load** () function some hints on how it should behave.

        You can give some hints on how the symbols are resolved. Usually, the
        symbols are not resolved at load time, but resolved lazily, (that is,
        when **resolve** () is called). If you set the loadHints to
        **ResolveAllSymbolsHint** , then all symbols will be resolved at load
        time if the platform supports it.

        Setting **ExportExternalSymbolsHint**  will make the external symbols in
        the library available for resolution in subsequent loaded libraries.

        If **LoadArchiveMemberHint**  is set, the file name is composed of two
        components: A path which is a reference to an archive file followed by
        the second component which is the reference to the archive member. For
        instance, the **fileName**  `libGL.a(shr_64.o)` will refer to the
        library `shr_64.o` in the archive file named `libGL.a`. This is only
        supported on the AIX platform.

        The interpretation of the load hints is platform dependent, and if you
        use it you are probably making some assumptions on which platform you
        are compiling for, so use them only if you understand the consequences
        of them.

        By default, none of these flags are set, so libraries will be loaded
        with lazy symbol resolution, and will not export external symbols for
        resolution in other dynamically-loaded libraries.

        **Note:** Setting this property after the library has been loaded has no
        effect and loadHints() will not reflect those changes.

        **Note:** This property is shared among all **QLibrary**  instances that
        refer to the same library.

        **Access functions:**

        QLibrary::LoadHints **loadHints** () const
        void **setLoadHints**
        (QLibrary::LoadHints **hints** )

        **Member Function Documentation**
        """
        ...

    def unload(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlibrary.html#unload

        **bool QLibrary::unload()**

        Unloads the library and returns `true` if the library could be unloaded;
        otherwise returns `false`.

        This happens automatically on application termination, so you shouldn't
        normally need to call this function.

        If other instances of **QLibrary**  are using the same library, the call
        will fail, and unloading will only happen when every instance has called
        unload().

        Note that on Mac OS X 10.3 (Panther), dynamic libraries cannot be
        unloaded.

        **See also** **resolve** () and **load** ().
        """
        ...
