"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Optional, Union, overload
import PySide6.QtCore

bytes = str


class QJsonDocument(object):
    """
    https://doc.qt.io/qt-6/qjsondocument.html

    **Detailed Description**

    QJsonDocument is a class that wraps a complete JSON document and can read
    this document from, and write it to, a UTF-8 encoded text-based
    representation.

    A JSON document can be converted from its text-based representation to a
    QJsonDocument using **QJsonDocument::fromJson** (). **toJson** () converts
    it back to text. The parser is very fast and efficient and converts the JSON
    to the binary representation used by Qt.

    Validity of the parsed document can be queried with !**isNull** ()

    A document can be queried as to whether it contains an array or an object
    using **isArray** () and **isObject** (). The array or object contained in
    the document can be retrieved using **array** () or **object** () and then
    read or manipulated.

    **See also** **JSON Support in Qt**  and **JSON Save Game Example** .
    """

    Indented: QJsonDocument.JsonFormat = ...
    Compact: QJsonDocument.JsonFormat = ...

    class JsonFormat(Enum):
        Indented: QJsonDocument.JsonFormat = ...
        Compact: QJsonDocument.JsonFormat = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#QJsonDocument

        **QJsonDocument::QJsonDocument()**

        Constructs an empty and invalid document.
        """
        ...

    @overload
    def __init__(self, array: PySide6.QtCore.QJsonArray) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#QJsonDocument-1

        **QJsonDocument::QJsonDocument(const QJsonObject & object )**

        Creates a QJsonDocument from **object**.
        """
        ...

    @overload
    def __init__(self, object: Dict[str, PySide6.QtCore.QJsonValue]) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#QJsonDocument-2

        **QJsonDocument::QJsonDocument(const QJsonArray & array )**

        Constructs a QJsonDocument from **array**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtCore.QJsonDocument) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#QJsonDocument-3

        **QJsonDocument::QJsonDocument(const QJsonDocument & other )**

        Creates a copy of the **other** document.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def array(self) -> PySide6.QtCore.QJsonArray:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#array

        **QJsonArray QJsonDocument::array() const**

        Returns the **QJsonArray**  contained in the document.

        Returns an empty array if the document contains an object.

        **See also** **isArray** (), **object** (), and **setArray** ().
        """
        ...

    @staticmethod
    def fromJson(
        json: Union[PySide6.QtCore.QByteArray, bytes],
        error: Optional[PySide6.QtCore.QJsonParseError] = ...,
    ) -> PySide6.QtCore.QJsonDocument:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#fromJson

        **[static] QJsonDocument QJsonDocument::fromJson(const QByteArray & json
        , QJsonParseError * error = nullptr)**

        Parses **json** as a UTF-8 encoded JSON document, and creates a
        **QJsonDocument**  from it.

        Returns a valid (non-null) **QJsonDocument**  if the parsing succeeds.
        If it fails, the returned document will be null, and the optional
        **error** variable will contain further details about the error.

        **See also** **toJson** (), **QJsonParseError** , and **isNull** ().
        """
        ...

    @staticmethod
    def fromVariant(variant: Any) -> PySide6.QtCore.QJsonDocument:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#fromVariant

        **[static] QJsonDocument QJsonDocument::fromVariant(const QVariant &
        variant )**

        Creates a **QJsonDocument**  from the **QVariant**  **variant**.

        If the **variant** contains any other type than a QVariantMap,
        QVariantHash, QVariantList or **QStringList** , the returned document is
        invalid.

        **See also** **toVariant** ().
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#isArray

        **bool QJsonDocument::isArray() const**

        Returns `true` if the document contains an array.

        **See also** **array** () and **isObject** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#isEmpty

        **bool QJsonDocument::isEmpty() const**

        Returns `true` if the document doesn't contain any data.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#isNull

        **bool QJsonDocument::isNull() const**

        returns `true` if this document is null.

        Null documents are documents created through the default constructor.

        Documents created from UTF-8 encoded text or the binary format are
        validated during parsing. If validation fails, the returned document
        will also be null.
        """
        ...

    def isObject(self) -> bool:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#isObject

        **bool QJsonDocument::isObject() const**

        Returns `true` if the document contains an object.

        **See also** **object** () and **isArray** ().
        """
        ...

    def object(self) -> Dict[str, PySide6.QtCore.QJsonValue]:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#object

        **QJsonObject QJsonDocument::object() const**

        Returns the **QJsonObject**  contained in the document.

        Returns an empty object if the document contains an array.

        **See also** **isObject** (), **array** (), and **setObject** ().
        """
        ...

    def setArray(self, array: PySide6.QtCore.QJsonArray) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#setArray

        **void QJsonDocument::setArray(const QJsonArray & array )**

        Sets **array** as the main object of this document.

        **See also** **setObject** () and **array** ().
        """
        ...

    def setObject(self, object: Dict[str, PySide6.QtCore.QJsonValue]) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#setObject

        **void QJsonDocument::setObject(const QJsonObject & object )**

        Sets **object** as the main object of this document.

        **See also** **setArray** () and **object** ().
        """
        ...

    def swap(self, other: PySide6.QtCore.QJsonDocument) -> None:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#swap

        **[since 5.10] void QJsonDocument::swap(QJsonDocument & other )**

        Swaps the document **other** with this. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.10.
        """
        ...

    def toJson(
        self, format: PySide6.QtCore.QJsonDocument.JsonFormat = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#toJson

        **[since 5.1] QByteArray QJsonDocument::toJson(QJsonDocument::JsonFormat
        format = Indented) const**

        Converts the **QJsonDocument**  to a UTF-8 encoded JSON document in the
        provided **format**.

        This function was introduced in Qt 5.1.

        **See also** **fromJson** () and **JsonFormat** .
        """
        ...

    def toVariant(self) -> Any:
        """
        https://doc.qt.io/qt-6/qjsondocument.html#toVariant

        **QVariant QJsonDocument::toVariant() const**

        Returns a **QVariant**  representing the Json document.

        The returned variant will be a QVariantList if the document is a
        **QJsonArray**  and a QVariantMap if the document is a **QJsonObject** .

        **See also** **fromVariant** () and **QJsonValue::toVariant** ().
        """
        ...
