"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import List, Union, overload
import PySide6.QtCore

bytes = str


class QItemSelectionRange(object):
    """
    https://doc.qt.io/qt-6/qitemselectionrange.html

    **Detailed Description**

    A QItemSelectionRange contains information about a range of selected items
    in a model. A range of items is a contiguous array of model items, extending
    to cover a number of adjacent rows and columns with a common parent item;
    this can be visualized as a two-dimensional block of cells in a table. A
    selection range has a **top** (), **left** () a **bottom** (), **right** ()
    and a **parent** ().

    The QItemSelectionRange class is one of the **Model/View Classes**  and is
    part of Qt's **model/view framework** .

    The model items contained in the selection range can be obtained using the
    **indexes** () function. Use **QItemSelectionModel::selectedIndexes** () to
    get a list of all selected items for a view.

    You can determine whether a given model item lies within a particular range
    by using the **contains** () function. Ranges can also be compared using the
    overloaded operators for equality and inequality, and the **intersects** ()
    function allows you to determine whether two ranges overlap.

    **See also** **Model/View Programming** , **QAbstractItemModel** ,
    **QItemSelection** , and **QItemSelectionModel** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#QItemSelectionRange

        **QItemSelectionRange::QItemSelectionRange()**

        Constructs an empty selection range.
        """
        ...

    @overload
    def __init__(self, QItemSelectionRange: PySide6.QtCore.QItemSelectionRange) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#QItemSelectionRange-1

        **QItemSelectionRange::QItemSelectionRange(const QModelIndex & topLeft ,
        const QModelIndex & bottomRight )**

        Constructs a new selection range containing only the index specified by
        the **topLeft** and the index **bottomRight**.
        """
        ...

    @overload
    def __init__(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#QItemSelectionRange-2

        **QItemSelectionRange::QItemSelectionRange(const QModelIndex & index )**

        Constructs a new selection range containing only the model item
        specified by the model index **index**.
        """
        ...

    @overload
    def __init__(
        self,
        topL: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        bottomR: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#QItemSelectionRange

        **QItemSelectionRange::QItemSelectionRange()**

        Constructs an empty selection range.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def bottom(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#bottom

        **int QItemSelectionRange::bottom() const**

        Returns the row index corresponding to the lowermost selected row in the
        selection range.
        """
        ...

    def bottomRight(self) -> PySide6.QtCore.QPersistentModelIndex:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#bottomRight

        **const QPersistentModelIndex &QItemSelectionRange::bottomRight()
        const**

        Returns the index for the item located at the bottom-right corner of the
        selection range.

        **See also** **bottom** (), **right** (), and **topLeft** ().
        """
        ...

    @overload
    def contains(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#contains

        **bool QItemSelectionRange::contains(const QModelIndex & index ) const**

        Returns `true` if the model item specified by the **index** lies within
        the range of selected items; otherwise returns `false`.
        """
        ...

    @overload
    def contains(
        self,
        row: int,
        column: int,
        parentIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#contains-1

        **bool QItemSelectionRange::contains(int row , int column , const
        QModelIndex & parentIndex ) const**

        This is an overloaded function.

        Returns `true` if the model item specified by ( **row** , **column** )
        and with **parentIndex** as the parent item lies within the range of
        selected items; otherwise returns `false`.
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#height

        **int QItemSelectionRange::height() const**

        Returns the number of selected rows in the selection range.
        """
        ...

    def indexes(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#indexes

        **QModelIndexList QItemSelectionRange::indexes() const**

        Returns the list of model index items stored in the selection.
        """
        ...

    def intersected(
        self, other: PySide6.QtCore.QItemSelectionRange
    ) -> PySide6.QtCore.QItemSelectionRange:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#intersected

        **QItemSelectionRange QItemSelectionRange::intersected(const
        QItemSelectionRange & other ) const**

        Returns a new selection range containing only the items that are found
        in both the selection range and the **other** selection range.
        """
        ...

    def intersects(self, other: PySide6.QtCore.QItemSelectionRange) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#intersects

        **bool QItemSelectionRange::intersects(const QItemSelectionRange & other
        ) const**

        Returns `true` if this selection range intersects (overlaps with) the
        **other** range given; otherwise returns `false`.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#isEmpty

        **bool QItemSelectionRange::isEmpty() const**

        Returns `true` if the selection range contains either no items or only
        items which are either disabled or marked as not selectable.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#isValid

        **bool QItemSelectionRange::isValid() const**

        Returns `true` if the selection range is valid; otherwise returns
        `false`.
        """
        ...

    def left(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#left

        **int QItemSelectionRange::left() const**

        Returns the column index corresponding to the leftmost selected column
        in the selection range.
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#model

        **const QAbstractItemModel *QItemSelectionRange::model() const**

        Returns the model that the items in the selection range belong to.
        """
        ...

    def parent(self) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#parent

        **QModelIndex QItemSelectionRange::parent() const**

        Returns the parent model item index of the items in the selection range.
        """
        ...

    def right(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#right

        **int QItemSelectionRange::right() const**

        Returns the column index corresponding to the rightmost selected column
        in the selection range.
        """
        ...

    def swap(self, other: PySide6.QtCore.QItemSelectionRange) -> None:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#swap

        **[since 5.6] void QItemSelectionRange::swap(QItemSelectionRange & other
        )**

        Swaps this selection range's contents with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.6.
        """
        ...

    def top(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#top

        **int QItemSelectionRange::top() const**

        Returns the row index corresponding to the uppermost selected row in the
        selection range.
        """
        ...

    def topLeft(self) -> PySide6.QtCore.QPersistentModelIndex:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#topLeft

        **const QPersistentModelIndex &QItemSelectionRange::topLeft() const**

        Returns the index for the item located at the top-left corner of the
        selection range.

        **See also** **top** (), **left** (), and **bottomRight** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qitemselectionrange.html#width

        **int QItemSelectionRange::width() const**

        Returns the number of selected columns in the selection range.
        """
        ...
