"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QIODevice(PySide6.QtCore.QObject, PySide6.QtCore.QIODeviceBase):
    """
    https://doc.qt.io/qt-6/qiodevice.html

    **Detailed Description**

    QIODevice provides both a common implementation and an abstract interface
    for devices that support reading and writing of blocks of data, such as
    **QFile** , **QBuffer**  and **QTcpSocket** . QIODevice is abstract and
    cannot be instantiated, but it is common to use the interface it defines to
    provide device-independent I/O features. For example, Qt's XML classes
    operate on a QIODevice pointer, allowing them to be used with various
    devices (such as files and buffers).

    Before accessing the device, **open** () must be called to set the correct
    OpenMode (such as ReadOnly or ReadWrite). You can then write to the device
    with **write** () or **putChar** (), and read by calling either **read** (),
    **readLine** (), or **readAll** (). Call **close** () when you are done with
    the device.

    QIODevice distinguishes between two types of devices: random-access devices
    and sequential devices.

    * Random-access devices support seeking to arbitrary positions using
    **seek** (). The current position in the file is available by calling
    **pos** (). **QFile**  and **QBuffer**  are examples of random-access
    devices.
      * Sequential devices don't support seeking to arbitrary
    positions. The data must be read in one pass. The functions **pos** () and
    **size** () don't work for sequential devices. **QTcpSocket**  and
    **QProcess**  are examples of sequential devices.

    You can use **isSequential** () to determine the type of device.

    QIODevice emits **readyRead** () when new data is available for reading; for
    example, if new data has arrived on the network or if additional data is
    appended to a file that you are reading from. You can call
    **bytesAvailable** () to determine the number of bytes that are currently
    available for reading. It's common to use **bytesAvailable** () together
    with the **readyRead** () signal when programming with asynchronous devices
    such as **QTcpSocket** , where fragments of data can arrive at arbitrary
    points in time. QIODevice emits the **bytesWritten** () signal every time a
    payload of data has been written to the device. Use **bytesToWrite** () to
    determine the current amount of data waiting to be written.

    Certain subclasses of QIODevice, such as **QTcpSocket**  and **QProcess** ,
    are asynchronous. This means that I/O functions such as **write** () or
    **read** () always return immediately, while communication with the device
    itself may happen when control goes back to the event loop. QIODevice
    provides functions that allow you to force these operations to be performed
    immediately, while blocking the calling thread and without entering the
    event loop. This allows QIODevice subclasses to be used without an event
    loop, or in a separate thread:

    * **waitForReadyRead** () - This function suspends operation in the calling
    thread until new data is available for reading.
      * **waitForBytesWritten**
    () - This function suspends operation in the calling thread until one
    payload of data has been written to the device.
      * waitFor....() -
    Subclasses of QIODevice implement blocking functions for device-specific
    operations. For example, **QProcess**  has a function called
    **waitForStarted** () which suspends operation in the calling thread until
    the process has started.

    Calling these functions from the main, GUI thread, may cause your user
    interface to freeze. Example:

    **QProcess**  gzip;
        gzip.start("gzip", **QStringList** () << "-c");
    if (!gzip.waitForStarted())
            return false;
    gzip.write("uncompressed data");

        **QByteArray**  compressed;
    while (gzip.waitForReadyRead())
            compressed += gzip.readAll();

    By subclassing QIODevice, you can provide the same interface to your own I/O
    devices. Subclasses of QIODevice are only required to implement the
    protected **readData** () and **writeData** () functions. QIODevice uses
    these functions to implement all its convenience functions, such as
    **getChar** (), **readLine** () and **write** (). QIODevice also handles
    access control for you, so you can safely assume that the device is opened
    in write mode if **writeData** () is called.

    Some subclasses, such as **QFile**  and **QTcpSocket** , are implemented
    using a memory buffer for intermediate storing of data. This reduces the
    number of required device accessing calls, which are often very slow.
    Buffering makes functions like **getChar** () and **putChar** () fast, as
    they can operate on the memory buffer instead of directly on the device
    itself. Certain I/O operations, however, don't work well with a buffer. For
    example, if several users open the same device and read it character by
    character, they may end up reading the same data when they meant to read a
    separate chunk each. For this reason, QIODevice allows you to bypass any
    buffering by passing the Unbuffered flag to **open** (). When subclassing
    QIODevice, remember to bypass any buffer you may use when the device is open
    in Unbuffered mode.

    Usually, the incoming data stream from an asynchronous device is fragmented,
    and chunks of data can arrive at arbitrary points in time. To handle
    incomplete reads of data structures, use the transaction mechanism
    implemented by QIODevice. See **startTransaction** () and related functions
    for more details.

    Some sequential devices support communicating via multiple channels. These
    channels represent separate streams of data that have the property of
    independently sequenced delivery. Once the device is opened, you can
    determine the number of channels by calling the **readChannelCount** () and
    **writeChannelCount** () functions. To switch between channels, call
    **setCurrentReadChannel** () and **setCurrentWriteChannel** (),
    respectively. QIODevice also provides additional signals to handle
    asynchronous communication on a per-channel basis.

    **See also** **QBuffer** , **QFile** , and **QTcpSocket** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#QIODevice

        **QIODevice::QIODevice()**

        Constructs a QIODevice object.
        """
        ...

    @overload
    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#QIODevice-1

        **QIODevice::QIODevice(QObject * parent )**

        Constructs a QIODevice object with the given **parent**.
        """
        ...

    def atEnd(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#atEnd

        **[virtual] bool QIODevice::atEnd() const**

        Returns `true` if the current read and write position is at the end of
        the device (i.e. there is no more data available for reading on the
        device); otherwise returns `false`.

        For some devices, atEnd() can return true even though there is more data
        to read. This special case only applies to devices that generate data in
        direct response to you calling **read** () (e.g., `/dev` or `/proc`
        files on Unix and macOS, or console input / `stdin` on all platforms).

        **See also** **bytesAvailable** (), **read** (), and **isSequential**
        ().
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#bytesAvailable

        **[virtual] qint64 QIODevice::bytesAvailable() const**

        Returns the number of bytes that are available for reading. This
        function is commonly used with sequential devices to determine the
        number of bytes to allocate in a buffer before reading.

        Subclasses that reimplement this function must call the base
        implementation in order to include the size of the buffer of
        **QIODevice** . Example:

        **qint64**  CustomDevice::bytesAvailable() const
            {
                return
        buffer.size() + **QIODevice** ::bytesAvailable();
            }

        **See also** **bytesToWrite** (), **readyRead** (), and **isSequential**
        ().
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#bytesToWrite

        **[virtual] qint64 QIODevice::bytesToWrite() const**

        For buffered devices, this function returns the number of bytes waiting
        to be written. For devices with no buffer, this function returns 0.

        Subclasses that reimplement this function must call the base
        implementation in order to include the size of the buffer of
        **QIODevice** .

        **See also** **bytesAvailable** (), **bytesWritten** (), and
        **isSequential** ().
        """
        ...

    def canReadLine(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#canReadLine

        **[virtual] bool QIODevice::canReadLine() const**

        Returns `true` if a complete line of data can be read from the device;
        otherwise returns `false`.

        Note that unbuffered devices, which have no way of determining what can
        be read, always return false.

        This function is often called in conjunction with the **readyRead** ()
        signal.

        Subclasses that reimplement this function must call the base
        implementation in order to include the contents of the **QIODevice** 's
        buffer. Example:

        bool CustomDevice::canReadLine() const
            {
                return
        buffer.contains('\\n') || **QIODevice** ::canReadLine();
            }

        **See also** **readyRead** () and **readLine** ().
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#close

        **[virtual] void QIODevice::close()**

        First emits **aboutToClose** (), then closes the device and sets its
        OpenMode to NotOpen. The error string is also reset.

        **See also** **setOpenMode** () and **QIODeviceBase::OpenMode** .
        """
        ...

    def commitTransaction(self) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#commitTransaction

        **[since 5.7] void QIODevice::commitTransaction()**

        Completes a read transaction.

        For sequential devices, all data recorded in the internal buffer during
        the transaction will be discarded.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** () and **rollbackTransaction** ().
        """
        ...

    def currentReadChannel(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#currentReadChannel

        **[since 5.7] int QIODevice::currentReadChannel() const**

        Returns the index of the current read channel.

        This function was introduced in Qt 5.7.

        **See also** **setCurrentReadChannel** (), **readChannelCount** (), and
        **QProcess** .
        """
        ...

    def currentWriteChannel(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#currentWriteChannel

        **[since 5.7] int QIODevice::currentWriteChannel() const**

        Returns the index of the current write channel.

        This function was introduced in Qt 5.7.

        **See also** **setCurrentWriteChannel** () and **writeChannelCount** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qiodevice.html#errorString

        **QString QIODevice::errorString() const**

        Returns a human-readable description of the last device error that
        occurred.

        **See also** **setErrorString** ().
        """
        ...

    def getChar(self, c: bytes) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#getChar

        **bool QIODevice::getChar(char * c )**

        Reads one character from the device and stores it in **c**. If **c** is
        `nullptr`, the character is discarded. Returns `true` on success;
        otherwise returns `false`.

        **See also** **read** (), **putChar** (), and **ungetChar** ().
        """
        ...

    def isOpen(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isOpen

        **bool QIODevice::isOpen() const**

        Returns `true` if the device is open; otherwise returns `false`. A
        device is open if it can be read from and/or written to. By default,
        this function returns `false` if **openMode** () returns `NotOpen`.

        **See also** **openMode** () and **QIODeviceBase::OpenMode** .
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isReadable

        **bool QIODevice::isReadable() const**

        Returns `true` if data can be read from the device; otherwise returns
        false. Use **bytesAvailable** () to determine how many bytes can be
        read.

        This is a convenience function which checks if the OpenMode of the
        device contains the ReadOnly flag.

        **See also** **openMode** () and **OpenMode** .
        """
        ...

    def isSequential(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isSequential

        **[virtual] bool QIODevice::isSequential() const**

        Returns `true` if this device is sequential; otherwise returns false.

        Sequential devices, as opposed to a random-access devices, have no
        concept of a start, an end, a size, or a current position, and they do
        not support seeking. You can only read from the device when it reports
        that data is available. The most common example of a sequential device
        is a network socket. On Unix, special files such as /dev/zero and fifo
        pipes are sequential.

        Regular files, on the other hand, do support random access. They have
        both a size and a current position, and they also support seeking
        backwards and forwards in the data stream. Regular files are non-
        sequential.

        **See also** **bytesAvailable** ().
        """
        ...

    def isTextModeEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isTextModeEnabled

        **bool QIODevice::isTextModeEnabled() const**

        Returns `true` if the **Text**  flag is enabled; otherwise returns
        `false`.

        **See also** **setTextModeEnabled** ().
        """
        ...

    def isTransactionStarted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isTransactionStarted

        **[since 5.7] bool QIODevice::isTransactionStarted() const**

        Returns `true` if a transaction is in progress on the device, otherwise
        `false`.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** ().
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#isWritable

        **bool QIODevice::isWritable() const**

        Returns `true` if data can be written to the device; otherwise returns
        false.

        This is a convenience function which checks if the OpenMode of the
        device contains the WriteOnly flag.

        **See also** **openMode** () and **OpenMode** .
        """
        ...

    def open(self, mode: PySide6.QtCore.QIODeviceBase.OpenMode) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#open

        **[virtual] bool QIODevice::open(QIODeviceBase::OpenMode mode )**

        Opens the device and sets its OpenMode to **mode**. Returns `true` if
        successful; otherwise returns `false`. This function should be called
        from any reimplementations of open() or other functions that open the
        device.

        **See also** **openMode** () and **QIODeviceBase::OpenMode** .
        """
        ...

    def openMode(self) -> PySide6.QtCore.QIODeviceBase.OpenMode:
        """
        https://doc.qt.io/qt-6/qiodevice.html#openMode

        **QIODeviceBase::OpenMode QIODevice::openMode() const**

        Returns the mode in which the device has been opened; i.e. ReadOnly or
        WriteOnly.

        **See also** **setOpenMode** () and **OpenMode** .
        """
        ...

    def peek(self, maxlen: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qiodevice.html#peek

        **qint64 QIODevice::peek(char * data , qint64 maxSize )**

        Reads at most **maxSize** bytes from the device into **data** , without
        side effects (i.e., if you call **read** () after peek(), you will get
        the same data). Returns the number of bytes read. If an error occurs,
        such as when attempting to peek a device opened in WriteOnly mode, this
        function returns -1.

        0 is returned when no more data is available for reading.

        Example:

        bool isExeFile(**QFile**  *file)
            {
                char buf[2];
                if
        (file->peek(buf, sizeof(buf)) == sizeof(buf))
                    return (buf[0]
        == 'M' && buf[1] == 'Z');
                return false;
            }

        **See also** **read** ().
        """
        ...

    def pos(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#pos

        **[virtual] qint64 QIODevice::pos() const**

        For random-access devices, this function returns the position that data
        is written to or read from. For sequential devices or closed devices,
        where there is no concept of a "current position", 0 is returned.

        The current read/write position of the device is maintained internally
        by **QIODevice** , so reimplementing this function is not necessary.
        When subclassing **QIODevice** , use **QIODevice::seek** () to notify
        **QIODevice**  about changes in the device position.

        **See also** **isSequential** () and **seek** ().
        """
        ...

    def putChar(self, c: int) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#putChar

        **bool QIODevice::putChar(char c )**

        Writes the character **c** to the device. Returns `true` on success;
        otherwise returns `false`.

        **See also** **write** (), **getChar** (), and **ungetChar** ().
        """
        ...

    def read(self, maxlen: int) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qiodevice.html#read

        **qint64 QIODevice::read(char * data , qint64 maxSize )**

        Reads at most **maxSize** bytes from the device into **data** , and
        returns the number of bytes read. If an error occurs, such as when
        attempting to read from a device opened in WriteOnly mode, this function
        returns -1.

        0 is returned when no more data is available for reading. However,
        reading past the end of the stream is considered an error, so this
        function returns -1 in those cases (that is, reading on a closed socket
        or after a process has died).

        **See also** **readData** (), **readLine** (), and **write** ().
        """
        ...

    def readAll(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readAll

        **QByteArray QIODevice::readAll()**

        Reads all remaining data from the device, and returns it as a byte
        array.

        This function has no way of reporting errors; returning an empty
        **QByteArray**  can mean either that no data was currently available for
        reading, or that an error occurred.
        """
        ...

    def readChannelCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readChannelCount

        **[since 5.7] int QIODevice::readChannelCount() const**

        Returns the number of available read channels if the device is open;
        otherwise returns 0.

        This function was introduced in Qt 5.7.

        **See also** **writeChannelCount** () and **QProcess** .
        """
        ...

    def readData(self, data: bytes, maxlen: int) -> object:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readData

        **[pure virtual protected] qint64 QIODevice::readData(char * data ,
        qint64 maxSize )**

        Reads up to **maxSize** bytes from the device into **data** , and
        returns the number of bytes read or -1 if an error occurred.

        If there are no bytes to be read and there can never be more bytes
        available (examples include socket closed, pipe closed, sub-process
        finished), this function returns -1.

        This function is called by **QIODevice** . Reimplement this function
        when creating a subclass of **QIODevice** .

        When reimplementing this function it is important that this function
        reads all the required data before returning. This is required in order
        for **QDataStream**  to be able to operate on the class. **QDataStream**
        assumes all the requested information was read and therefore does not
        retry reading if there was a problem.

        This function might be called with a maxSize of 0, which can be used to
        perform post-reading operations.

        **See also** **read** (), **readLine** (), and **writeData** ().
        """
        ...

    def readLine(self, maxlen: int = ...) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readLine

        **qint64 QIODevice::readLine(char * data , qint64 maxSize )**

        This function reads a line of ASCII characters from the device, up to a
        maximum of **maxSize** \\- 1 bytes, stores the characters in **data** ,
        and returns the number of bytes read. If a line could not be read but no
        error occurred, this function returns 0. If an error occurs, this
        function returns the length of what could be read, or -1 if nothing was
        read.

        A terminating '\\0' byte is always appended to **data** , so **maxSize**
        must be larger than 1.

        Data is read until either of the following conditions are met:

        * The first '\\n' character is read.
          * **maxSize** \\- 1 bytes are read.
        * The end of the device data is detected.

        For example, the following code reads a line of characters from a file:

        **QFile**  file("box.txt");
            if (file.open(**QFile** ::ReadOnly)) {
        char buf[1024];
                **qint64**  lineLength = file.readLine(buf,
        sizeof(buf));
                if (lineLength != -1) {
                    // the line is
        available in buf
                }
            }

        The newline character ('\\n') is included in the buffer. If a newline is
        not encountered before maxSize - 1 bytes are read, a newline will not be
        inserted into the buffer. On windows newline characters are replaced
        with '\\n'.

        Note that on sequential devices, data may not be immediately available,
        which may result in a partial line being returned. By calling the
        **canReadLine** () function before reading, you can check whether a
        complete line (including the newline character) can be read.

        This function calls **readLineData** (), which is implemented using
        repeated calls to **getChar** (). You can provide a more efficient
        implementation by reimplementing **readLineData** () in your own
        subclass.

        **See also** **getChar** (), **read** (), **canReadLine** (), and
        **write** ().
        """
        ...

    def readLineData(self, data: bytes, maxlen: int) -> object:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readLineData

        **[virtual protected] qint64 QIODevice::readLineData(char * data ,
        qint64 maxSize )**

        Reads up to **maxSize** characters into **data** and returns the number
        of characters read.

        This function is called by **readLine** (), and provides its base
        implementation, using **getChar** (). Buffered devices can improve the
        performance of **readLine** () by reimplementing this function.

        **readLine** () appends a '\\0' byte to **data** ; readLineData() does
        not need to do this.

        If you reimplement this function, be careful to return the correct
        value: it should return the number of bytes read in this line, including
        the terminating newline, or 0 if there is no line to be read at this
        point. If an error occurs, it should return -1 if and only if no bytes
        were read. Reading past EOF is considered an error.
        """
        ...

    def reset(self) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#reset

        **[virtual] bool QIODevice::reset()**

        Seeks to the start of input for random-access devices. Returns true on
        success; otherwise returns `false` (for example, if the device is not
        open).

        Note that when using a **QTextStream**  on a **QFile** , calling reset()
        on the **QFile**  will not have the expected result because
        **QTextStream**  buffers the file. Use the **QTextStream::seek** ()
        function instead.

        **See also** **seek** ().
        """
        ...

    def rollbackTransaction(self) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#rollbackTransaction

        **[since 5.7] void QIODevice::rollbackTransaction()**

        Rolls back a read transaction.

        Restores the input stream to the point of the **startTransaction** ()
        call. This function is commonly used to rollback the transaction when an
        incomplete read was detected prior to committing the transaction.

        This function was introduced in Qt 5.7.

        **See also** **startTransaction** () and **commitTransaction** ().
        """
        ...

    def seek(self, pos: int) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#seek

        **[virtual] bool QIODevice::seek(qint64 pos )**

        For random-access devices, this function sets the current position to
        **pos** , returning true on success, or false if an error occurred. For
        sequential devices, the default behavior is to produce a warning and
        return false.

        When subclassing **QIODevice** , you must call QIODevice::seek() at the
        start of your function to ensure integrity with **QIODevice** 's built-
        in buffer.

        **See also** **pos** () and **isSequential** ().
        """
        ...

    def setCurrentReadChannel(self, channel: int) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#setCurrentReadChannel

        **[since 5.7] void QIODevice::setCurrentReadChannel(int channel )**

        Sets the current read channel of the **QIODevice**  to the given
        **channel**. The current input channel is used by the functions **read**
        (), **readAll** (), **readLine** (), and **getChar** (). It also
        determines which channel triggers **QIODevice**  to emit **readyRead**
        ().

        This function was introduced in Qt 5.7.

        **See also** **currentReadChannel** (), **readChannelCount** (), and
        **QProcess** .
        """
        ...

    def setCurrentWriteChannel(self, channel: int) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#setCurrentWriteChannel

        **[since 5.7] void QIODevice::setCurrentWriteChannel(int channel )**

        Sets the current write channel of the **QIODevice**  to the given
        **channel**. The current output channel is used by the functions
        **write** (), **putChar** (). It also determines which channel triggers
        **QIODevice**  to emit **bytesWritten** ().

        This function was introduced in Qt 5.7.

        **See also** **currentWriteChannel** () and **writeChannelCount** ().
        """
        ...

    def setErrorString(self, errorString: str) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#setErrorString

        **[protected] void QIODevice::setErrorString(const QString & str )**

        Sets the human readable description of the last device error that
        occurred to **str**.

        **See also** **errorString** ().
        """
        ...

    def setOpenMode(self, openMode: PySide6.QtCore.QIODeviceBase.OpenMode) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#setOpenMode

        **[protected] void QIODevice::setOpenMode(QIODeviceBase::OpenMode
        openMode )**

        Sets the OpenMode of the device to **openMode**. Call this function to
        set the open mode if the flags change after the device has been opened.

        **See also** **openMode** () and **OpenMode** .
        """
        ...

    def setTextModeEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#setTextModeEnabled

        **void QIODevice::setTextModeEnabled(bool enabled )**

        If **enabled** is true, this function sets the **Text**  flag on the
        device; otherwise the **Text**  flag is removed. This feature is useful
        for classes that provide custom end-of-line handling on a **QIODevice**
        .

        The IO device should be opened before calling this function.

        **See also** **isTextModeEnabled** (), **open** (), and **setOpenMode**
        ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#size

        **[virtual] qint64 QIODevice::size() const**

        For open random-access devices, this function returns the size of the
        device. For open sequential devices, **bytesAvailable** () is returned.

        If the device is closed, the size returned will not reflect the actual
        size of the device.

        **See also** **isSequential** () and **pos** ().
        """
        ...

    def skip(self, maxSize: int) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#skip

        **[since 5.10] qint64 QIODevice::skip(qint64 maxSize )**

        Skips up to **maxSize** bytes from the device. Returns the number of
        bytes actually skipped, or -1 on error.

        This function does not wait and only discards the data that is already
        available for reading.

        If the device is opened in text mode, end-of-line terminators are
        translated to '\\n' symbols and count as a single byte identically to the
        **read** () and **peek** () behavior.

        This function works for all devices, including sequential ones that
        cannot **seek** (). It is optimized to skip unwanted data after a
        **peek** () call.

        For random-access devices, skip() can be used to seek forward from the
        current position. Negative **maxSize** values are not allowed.

        This function was introduced in Qt 5.10.

        **See also** **skipData** (), **peek** (), **seek** (), and **read** ().
        """
        ...

    def skipData(self, maxSize: int) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#skipData

        **[virtual protected, since 6.0] qint64 QIODevice::skipData(qint64
        maxSize )**

        Skips up to **maxSize** bytes from the device. Returns the number of
        bytes actually skipped, or -1 on error.

        This function is called by **QIODevice** . Consider reimplementing it
        when creating a subclass of **QIODevice** .

        The base implementation discards the data by reading into a dummy
        buffer. This is slow, but works for all types of devices. Subclasses can
        reimplement this function to improve on that.

        This function was introduced in Qt 6.0.

        **See also** **skip** (), **peek** (), **seek** (), and **read** ().
        """
        ...

    def startTransaction(self) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#startTransaction

        **[since 5.7] void QIODevice::startTransaction()**

        Starts a new read transaction on the device.

        Defines a restorable point within the sequence of read operations. For
        sequential devices, read data will be duplicated internally to allow
        recovery in case of incomplete reads. For random-access devices, this
        function saves the current position. Call **commitTransaction** () or
        **rollbackTransaction** () to finish the transaction.

        **Note:** Nesting transactions is not supported.

        This function was introduced in Qt 5.7.

        **See also** **commitTransaction** () and **rollbackTransaction** ().
        """
        ...

    def ungetChar(self, c: int) -> None:
        """
        https://doc.qt.io/qt-6/qiodevice.html#ungetChar

        **void QIODevice::ungetChar(char c )**

        Puts the character **c** back into the device, and decrements the
        current position unless the position is 0. This function is usually
        called to "undo" a **getChar** () operation, such as when writing a
        backtracking parser.

        If **c** was not previously read from the device, the behavior is
        undefined.

        **Note:** This function is not available while a transaction is in
        progress.
        """
        ...

    def waitForBytesWritten(self, msecs: int) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#waitForBytesWritten

        **[virtual] bool QIODevice::waitForBytesWritten(int msecs )**

        For buffered devices, this function waits until a payload of buffered
        written data has been written to the device and the **bytesWritten** ()
        signal has been emitted, or until **msecs** milliseconds have passed. If
        msecs is -1, this function will not time out. For unbuffered devices, it
        returns immediately.

        Returns `true` if a payload of data was written to the device; otherwise
        returns `false` (i.e. if the operation timed out, or if an error
        occurred).

        This function can operate without an event loop. It is useful when
        writing non-GUI applications and when performing I/O operations in a
        non-GUI thread.

        If called from within a slot connected to the **bytesWritten** ()
        signal, **bytesWritten** () will not be reemitted.

        Reimplement this function to provide a blocking API for a custom device.
        The default implementation does nothing, and returns `false`.

        **Warning:** Calling this function from the main (GUI) thread might
        cause your user interface to freeze.

        **See also** **waitForReadyRead** ().
        """
        ...

    def waitForReadyRead(self, msecs: int) -> bool:
        """
        https://doc.qt.io/qt-6/qiodevice.html#waitForReadyRead

        **[virtual] bool QIODevice::waitForReadyRead(int msecs )**

        Blocks until new data is available for reading and the **readyRead** ()
        signal has been emitted, or until **msecs** milliseconds have passed. If
        msecs is -1, this function will not time out.

        Returns `true` if new data is available for reading; otherwise returns
        false (if the operation timed out or if an error occurred).

        This function can operate without an event loop. It is useful when
        writing non-GUI applications and when performing I/O operations in a
        non-GUI thread.

        If called from within a slot connected to the **readyRead** () signal,
        **readyRead** () will not be reemitted.

        Reimplement this function to provide a blocking API for a custom device.
        The default implementation does nothing, and returns `false`.

        **Warning:** Calling this function from the main (GUI) thread might
        cause your user interface to freeze.

        **See also** **waitForBytesWritten** ().
        """
        ...

    def write(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#write

        **qint64 QIODevice::write(const char * data , qint64 maxSize )**

        Writes at most **maxSize** bytes of data from **data** to the device.
        Returns the number of bytes that were actually written, or -1 if an
        error occurred.

        **See also** **read** () and **writeData** ().
        """
        ...

    def writeChannelCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#writeChannelCount

        **[since 5.7] int QIODevice::writeChannelCount() const**

        Returns the number of available write channels if the device is open;
        otherwise returns 0.

        This function was introduced in Qt 5.7.

        **See also** **readChannelCount** ().
        """
        ...

    def writeData(self, data: bytes, len: int) -> int:
        """
        https://doc.qt.io/qt-6/qiodevice.html#writeData

        **[pure virtual protected] qint64 QIODevice::writeData(const char * data
        , qint64 maxSize )**

        Writes up to **maxSize** bytes from **data** to the device. Returns the
        number of bytes written, or -1 if an error occurred.

        This function is called by **QIODevice** . Reimplement this function
        when creating a subclass of **QIODevice** .

        When reimplementing this function it is important that this function
        writes all the data available before returning. This is required in
        order for **QDataStream**  to be able to operate on the class.
        **QDataStream**  assumes all the information was written and therefore
        does not retry writing if there was a problem.

        **See also** **read** () and **write** ().
        """
        ...

    @property
    def aboutToClose(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#aboutToClose

        **[signal] void QIODevice::aboutToClose()**

        This signal is emitted when the device is about to close. Connect this
        signal if you have operations that need to be performed before the
        device closes (e.g., if you have data in a separate buffer that needs to
        be written to the device).
        """
        ...

    @property
    def bytesWritten(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#bytesWritten

        **[signal] void QIODevice::bytesWritten(qint64 bytes )**

        This signal is emitted every time a payload of data has been written to
        the device's current write channel. The **bytes** argument is set to the
        number of bytes that were written in this payload.

        bytesWritten() is not emitted recursively; if you reenter the event loop
        or call **waitForBytesWritten** () inside a slot connected to the
        bytesWritten() signal, the signal will not be reemitted (although
        **waitForBytesWritten** () may still return true).

        **See also** **readyRead** ().
        """
        ...

    @property
    def channelBytesWritten(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#channelBytesWritten

        **[signal, since 5.7] void QIODevice::channelBytesWritten(int channel ,
        qint64 bytes )**

        This signal is emitted every time a payload of data has been written to
        the device. The **bytes** argument is set to the number of bytes that
        were written in this payload, while **channel** is the channel they were
        written to. Unlike **bytesWritten** (), it is emitted regardless of the
        **current write channel** .

        channelBytesWritten() can be emitted recursively - even for the same
        channel.

        This function was introduced in Qt 5.7.

        **See also** **bytesWritten** () and **channelReadyRead** ().
        """
        ...

    @property
    def channelReadyRead(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#channelReadyRead

        **[signal, since 5.7] void QIODevice::channelReadyRead(int channel )**

        This signal is emitted when new data is available for reading from the
        device. The **channel** argument is set to the index of the read channel
        on which the data has arrived. Unlike **readyRead** (), it is emitted
        regardless of the **current read channel** .

        channelReadyRead() can be emitted recursively - even for the same
        channel.

        This function was introduced in Qt 5.7.

        **See also** **readyRead** () and **channelBytesWritten** ().
        """
        ...

    @property
    def readChannelFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readChannelFinished

        **[signal] void QIODevice::readChannelFinished()**

        This signal is emitted when the input (reading) stream is closed in this
        device. It is emitted as soon as the closing is detected, which means
        that there might still be data available for reading with **read** ().

        **See also** **atEnd** () and **read** ().
        """
        ...

    @property
    def readyRead(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qiodevice.html#readyRead

        **[signal] void QIODevice::readyRead()**

        This signal is emitted once every time new data is available for reading
        from the device's current read channel. It will only be emitted again
        once new data is available, such as when a new payload of network data
        has arrived on your network socket, or when a new block of data has been
        appended to your device.

        readyRead() is not emitted recursively; if you reenter the event loop or
        call **waitForReadyRead** () inside a slot connected to the readyRead()
        signal, the signal will not be reemitted (although **waitForReadyRead**
        () may still return true).

        Note for developers implementing classes derived from **QIODevice** :
        you should always emit readyRead() when new data has arrived (do not
        emit it only because there's data still to be read in your buffers). Do
        not emit readyRead() in other conditions.

        **See also** **bytesWritten** ().
        """
        ...
