"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QCryptographicHash(object):
    """
    https://doc.qt.io/qt-6/qcryptographichash.html

    **Detailed Description**

    QCryptographicHash can be used to generate cryptographic hashes of binary or
    text data.

    Refer to the documentation of the **QCryptographicHash::Algorithm**  enum
    for a list of the supported algorithms.
    """

    Md4: QCryptographicHash.Algorithm = ...
    Md5: QCryptographicHash.Algorithm = ...
    Sha1: QCryptographicHash.Algorithm = ...
    Sha224: QCryptographicHash.Algorithm = ...
    Sha256: QCryptographicHash.Algorithm = ...
    Sha384: QCryptographicHash.Algorithm = ...
    Sha512: QCryptographicHash.Algorithm = ...
    Keccak_224: QCryptographicHash.Algorithm = ...
    Keccak_256: QCryptographicHash.Algorithm = ...
    Keccak_384: QCryptographicHash.Algorithm = ...
    Keccak_512: QCryptographicHash.Algorithm = ...
    RealSha3_224: QCryptographicHash.Algorithm = ...
    Sha3_224: QCryptographicHash.Algorithm = ...
    RealSha3_256: QCryptographicHash.Algorithm = ...
    Sha3_256: QCryptographicHash.Algorithm = ...
    RealSha3_384: QCryptographicHash.Algorithm = ...
    Sha3_384: QCryptographicHash.Algorithm = ...
    RealSha3_512: QCryptographicHash.Algorithm = ...
    Sha3_512: QCryptographicHash.Algorithm = ...
    Blake2b_160: QCryptographicHash.Algorithm = ...
    Blake2b_256: QCryptographicHash.Algorithm = ...
    Blake2b_384: QCryptographicHash.Algorithm = ...
    Blake2b_512: QCryptographicHash.Algorithm = ...
    Blake2s_128: QCryptographicHash.Algorithm = ...
    Blake2s_160: QCryptographicHash.Algorithm = ...
    Blake2s_224: QCryptographicHash.Algorithm = ...
    Blake2s_256: QCryptographicHash.Algorithm = ...

    class Algorithm(Enum):
        Md4: QCryptographicHash.Algorithm = ...
        Md5: QCryptographicHash.Algorithm = ...
        Sha1: QCryptographicHash.Algorithm = ...
        Sha224: QCryptographicHash.Algorithm = ...
        Sha256: QCryptographicHash.Algorithm = ...
        Sha384: QCryptographicHash.Algorithm = ...
        Sha512: QCryptographicHash.Algorithm = ...
        Keccak_224: QCryptographicHash.Algorithm = ...
        Keccak_256: QCryptographicHash.Algorithm = ...
        Keccak_384: QCryptographicHash.Algorithm = ...
        Keccak_512: QCryptographicHash.Algorithm = ...
        RealSha3_224: QCryptographicHash.Algorithm = ...
        Sha3_224: QCryptographicHash.Algorithm = ...
        RealSha3_256: QCryptographicHash.Algorithm = ...
        Sha3_256: QCryptographicHash.Algorithm = ...
        RealSha3_384: QCryptographicHash.Algorithm = ...
        Sha3_384: QCryptographicHash.Algorithm = ...
        RealSha3_512: QCryptographicHash.Algorithm = ...
        Sha3_512: QCryptographicHash.Algorithm = ...
        Blake2b_160: QCryptographicHash.Algorithm = ...
        Blake2b_256: QCryptographicHash.Algorithm = ...
        Blake2b_384: QCryptographicHash.Algorithm = ...
        Blake2b_512: QCryptographicHash.Algorithm = ...
        Blake2s_128: QCryptographicHash.Algorithm = ...
        Blake2s_160: QCryptographicHash.Algorithm = ...
        Blake2s_224: QCryptographicHash.Algorithm = ...
        Blake2s_256: QCryptographicHash.Algorithm = ...

    def __init__(self, method: PySide6.QtCore.QCryptographicHash.Algorithm) -> None:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#QCryptographicHash

        **QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm
        method )**

        Constructs an object that can be used to create a cryptographic hash
        from data using **method**.
        """
        ...

    @overload
    def addData(self, data: bytes, length: int) -> None:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#addData

        **void QCryptographicHash::addData(const char * data , qsizetype length
        )**

        Adds the first **length** chars of **data** to the cryptographic hash.
        """
        ...

    @overload
    def addData(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#addData-1

        **void QCryptographicHash::addData(const QByteArray & data )**

        This function overloads addData().
        """
        ...

    @overload
    def addData(self, device: PySide6.QtCore.QIODevice) -> bool:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#addData-2

        **[since 5.0] bool QCryptographicHash::addData(QIODevice * device )**

        Reads the data from the open **QIODevice**  **device** until it ends and
        hashes it. Returns `true` if reading was successful.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def hash(
        data: Union[PySide6.QtCore.QByteArray, bytes],
        method: PySide6.QtCore.QCryptographicHash.Algorithm,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#hash

        **[static] QByteArray QCryptographicHash::hash(const QByteArray & data ,
        QCryptographicHash::Algorithm method )**

        Returns the hash of **data** using **method**.
        """
        ...

    @staticmethod
    def hashLength(method: PySide6.QtCore.QCryptographicHash.Algorithm) -> int:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#hashLength

        **[static, since 5.12] int
        QCryptographicHash::hashLength(QCryptographicHash::Algorithm method )**

        Returns the size of the output of the selected hash **method** in bytes.

        This function was introduced in Qt 5.12.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#reset

        **void QCryptographicHash::reset()**

        Resets the object.
        """
        ...

    def result(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcryptographichash.html#result

        **QByteArray QCryptographicHash::result() const**

        Returns the final hash value.

        **See also** **QByteArray::toHex** ().
        """
        ...
