"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, Optional, Union, overload
import PySide6.QtCore

bytes = str


class QCborValue(object):
    """
    https://doc.qt.io/qt-6/qcborvalue.html

    **Detailed Description**

    This class can be used to hold one of the many types available in CBOR. CBOR
    is the Concise Binary Object Representation, a very compact form of binary
    data encoding that is a superset of JSON. It was created by the IETF
    Constrained RESTful Environments (CoRE) WG, which has used it in many new
    RFCs. It is meant to be used alongside the **CoAP protocol** .

    CBOR has three groups of built-in types:

    * Basic types: integers, floating point (double), boolean, null, etc.
      *
    String-like types: strings and byte arrays
      * Containers: arrays and maps

    Additionally, CBOR supports a form of type extensibility by associating a
    "tag" to one of the above types to convey more information. For example, a
    UUID is represented by a tag and a byte array containing the 16 bytes of the
    UUID content. QCborValue supports creating and decoding several of those
    extended types directly with Qt classes (like **QUuid** ).

    For the complete list, see **QCborValue::Type** . The type of a QCborValue
    can be queried using **type** () or one of the "isXxxx" functions.

    **Extended types and tagged values**

    A tagged value is a normal QCborValue that is paired with a number that is
    its tag. See **QCborKnownTags**  for more information on what tags are in
    the API as well as the full, official list. Such combinations form extended
    types.

    QCborValue has support for certain extended types in the API, like URL (with
    **QUrl** ) and UUID (with **QUuid** ). Other extended types not supported in
    the API are represented by a QCborValue of **Tag**  type. The tag can later
    be retrieved by **tag** () and the tagged value using **taggedValue** ().

    In order to support future compatibility, QCborValues containing extended Qt
    types compare equal to the tag type of the same contents. In other words,
    the following expression is true:

    **QCborValue** (uuid) == **QCborValue** (**QCborKnownTags** ::Uuid,
    uuid.toRfc4122());

    **Undefined and null values**

    QCborValue can contain a value of "null", which is not of any specific type.
    It resembles the C++ `std::nullptr_t` type, whose only possible value is
    `nullptr`. QCborValue has a constructor taking such a type and creates a
    null QCborValue.

    Null values are used to indicate that an optional value is not present. In
    that aspect, it is similar to the C++ Standard Library type `std::optional`
    when that is disengaged. Unlike the C++ type, CBOR nulls are simply of type
    "Null" and it is not possible to determine what concrete type it is
    replacing.

    QCborValue can also be of the undefined type, which represents a value of
    "undefined". In fact, that is what the QCborValue default constructor
    creates.

    Undefined values are different from null values. While nulls are used to
    indicate an optional value that is not provided, Undefined is usually used
    to indicate that an expected value could not be provided, usually due to an
    error or a precondition that could not be satisfied.

    Such values are completely valid and may appear in CBOR streams, unlike JSON
    content and **QJsonValue** 's undefined bit. But like **QJsonValue** 's
    Undefined, it is returned by a CBOR container's value() or read-only
    operator[] for invalid look-ups (index out of range for **QCborArray** , or
    key not found for **QCborMap** ). It is not possible to tell such a case
    apart from the value of Undefined, so if that is required, check the
    **QCborArray**  size and use the **QCborMap**  iterator API.

    **Simple types**

    CBOR supports additional simple types that, like Null and Undefined, carry
    no other value. They are called interchangeably "Simple Types" and "Simple
    Values". CBOR encodes booleans as two distinct types (one for `true` and one
    for `false`), but QCborValue has a convenience API for them.

    There are currently no other defined CBOR simple types. QCborValue supports
    them simply by their number with API like **isSimpleType** () and
    **toSimpleType** (), available for compatibility with future specifications
    before the Qt API can be updated. Their use before such a specification is
    discouraged, as other CBOR implementations may not support them fully.

    **CBOR support**

    QCborValue supports all CBOR features required to create canonical and
    strict streams. It implements almost all of the features specified in **RFC
    7049** .

    The following table lists the CBOR features that QCborValue supports.

    FeatureSupport
    Unsigned numbersYes (**qint64**  range)
    Negative
    numbersYes (**qint64**  range)
    Byte stringsYes
    Text stringsYes
    Chunked
    stringsSee below
    TagsYes (arbitrary)
    BooleansYes
    NullYes
    UndefinedYes
    Arbitrary simple valuesYes
    Half-precision float (16-bit)Yes
    Single-precision float (32-bit)Yes
    Double-precision float (64-bit)Yes
    Infinities and NaN floating pointYes
    Determinate-length arrays and mapsYes
    Indeterminate-length arrays and mapsYes
    Map key types other than strings
    and integersYes (arbitrary)

    Integers in QCborValue are limited to the range of the **qint64**  type.
    That is, from -9,223,372,036,854,775,808 (-263) to 9,223,372,036,854,775,807
    (263 \\- 1). CBOR itself can represent integer values outside of this range,
    which QCborValue does not support. When decoding a stream using **fromCbor**
    () containing one of those values, QCborValue will convert automatically to
    **Double** , but that may lose up to 11 bits of precision.

    **fromCbor** () is able to decode chunked strings, but will always merge the
    chunks together into a single QCborValue. For that reason, it always writes
    non-chunked strings when using **toCbor** () (which is required by the
    Canonical format anyway).

    QCborValue will always convert half- and single-precision floating point
    values in the CBOR stream to double-precision. The **toCbor** () function
    can take a parameter indicating to recreate them.

    **QCborValueRef**

    **QCborValueRef**  is a helper class for **QCborArray**  and **QCborMap** .
    It is the type you get when using one of the mutating APIs in those classes.
    Unlike QCborValue, new values can be assigned to that class. When that is
    done, the array or map it refers to will be modified with the new value. In
    all other aspects, its API is identical to QCborValue.

    **QJsonValue** , **QJsonDocument**

    **See also** **QCborArray** , **QCborMap** , **QCborStreamReader** , and
    **QCborStreamWriter** .
    """

    Compact: QCborValue.DiagnosticNotationOption = ...
    LineWrapped: QCborValue.DiagnosticNotationOption = ...
    ExtendedFormat: QCborValue.DiagnosticNotationOption = ...
    NoTransformation: QCborValue.EncodingOption = ...
    SortKeysInMaps: QCborValue.EncodingOption = ...
    UseFloat: QCborValue.EncodingOption = ...
    UseFloat16: QCborValue.EncodingOption = ...
    UseIntegers: QCborValue.EncodingOption = ...
    Invalid: QCborValue.Type = ...
    Integer: QCborValue.Type = ...
    ByteArray: QCborValue.Type = ...
    String: QCborValue.Type = ...
    Array: QCborValue.Type = ...
    Map: QCborValue.Type = ...
    Tag: QCborValue.Type = ...
    SimpleType: QCborValue.Type = ...
    False_: QCborValue.Type = ...
    True_: QCborValue.Type = ...
    Null: QCborValue.Type = ...
    Undefined: QCborValue.Type = ...
    Double: QCborValue.Type = ...
    DateTime: QCborValue.Type = ...
    Url: QCborValue.Type = ...
    RegularExpression: QCborValue.Type = ...
    Uuid: QCborValue.Type = ...

    class DiagnosticNotationOption(Enum):
        Compact: QCborValue.DiagnosticNotationOption = ...
        LineWrapped: QCborValue.DiagnosticNotationOption = ...
        ExtendedFormat: QCborValue.DiagnosticNotationOption = ...

    class DiagnosticNotationOptions(object):
        ...

    class EncodingOption(Enum):
        NoTransformation: QCborValue.EncodingOption = ...
        SortKeysInMaps: QCborValue.EncodingOption = ...
        UseFloat: QCborValue.EncodingOption = ...
        UseFloat16: QCborValue.EncodingOption = ...
        UseIntegers: QCborValue.EncodingOption = ...

    class EncodingOptions(object):
        ...

    class Type(Enum):
        Invalid: QCborValue.Type = ...
        Integer: QCborValue.Type = ...
        ByteArray: QCborValue.Type = ...
        String: QCborValue.Type = ...
        Array: QCborValue.Type = ...
        Map: QCborValue.Type = ...
        Tag: QCborValue.Type = ...
        SimpleType: QCborValue.Type = ...
        False_: QCborValue.Type = ...
        True_: QCborValue.Type = ...
        Null: QCborValue.Type = ...
        Undefined: QCborValue.Type = ...
        Double: QCborValue.Type = ...
        DateTime: QCborValue.Type = ...
        Url: QCborValue.Type = ...
        RegularExpression: QCborValue.Type = ...
        Uuid: QCborValue.Type = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, a: PySide6.QtCore.QCborArray) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-1

        **QCborValue::QCborValue(QCborValue::Type t_ )**

        Creates a QCborValue of type **t_**. The value associated with such a
        type (if any) will be default constructed.

        **See also** **type** ().
        """
        ...

    @overload
    def __init__(self, b_: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-2

        **QCborValue::QCborValue(std::nullptr_t)**

        Creates a QCborValue of the **Null**  type.

        CBOR null values are used to indicate optional values that were not
        provided. They are distinct from undefined values, in that null values
        are usually not the result of an earlier error or problem.

        **See also** **isNull** (), **isUndefined** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, ba: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-3

        **QCborValue::QCborValue(bool b )**

        Creates a QCborValue with boolean value **b**. The value can later be
        retrieved using **toBool** ().

        Internally, CBOR booleans are represented by a pair of types, one for
        true and one for false. For that reason, boolean QCborValues will return
        true for **isSimpleType** () and one of
        `isSimpleType(QCborSimpleType::False)` or
        `isSimpleType(QCborSimpleType::True)`.

        **See also** **toBool** (), **isBool** (), **isTrue** (), **isFalse**
        (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, dt: PySide6.QtCore.QDateTime) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-4

        **QCborValue::QCborValue(qint64 i )**

        Creates a QCborValue with integer value **i**. The value can later be
        retrieved using **toInteger** ().

        CBOR integer values are distinct from floating point values. Therefore,
        QCborValue objects with integers will compare differently to QCborValue
        objects containing floating-point, even if the values contained in the
        objects are equivalent.

        **See also** **toInteger** (), **isInteger** (), and **isDouble** ().
        """
        ...

    @overload
    def __init__(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-5

        **QCborValue::QCborValue(double d )**

        Creates a QCborValue with floating point value **d**. The value can
        later be retrieved using **toDouble** ().

        CBOR floating point values are distinct from integer values. Therefore,
        QCborValue objects with integers will compare differently to QCborValue
        objects containing floating-point, even if the values contained in the
        objects are equivalent.

        **See also** **toDouble** (), **isDouble** (), and **isInteger** ().
        """
        ...

    @overload
    def __init__(self, i: int) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-6

        **QCborValue::QCborValue(QCborSimpleType st )**

        Creates a QCborValue of simple type **st**. The type can later later be
        retrieved using **toSimpleType** () as well as **isSimpleType** (st).

        CBOR simple types are types that do not have any associated value, like
        C++'s `std::nullptr_t` type, whose only possible value is `nullptr`.

        If **st** is `QCborSimpleType::Null`, the resulting QCborValue will be
        of the **Null**  type and similarly for `QCborSimpleType::Undefined`. If
        **st** is `QCborSimpleType::False` or `QCborSimpleType::True`, the
        created QCborValue will be a boolean containing a value of false or
        true, respectively.

        This function can be used with simple types not defined in the API. For
        example, to create a QCborValue with simple type 12, one could write:

        **QCborValue**  value(**QCborSimpleType** (12));

        Simple types should not be used until a specification for them has been
        published, since other implementations may not support them properly.
        Simple type values 24 to 31 are reserved and must not be used.

        **isSimpleType** (), **isNull** (), **isUndefined** (), **isTrue** (),
        **isFalse** ()
        """
        ...

    @overload
    def __init__(self, m: PySide6.QtCore.QCborMap) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-7

        **QCborValue::QCborValue(const QByteArray & ba )**

        Creates a QCborValue with byte array value **ba**. The value can later
        be retrieved using **toByteArray** ().

        **See also** **toByteArray** (), **isByteArray** (), and **isString**
        ().
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-8

        **QCborValue::QCborValue(const QString & s )**

        Creates a QCborValue with string value **s**. The value can later be
        retrieved using **toString** ().

        **See also** **toString** (), **isString** (), and **isByteArray** ().
        """
        ...

    @overload
    def __init__(self, rx: Union[PySide6.QtCore.QRegularExpression, str]) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-9

        **QCborValue::QCborValue(QStringView s )**

        Creates a QCborValue with string value **s**. The value can later be
        retrieved using **toString** ().

        **See also** **toString** (), **isString** (), and **isByteArray** ().
        """
        ...

    @overload
    def __init__(self, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue-10

        **QCborValue::QCborValue(QLatin1String s )**

        This is an overloaded function.

        Creates a QCborValue with string value **s**. The value can later be
        retrieved using **toString** ().

        **See also** **toString** (), **isString** (), and **isByteArray** ().
        """
        ...

    @overload
    def __init__(self, s: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, st: PySide6.QtCore.QCborSimpleType) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(
        self,
        t_: PySide6.QtCore.QCborKnownTags,
        tv: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, t_: PySide6.QtCore.QCborValue.Type) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(
        self,
        tag: PySide6.QtCore.QCborTag,
        taggedValue: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, u: int) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, uuid: PySide6.QtCore.QUuid) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @overload
    def __init__(self, v: float) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#QCborValue

        **QCborValue::QCborValue()**

        Creates a QCborValue of the **Undefined**  type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are represented by the **Undefined simple type** .
        Because of that, QCborValues with undefined values will also return true
        for **isSimpleType** () and `isSimpleType(QCborSimpleType::Undefined)`.

        Undefined values are different from null values.

        QCborValue objects with undefined values are also different from invalid
        QCborValue objects. The API will not create invalid QCborValues, but
        they may exist as a result of a parsing error.

        **See also** **isUndefined** (), **isNull** (), and **isSimpleType** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def compare(
        self,
        other: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#compare

        **int QCborValue::compare(const QCborValue & other ) const**

        Compares this value and **other** , and returns an integer that
        indicates whether this value should be sorted prior to (if the result is
        negative) or after **other** (if the result is positive). If this
        function returns 0, the two values are equal and hold the same contents.

        If each **QCborValue**  contains an array or map, the comparison is
        recursive to elements contained in them.

        **Extended types**

        **QCborValue**  compares equal a **QCborValue**  containing an extended
        type, like **Url**  and **Url**  and its equivalent tagged
        representation. So, for example, the following expression is true:

        **QCborValue** (**QUrl** ("https://example.com")) == **QCborValue**
        (**QCborKnownTags** ::Url, "https://example.com");

        Do note that Qt types like **QUrl**  and **QDateTime**  will normalize
        and otherwise modify their arguments. The expression above is true only
        because the string on the right side is the normalized value that the
        **QCborValue**  on the left would take. If, for example, the "https"
        part were uppercase in both sides, the comparison would fail. For
        information on normalizations performed by **QCborValue** , please
        consult the documentation of the constructor taking the Qt type in
        question.

        **Sorting order**

        Sorting order in CBOR is defined in **RFC 7049, section 3.9** , which
        discusses the sorting of keys in a map when following the Canonical
        encoding. According to the specification, "sorting is performed on the
        bytes of the representation of the key data items" and lists as
        consequences that:

        * "If two keys have different lengths, the shorter one sorts earlier;"
        * "If two keys have the same length, the one with the lower value in
        (byte-wise) lexical order sorts earlier."

        This results in surprising sorting of QCborValues, where the result of
        this function is different from that which would later be retrieved by
        comparing the contained elements. For example, the **QCborValue**
        containing string "zzz" sorts before the **QCborValue**  with string
        "foobar", even though when comparing as **QStrings**  or **QByteArrays**
        the "zzz" sorts after "foobar" (dictionary order).

        The specification does not clearly indicate what sorting order should be
        done for values of different types (it says sorting should not pay
        "attention to the 3/5 bit splitting for major types"). **QCborValue**
        makes the assumption that types should be sorted too. The numeric values
        of the **QCborValue::Type**  enumeration are in that order, with the
        exception of the extended types, which compare as their tagged
        equivalents.

        **Note:** Sorting order is preliminary and is subject to change.
        Applications should not depend on the order returned by this function
        for the time being.

        **See also** **QCborArray::compare** (), **QCborMap::compare** (), and
        **operator==** ().
        """
        ...

    @overload
    @staticmethod
    def fromCbor(
        ba: Union[PySide6.QtCore.QByteArray, bytes],
        error: Optional[PySide6.QtCore.QCborParserError] = ...,
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromCbor

        **[static] QCborValue QCborValue::fromCbor(QCborStreamReader & reader
        )**

        Decodes one item from the CBOR stream found in **reader** and returns
        the equivalent representation. This function is recursive: if the item
        is a map or array, it will decode all items found in that map or array,
        until the outermost object is finished.

        This function need not be used on the root element of a
        **QCborStreamReader** . For example, the following code illustrates how
        to skip the CBOR signature tag from the beginning of a file:

        if (reader.isTag() && reader.toTag() == **QCborKnownTags** ::Signature)
        reader.next();

                **QCborValue**  contents = **QCborValue**
        ::fromCbor(reader);

        The returned value may be partially complete and indistinguishable from
        a valid **QCborValue**  even if the decoding failed. To determine if
        there was an error, check if **reader.lastError** () is indicating an
        error condition. This function stops decoding immediately after the
        first error.

        **See also** **toCbor** (), **toDiagnosticNotation** (), **toVariant**
        (), and **toJsonValue** ().
        """
        ...

    @overload
    @staticmethod
    def fromCbor(
        data: bytes, len: int, error: Optional[PySide6.QtCore.QCborParserError] = ...
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromCbor-1

        **[static] QCborValue QCborValue::fromCbor(const QByteArray & ba ,
        QCborParserError * error = nullptr)**

        This is an overloaded function.

        Decodes one item from the CBOR stream found in the byte array **ba** and
        returns the equivalent representation. This function is recursive: if
        the item is a map or array, it will decode all items found in that map
        or array, until the outermost object is finished.

        This function stores the error state, if any, in the object pointed to
        by **error** , along with the offset of where the error occurred. If no
        error happened, it stores **NoError**  in the error state and the number
        of bytes that it consumed (that is, it stores the offset for the first
        unused byte). Using that information makes it possible to parse further
        data that may exist in the same byte array.

        The returned value may be partially complete and indistinguishable from
        a valid **QCborValue**  even if the decoding failed. To determine if
        there was an error, check if there was an error stored in **error**.
        This function stops decoding immediately after the first error.

        **See also** **toCbor** (), **toDiagnosticNotation** (), **toVariant**
        (), and **toJsonValue** ().
        """
        ...

    @overload
    @staticmethod
    def fromCbor(
        data: bytearray,
        len: int,
        error: Optional[PySide6.QtCore.QCborParserError] = ...,
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromCbor

        **[static] QCborValue QCborValue::fromCbor(QCborStreamReader & reader
        )**

        Decodes one item from the CBOR stream found in **reader** and returns
        the equivalent representation. This function is recursive: if the item
        is a map or array, it will decode all items found in that map or array,
        until the outermost object is finished.

        This function need not be used on the root element of a
        **QCborStreamReader** . For example, the following code illustrates how
        to skip the CBOR signature tag from the beginning of a file:

        if (reader.isTag() && reader.toTag() == **QCborKnownTags** ::Signature)
        reader.next();

                **QCborValue**  contents = **QCborValue**
        ::fromCbor(reader);

        The returned value may be partially complete and indistinguishable from
        a valid **QCborValue**  even if the decoding failed. To determine if
        there was an error, check if **reader.lastError** () is indicating an
        error condition. This function stops decoding immediately after the
        first error.

        **See also** **toCbor** (), **toDiagnosticNotation** (), **toVariant**
        (), and **toJsonValue** ().
        """
        ...

    @overload
    @staticmethod
    def fromCbor(reader: PySide6.QtCore.QCborStreamReader) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromCbor

        **[static] QCborValue QCborValue::fromCbor(QCborStreamReader & reader
        )**

        Decodes one item from the CBOR stream found in **reader** and returns
        the equivalent representation. This function is recursive: if the item
        is a map or array, it will decode all items found in that map or array,
        until the outermost object is finished.

        This function need not be used on the root element of a
        **QCborStreamReader** . For example, the following code illustrates how
        to skip the CBOR signature tag from the beginning of a file:

        if (reader.isTag() && reader.toTag() == **QCborKnownTags** ::Signature)
        reader.next();

                **QCborValue**  contents = **QCborValue**
        ::fromCbor(reader);

        The returned value may be partially complete and indistinguishable from
        a valid **QCborValue**  even if the decoding failed. To determine if
        there was an error, check if **reader.lastError** () is indicating an
        error condition. This function stops decoding immediately after the
        first error.

        **See also** **toCbor** (), **toDiagnosticNotation** (), **toVariant**
        (), and **toJsonValue** ().
        """
        ...

    @staticmethod
    def fromJsonValue(
        v: Union[
            PySide6.QtCore.QJsonValue,
            PySide6.QtCore.QJsonValue.Type,
            PySide6.QtCore.QJsonArray,
            Dict[str, PySide6.QtCore.QJsonValue],
            str,
            bytes,
            float,
            int,
        ]
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromJsonValue

        **[static] QCborValue QCborValue::fromJsonValue(const QJsonValue & v )**

        Converts the JSON value contained in **v** into its corresponding CBOR
        value and returns it. There is no data loss in converting from JSON to
        CBOR, as the CBOR type set is richer than JSON's. Additionally, values
        converted to CBOR using this function can be converted back to JSON
        using **toJsonValue** () with no data loss.

        The following table lists the mapping of JSON types to CBOR types:

        JSON TypeCBOR Type
        BoolBool
        NumberInteger (if the number has no
        fraction and is in the **qint64**  range) or Double
        StringString
        ArrayArray
        ObjectMap
        NullNull

        **QJsonValue**  can also be undefined, indicating a previous operation
        that failed to complete (for example, searching for a key not present in
        an object). Undefined values are not JSON types and may not appear in
        JSON arrays and objects, but this function does return the
        **QCborValue**  undefined value if the corresponding **QJsonValue**  is
        undefined.

        **See also** **toJsonValue** (), **fromVariant** (),
        **QCborArray::fromJsonArray** (), and **QCborMap::fromJsonObject** ().
        """
        ...

    @staticmethod
    def fromVariant(variant: Any) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#fromVariant

        **[static] QCborValue QCborValue::fromVariant(const QVariant & variant
        )**

        Converts the **QVariant**  **variant** into **QCborValue**  and returns
        it.

        QVariants may contain a large list of different meta types, many of
        which have no corresponding representation in CBOR. That includes all
        user-defined meta types. When preparing transmission using CBOR, it is
        suggested to encode carefully each value to prevent loss of
        representation.

        The following table lists the conversion this function will apply:

        Qt (C++) typeCBOR type
        invalid (QVariant())Undefined
        `bool`Bool
        `std::nullptr_t`Null
        `short`, `ushort`, `int`, `uint`, **qint64**
        Integer
        **quint64** Integer, or Double if outside the range of qint64
        `float`, `double`Double
        **QByteArray** **ByteArray**
        **QDateTime**
        **DateTime**
        **QCborSimpleType** Simple type
        **QJsonArray** Array,
        converted using QCborArray::formJsonArray()
        **QJsonDocument** Array or
        Map
        **QJsonObject** Map, converted using **QCborMap::fromJsonObject**
        ()
        **QJsonValue** converted using **fromJsonValue** ()
        **QRegularExpression** **RegularExpression**
        **QString** String
        **QStringList** Array
        **QVariantHash** Map
        **QVariantList** Array
        **QVariantMap** Map
        **QUrl** Url
        **QUuid** Uuid

        If **QVariant::isNull** () returns true, a null **QCborValue**  is
        returned or inserted into the list or object, regardless of the type
        carried by **QVariant** . Note the behavior change in Qt 6.0 affecting
        **QVariant::isNull** () also affects this function.

        For other types not listed above, a conversion to string will be
        attempted, usually but not always by calling **QVariant::toString** ().
        If the conversion fails the value is replaced by an Undefined CBOR
        value. Note that **QVariant::toString** () is also lossy for the
        majority of types.

        Please note that the conversions via **QVariant::toString** () are
        subject to change at any time. Both **QVariant**  and **QCborValue**
        may be extended in the future to support more types, which will result
        in a change in how this function performs conversions.

        **See also** **toVariant** (), **fromJsonValue** (),
        **QCborArray::toVariantList** (), **QCborMap::toVariantMap** (), and
        **QJsonValue::fromVariant** ().
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isArray

        **bool QCborValue::isArray() const**

        Returns true if this **QCborValue**  is of the array type. The array
        value can be retrieved using **toArray** ().

        **See also** **type** () and **toArray** ().
        """
        ...

    def isBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isBool

        **bool QCborValue::isBool() const**

        Returns true if this **QCborValue**  is a boolean. The value can be
        retrieved using **toBool** ().

        **See also** **type** (), **toBool** (), **isTrue** (), and **isFalse**
        ().
        """
        ...

    def isByteArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isByteArray

        **bool QCborValue::isByteArray() const**

        Returns true if this **QCborValue**  is of the byte array type. The byte
        array value can be retrieved using **toByteArray** ().

        **See also** **type** () and **toByteArray** ().
        """
        ...

    def isContainer(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isContainer

        **bool QCborValue::isContainer() const**

        This convenience function returns true if the **QCborValue**  is either
        an array or a map.

        **See also** **isArray** () and **isMap** ().
        """
        ...

    def isDateTime(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isDateTime

        **bool QCborValue::isDateTime() const**

        Returns true if this **QCborValue**  is of the date/time type. The value
        can be retrieved using **toDateTime** (). Date/times are extended types
        that use the tag **DateTime** .

        Additionally, when decoding from a CBOR stream, **QCborValue**  will
        interpret tags of value **UnixTime_t**  and convert them to the
        equivalent date/time.

        **See also** **type** () and **toDateTime** ().
        """
        ...

    def isDouble(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isDouble

        **bool QCborValue::isDouble() const**

        Returns true if this **QCborValue**  is of the floating-point type. The
        value can be retrieved using **toDouble** ().

        **See also** **type** () and **toDouble** ().
        """
        ...

    def isFalse(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isFalse

        **bool QCborValue::isFalse() const**

        Returns true if this **QCborValue**  is a boolean with false value. This
        function exists because, internally, CBOR booleans are stored as two
        separate types, one for true and one for false.

        **See also** **type** (), **isBool** (), **isTrue** (), and **toBool**
        ().
        """
        ...

    def isInteger(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isInteger

        **bool QCborValue::isInteger() const**

        Returns true if this **QCborValue**  is of the integer type. The integer
        value can be retrieved using **toInteger** ().

        **See also** **type** () and **toInteger** ().
        """
        ...

    def isInvalid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isInvalid

        **bool QCborValue::isInvalid() const**

        Returns true if this **QCborValue**  is not of any valid type. Invalid
        QCborValues are distinct from those with undefined values and they
        usually represent a decoding error.

        **See also** **isUndefined** () and **isNull** ().
        """
        ...

    def isMap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isMap

        **bool QCborValue::isMap() const**

        Returns true if this **QCborValue**  is of the map type. The map value
        can be retrieved using **toMap** ().

        **See also** **type** () and **toMap** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isNull

        **bool QCborValue::isNull() const**

        Returns true if this **QCborValue**  is of the null type.

        CBOR null values are used to indicate optional values that were not
        provided. They are distinct from undefined values, in that null values
        are usually not the result of an earlier error or problem.

        Null values are distinct from undefined values and from invalid
        **QCborValue**  objects. The API will not create invalid QCborValues,
        but they may exist as a result of a parsing error.

        **See also** **type** (), **isUndefined** (), and **isInvalid** ().
        """
        ...

    def isRegularExpression(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isRegularExpression

        **bool QCborValue::isRegularExpression() const**

        Returns true if this **QCborValue**  contains a regular expression's
        pattern. The pattern can be retrieved using **toRegularExpression** ().

        **See also** **type** () and **toRegularExpression** ().
        """
        ...

    @overload
    def isSimpleType(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isSimpleType

        **bool QCborValue::isSimpleType() const**

        Returns true if this **QCborValue**  is of one of the CBOR simple types.
        The type itself can later be retrieved using **type** (), even for types
        that don't have an enumeration in the API. They can also be checked with
        the **isSimpleType** (QCborSimpleType) overload.

        **See also** **QCborSimpleType** , **isSimpleType** (QCborSimpleType),
        and **toSimpleType** ().
        """
        ...

    @overload
    def isSimpleType(self, st: PySide6.QtCore.QCborSimpleType) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isSimpleType-1

        **bool QCborValue::isSimpleType(QCborSimpleType st ) const**

        This is an overloaded function.

        Returns true if this **QCborValue**  is of a simple type and
        **toSimpleType** () would return **st** , false otherwise. This function
        can be used to check for any CBOR simple type, even those for which
        there is no enumeration in the API. For example, for the simple type of
        value 12, you could write:

        value.isSimpleType(**QCborSimpleType** (12));

        **See also** **QCborValue::QCborValue** (QCborSimpleType),
        **isSimpleType** (), **isFalse** (), **isTrue** (), **isNull** ,
        **isUndefined** (), and **toSimpleType** ().
        """
        ...

    def isString(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isString

        **bool QCborValue::isString() const**

        Returns true if this **QCborValue**  is of the string type. The string
        value can be retrieved using **toString** ().

        **See also** **type** () and **toString** ().
        """
        ...

    def isTag(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isTag

        **bool QCborValue::isTag() const**

        Returns true if this **QCborValue**  is of the tag type. The tag value
        can be retrieved using **tag** () and the tagged value using
        **taggedValue** ().

        This function also returns true for extended types that the API
        recognizes. For code that handles extended types directly before the Qt
        API is updated to support them, it is possible to recreate the tag +
        tagged value pair by using **taggedValue** ().

        **See also** **type** (), **tag** (), **taggedValue** (), and
        **taggedValue** ().
        """
        ...

    def isTrue(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isTrue

        **bool QCborValue::isTrue() const**

        Returns true if this **QCborValue**  is a boolean with true value. This
        function exists because, internally, CBOR booleans are stored as two
        separate types, one for false and one for true.

        **See also** **type** (), **isBool** (), **isFalse** (), and **toBool**
        ().
        """
        ...

    def isUndefined(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isUndefined

        **bool QCborValue::isUndefined() const**

        Returns true if this **QCborValue**  is of the undefined type.

        CBOR undefined values are used to indicate missing information, usually
        as a result of a previous operation that did not complete as expected.
        They are also used by the **QCborArray**  and **QCborMap**  API to
        indicate the searched item was not found.

        Undefined values are distinct from null values.

        **QCborValue**  objects with undefined values are also different from
        invalid **QCborValue**  objects. The API will not create invalid
        QCborValues, but they may exist as a result of a parsing error.

        **See also** **type** (), **isNull** (), and **isInvalid** ().
        """
        ...

    def isUrl(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isUrl

        **bool QCborValue::isUrl() const**

        Returns true if this **QCborValue**  is of the URL type. The URL value
        can be retrieved using **toUrl** ().

        **See also** **type** () and **toUrl** ().
        """
        ...

    def isUuid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#isUuid

        **bool QCborValue::isUuid() const**

        Returns true if this **QCborValue**  contains a UUID. The value can be
        retrieved using **toUuid** ().

        **See also** **type** () and **toUuid** ().
        """
        ...

    def swap(
        self,
        other: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#swap

        **void QCborValue::swap(QCborValue & other )**

        Swaps the contents of this **QCborValue**  object and **other**.
        """
        ...

    def tag(
        self, defaultValue: PySide6.QtCore.QCborTag = ...
    ) -> PySide6.QtCore.QCborTag:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#tag

        **QCborTag QCborValue::tag(QCborTag defaultValue = QCborTag(-1)) const**

        Returns the tag of this extended **QCborValue**  object, if it is of the
        tag type, **defaultValue** otherwise.

        CBOR represents extended types by associating a number (the tag) with a
        stored representation. This function returns that number. To retrieve
        the representation, use **taggedValue** ().

        **See also** **isTag** (), **taggedValue** (), **isDateTime** (),
        **isUrl** (), **isRegularExpression** (), and **isUuid** ().
        """
        ...

    def taggedValue(
        self,
        defaultValue: Union[
            PySide6.QtCore.QCborValue,
            PySide6.QtCore.QCborKnownTags,
            PySide6.QtCore.QCborSimpleType,
            PySide6.QtCore.QCborTag,
            PySide6.QtCore.QCborValue.Type,
            str,
            PySide6.QtCore.QByteArray,
            PySide6.QtCore.QCborArray,
            PySide6.QtCore.QCborMap,
            bytes,
            float,
            int,
        ] = ...,
    ) -> PySide6.QtCore.QCborValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#taggedValue

        **QCborValue QCborValue::taggedValue(const QCborValue & defaultValue =
        QCborValue()) const**

        Returns the tagged value of this extended **QCborValue**  object, if it
        is of the tag type, **defaultValue** otherwise.

        CBOR represents extended types by associating a number (the tag) with a
        stored representation. This function returns that representation. To
        retrieve the tag, use **tag** ().

        **See also** **isTag** (), **tag** (), **isDateTime** (), **isUrl** (),
        **isRegularExpression** (), and **isUuid** ().
        """
        ...

    @overload
    def toArray(self) -> PySide6.QtCore.QCborArray:
        ...

    @overload
    def toArray(
        self, defaultValue: PySide6.QtCore.QCborArray
    ) -> PySide6.QtCore.QCborArray:
        ...

    def toBool(self, defaultValue: bool = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toBool

        **bool QCborValue::toBool(bool defaultValue = false) const**

        Returns the boolean value stored in this **QCborValue** , if it is of a
        boolean type. Otherwise, it returns **defaultValue**.

        **See also** **isBool** (), **isTrue** (), and **isFalse** ().
        """
        ...

    def toByteArray(
        self, defaultValue: Union[PySide6.QtCore.QByteArray, bytes] = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toByteArray

        **QByteArray QCborValue::toByteArray(const QByteArray & defaultValue =
        {}) const**

        Returns the byte array value stored in this **QCborValue** , if it is of
        the byte array type. Otherwise, it returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QByteArray** .

        **See also** **isByteArray** (), **isString** (), and **toString** ().
        """
        ...

    @overload
    def toCbor(
        self, opt: PySide6.QtCore.QCborValue.EncodingOptions = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toCbor

        **QByteArray QCborValue::toCbor(QCborValue::EncodingOptions opt =
        NoTransformation) const**

        Encodes this **QCborValue**  object to its CBOR representation, using
        the options specified in **opt** , and return the byte array containing
        that representation.

        This function will not fail, except if this **QCborValue**  or any of
        the contained items, if this is a map or array, are invalid. Invalid
        types are not produced normally by the API, but can result from decoding
        errors.

        By default, this function performs no transformation on the values in
        the **QCborValue** , writing all floating point directly as double-
        precision (`double`) types. If the **UseFloat**  option is specified, it
        will use single precision (`float`) for any floating point value for
        which there's no loss of precision in using that representation. That
        includes infinities and NaN values.

        Similarly, if **UseFloat16**  is specified, this function will try to
        use half-precision (`qfloat16`) floating point if the conversion to that
        results in no loss of precision. This is always true for infinities and
        NaN.

        If **UseIntegers**  is specified, it will use integers for any floating
        point value that contains an actual integer.

        **See also** **fromCbor** (), **fromVariant** (), and **fromJsonValue**
        ().
        """
        ...

    @overload
    def toCbor(
        self,
        writer: PySide6.QtCore.QCborStreamWriter,
        opt: PySide6.QtCore.QCborValue.EncodingOptions = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toCbor-1

        **void QCborValue::toCbor(QCborStreamWriter & writer ,
        QCborValue::EncodingOptions opt = NoTransformation) const**

        This is an overloaded function.

        Encodes this **QCborValue**  object to its CBOR representation, using
        the options specified in **opt** , to the writer specified by
        **writer**. The same writer can be used by multiple QCborValues, for
        example, in order to encode different elements in a larger array.

        This function will not fail, except if this **QCborValue**  or any of
        the contained items, if this is a map or array, are invalid. Invalid
        types are not produced normally by the API, but can result from decoding
        errors.

        By default, this function performs no transformation on the values in
        the **QCborValue** , writing all floating point directly as double-
        precision (binary64) types. If the **UseFloat**  option is specified, it
        will use single precision (binary32) for any floating point value for
        which there's no loss of precision in using that representation. That
        includes infinities and NaN values.

        Similarly, if **UseFloat16**  is specified, this function will try to
        use half-precision (binary16) floating point if the conversion to that
        results in no loss of precision. This is always true for infinities and
        NaN.

        If **UseIntegers**  is specified, it will use integers for any floating
        point value that contains an actual integer.

        **See also** **fromCbor** (), **fromVariant** (), and **fromJsonValue**
        ().
        """
        ...

    def toDateTime(
        self, defaultValue: PySide6.QtCore.QDateTime = ...
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toDateTime

        **QDateTime QCborValue::toDateTime(const QDateTime & defaultValue = {})
        const**

        Returns the date/time value stored in this **QCborValue** , if it is of
        the date/time extended type. Otherwise, it returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QDateTime** .

        **See also** **isDateTime** (), **isTag** (), and **taggedValue** ().
        """
        ...

    def toDiagnosticNotation(
        self, opts: PySide6.QtCore.QCborValue.DiagnosticNotationOptions = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toDiagnosticNotation

        **QString
        QCborValue::toDiagnosticNotation(QCborValue::DiagnosticNotationOptions
        opts = Compact) const**

        Creates the diagnostic notation equivalent of this CBOR object and
        returns it. The **opts** parameter controls the dialect of the notation.
        Diagnostic notation is useful in debugging, to aid the developer in
        understanding what value is stored in the **QCborValue**  or in a CBOR
        stream. For that reason, the Qt API provides no support for parsing the
        diagnostic back into the in-memory format or CBOR stream, though the
        representation is unique and it would be possible.

        CBOR diagnostic notation is specified by **section 6**  of RFC 7049. It
        is a text representation of the CBOR stream and it is very similar to
        JSON, but it supports the CBOR types not found in JSON. The extended
        format enabled by the **ExtendedFormat**  flag is currently in some IETF
        drafts and its format is subject to change.

        This function produces the equivalent representation of the stream that
        **toCbor** () would produce, without any transformation option provided
        there. This also implies this function may not produce a representation
        of the stream that was used to create the object, if it was created
        using **fromCbor** (), as that function may have applied
        transformations. For a high-fidelity notation of a stream, without
        transformation, see the `cbordump` example.

        **See also** **toCbor** () and **QJsonDocument::toJson** ().
        """
        ...

    def toDouble(self, defaultValue: float = ...) -> float:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toDouble

        **double QCborValue::toDouble(double defaultValue = 0) const**

        Returns the floating point value stored in this **QCborValue** , if it
        is of the Double type. If it is of the Integer type, this function
        returns the integer value converted to double. In any other case, it
        returns **defaultValue**.

        **See also** **isDouble** (), **isInteger** (), and **toInteger** ().
        """
        ...

    def toInteger(self, defaultValue: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toInteger

        **qint64 QCborValue::toInteger(qint64 defaultValue = 0) const**

        Returns the integer value stored in this **QCborValue** , if it is of
        the integer type. If it is of the Double type, this function returns the
        floating point value converted to integer. In any other case, it returns
        **defaultValue**.

        **See also** **isInteger** (), **isDouble** (), and **toDouble** ().
        """
        ...

    def toJsonValue(self) -> PySide6.QtCore.QJsonValue:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toJsonValue

        **QJsonValue QCborValue::toJsonValue() const**

        Converts this **QCborValue**  object to an equivalent representation in
        JSON and returns it as a **QJsonValue** .

        Please note that CBOR contains a richer and wider type set than JSON, so
        some information may be lost in this conversion. The following table
        compares CBOR types to JSON types and indicates whether information may
        be lost or not.

        CBOR TypeJSON TypeComments
        BoolBoolNo data loss possible
        DoubleNumberInfinities and NaN will be converted to Null; no data loss
        for other values
        IntegerNumberData loss possible in the conversion if
        the integer is larger than 253 or smaller than -253.
        NullNullNo data
        loss possible
        UndefinedNullType information lost
        StringStringNo data
        loss possible
        Byte ArrayStringConverted to a lossless encoding like
        Base64url, but the distinction between strings and byte arrays is lost
        Other simple typesStringType information lost
        ArrayArrayConversion
        applies to each contained value
        MapObjectKeys are converted to string;
        values converted according to this table
        Tags and extended
        typesSpecialThe tag number itself is lost and the tagged value is
        converted to JSON

        For information on the conversion of CBOR map keys to string, see
        **QCborMap::toJsonObject** ().

        If this **QCborValue**  contains the undefined value, this function will
        return an undefined **QJsonValue**  too. Note that JSON does not support
        undefined values and undefined QJsonValues are an extension to the
        specification. They cannot be held in a **QJsonArray**  or
        **QJsonObject** , but can be returned from functions to indicate a
        failure. For all other intents and purposes, they are the same as null.

        **Special handling of tags and extended types**

        Some tags are handled specially and change the transformation of the
        tagged value from CBOR to JSON. The following table lists those special
        cases:

        TagCBOR typeTransformation
        **ExpectedBase64url** Byte arrayEncodes the
        byte array as Base64url
        **ExpectedBase64** Byte arrayEncodes the byte
        array as Base64
        **ExpectedBase16** Byte arrayEncodes the byte array as
        hex
        UrlUrl and StringUses **QUrl::toEncoded** () to normalize the
        encoding to the URL's fully encoded format
        UuidUuid and Byte arrayUses
        **QUuid::toString** () to create the string representation

        **See also** **fromJsonValue** (), **toVariant** (),
        **QCborArray::toJsonArray** (), and **QCborMap::toJsonObject** ().
        """
        ...

    @overload
    def toMap(self) -> PySide6.QtCore.QCborMap:
        ...

    @overload
    def toMap(self, defaultValue: PySide6.QtCore.QCborMap) -> PySide6.QtCore.QCborMap:
        ...

    def toRegularExpression(
        self, defaultValue: Union[PySide6.QtCore.QRegularExpression, str] = ...
    ) -> PySide6.QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toRegularExpression

        **QRegularExpression QCborValue::toRegularExpression(const
        QRegularExpression & defaultValue = {}) const**

        Returns the regular expression value stored in this **QCborValue** , if
        it is of the regular expression pattern extended type. Otherwise, it
        returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QRegularExpression** .

        **See also** **isRegularExpression** (), **isTag** (), and
        **taggedValue** ().
        """
        ...

    def toSimpleType(
        self, defaultValue: PySide6.QtCore.QCborSimpleType = ...
    ) -> PySide6.QtCore.QCborSimpleType:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toSimpleType

        **QCborSimpleType QCborValue::toSimpleType(QCborSimpleType defaultValue
        = QCborSimpleType::Undefined) const**

        Returns the simple type this **QCborValue**  is of, if it is a simple
        type. If it is not a simple type, it returns **defaultValue**.

        The following types are simple types and this function will return the
        listed values:

        **QCborValue::False** **QCborSimpleType::False**
        **QCborValue::True**
        **QCborSimpleType::True**
        **QCborValue::Null**
        **QCborSimpleType::Null**
        **QCborValue::Undefined**
        **QCborSimpleType::Undefined**

        **See also** **type** (), **isSimpleType** (), **isBool** (), **isTrue**
        (), **isFalse** (), **isTrue** (), **isNull** (), and **isUndefined**
        ().
        """
        ...

    def toString(self, defaultValue: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toString

        **QString QCborValue::toString(const QString & defaultValue = {})
        const**

        Returns the string value stored in this **QCborValue** , if it is of the
        string type. Otherwise, it returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QString** .

        **See also** **isString** (), **isByteArray** (), and **toByteArray**
        ().
        """
        ...

    def toUrl(
        self, defaultValue: Union[PySide6.QtCore.QUrl, str] = ...
    ) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toUrl

        **QUrl QCborValue::toUrl(const QUrl & defaultValue = {}) const**

        Returns the URL value stored in this **QCborValue** , if it is of the
        URL extended type. Otherwise, it returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QUrl** .

        **See also** **isUrl** (), **isTag** (), and **taggedValue** ().
        """
        ...

    def toUuid(self, defaultValue: PySide6.QtCore.QUuid = ...) -> PySide6.QtCore.QUuid:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toUuid

        **QUuid QCborValue::toUuid(const QUuid & defaultValue = {}) const**

        Returns the UUID value stored in this **QCborValue** , if it is of the
        UUID extended type. Otherwise, it returns **defaultValue**.

        Note that this function performs no conversion from other types to
        **QUuid** .

        **See also** **isUuid** (), **isTag** (), and **taggedValue** ().
        """
        ...

    def toVariant(self) -> Any:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#toVariant

        **QVariant QCborValue::toVariant() const**

        Converts this value to a native Qt type and returns the corresponding
        **QVariant** .

        The following table lists the mapping performed between **QCborValue
        types**  and **Qt meta types** .

        CBOR TypeQt or C++ typeNotes
        Integer**qint64**
        Double`double`
        Bool`bool`
        Null`std::nullptr_t`
        Undefinedno type (QVariant())
        Byte
        array**QByteArray**
        String**QString**
        Array**QVariantList**
        Recursively converts all values
        Map**QVariantMap** Key types are
        "stringified"
        Other simple types**QCborSimpleType**
        **DateTime**
        **QDateTime**
        Url**QUrl**
        **RegularExpression**
        **QRegularExpression**
        Uuid**QUuid**
        Other tagsSpecialThe tag is
        ignored and the tagged value is converted using this function

        Note that values in both CBOR Maps and Arrays are converted recursively
        using this function too and placed in QVariantMap and QVariantList
        instead. You will not find **QCborMap**  and **QCborArray**  stored
        inside the QVariants.

        QVariantMaps have string keys, unlike CBOR, so the conversion of a
        **QCborMap**  to QVariantMap will imply a step of "stringification" of
        the key values. See **QCborMap::toJsonObject** () for details.

        **See also** **fromVariant** (), **toJsonValue** (),
        **QCborArray::toVariantList** (), and **QCborMap::toVariantMap** ().
        """
        ...

    def type(self) -> PySide6.QtCore.QCborValue.Type:
        """
        https://doc.qt.io/qt-6/qcborvalue.html#type

        **QCborValue::Type QCborValue::type() const**

        Returns the type of this **QCborValue** . The type can also later be
        retrieved by one of the "isXxx" functions.

        **See also** **isInteger** (), **isByteArray** (), **isString** (),
        **isArray** (), **isMap** (), **isTag** (), **isFalse** (), **isTrue**
        (), **isBool** (), **isNull** (), **isUndefined** , **isDouble** (),
        **isDateTime** (), **isUrl** (), **isRegularExpression** (), and
        **isUuid** ().
        """
        ...
