"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore

bytes = str


class QByteArrayMatcher(object):
    """
    https://doc.qt.io/qt-6/qbytearraymatcher.html

    **Detailed Description**

    This class is useful when you have a sequence of bytes that you want to
    repeatedly match against some byte arrays (perhaps in a loop), or when you
    want to search for the same sequence of bytes multiple times in the same
    byte array. Using a matcher object and **indexIn** () is faster than
    matching a plain **QByteArray**  with **QByteArray::indexOf** () if repeated
    matching takes place. This class offers no benefit if you are doing one-off
    byte array matches.

    Create the QByteArrayMatcher with the **QByteArray**  you want to search
    for. Then call **indexIn** () on the **QByteArray**  that you want to
    search.

    **See also** **QByteArray**  and **QStringMatcher** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#QByteArrayMatcher

        **QByteArrayMatcher::QByteArrayMatcher()**

        Constructs an empty byte array matcher that won't match anything. Call
        **setPattern** () to give it a pattern to match.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtCore.QByteArrayMatcher) -> None:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#QByteArrayMatcher-1

        **QByteArrayMatcher::QByteArrayMatcher(const QByteArray & pattern )**

        Constructs a byte array matcher that will search for **pattern**. Call
        **indexIn** () to perform a search.
        """
        ...

    @overload
    def __init__(self, pattern: bytes, length: int) -> None:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#QByteArrayMatcher-2

        **QByteArrayMatcher::QByteArrayMatcher(const char * pattern , qsizetype
        length )**

        Constructs a byte array matcher from **pattern**. **pattern** has the
        given **length**. Call **indexIn** () to perform a search.

        **Note:** the data that **pattern** is referencing must remain valid
        while this object is used.
        """
        ...

    @overload
    def __init__(self, pattern: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#QByteArrayMatcher-3

        **QByteArrayMatcher::QByteArrayMatcher(const QByteArrayMatcher & other
        )**

        Copies the **other** byte array matcher to this byte array matcher.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    @overload
    def indexIn(
        self, ba: Union[PySide6.QtCore.QByteArray, bytes], from_: int = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#indexIn

        **qsizetype QByteArrayMatcher::indexIn(const QByteArray & ba , qsizetype
        from = 0) const**

        Searches the byte array **ba** , from byte position **from** (default 0,
        i.e. from the first byte), for the byte array **pattern** () that was
        set in the constructor or in the most recent call to **setPattern** ().
        Returns the position where the **pattern** () matched in **ba** , or -1
        if no match was found.
        """
        ...

    @overload
    def indexIn(self, str: bytes, len: int, from_: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#indexIn-1

        **qsizetype QByteArrayMatcher::indexIn(const char * str , qsizetype len
        , qsizetype from = 0) const**

        Searches the char string **str** , which has length **len** , from byte
        position **from** (default 0, i.e. from the first byte), for the byte
        array **pattern** () that was set in the constructor or in the most
        recent call to **setPattern** (). Returns the position where the
        **pattern** () matched in **str** , or -1 if no match was found.
        """
        ...

    def pattern(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#pattern

        **QByteArray QByteArrayMatcher::pattern() const**

        Returns the byte array pattern that this byte array matcher will search
        for.

        **See also** **setPattern** ().
        """
        ...

    def setPattern(self, pattern: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qbytearraymatcher.html#setPattern

        **void QByteArrayMatcher::setPattern(const QByteArray & pattern )**

        Sets the byte array that this byte array matcher will search for to
        **pattern**.

        **See also** **pattern** () and **indexIn** ().
        """
        ...
