"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, List, Optional, Union
import PySide6.QtCore

bytes = str


class QAbstractProxyModel(PySide6.QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-6/qabstractproxymodel.html

    **Detailed Description**

    This class defines the standard interface that proxy models must use to be
    able to interoperate correctly with other model/view components. It is not
    supposed to be instantiated directly.

    All standard proxy models are derived from the QAbstractProxyModel class. If
    you need to create a new proxy model class, it is usually better to subclass
    an existing class that provides the closest behavior to the one you want to
    provide.

    Proxy models that filter or sort items of data from a source model should be
    created by using or subclassing **QSortFilterProxyModel** .

    To subclass QAbstractProxyModel, you need to implement **mapFromSource** ()
    and **mapToSource** (). The **mapSelectionFromSource** () and
    **mapSelectionToSource** () functions only need to be reimplemented if you
    need a behavior different from the default behavior.

    **Note:** If the source model is deleted or no source model is specified,
    the proxy model operates on a empty placeholder model.

    **See also** **QSortFilterProxyModel** , **QAbstractItemModel** , and
    **Model/View Programming** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#QAbstractProxyModel

        **QAbstractProxyModel::QAbstractProxyModel(QObject * parent = nullptr)**

        Constructs a proxy model with the given **parent**.
        """
        ...

    def buddy(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#buddy

        **[override virtual] QModelIndex QAbstractProxyModel::buddy(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::buddy(const QModelIndex &index)
        const** .
        """
        ...

    def canDropMimeData(
        self,
        data: PySide6.QtCore.QMimeData,
        action: PySide6.QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#canDropMimeData

        **[override virtual, since 5.4] bool
        QAbstractProxyModel::canDropMimeData(const QMimeData * data ,
        Qt::DropAction action , int row , int column , const QModelIndex &
        parent ) const**

        Reimplements: **QAbstractItemModel::canDropMimeData(const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent) const** .

        This function was introduced in Qt 5.4.
        """
        ...

    def canFetchMore(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#canFetchMore

        **[override virtual] bool QAbstractProxyModel::canFetchMore(const
        QModelIndex & parent ) const**

        Reimplements: **QAbstractItemModel::canFetchMore(const QModelIndex
        &parent) const** .
        """
        ...

    def clearItemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#clearItemData

        **[override virtual, since 6.0] bool
        QAbstractProxyModel::clearItemData(const QModelIndex & index )**

        Reimplements: **QAbstractItemModel::clearItemData** (const QModelIndex
        &index).

        This function was introduced in Qt 6.0.
        """
        ...

    def createSourceIndex(
        self, row: int, col: int, internalPtr: int
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#createSourceIndex

        **[protected, since 6.2] QModelIndex
        QAbstractProxyModel::createSourceIndex(int row , int col , void *
        internalPtr ) const**

        Equivalent to calling createIndex on the source model.

        This method is useful if your proxy model wants to maintain the parent-
        child relationship of items in the source model. When reimplementing
        **mapToSource** (), you can call this method to create an index for row
        **row** and column **col** of the source model.

        A typical use would be to save the internal pointer coming from the
        source model in the proxy index when reimplementing **mapFromSource** ()
        and use the same internal pointer as **internalPtr** to recover the
        original source index when reimplementing **mapToSource** ().

        This function was introduced in Qt 6.2.
        """
        ...

    def data(
        self,
        proxyIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
        role: int = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#data

        **[override virtual] QVariant QAbstractProxyModel::data(const
        QModelIndex & proxyIndex , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data(const QModelIndex &index, int
        role) const** .

        **See also** **setData** ().
        """
        ...

    def dropMimeData(
        self,
        data: PySide6.QtCore.QMimeData,
        action: PySide6.QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#dropMimeData

        **[override virtual, since 5.4] bool
        QAbstractProxyModel::dropMimeData(const QMimeData * data ,
        Qt::DropAction action , int row , int column , const QModelIndex &
        parent )**

        Reimplements: **QAbstractItemModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).

        This function was introduced in Qt 5.4.
        """
        ...

    def fetchMore(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#fetchMore

        **[override virtual] void QAbstractProxyModel::fetchMore(const
        QModelIndex & parent )**

        Reimplements: **QAbstractItemModel::fetchMore** (const QModelIndex
        &parent).
        """
        ...

    def flags(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#flags

        **[override virtual] Qt::ItemFlags QAbstractProxyModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::flags(const QModelIndex &index)
        const** .
        """
        ...

    def hasChildren(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#hasChildren

        **[override virtual] bool QAbstractProxyModel::hasChildren(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::hasChildren(const QModelIndex
        &parent) const** .
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#headerData

        **[override virtual] QVariant QAbstractProxyModel::headerData(int
        section , Qt::Orientation orientation , int role = Qt::DisplayRole)
        const**

        Reimplements: **QAbstractItemModel::headerData(int section,
        Qt::Orientation orientation, int role) const** .

        **See also** **setHeaderData** ().
        """
        ...

    def itemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> Dict[int, Any]:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#itemData

        **[override virtual] QMap<int, QVariant>
        QAbstractProxyModel::itemData(const QModelIndex & proxyIndex ) const**

        Reimplements: **QAbstractItemModel::itemData(const QModelIndex &index)
        const** .

        **See also** **setItemData** ().
        """
        ...

    def mapFromSource(
        self,
        sourceIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mapFromSource

        **[pure virtual invokable] QModelIndex
        QAbstractProxyModel::mapFromSource(const QModelIndex & sourceIndex )
        const**

        Reimplement this function to return the model index in the proxy model
        that corresponds to the **sourceIndex** from the source model.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **mapToSource** ().
        """
        ...

    def mapSelectionFromSource(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtCore.QItemSelection:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mapSelectionFromSource

        **[virtual invokable] QItemSelection
        QAbstractProxyModel::mapSelectionFromSource(const QItemSelection &
        sourceSelection ) const**

        Returns a proxy selection mapped from the specified **sourceSelection**.

        Reimplement this method to map source selections to proxy selections.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def mapSelectionToSource(
        self, selection: PySide6.QtCore.QItemSelection
    ) -> PySide6.QtCore.QItemSelection:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mapSelectionToSource

        **[virtual invokable] QItemSelection
        QAbstractProxyModel::mapSelectionToSource(const QItemSelection &
        proxySelection ) const**

        Returns a source selection mapped from the specified **proxySelection**.

        Reimplement this method to map proxy selections to source selections.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def mapToSource(
        self,
        proxyIndex: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mapToSource

        **[pure virtual invokable] QModelIndex
        QAbstractProxyModel::mapToSource(const QModelIndex & proxyIndex )
        const**

        Reimplement this function to return the model index in the source model
        that corresponds to the **proxyIndex** in the proxy model.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **mapFromSource** ().
        """
        ...

    def mimeData(self, indexes: List[int]) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mimeData

        **[override virtual] QMimeData *QAbstractProxyModel::mimeData(const
        QModelIndexList & indexes ) const**

        Reimplements: **QAbstractItemModel::mimeData(const QModelIndexList
        &indexes) const** .
        """
        ...

    def mimeTypes(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#mimeTypes

        **[override virtual] QStringList QAbstractProxyModel::mimeTypes()
        const**

        Reimplements: **QAbstractItemModel::mimeTypes() const** .
        """
        ...

    def revert(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#revert

        **[override virtual] void QAbstractProxyModel::revert()**

        Reimplements: **QAbstractItemModel::revert** ().
        """
        ...

    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#roleNames

        **[override virtual] QHash<int, QByteArray>
        QAbstractProxyModel::roleNames() const**

        Reimplements: **QAbstractItemModel::roleNames() const** .
        """
        ...

    def setData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#setData

        **[override virtual] bool QAbstractProxyModel::setData(const QModelIndex
        & index , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        **See also** **data** ().
        """
        ...

    def setHeaderData(
        self,
        section: int,
        orientation: PySide6.QtCore.Qt.Orientation,
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#setHeaderData

        **[override virtual] bool QAbstractProxyModel::setHeaderData(int section
        , Qt::Orientation orientation , const QVariant & value , int role =
        Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setHeaderData** (int section,
        Qt::Orientation orientation, const QVariant &value, int role).

        **See also** **headerData** ().
        """
        ...

    def setItemData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        roles: Dict[int, Any],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#setItemData

        **[override virtual] bool QAbstractProxyModel::setItemData(const
        QModelIndex & index , const QMap<int, QVariant> & roles )**

        Reimplements: **QAbstractItemModel::setItemData** (const QModelIndex
        &index, const QMap<int, QVariant> &roles).

        **See also** **itemData** ().
        """
        ...

    def setSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#setSourceModel

        **[virtual] void QAbstractProxyModel::setSourceModel(QAbstractItemModel
        * sourceModel )**

        Sets the given **sourceModel** to be processed by the proxy model.

        Subclasses should call **beginResetModel** () at the beginning of the
        method, disconnect from the old model, call this method, connect to the
        new model, and call **endResetModel** ().

        **Note:** Setter function for property **sourceModel** .

        **See also** **sourceModel** ().
        """
        ...

    def sibling(
        self,
        row: int,
        column: int,
        idx: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#sibling

        **[override virtual] QModelIndex QAbstractProxyModel::sibling(int row ,
        int column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractItemModel::sibling(int row, int column, const
        QModelIndex &index) const** .
        """
        ...

    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#sort

        **[override virtual] void QAbstractProxyModel::sort(int column ,
        Qt::SortOrder order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).
        """
        ...

    def sourceModel(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#sourceModel

        **QAbstractItemModel *QAbstractProxyModel::sourceModel() const**

        Returns the model that contains the data that is available through the
        proxy model.

        **Note:** Getter function for property sourceModel.

        **See also** **setSourceModel** ().
        """
        ...

    def span(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#span

        **[override virtual] QSize QAbstractProxyModel::span(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemModel::span(const QModelIndex &index)
        const** .
        """
        ...

    def submit(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#submit

        **[override virtual] bool QAbstractProxyModel::submit()**

        Reimplements: **QAbstractItemModel::submit** ().
        """
        ...

    def supportedDragActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#supportedDragActions

        **[override virtual] Qt::DropActions
        QAbstractProxyModel::supportedDragActions() const**

        Reimplements: **QAbstractItemModel::supportedDragActions() const** .
        """
        ...

    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qabstractproxymodel.html#supportedDropActions

        **[override virtual] Qt::DropActions
        QAbstractProxyModel::supportedDropActions() const**

        Reimplements: **QAbstractItemModel::supportedDropActions() const** .
        """
        ...

    @property
    def sourceModelChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
