"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Any, List, Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QXYSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qxyseries.html

    **Detailed Description**

    QXYSeries supports displaying best fit line on a chart. Best fit line is a
    line through a chart that expresses the relationship between points.
    """

    @overload
    def __lshift__(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> PySide6.QtCharts.QXYSeries:
        ...

    @overload
    def __lshift__(
        self, points: Sequence[PySide6.QtCore.QPointF]
    ) -> PySide6.QtCharts.QXYSeries:
        ...

    @overload
    def append(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#append

        **void QXYSeries::append(qreal x , qreal y )**

        Adds the data point with the coordinates **x** and **y** to the series.
        """
        ...

    @overload
    def append(self, points: Sequence[PySide6.QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#append-1

        **void QXYSeries::append(const QPointF & point )**

        This is an overloaded function.

        Adds the data point **point** to the series.
        """
        ...

    @overload
    def append(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#append-2

        **void QXYSeries::append(const QList<QPointF> & points )**

        This is an overloaded function.

        Adds the list of data points specified by **points** to the series.
        """
        ...

    def appendNp(
        self,
        x: shibokensupport.signature.mapping.ArrayLikeVariable,
        y: shibokensupport.signature.mapping.ArrayLikeVariable,
    ) -> None:
        ...

    def at(self, index: int) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qxyseries.html#at

        **const QPointF &QXYSeries::at(int index ) const**

        Returns the data point at the position specified by **index** in the
        internal series of points.
        """
        ...

    def bestFitLineColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineColor-prop

        **[since 6.2] bestFitLineColor : QColor**

        This property holds the color of best fit line.

        This property was introduced in Qt 6.2.

        **Access functions:**

        QColor **bestFitLineColor** () const
        void **setBestFitLineColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****bestFitLineColorChanged** ** (const QColor & **color** )

        **See also** **bestFitLineEquation**  and **bestFitLineVisible** .
        """
        ...

    def bestFitLineEquation(self, ok: bool) -> Tuple[float, float]:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineEquation

        **[since 6.2] QPair<qreal, qreal> QXYSeries::bestFitLineEquation(bool &
        ok ) const**

        Returns a pair of numbers where the first number is a slope factor and
        the second number is intercept of a linear function for a best fit line.

        Those factors are calculated using Least Squares Method based on points
        passed to the series.

        Parameter **ok** is used to report a failure by setting its value to
        `false` and to report a success by setting its value to `true`.

        This function was introduced in Qt 6.2.

        **See also** **QXYSeries::bestFitLineVisible** ().
        """
        ...

    def bestFitLinePen(self) -> PySide6.QtGui.QPen:
        ...

    def bestFitLineVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineVisible-prop

        **[since 6.2] bestFitLineVisible : bool**

        This property holds the visibility of the best fit line.

        This property is `false` by default.

        This property was introduced in Qt 6.2.

        **Access functions:**

        bool **bestFitLineVisible** () const
        void **setBestFitLineVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****bestFitLineVisibilityChanged** ** (bool **visible** )

        **See also** **bestFitLineEquation** .
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qxyseries.html#brush

        **QBrush QXYSeries::brush() const**

        Returns the brush used to fill the data points for the series.

        **See also** **setBrush** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#clear

        **void QXYSeries::clear()**

        Removes all points from the series.

        **See also** **pointsRemoved** ().
        """
        ...

    def clearPointConfiguration(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#clearPointConfiguration

        **[since 6.2] void QXYSeries::clearPointConfiguration(const int index
        )**

        Removes the configuration of a point located at **index** and restores
        the default look derived from the series' settings.

        **Note:** It doesn't affect the configuration of other points.

        This function was introduced in Qt 6.2.

        **See also** **clearPointsConfiguration** () and
        **setPointConfiguration** ().
        """
        ...

    def clearPointsConfiguration(self) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#clearPointsConfiguration

        **[since 6.2] void QXYSeries::clearPointsConfiguration()**

        Removes the configuration of all points in the series and restores the
        default look derived from the series' settings.

        This function was introduced in Qt 6.2.

        **See also** **setPointConfiguration** ().
        """
        ...

    def color(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qxyseries.html#color-prop

        **color : QColor**

        This property holds the color of the series.

        This is the line (pen) color in case of **QLineSeries**  or
        **QSplineSeries**  and the fill (brush) color in case of
        **QScatterSeries**  or **QAreaSeries** .

        **Access functions:**

        virtual QColor ****color** ** () const
        virtual void **setColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****colorChanged** ** (QColor **color** )

        **See also** **pen** () and **brush** ().
        """
        ...

    def colorBy(
        self, sourceData: Sequence[float], gradient: PySide6.QtGui.QLinearGradient = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#colorBy

        **[since 6.2] void QXYSeries::colorBy(const QList<qreal> & sourceData ,
        const QLinearGradient & gradient = QLinearGradient())**

        Sets the points' color according to a passed list of values. Values from
        **sourceData** are sorted and mapped to the **gradient**.

        If the series has a **QColorAxis**  attached, then a gradient from the
        axis is going to be used.

        This function was introduced in Qt 6.2.

        **See also** **setPointConfiguration** (), **pointConfiguration** (),
        and **QColorAxis** .
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qxyseries.html#count

        **int QXYSeries::count() const**

        Returns the number of data points in a series.
        """
        ...

    def deselectAllPoints(self) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#deselectAllPoints

        **[since 6.2] void QXYSeries::deselectAllPoints()**

        Deselects all points in the series.

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def deselectPoint(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#deselectPoint

        **[since 6.2] void QXYSeries::deselectPoint(int index )**

        Deselects point at given **index**.

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def deselectPoints(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#deselectPoints

        **[since 6.2] void QXYSeries::deselectPoints(const QList<int> & indexes
        )**

        Marks multiple points passed in a **indexes** list as deselected.

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def insert(
        self,
        index: int,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#insert

        **void QXYSeries::insert(int index , const QPointF & point )**

        Inserts the data point **point** in the series at the position specified
        by **index**.

        **See also** **pointAdded** ().
        """
        ...

    def isPointSelected(self, index: int) -> bool:
        """
        https://doc.qt.io/qt-6/qxyseries.html#isPointSelected

        **[since 6.2] bool QXYSeries::isPointSelected(int index )**

        Returns true if point at given **index** is among selected points and
        false otherwise.

        **Note:** Selected points are drawn using the selected color if it was
        specified.

        This function was introduced in Qt 6.2.

        **See also** **selectedPoints** (), **setPointSelected** (), and
        **setSelectedColor** ().
        """
        ...

    def lightMarker(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qxyseries.html#lightMarker

        **[since 6.2] const QImage &QXYSeries::lightMarker() const**

        Gets the image used for drawing markers on each point of the series.

        The default value is QImage(), meaning no light marker will be painted.

        The light markers visualize the data points of this series and as such
        are an alternative to **setPointsVisible** (true). Both features can be
        enabled independently from each other.

        Unlike the elements of **QScatterSeries**  the light markers are not
        represented by **QGraphicsItem** , but are just painted (no objects
        created). However, the mouse-event-signals of **QXYSeries**  behave the
        same way, meaning that you'll get the exact domain value of the point if
        you click/press/hover the light marker. You'll still get the in between
        domain value if you click on the line. The light markers are above the
        line in terms of painting as well as events.

        This function was introduced in Qt 6.2.

        **See also** **QXYSeries::setLightMarker** ().
        """
        ...

    def markerSize(self) -> float:
        """
        https://doc.qt.io/qt-6/qxyseries.html#markerSize

        **[since 6.2] qreal QXYSeries::markerSize() const**

        Gets the size of the marker used to render points in the series.

        The default size depends on the specific **QXYSeries**  type.
        **QScatterSeries**  has a default of 15.0 **QLineSeries**  has a default
        of the series pen size * 1.5

        This function was introduced in Qt 6.2.

        **See also** **setMarkerSize** () and **QScatterSeries::markerSize** .
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pen

        **QPen QXYSeries::pen() const**

        Returns the pen used to draw the outline of the data points for the
        series.

        **See also** **setPen** ().
        """
        ...

    def pointLabelsClipping(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsClipping-prop

        **pointLabelsClipping : bool**

        This property holds the clipping for data point labels.

        This property is `true` by default. The labels on the edge of the plot
        area are cut when clipping is enabled.

        **Access functions:**

        bool **pointLabelsClipping** () const
        void **setPointLabelsClipping**
        (bool **enabled** = true)

        **Notifier signal:**

        void ****pointLabelsClippingChanged** ** (bool **clipping** )

        **See also** **pointLabelsVisible** .
        """
        ...

    def pointLabelsColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsColor-prop

        **pointLabelsColor : QColor**

        This property holds the color used for data point labels. By default,
        the color is the color of the brush defined in theme for labels.

        **Access functions:**

        QColor **pointLabelsColor** () const
        void **setPointLabelsColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****pointLabelsColorChanged** ** (const QColor & **color** )

        **See also** **pointLabelsFormat** .
        """
        ...

    def pointLabelsFont(self) -> PySide6.QtGui.QFont:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFont-prop

        **pointLabelsFont : QFont**

        This property holds the font used for data point labels.

        **Access functions:**

        QFont **pointLabelsFont** () const
        void **setPointLabelsFont** (const
        QFont & **font** )

        **Notifier signal:**

        void ****pointLabelsFontChanged** ** (const QFont & **font** )

        **See also** **pointLabelsFormat** .
        """
        ...

    def pointLabelsFormat(self) -> str:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFormat-prop

        **pointLabelsFormat : QString**

        This property holds the format used for showing labels with data points.

        **QXYSeries**  supports the following format tags:

        @xPointThe x-coordinate of the data point.
        @yPointThe y-coordinate of
        the data point.

        For example, the following usage of the format tags would produce labels
        that display the data point shown inside brackets separated by a comma
        (x, y):

        series->setPointLabelsFormat("(@xPoint, @yPoint)");

        By default, the labels' format is set to `@xPoint, @yPoint`. The labels
        are shown on the plot area, and the labels on the edge of the plot area
        are cut. If the points are close to each other, the labels may overlap.

        **Access functions:**

        QString **pointLabelsFormat** () const
        void **setPointLabelsFormat**
        (const QString & **format** )

        **Notifier signal:**

        void ****pointLabelsFormatChanged** ** (const QString & **format** )

        **See also** **pointLabelsVisible** , **pointLabelsFont** , and
        **pointLabelsColor** .
        """
        ...

    def pointLabelsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsVisible-prop

        **pointLabelsVisible : bool**

        This property holds the visibility of data point labels.

        This property is `false` by default.

        **Access functions:**

        bool **pointLabelsVisible** () const
        void **setPointLabelsVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****pointLabelsVisibilityChanged** ** (bool **visible** )

        **See also** **pointLabelsFormat**  and **pointLabelsClipping** .
        """
        ...

    def points(self) -> List[PySide6.QtCore.QPointF]:
        """
        https://doc.qt.io/qt-6/qxyseries.html#points

        **QList<QPointF> QXYSeries::points() const**

        Returns the points in the series.
        """
        ...

    def pointsVector(self) -> List[PySide6.QtCore.QPointF]:
        ...

    def pointsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointsVisible-prop

        **pointsVisible : bool**

        This property holds whether the data points are visible and should be
        drawn.

        **Access functions:**

        bool **pointsVisible** () const
        void **setPointsVisible** (bool
        **visible** = true)
        """
        ...

    @overload
    def remove(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#remove

        **void QXYSeries::remove(qreal x , qreal y )**

        Removes the point that has the coordinates **x** and **y** from the
        series.

        **See also** **pointRemoved** ().
        """
        ...

    @overload
    def remove(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#remove-1

        **void QXYSeries::remove(const QPointF & point )**

        Removes the data point **point** from the series.

        **See also** **pointRemoved** ().
        """
        ...

    @overload
    def remove(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#remove-2

        **void QXYSeries::remove(int index )**

        Removes the point at the position specified by **index** from the
        series.

        **See also** **pointRemoved** ().
        """
        ...

    def removePoints(self, index: int, count: int) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#removePoints

        **void QXYSeries::removePoints(int index , int count )**

        Removes the number of points specified by **count** from the series
        starting at the position specified by **index**.

        **See also** **pointsRemoved** ().
        """
        ...

    @overload
    def replace(
        self,
        index: int,
        newPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#replace

        **void QXYSeries::replace(qreal oldX , qreal oldY , qreal newX , qreal
        newY )**

        Replaces the point with the coordinates **oldX** and **oldY** with the
        point with the coordinates **newX** and **newY**. Does nothing if the
        old point does not exist.

        **See also** **pointReplaced** ().
        """
        ...

    @overload
    def replace(self, index: int, newX: float, newY: float) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#replace-1

        **void QXYSeries::replace(const QPointF & oldPoint , const QPointF &
        newPoint )**

        Replaces the point specified by **oldPoint** with the one specified by
        **newPoint**.

        **See also** **pointReplaced** ().
        """
        ...

    @overload
    def replace(
        self,
        oldPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        newPoint: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#replace-2

        **void QXYSeries::replace(int index , qreal newX , qreal newY )**

        Replaces the point at the position specified by **index** with the point
        that has the coordinates **newX** and **newY**.

        **See also** **pointReplaced** ().
        """
        ...

    @overload
    def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#replace-3

        **void QXYSeries::replace(int index , const QPointF & newPoint )**

        Replaces the point at the position specified by **index** with the point
        specified by **newPoint**.

        **See also** **pointReplaced** ().
        """
        ...

    @overload
    def replace(self, points: Sequence[PySide6.QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#replace-4

        **void QXYSeries::replace(const QList<QPointF> & points )**

        Replaces the current points with the points specified by **points**.

        **Note:** This is much faster than replacing data points one by one, or
        first clearing all data, and then appending the new data. Emits
        **QXYSeries::pointsReplaced** () when the points have been replaced.

        **See also** **pointsReplaced** ().
        """
        ...

    def replaceNp(
        self,
        x: shibokensupport.signature.mapping.ArrayLikeVariable,
        y: shibokensupport.signature.mapping.ArrayLikeVariable,
    ) -> None:
        ...

    def selectAllPoints(self) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectAllPoints

        **[since 6.2] void QXYSeries::selectAllPoints()**

        Marks all points in the series as selected,

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def selectPoint(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectPoint

        **[since 6.2] void QXYSeries::selectPoint(int index )**

        Marks point at **index** as selected.

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def selectPoints(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectPoints

        **[since 6.2] void QXYSeries::selectPoints(const QList<int> & indexes
        )**

        Marks multiple points passed in a **indexes** list as selected.

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    def selectedColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectedColor-prop

        **[since 6.2] selectedColor : QColor**

        This property holds the color of the selected points.

        This is the fill (brush) color of points marked as selected. If not
        specified, value of **QXYSeries::color**  is used as default.

        This property was introduced in Qt 6.2.

        **Access functions:**

        virtual QColor ****color** ** () const
        void **setSelectedColor**
        (const QColor & **color** )

        **Notifier signal:**

        void **selectedColorChanged** (const QColor & **color** )

        **See also** **color** .

        **Member Function Documentation**
        """
        ...

    def selectedLightMarker(self) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectedLightMarker

        **[since 6.2] const QImage &QXYSeries::selectedLightMarker() const**

        Returns the image used for drawing markers on selected series' points.

        The default value is QImage(), meaning usual **lightMarker** () will be
        painted.

        This is equivalent to **selectedColor**  if you prefer light markers
        over normal points, but still want to distinguish selected points.

        This function was introduced in Qt 6.2.

        **See also** **setSelectedLightMarker** (), **lightMarker** (),
        **selectedColor** , and **setPointSelected** ().
        """
        ...

    def selectedPoints(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectedPoints

        **[since 6.2] QList<int> QXYSeries::selectedPoints() const**

        Returns a list of points indexes marked as selected. Selected points are
        visible regardless of points visibility.

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** () and **pointsVisible** ().
        """
        ...

    def setBestFitLineColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineColor-prop

        **[since 6.2] bestFitLineColor : QColor**

        This property holds the color of best fit line.

        This property was introduced in Qt 6.2.

        **Access functions:**

        QColor **bestFitLineColor** () const
        void **setBestFitLineColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****bestFitLineColorChanged** ** (const QColor & **color** )

        **See also** **bestFitLineEquation**  and **bestFitLineVisible** .
        """
        ...

    def setBestFitLinePen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        ...

    def setBestFitLineVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineVisible-prop

        **[since 6.2] bestFitLineVisible : bool**

        This property holds the visibility of the best fit line.

        This property is `false` by default.

        This property was introduced in Qt 6.2.

        **Access functions:**

        bool **bestFitLineVisible** () const
        void **setBestFitLineVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****bestFitLineVisibilityChanged** ** (bool **visible** )

        **See also** **bestFitLineEquation** .
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setBrush

        **[virtual] void QXYSeries::setBrush(const QBrush & brush )**

        Sets the brush used for drawing points on the chart to **brush**. If the
        brush is not defined, the brush from the chart theme setting is used.

        **See also** **brush** () and **QChart::setTheme** ().
        """
        ...

    def setColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#color-prop

        **color : QColor**

        This property holds the color of the series.

        This is the line (pen) color in case of **QLineSeries**  or
        **QSplineSeries**  and the fill (brush) color in case of
        **QScatterSeries**  or **QAreaSeries** .

        **Access functions:**

        virtual QColor ****color** ** () const
        virtual void **setColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****colorChanged** ** (QColor **color** )

        **See also** **pen** () and **brush** ().
        """
        ...

    def setLightMarker(self, lightMarker: Union[PySide6.QtGui.QImage, str]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setLightMarker

        **[since 6.2] void QXYSeries::setLightMarker(const QImage & lightMarker
        )**

        Sets the image used for drawing markers on each point of the series as
        the value of **lightMarker**.

        The default value is a default-QImage() (**QImage::isNull** () == true),
        meaning no light marker will be painted. You can reset back to default
        (disabled) by calling this function with a null **QImage**  (QImage()).

        The light markers visualize the data points of this series and as such
        are an alternative to `setPointsVisible(true)`. If a light marker is set
        with this method, visible points as set with `setPointsVisible(true)`
        are not displayed.

        Unlike the elements of **QScatterSeries**  the light markers are not
        represented by **QGraphicsItem** , but are just painted (no objects
        created). However, the mouse-event-signals of **QXYSeries**  behave the
        same way, meaning that you'll get the exact domain value of the point if
        you click/press/hover the light marker. You'll still get the in between
        domain value if you click on the line. The light markers are above the
        line in terms of painting as well as events.

        This function was introduced in Qt 6.2.

        **See also** **QXYSeries::lightMarker** ().
        """
        ...

    def setMarkerSize(self, size: float) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setMarkerSize

        **[since 6.2] void QXYSeries::setMarkerSize(qreal size )**

        Sets the **size** of the marker used to render points in the series.

        The default size is 15.0.

        This function was introduced in Qt 6.2.

        **See also** **QScatterSeries::markerSize** .
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setPen

        **[virtual] void QXYSeries::setPen(const QPen & pen )**

        Sets the pen used for drawing points on the chart to **pen**. If the pen
        is not defined, the pen from the chart theme is used.

        **See also** **pen** () and **QChart::setTheme** ().
        """
        ...

    def setPointLabelsClipping(self, enabled: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsClipping-prop

        **pointLabelsClipping : bool**

        This property holds the clipping for data point labels.

        This property is `true` by default. The labels on the edge of the plot
        area are cut when clipping is enabled.

        **Access functions:**

        bool **pointLabelsClipping** () const
        void **setPointLabelsClipping**
        (bool **enabled** = true)

        **Notifier signal:**

        void ****pointLabelsClippingChanged** ** (bool **clipping** )

        **See also** **pointLabelsVisible** .
        """
        ...

    def setPointLabelsColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsColor-prop

        **pointLabelsColor : QColor**

        This property holds the color used for data point labels. By default,
        the color is the color of the brush defined in theme for labels.

        **Access functions:**

        QColor **pointLabelsColor** () const
        void **setPointLabelsColor**
        (const QColor & **color** )

        **Notifier signal:**

        void ****pointLabelsColorChanged** ** (const QColor & **color** )

        **See also** **pointLabelsFormat** .
        """
        ...

    def setPointLabelsFont(
        self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFont-prop

        **pointLabelsFont : QFont**

        This property holds the font used for data point labels.

        **Access functions:**

        QFont **pointLabelsFont** () const
        void **setPointLabelsFont** (const
        QFont & **font** )

        **Notifier signal:**

        void ****pointLabelsFontChanged** ** (const QFont & **font** )

        **See also** **pointLabelsFormat** .
        """
        ...

    def setPointLabelsFormat(self, format: str) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFormat-prop

        **pointLabelsFormat : QString**

        This property holds the format used for showing labels with data points.

        **QXYSeries**  supports the following format tags:

        @xPointThe x-coordinate of the data point.
        @yPointThe y-coordinate of
        the data point.

        For example, the following usage of the format tags would produce labels
        that display the data point shown inside brackets separated by a comma
        (x, y):

        series->setPointLabelsFormat("(@xPoint, @yPoint)");

        By default, the labels' format is set to `@xPoint, @yPoint`. The labels
        are shown on the plot area, and the labels on the edge of the plot area
        are cut. If the points are close to each other, the labels may overlap.

        **Access functions:**

        QString **pointLabelsFormat** () const
        void **setPointLabelsFormat**
        (const QString & **format** )

        **Notifier signal:**

        void ****pointLabelsFormatChanged** ** (const QString & **format** )

        **See also** **pointLabelsVisible** , **pointLabelsFont** , and
        **pointLabelsColor** .
        """
        ...

    def setPointLabelsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsVisible-prop

        **pointLabelsVisible : bool**

        This property holds the visibility of data point labels.

        This property is `false` by default.

        **Access functions:**

        bool **pointLabelsVisible** () const
        void **setPointLabelsVisible**
        (bool **visible** = true)

        **Notifier signal:**

        void ****pointLabelsVisibilityChanged** ** (bool **visible** )

        **See also** **pointLabelsFormat**  and **pointLabelsClipping** .
        """
        ...

    def setPointSelected(self, index: int, selected: bool) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setPointSelected

        **[since 6.2] void QXYSeries::setPointSelected(int index , bool selected
        )**

        Marks point at given **index** as either selected or deselected as
        specified by **selected**.

        **Note:** Selected points are drawn using the selected color if it was
        specified. Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **isPointSelected** (), setPointSelected(), and
        **setSelectedColor** ().
        """
        ...

    def setPointsVisible(self, visible: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointsVisible-prop

        **pointsVisible : bool**

        This property holds whether the data points are visible and should be
        drawn.

        **Access functions:**

        bool **pointsVisible** () const
        void **setPointsVisible** (bool
        **visible** = true)
        """
        ...

    def setSelectedColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#selectedColor-prop

        **[since 6.2] selectedColor : QColor**

        This property holds the color of the selected points.

        This is the fill (brush) color of points marked as selected. If not
        specified, value of **QXYSeries::color**  is used as default.

        This property was introduced in Qt 6.2.

        **Access functions:**

        virtual QColor ****color** ** () const
        void **setSelectedColor**
        (const QColor & **color** )

        **Notifier signal:**

        void **selectedColorChanged** (const QColor & **color** )

        **See also** **color** .

        **Member Function Documentation**
        """
        ...

    def setSelectedLightMarker(
        self, selectedLightMarker: Union[PySide6.QtGui.QImage, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#setSelectedLightMarker

        **[since 6.2] void QXYSeries::setSelectedLightMarker(const QImage &
        selectedLightMarker )**

        Sets the image used for drawing markers on selected series's points to
        **selectedLightMarker**.

        The default value is QImage(), meaning usual **lightMarker** () will be
        painted.

        This is an equivalent for **selectedColor**  if you prefer light markers
        over normal points, but still want to distinguish selected points.

        This function was introduced in Qt 6.2.

        **See also** **selectedLightMarker** (), **lightMarker** (),
        **selectedColor** , and **setPointSelected** ().
        """
        ...

    def sizeBy(
        self, sourceData: Sequence[float], minSize: float, maxSize: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#sizeBy

        **[since 6.2] void QXYSeries::sizeBy(const QList<qreal> & sourceData ,
        const qreal minSize , const qreal maxSize )**

        Sets the points' sizes according to a passed list of values. Values from
        **sourceData** are sorted and mapped to a point size which is between
        **minSize** and **maxSize**.

        **Note:** If **sourceData** length is smaller than number of points in
        the series, then size of the points at the end of the series will stay
        the same.

        This function was introduced in Qt 6.2.

        **See also** **setPointConfiguration** () and **pointConfiguration** ().
        """
        ...

    def toggleSelection(self, indexes: Sequence[int]) -> None:
        """
        https://doc.qt.io/qt-6/qxyseries.html#toggleSelection

        **[since 6.2] void QXYSeries::toggleSelection(const QList<int> & indexes
        )**

        Changes selection state of points at given **indexes** to the opposite
        one. Makes

        **Note:** Emits QXYSeries::selectedPointsChanged

        This function was introduced in Qt 6.2.

        **See also** **setPointSelected** ().
        """
        ...

    @property
    def bestFitLineColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineColorChanged

        **[signal] void QXYSeries::bestFitLineColorChanged(const QColor & color
        )**

        This signal is emitted when the color used for the best fit line changes
        to **color**.

        **Note:** Notifier signal for property **bestFitLineColor** .
        """
        ...

    @property
    def bestFitLineVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#bestFitLineVisibilityChanged

        **[signal] void QXYSeries::bestFitLineVisibilityChanged(bool visible )**

        This signal is emitted when the visibility of the best fit line changes
        to **visible**.

        **Note:** Notifier signal for property **bestFitLineVisible** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#clicked

        **[signal] void QXYSeries::clicked(const QPointF & point )**

        This signal is emitted when the user triggers a mouse event by clicking
        the point **point** in the chart.

        **See also** **pressed** (), **released** (), and **doubleClicked** ().
        """
        ...

    @property
    def colorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#colorChanged

        **[signal] void QXYSeries::colorChanged(QColor color )**

        This signal is emitted when the line (pen) color changes to **color**.

        **Note:** Notifier signal for property **color** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#doubleClicked

        **[signal] void QXYSeries::doubleClicked(const QPointF & point )**

        This signal is emitted when the user double-clicks the data point
        **point** in the chart. The **point** is the point where the first press
        was triggered.

        **See also** **pressed** (), **released** (), and **clicked** ().
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#hovered

        **[signal] void QXYSeries::hovered(const QPointF & point , bool state
        )**

        This signal is emitted when a mouse is hovered over the point **point**
        in the chart. When the mouse moves over the point, **state** turns
        `true`, and when the mouse moves away again, it turns `false`.
        """
        ...

    @property
    def lightMarkerChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#lightMarkerChanged

        **[signal, since 6.2] void QXYSeries::lightMarkerChanged(const QImage &
        lightMarker )**

        This signal is emitted when the light marker image changes to
        **lightMarker**.

        This function was introduced in Qt 6.2.

        **See also** **QXYSeries::setLightMarker** () and **;** .
        """
        ...

    @property
    def markerSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#markerSizeChanged

        **[signal] void QXYSeries::markerSizeChanged(qreal size )**

        This signal is emitted when the marker size changes to **size**.
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#penChanged

        **[signal] void QXYSeries::penChanged(const QPen & pen )**

        This signal is emitted when the pen changes to **pen**.
        """
        ...

    @property
    def pointAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointAdded

        **[signal] void QXYSeries::pointAdded(int index )**

        This signal is emitted when a point is added at the position specified
        by **index**.

        **See also** **append** () and **insert** ().
        """
        ...

    @property
    def pointLabelsClippingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsClippingChanged

        **[signal] void QXYSeries::pointLabelsClippingChanged(bool clipping )**

        This signal is emitted when the clipping of the data point labels
        changes to **clipping**.

        **Note:** Notifier signal for property **pointLabelsClipping** .
        """
        ...

    @property
    def pointLabelsColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsColorChanged

        **[signal] void QXYSeries::pointLabelsColorChanged(const QColor & color
        )**

        This signal is emitted when the color used for data point labels changes
        to **color**.

        **Note:** Notifier signal for property **pointLabelsColor** .
        """
        ...

    @property
    def pointLabelsFontChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFontChanged

        **[signal] void QXYSeries::pointLabelsFontChanged(const QFont & font )**

        This signal is emitted when the font used for data point labels changes
        to **font**.

        **Note:** Notifier signal for property **pointLabelsFont** .
        """
        ...

    @property
    def pointLabelsFormatChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsFormatChanged

        **[signal] void QXYSeries::pointLabelsFormatChanged(const QString &
        format )**

        This signal is emitted when the format of data point labels changes to
        **format**.

        **Note:** Notifier signal for property **pointLabelsFormat** .
        """
        ...

    @property
    def pointLabelsVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointLabelsVisibilityChanged

        **[signal] void QXYSeries::pointLabelsVisibilityChanged(bool visible )**

        This signal is emitted when the visibility of the data point labels
        changes to **visible**.

        **Note:** Notifier signal for property **pointLabelsVisible** .
        """
        ...

    @property
    def pointRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointRemoved

        **[signal] void QXYSeries::pointRemoved(int index )**

        This signal is emitted when a point is removed from the position
        specified by **index**.

        **See also** **remove** ().
        """
        ...

    @property
    def pointReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointReplaced

        **[signal] void QXYSeries::pointReplaced(int index )**

        This signal is emitted when a point is replaced at the position
        specified by **index**.

        **See also** **replace** ().
        """
        ...

    @property
    def pointsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointsRemoved

        **[signal] void QXYSeries::pointsRemoved(int index , int count )**

        This signal is emitted when the number of points specified by **count**
        is removed starting at the position specified by **index**.

        **See also** **removePoints** () and **clear** ().
        """
        ...

    @property
    def pointsReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pointsReplaced

        **[signal] void QXYSeries::pointsReplaced()**

        This signal is emitted when all points are replaced with other points.

        **See also** **replace** ().
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#pressed

        **[signal] void QXYSeries::pressed(const QPointF & point )**

        This signal is emitted when the user presses the data point **point** in
        the chart and holds down the mouse button.

        **See also** **clicked** (), **released** (), and **doubleClicked** ().
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qxyseries.html#released

        **[signal] void QXYSeries::released(const QPointF & point )**

        This signal is emitted when the user releases the mouse press on the
        data point specified by **point**.

        **See also** **pressed** (), **clicked** (), and **doubleClicked** ().
        """
        ...

    @property
    def selectedColorChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
