"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QXYLegendMarker(PySide6.QtCharts.QLegendMarker):
    """
    https://doc.qt.io/qt-6/qxylegendmarker.html

    **Detailed Description**

    An XY legend marker is related to **QXYSeries**  derived classes:
    **QLineSeries** , **QSplineSeries** , and **QScatterSeries** . Each marker
    is related to one series.

    **See also** **QLegend** , **QXYSeries** , **QSplineSeries** ,
    **QScatterSeries** , and **QLineSeries** .
    """

    def __init__(
        self,
        series: PySide6.QtCharts.QXYSeries,
        legend: PySide6.QtCharts.QLegend,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        ...

    def series(self) -> PySide6.QtCharts.QXYSeries:
        """
        https://doc.qt.io/qt-6/qxylegendmarker.html#series

        **[override virtual] QXYSeries *QXYLegendMarker::series()**

        Reimplements: **QLegendMarker::series** ().
        """
        ...

    def type(self) -> PySide6.QtCharts.QLegendMarker.LegendMarkerType:
        """
        https://doc.qt.io/qt-6/qxylegendmarker.html#type

        **[override virtual] QLegendMarker::LegendMarkerType
        QXYLegendMarker::type()**

        Reimplements: **QLegendMarker::type** ().
        """
        ...
