"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QVCandlestickModelMapper(PySide6.QtCharts.QCandlestickModelMapper):
    """
    https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A vertical model
    mapper is used to create a connection between a data model and
    **QCandlestickSeries** , so that each column in the data model defines a
    candlestick item and each row maps to the open, high, low, close, and
    timestamp values of the candlestick item.

    Both model and candlestick series properties can be used to manipulate the
    data. The model mapper keeps the candlestick series and the data model in
    sync.

    The model mapper ensures that all the candlestick items in the candlestick
    series have equal sizes. Therefore, adding or removing a value from a
    candlestick item causes the same change to be made in all the candlestick
    items in the candlestick series.

    **See also** **QCandlestickSeries** , **QCandlestickSet** , and
    **QHCandlestickModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#QVCandlestickModelM
        apper

        **QVCandlestickModelMapper::QVCandlestickModelMapper(QObject * parent =
        nullptr)**

        Constructs a vertical model mapper object which is a child of
        **parent**.
        """
        ...

    def closeRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#closeRow-prop

        **closeRow : int**

        This property holds the row of the model that contains the close values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **closeRow** () const
        void **setCloseRow** (int **closeRow** )

        **Notifier signal:**

        void ****closeRowChanged** ** ()
        """
        ...

    def firstSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#firstSetColumn-prop

        **firstSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstSetColumn** () const
        void **setFirstSetColumn** (int
        **firstSetColumn** )

        **Notifier signal:**

        void ****firstSetColumnChanged** ** ()
        """
        ...

    def highRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#highRow-prop

        **highRow : int**

        This property holds the row of the model that contains the high values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **highRow** () const
        void **setHighRow** (int **highRow** )

        **Notifier signal:**

        void ****highRowChanged** ** ()
        """
        ...

    def lastSetColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lastSetColumn-prop

        **lastSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastSetColumn** () const
        void **setLastSetColumn** (int
        **lastSetColumn** )

        **Notifier signal:**

        void ****lastSetColumnChanged** ** ()
        """
        ...

    def lowRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lowRow-prop

        **lowRow : int**

        This property holds the row of the model that contains the low values of
        the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lowRow** () const
        void **setLowRow** (int **lowRow** )

        **Notifier signal:**

        void ****lowRowChanged** ** ()
        """
        ...

    def openRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#openRow-prop

        **openRow : int**

        This property holds the row of the model that contains the open values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **openRow** () const
        void **setOpenRow** (int **openRow** )

        **Notifier signal:**

        void ****openRowChanged** ** ()
        """
        ...

    def orientation(self) -> PySide6.QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#orientation

        **[override virtual] Qt::Orientation
        QVCandlestickModelMapper::orientation() const**

        Reimplements: **QCandlestickModelMapper::orientation() const** .

        Returns **Qt::Vertical** . This means that values of the item are read
        from columns.
        """
        ...

    def setCloseRow(self, closeRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#closeRow-prop

        **closeRow : int**

        This property holds the row of the model that contains the close values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **closeRow** () const
        void **setCloseRow** (int **closeRow** )

        **Notifier signal:**

        void ****closeRowChanged** ** ()
        """
        ...

    def setFirstSetColumn(self, firstSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#firstSetColumn-prop

        **firstSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the first item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstSetColumn** () const
        void **setFirstSetColumn** (int
        **firstSetColumn** )

        **Notifier signal:**

        void ****firstSetColumnChanged** ** ()
        """
        ...

    def setHighRow(self, highRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#highRow-prop

        **highRow : int**

        This property holds the row of the model that contains the high values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **highRow** () const
        void **setHighRow** (int **highRow** )

        **Notifier signal:**

        void ****highRowChanged** ** ()
        """
        ...

    def setLastSetColumn(self, lastSetColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lastSetColumn-prop

        **lastSetColumn : int**

        This property holds the column of the model that is used as the data
        source for the last item.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastSetColumn** () const
        void **setLastSetColumn** (int
        **lastSetColumn** )

        **Notifier signal:**

        void ****lastSetColumnChanged** ** ()
        """
        ...

    def setLowRow(self, lowRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lowRow-prop

        **lowRow : int**

        This property holds the row of the model that contains the low values of
        the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lowRow** () const
        void **setLowRow** (int **lowRow** )

        **Notifier signal:**

        void ****lowRowChanged** ** ()
        """
        ...

    def setOpenRow(self, openRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#openRow-prop

        **openRow : int**

        This property holds the row of the model that contains the open values
        of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **openRow** () const
        void **setOpenRow** (int **openRow** )

        **Notifier signal:**

        void ****openRowChanged** ** ()
        """
        ...

    def setTimestampRow(self, timestampRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#timestampRow-prop

        **timestampRow : int**

        This property holds the row of the model that contains the timestamp
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **timestampRow** () const
        void **setTimestampRow** (int
        **timestampRow** )

        **Notifier signal:**

        void ****timestampRowChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def timestampRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#timestampRow-prop

        **timestampRow : int**

        This property holds the row of the model that contains the timestamp
        values of the candlestick items in the series.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **timestampRow** () const
        void **setTimestampRow** (int
        **timestampRow** )

        **Notifier signal:**

        void ****timestampRowChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def closeRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#closeRowChanged

        **[signal] void QVCandlestickModelMapper::closeRowChanged()**

        Emitted when the row of the model that contains close values is changed.

        **Note:** Notifier signal for property **closeRow** .

        **See also** **closeRow** .
        """
        ...

    @property
    def firstSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#firstSetColumnChang
        ed

        **[signal] void QVCandlestickModelMapper::firstSetColumnChanged()**

        Emitted when the column of the model that contains the data of the first
        item is changed.

        **Note:** Notifier signal for property **firstSetColumn** .

        **See also** **firstSetColumn** .
        """
        ...

    @property
    def highRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#highRowChanged

        **[signal] void QVCandlestickModelMapper::highRowChanged()**

        Emitted when the row of the model that contains high values is changed.

        **Note:** Notifier signal for property **highRow** .

        **See also** **highRow** .
        """
        ...

    @property
    def lastSetColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lastSetColumnChange
        d

        **[signal] void QVCandlestickModelMapper::lastSetColumnChanged()**

        Emitted when the column of the model that contains the data of the last
        item is changed.

        **Note:** Notifier signal for property **lastSetColumn** .

        **See also** **lastSetColumn** .
        """
        ...

    @property
    def lowRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#lowRowChanged

        **[signal] void QVCandlestickModelMapper::lowRowChanged()**

        Emitted when the row of the model that contains low values is changed.

        **Note:** Notifier signal for property **lowRow** .

        **See also** **lowRow** .
        """
        ...

    @property
    def openRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#openRowChanged

        **[signal] void QVCandlestickModelMapper::openRowChanged()**

        Emitted when the row of the model that contains open values is changed.

        **Note:** Notifier signal for property **openRow** .

        **See also** **openRow** .
        """
        ...

    @property
    def timestampRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qvcandlestickmodelmapper.html#timestampRowChanged

        **[signal] void QVCandlestickModelMapper::timestampRowChanged()**

        Emitted when the row of the model that contains timestamp values is
        changed.

        **Note:** Notifier signal for property **timestampRow** .

        **See also** **timestampRow** .
        """
        ...
