"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QPolarChart(PySide6.QtCharts.QChart):
    """
    https://doc.qt.io/qt-6/qpolarchart.html

    **Detailed Description**

    Polar charts present data in a circular graph, where the placement of data
    is based on the angle and distance from the center of the graph, the
    **pole**.

    ![](images/examples_polarchart.png)

    A polar chart is a specialization of **QChart**  that supports line, spline,
    area, and scatter series, and all axis types supported by them. Each axis
    can be used either as a radial or an angular axis.

    The first and last tick mark on an angular **QValueAxis**  are co-located at
    a 0/360 degree angle.

    If the angular distance between two consecutive points in a series is more
    than 180 degrees, any direct line connecting the two points becomes
    meaningless, and will not be drawn. Instead, a line will be drawn to and
    from the center of the chart. Therefore, the axis ranges must be chosen
    accordingly when displaying line, spline, or area series.

    Polar charts draw all axes of the same orientation in the same position, so
    using multiple axes of the same orientation can be confusing, unless the
    extra axes are only used to customize the grid. For example, you can display
    a highlighted range with a secondary shaded **QCategoryAxis**  or provide
    unlabeled subticks with a secondary **QValueAxis**  thas has hidden labels.

    **See also** **QChart** .
    """

    PolarOrientationRadial: QPolarChart.PolarOrientation = ...
    PolarOrientationAngular: QPolarChart.PolarOrientation = ...

    class PolarOrientation(Enum):
        PolarOrientationRadial: QPolarChart.PolarOrientation = ...
        PolarOrientationAngular: QPolarChart.PolarOrientation = ...

    class PolarOrientations(object):
        ...

    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
        wFlags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolarchart.html#QPolarChart

        **QPolarChart::QPolarChart(QGraphicsItem * parent = nullptr,
        Qt::WindowFlags wFlags = Qt::WindowFlags())**

        Constructs a polar chart as a child of **parent**. The properties
        specified by **wFlags** are passed to the **QChart**  constructor.
        """
        ...

    def addAxis(
        self,
        axis: PySide6.QtCharts.QAbstractAxis,
        polarOrientation: PySide6.QtCharts.QPolarChart.PolarOrientation,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolarchart.html#addAxis

        **void QPolarChart::addAxis(QAbstractAxis * axis ,
        QPolarChart::PolarOrientation polarOrientation )**

        This convenience method adds the axis **axis** to the polar chart with
        the polar orientation **polarOrientation**. The chart takes the
        ownership of the axis.

        **Note:** Axes can be added to a polar chart also with
        **QChart::addAxis** (). The specified alignment determines the polar
        orientation: horizontal alignments indicate an angular axis and vertical
        alignments indicate a radial axis.

        **See also** **QChart::removeAxis** (), **QChart::createDefaultAxes**
        (), **QAbstractSeries::attachAxis** (), and **QChart::addAxis** ().
        """
        ...

    @staticmethod
    def axisPolarOrientation(
        axis: PySide6.QtCharts.QAbstractAxis,
    ) -> PySide6.QtCharts.QPolarChart.PolarOrientation:
        """
        https://doc.qt.io/qt-6/qpolarchart.html#axisPolarOrientation

        **[static] QPolarChart::PolarOrientation
        QPolarChart::axisPolarOrientation(QAbstractAxis * axis )**

        The angular axes of a polar chart report horizontal orientation and the
        radial axes report vertical orientation. This function is a convenience
        function for converting the orientation of the axis **axis** to the
        corresponding polar orientation. If the **axis** is null or not added to
        a polar chart, the return value is meaningless.
        """
        ...
