"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QHorizontalBarSeries(PySide6.QtCharts.QAbstractBarSeries):
    """
    https://doc.qt.io/qt-6/qhorizontalbarseries.html

    **Detailed Description**

    This class draws data as a series of horizontal bars grouped by category,
    with one bar per category from each bar set added to the series.

    See the **horizontal bar chart example**  to learn how to create a
    horizontal bar chart.

    ![](images/examples_horizontalbarchart.png)

    **See also** **QBarSet** , **QBarSeries** , **QPercentBarSeries** ,
    **QAbstractBarSeries** , **QStackedBarSeries** ,
    **QHorizontalStackedBarSeries** , and **QHorizontalPercentBarSeries** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhorizontalbarseries.html#QHorizontalBarSeries

        **QHorizontalBarSeries::QHorizontalBarSeries(QObject * parent =
        nullptr)**

        Constructs an empty horizontal bar series that is a **QObject**  and a
        child of **parent**.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qhorizontalbarseries.html#type

        **[override virtual] QAbstractSeries::SeriesType
        QHorizontalBarSeries::type() const**

        Reimplements an access function for property: **QAbstractSeries::type**
        .

        Returns the horizontal bar series.
        """
        ...
