"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QHBarModelMapper(PySide6.QtCharts.QBarModelMapper):
    """
    https://doc.qt.io/qt-6/qhbarmodelmapper.html

    **Detailed Description**

    Model mappers enable using a data model derived from the
    **QAbstractItemModel**  class as a data source for a chart. A horizontal
    model mapper is used to create a connection between a data model and
    **QAbstractBarSeries** , so that each row in the data model defines a bar
    set and each column maps to a category in a bar series.

    Both model and bar series properties can be used to manipulate the data. The
    model mapper keeps the bar series and the data model in sync.

    The model mapper ensures that all the bar sets in the bar series have equal
    sizes. Therefore, adding or removing a value from a bar set causes the same
    change to be made in all the bar sets in the bar series.

    **See also** **QVBarModelMapper** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#QHBarModelMapper

        **QHBarModelMapper::QHBarModelMapper(QObject * parent = nullptr)**

        Constructs a mapper object that is a child of **parent**.
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for the bar series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int
        **columnCount** )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def firstBarSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstBarSetRow-prop

        **firstBarSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBarSetRow** () const
        void **setFirstBarSetRow** (int
        **firstBarSetRow** )

        **Notifier signal:**

        void ****firstBarSetRowChanged** ** ()
        """
        ...

    def firstColumn(self) -> int:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the first
        values of the bar sets in the bar series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def lastBarSetRow(self) -> int:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#lastBarSetRow-prop

        **lastBarSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBarSetRow** () const
        void **setLastBarSetRow** (int
        **lastBarSetRow** )

        **Notifier signal:**

        void ****lastBarSetRowChanged** ** ()
        """
        ...

    def model(self) -> PySide6.QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        Defines the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def series(self) -> PySide6.QtCharts.QAbstractBarSeries:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#series-prop

        **series : QAbstractBarSeries***

        This property holds the bar series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QAbstractBarSeries * **series** () const
        void **setSeries**
        (QAbstractBarSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    def setColumnCount(self, columnCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#columnCount-prop

        **columnCount : int**

        This property holds the number of columns of the model that are mapped
        as the data for the bar series.

        The minimum and default value is -1 (number limited to the number of
        columns in the model).

        **Access functions:**

        int **columnCount** () const
        void **setColumnCount** (int
        **columnCount** )

        **Notifier signal:**

        void ****columnCountChanged** ** ()
        """
        ...

    def setFirstBarSetRow(self, firstBarSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstBarSetRow-prop

        **firstBarSetRow : int**

        This property holds the row of the model that is used as the data source
        for the first bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **firstBarSetRow** () const
        void **setFirstBarSetRow** (int
        **firstBarSetRow** )

        **Notifier signal:**

        void ****firstBarSetRowChanged** ** ()
        """
        ...

    def setFirstColumn(self, firstColumn: int) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstColumn-prop

        **firstColumn : int**

        This property holds the column of the model that contains the first
        values of the bar sets in the bar series.

        The minimum and default value is 0.

        **Access functions:**

        int **firstColumn** () const
        void **setFirstColumn** (int
        **firstColumn** )

        **Notifier signal:**

        void ****firstColumnChanged** ** ()
        """
        ...

    def setLastBarSetRow(self, lastBarSetRow: int) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#lastBarSetRow-prop

        **lastBarSetRow : int**

        This property holds the row of the model that is used as the data source
        for the last bar set.

        The default value is -1 (invalid mapping).

        **Access functions:**

        int **lastBarSetRow** () const
        void **setLastBarSetRow** (int
        **lastBarSetRow** )

        **Notifier signal:**

        void ****lastBarSetRowChanged** ** ()
        """
        ...

    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#model-prop

        **model : QAbstractItemModel***

        Defines the model that is used by the mapper.

        **Access functions:**

        QAbstractItemModel * **model** () const
        void **setModel**
        (QAbstractItemModel * **model** )

        **Notifier signal:**

        void ****modelReplaced** ** ()
        """
        ...

    def setSeries(self, series: PySide6.QtCharts.QAbstractBarSeries) -> None:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#series-prop

        **series : QAbstractBarSeries***

        This property holds the bar series that is used by the mapper.

        All the data in the series is discarded when it is set to the mapper.
        When a new series is specified, the old series is disconnected (but it
        preserves its data).

        **Access functions:**

        QAbstractBarSeries * **series** () const
        void **setSeries**
        (QAbstractBarSeries * **series** )

        **Notifier signal:**

        void ****seriesReplaced** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def columnCountChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#columnCountChanged

        **[signal] void QHBarModelMapper::columnCountChanged()**

        This signal is emitted when the number of columns changes.

        **Note:** Notifier signal for property **columnCount** .
        """
        ...

    @property
    def firstBarSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstBarSetRowChanged

        **[signal] void QHBarModelMapper::firstBarSetRowChanged()**

        This signal is emitted when the first bar set row changes.

        **Note:** Notifier signal for property **firstBarSetRow** .
        """
        ...

    @property
    def firstColumnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#firstColumnChanged

        **[signal] void QHBarModelMapper::firstColumnChanged()**

        This signal is emitted when the first column changes.

        **Note:** Notifier signal for property **firstColumn** .
        """
        ...

    @property
    def lastBarSetRowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#lastBarSetRowChanged

        **[signal] void QHBarModelMapper::lastBarSetRowChanged()**

        This signal is emitted when the last bar set row changes.

        **Note:** Notifier signal for property **lastBarSetRow** .
        """
        ...

    @property
    def modelReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#modelReplaced

        **[signal] void QHBarModelMapper::modelReplaced()**

        This signal is emitted when the model that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **model** .
        """
        ...

    @property
    def seriesReplaced(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qhbarmodelmapper.html#seriesReplaced

        **[signal] void QHBarModelMapper::seriesReplaced()**

        This signal is emitted when the series that the mapper is connected to
        changes.

        **Note:** Notifier signal for property **series** .
        """
        ...
