"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QCandlestickSet(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qcandlestickset.html

    **Detailed Description**

    Five values are needed to create a graphical representation of a candlestick
    item: **open** , **high** , **low** , **close** , and **timestamp**. These
    values can be either passed to a QCandlestickSet constructor or set by using
    **setOpen** (), **setHigh** (), **setLow** (), **setClose** (), and
    **setTimestamp** ().

    **See also** **QCandlestickSeries** .
    """

    @overload
    def __init__(
        self,
        open: float,
        high: float,
        low: float,
        close: float,
        timestamp: float = ...,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#QCandlestickSet

        **QCandlestickSet::QCandlestickSet(qreal timestamp = 0.0, QObject *
        parent = nullptr)**

        Constructs a candlestick item with an optional **timestamp** and a
        **parent**.
        """
        ...

    @overload
    def __init__(
        self, timestamp: float = ..., parent: Optional[PySide6.QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#QCandlestickSet-1

        **QCandlestickSet::QCandlestickSet(qreal open , qreal high , qreal low ,
        qreal close , qreal timestamp = 0.0, QObject * parent = nullptr)**

        Constructs a candlestick item with given ordered values. The values
        **open** , **high** , **low** , and **close** are mandatory. The values
        **timestamp** and **parent** are optional.
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the candlestick item.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def close(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#close-prop

        **close : qreal**

        This property holds the close value of the candlestick item.

        **Access functions:**

        qreal **close** () const
        void **setClose** (qreal **close** )

        **Notifier signal:**

        void ****closeChanged** ** ()
        """
        ...

    def high(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#high-prop

        **high : qreal**

        This property holds the high value of the candlestick item.

        **Access functions:**

        qreal **high** () const
        void **setHigh** (qreal **high** )

        **Notifier signal:**

        void ****highChanged** ** ()
        """
        ...

    def low(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#low-prop

        **low : qreal**

        This property holds the low value of the candlestick item.

        **Access functions:**

        qreal **low** () const
        void **setLow** (qreal **low** )

        **Notifier signal:**

        void ****lowChanged** ** ()
        """
        ...

    def open(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#open-prop

        **open : qreal**

        This property holds the open value of the candlestick item.

        **Access functions:**

        qreal **open** () const
        void **setOpen** (qreal **open** )

        **Notifier signal:**

        void ****openChanged** ** ()
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the candlestick
        item.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the candlestick item.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def setClose(self, close: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#close-prop

        **close : qreal**

        This property holds the close value of the candlestick item.

        **Access functions:**

        qreal **close** () const
        void **setClose** (qreal **close** )

        **Notifier signal:**

        void ****closeChanged** ** ()
        """
        ...

    def setHigh(self, high: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#high-prop

        **high : qreal**

        This property holds the high value of the candlestick item.

        **Access functions:**

        qreal **high** () const
        void **setHigh** (qreal **high** )

        **Notifier signal:**

        void ****highChanged** ** ()
        """
        ...

    def setLow(self, low: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#low-prop

        **low : qreal**

        This property holds the low value of the candlestick item.

        **Access functions:**

        qreal **low** () const
        void **setLow** (qreal **low** )

        **Notifier signal:**

        void ****lowChanged** ** ()
        """
        ...

    def setOpen(self, open: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#open-prop

        **open : qreal**

        This property holds the open value of the candlestick item.

        **Access functions:**

        qreal **open** () const
        void **setOpen** (qreal **open** )

        **Notifier signal:**

        void ****openChanged** ** ()
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the candlestick
        item.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()
        """
        ...

    def setTimestamp(self, timestamp: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#timestamp-prop

        **timestamp : qreal**

        This property holds the timestamp value of the candlestick item.

        **Access functions:**

        qreal **timestamp** () const
        void **setTimestamp** (qreal
        **timestamp** )

        **Notifier signal:**

        void ****timestampChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def timestamp(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#timestamp-prop

        **timestamp : qreal**

        This property holds the timestamp value of the candlestick item.

        **Access functions:**

        qreal **timestamp** () const
        void **setTimestamp** (qreal
        **timestamp** )

        **Notifier signal:**

        void ****timestampChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#brushChanged

        **[signal] void QCandlestickSet::brushChanged()**

        This signal is emitted when the candlestick item brush changes.

        **Note:** Notifier signal for property **brush** .

        **See also** **brush** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#clicked

        **[signal] void QCandlestickSet::clicked()**

        This signal is emitted when the candlestick item is clicked.
        """
        ...

    @property
    def closeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#closeChanged

        **[signal] void QCandlestickSet::closeChanged()**

        This signal is emitted when the candlestick item close value changes.

        **Note:** Notifier signal for property **close** .

        **See also** **close** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#doubleClicked

        **[signal] void QCandlestickSet::doubleClicked()**

        This signal is emitted when the user double-clicks a candlestick item.
        """
        ...

    @property
    def highChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#highChanged

        **[signal] void QCandlestickSet::highChanged()**

        This signal is emitted when the candlestick item high value changes.

        **Note:** Notifier signal for property **high** .

        **See also** **high** .
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#hovered

        **[signal] void QCandlestickSet::hovered(bool status )**

        This signal is emitted when a mouse is hovered over a candlestick item.

        When the mouse moves over the item, **status** turns `true`, and when
        the mouse moves away again, it turns `false`.
        """
        ...

    @property
    def lowChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#lowChanged

        **[signal] void QCandlestickSet::lowChanged()**

        This signal is emitted when the candlestick item low value changes.

        **Note:** Notifier signal for property **low** .

        **See also** **low** .
        """
        ...

    @property
    def openChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#openChanged

        **[signal] void QCandlestickSet::openChanged()**

        This signal is emitted when the candlestick item open value changes.

        **Note:** Notifier signal for property **open** .

        **See also** **open** .
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#penChanged

        **[signal] void QCandlestickSet::penChanged()**

        This signal is emitted when the candlestick item pen changes.

        **Note:** Notifier signal for property **pen** .

        **See also** **pen** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#pressed

        **[signal] void QCandlestickSet::pressed()**

        This signal is emitted when the user clicks the candlestick item and
        holds down the mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#released

        **[signal] void QCandlestickSet::released()**

        This signal is emitted when the user releases the mouse press on the
        candlestick item.
        """
        ...

    @property
    def timestampChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickset.html#timestampChanged

        **[signal] void QCandlestickSet::timestampChanged()**

        This signal is emitted when the candlestick item timestamp changes.

        **Note:** Notifier signal for property **timestamp** .

        **See also** **timestamp** .
        """
        ...
