"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtCharts, except for defaults which are replaced by "...".
"""
from typing import Any, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtCharts

bytes = str


class QCandlestickSeries(PySide6.QtCharts.QAbstractSeries):
    """
    https://doc.qt.io/qt-6/qcandlestickseries.html

    **Detailed Description**

    This class acts as a container for single candlestick items. Each item is
    drawn to its own category when using **QBarCategoryAxis** .
    **QDateTimeAxis**  and **QValueAxis**  can be used as alternatives to
    **QBarCategoryAxis** . In this case, each candlestick item is drawn
    according to its timestamp value.

    **Note:** The timestamps must be unique within a QCandlestickSeries. When
    using **QBarCategoryAxis** , only the first one of the candlestick items
    sharing a timestamp is drawn. If the chart includes multiple instances of
    QCandlestickSeries, items from different series sharing a timestamp are
    drawn to the same category. When using **QValueAxis**  or **QDateTimeAxis**
    , candlestick items sharing a timestamp will overlap each other.

    See the **candlestick chart example**  to learn how to create a candlestick
    chart.

    ![](images/examples_candlestickchart.png)

    **See also** **QCandlestickSet** , **QBarCategoryAxis** , **QDateTimeAxis**
    , and **QValueAxis** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#QCandlestickSeries

        **QCandlestickSeries::QCandlestickSeries(QObject * parent = nullptr)**

        Constructs an empty QCandlestickSeries. The **parent** is optional.
        """
        ...

    @overload
    def append(self, set: PySide6.QtCharts.QCandlestickSet) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#append

        **bool QCandlestickSeries::append(QCandlestickSet * set )**

        Adds a single candlestick item specified by **set** to the series and
        takes ownership of it. If the item is null or it is already in the
        series, it is not appended. Returns `true` if appending succeeded,
        `false` otherwise.
        """
        ...

    @overload
    def append(self, sets: Sequence[PySide6.QtCharts.QCandlestickSet]) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#append-1

        **bool QCandlestickSeries::append(const QList<QCandlestickSet *> & sets
        )**

        Adds a list of candlestick items specified by **sets** to the series and
        takes ownership of it. If any of the items are null, already belong to
        the series, or appear in the list more than once, nothing is appended.
        Returns `true` if all items were appended successfully, `false`
        otherwise.
        """
        ...

    def bodyOutlineVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyOutlineVisible-prop

        **bodyOutlineVisible : bool**

        This property holds the visibility of the candlestick body outline.

        **Access functions:**

        bool **bodyOutlineVisible** () const
        void **setBodyOutlineVisible**
        (bool **bodyOutlineVisible** )

        **Notifier signal:**

        void ****bodyOutlineVisibilityChanged** ** ()
        """
        ...

    def bodyWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyWidth-prop

        **bodyWidth : qreal**

        This property holds the relative width of the candlestick item within
        its own slot, in the range from 0.0 to 1.0.

        Values outside this range are clamped to 0.0 or 1.0.

        **Access functions:**

        qreal **bodyWidth** () const
        void **setBodyWidth** (qreal
        **bodyWidth** )

        **Notifier signal:**

        void ****bodyWidthChanged** ** ()
        """
        ...

    def brush(self) -> PySide6.QtGui.QBrush:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the candlestick items.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def capsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsVisible-prop

        **capsVisible : bool**

        This property holds the visibility of the caps.

        **Access functions:**

        bool **capsVisible** () const
        void **setCapsVisible** (bool
        **capsVisible** )

        **Notifier signal:**

        void ****capsVisibilityChanged** ** ()
        """
        ...

    def capsWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsWidth-prop

        **capsWidth : qreal**

        This property holds the relative width of the caps within a candlestick,
        in the range from 0.0 to 1.0.

        Values outside this range are clamped to 0.0 or 1.0.

        **Access functions:**

        qreal **capsWidth** () const
        void **setCapsWidth** (qreal
        **capsWidth** )

        **Notifier signal:**

        void ****capsWidthChanged** ** ()
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#clear

        **void QCandlestickSeries::clear()**

        Removes all candlestick items from the series and permanently deletes
        them.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#count

        **int QCandlestickSeries::count() const**

        Returns the number of the candlestick items in the series.

        **Note:** Getter function for property count.
        """
        ...

    def decreasingColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#decreasingColor-prop

        **decreasingColor : QColor**

        This property holds the color of the decreasing candlestick item body.

        A candlestick is **decreasing** when its open value is higher than the
        close value. By default, this property is set to the brush color with
        the alpha channel set to 128. The default color is used also when the
        property is set to an invalid color value.

        **Access functions:**

        QColor **decreasingColor** () const
        void **setDecreasingColor** (const
        QColor & **decreasingColor** )

        **Notifier signal:**

        void ****decreasingColorChanged** ** ()
        """
        ...

    def increasingColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#increasingColor-prop

        **increasingColor : QColor**

        This property holds the color of the increasing candlestick item body.

        A candlestick is **increasing** when its close value is higher than the
        open value. By default, this property is set to the brush color. The
        default color is used also when the property is set to an invalid color
        value.

        **Access functions:**

        QColor **increasingColor** () const
        void **setIncreasingColor** (const
        QColor & **increasingColor** )

        **Notifier signal:**

        void ****increasingColorChanged** ** ()
        """
        ...

    def insert(self, index: int, set: PySide6.QtCharts.QCandlestickSet) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#insert

        **bool QCandlestickSeries::insert(int index , QCandlestickSet * set )**

        Inserts the candlestick item specified by **set** to the series at the
        position specified by **index**. Takes ownership of the item. If the
        item is null or already belongs to the series, it is not inserted.
        Returns `true` if inserting succeeded, `false` otherwise.
        """
        ...

    def maximumColumnWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#maximumColumnWidth-prop

        **maximumColumnWidth : qreal**

        This property holds the maximum width of the candlestick items in
        pixels. Setting a negative value means there is no maximum width. All
        negative values are converted to -1.0.

        **Access functions:**

        qreal **maximumColumnWidth** () const
        void **setMaximumColumnWidth**
        (qreal **maximumColumnWidth** )

        **Notifier signal:**

        void ****maximumColumnWidthChanged** ** ()
        """
        ...

    def minimumColumnWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#minimumColumnWidth-prop

        **minimumColumnWidth : qreal**

        This property holds the minimum width of the candlestick items in
        pixels. Setting a negative value means there is no minimum width. All
        negative values are converted to -1.0.

        **Access functions:**

        qreal **minimumColumnWidth** () const
        void **setMinimumColumnWidth**
        (qreal **minimumColumnWidth** )

        **Notifier signal:**

        void ****minimumColumnWidthChanged** ** ()
        """
        ...

    def pen(self) -> PySide6.QtGui.QPen:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the candlestick
        items.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()

        **Member Function Documentation**
        """
        ...

    @overload
    def remove(self, set: PySide6.QtCharts.QCandlestickSet) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#remove

        **bool QCandlestickSeries::remove(QCandlestickSet * set )**

        Removes a single candlestick item, specified by **set** , from the
        series. Returns `true` if the item is successfully deleted, `false`
        otherwise.
        """
        ...

    @overload
    def remove(self, sets: Sequence[PySide6.QtCharts.QCandlestickSet]) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#remove-1

        **bool QCandlestickSeries::remove(const QList<QCandlestickSet *> & sets
        )**

        Removes a list of candlestick items specified by **sets** from the
        series. If any of the items are null, were already removed from the
        series, or appear in the list more than once, nothing is removed.
        Returns `true` if all items were removed successfully, `false`
        otherwise.
        """
        ...

    def setBodyOutlineVisible(self, bodyOutlineVisible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyOutlineVisible-prop

        **bodyOutlineVisible : bool**

        This property holds the visibility of the candlestick body outline.

        **Access functions:**

        bool **bodyOutlineVisible** () const
        void **setBodyOutlineVisible**
        (bool **bodyOutlineVisible** )

        **Notifier signal:**

        void ****bodyOutlineVisibilityChanged** ** ()
        """
        ...

    def setBodyWidth(self, bodyWidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyWidth-prop

        **bodyWidth : qreal**

        This property holds the relative width of the candlestick item within
        its own slot, in the range from 0.0 to 1.0.

        Values outside this range are clamped to 0.0 or 1.0.

        **Access functions:**

        qreal **bodyWidth** () const
        void **setBodyWidth** (qreal
        **bodyWidth** )

        **Notifier signal:**

        void ****bodyWidthChanged** ** ()
        """
        ...

    def setBrush(
        self,
        brush: Union[
            PySide6.QtGui.QBrush,
            PySide6.QtCore.Qt.BrushStyle,
            PySide6.QtCore.Qt.GlobalColor,
            PySide6.QtGui.QColor,
            PySide6.QtGui.QGradient,
            PySide6.QtGui.QImage,
            PySide6.QtGui.QPixmap,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#brush-prop

        **brush : QBrush**

        This property holds the brush used to fill the candlestick items.

        **Access functions:**

        QBrush **brush** () const
        void **setBrush** (const QBrush & **brush**
        )

        **Notifier signal:**

        void ****brushChanged** ** ()
        """
        ...

    def setCapsVisible(self, capsVisible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsVisible-prop

        **capsVisible : bool**

        This property holds the visibility of the caps.

        **Access functions:**

        bool **capsVisible** () const
        void **setCapsVisible** (bool
        **capsVisible** )

        **Notifier signal:**

        void ****capsVisibilityChanged** ** ()
        """
        ...

    def setCapsWidth(self, capsWidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsWidth-prop

        **capsWidth : qreal**

        This property holds the relative width of the caps within a candlestick,
        in the range from 0.0 to 1.0.

        Values outside this range are clamped to 0.0 or 1.0.

        **Access functions:**

        qreal **capsWidth** () const
        void **setCapsWidth** (qreal
        **capsWidth** )

        **Notifier signal:**

        void ****capsWidthChanged** ** ()
        """
        ...

    def setDecreasingColor(
        self,
        decreasingColor: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#decreasingColor-prop

        **decreasingColor : QColor**

        This property holds the color of the decreasing candlestick item body.

        A candlestick is **decreasing** when its open value is higher than the
        close value. By default, this property is set to the brush color with
        the alpha channel set to 128. The default color is used also when the
        property is set to an invalid color value.

        **Access functions:**

        QColor **decreasingColor** () const
        void **setDecreasingColor** (const
        QColor & **decreasingColor** )

        **Notifier signal:**

        void ****decreasingColorChanged** ** ()
        """
        ...

    def setIncreasingColor(
        self,
        increasingColor: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#increasingColor-prop

        **increasingColor : QColor**

        This property holds the color of the increasing candlestick item body.

        A candlestick is **increasing** when its close value is higher than the
        open value. By default, this property is set to the brush color. The
        default color is used also when the property is set to an invalid color
        value.

        **Access functions:**

        QColor **increasingColor** () const
        void **setIncreasingColor** (const
        QColor & **increasingColor** )

        **Notifier signal:**

        void ****increasingColorChanged** ** ()
        """
        ...

    def setMaximumColumnWidth(self, maximumColumnWidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#maximumColumnWidth-prop

        **maximumColumnWidth : qreal**

        This property holds the maximum width of the candlestick items in
        pixels. Setting a negative value means there is no maximum width. All
        negative values are converted to -1.0.

        **Access functions:**

        qreal **maximumColumnWidth** () const
        void **setMaximumColumnWidth**
        (qreal **maximumColumnWidth** )

        **Notifier signal:**

        void ****maximumColumnWidthChanged** ** ()
        """
        ...

    def setMinimumColumnWidth(self, minimumColumnWidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#minimumColumnWidth-prop

        **minimumColumnWidth : qreal**

        This property holds the minimum width of the candlestick items in
        pixels. Setting a negative value means there is no minimum width. All
        negative values are converted to -1.0.

        **Access functions:**

        qreal **minimumColumnWidth** () const
        void **setMinimumColumnWidth**
        (qreal **minimumColumnWidth** )

        **Notifier signal:**

        void ****minimumColumnWidthChanged** ** ()
        """
        ...

    def setPen(
        self,
        pen: Union[
            PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#pen-prop

        **pen : QPen**

        This property holds the pen used to draw the lines of the candlestick
        items.

        **Access functions:**

        QPen **pen** () const
        void **setPen** (const QPen & **pen** )

        **Notifier signal:**

        void ****penChanged** ** ()

        **Member Function Documentation**
        """
        ...

    def sets(self) -> List[PySide6.QtCharts.QCandlestickSet]:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#sets

        **QList<QCandlestickSet *> QCandlestickSeries::sets() const**

        Returns the list of candlestick items in the series. Ownership of the
        items does not change.
        """
        ...

    def take(self, set: PySide6.QtCharts.QCandlestickSet) -> bool:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#take

        **bool QCandlestickSeries::take(QCandlestickSet * set )**

        Takes a single candlestick item, specified by **set** , from the series.
        Does not delete the item. Returns `true` if the take operation was
        successful, `false` otherwise.

        **Note:** The series remains the item's parent object. You must set the
        parent object to take full ownership.
        """
        ...

    def type(self) -> PySide6.QtCharts.QAbstractSeries.SeriesType:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#type

        **[override virtual] QAbstractSeries::SeriesType
        QCandlestickSeries::type() const**

        Reimplements an access function for property: **QAbstractSeries::type**
        .

        Returns the type of the series
        (**QAbstractSeries::SeriesTypeCandlestick** ).
        """
        ...

    @property
    def bodyOutlineVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyOutlineVisibilityChan
        ged

        **[signal] void QCandlestickSeries::bodyOutlineVisibilityChanged()**

        This signal is emitted when the visibility of the candlestick item body
        outline changes.

        **Note:** Notifier signal for property **bodyOutlineVisible** .

        **See also** **bodyOutlineVisible** .
        """
        ...

    @property
    def bodyWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#bodyWidthChanged

        **[signal] void QCandlestickSeries::bodyWidthChanged()**

        This signal is emitted when the candlestick item width changes.

        **Note:** Notifier signal for property **bodyWidth** .

        **See also** **bodyWidth** .
        """
        ...

    @property
    def brushChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#brushChanged

        **[signal] void QCandlestickSeries::brushChanged()**

        This signal is emitted when the candlestick item brush changes.

        **Note:** Notifier signal for property **brush** .

        **See also** **brush** .
        """
        ...

    @property
    def candlestickSetsAdded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#candlestickSetsAdded

        **[signal] void QCandlestickSeries::candlestickSetsAdded(const
        QList<QCandlestickSet *> & sets )**

        This signal is emitted when the candlestick items specified by **sets**
        are added to the series.
        """
        ...

    @property
    def candlestickSetsRemoved(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#candlestickSetsRemoved

        **[signal] void QCandlestickSeries::candlestickSetsRemoved(const
        QList<QCandlestickSet *> & sets )**

        This signal is emitted when the candlestick items specified by **sets**
        are removed from the series.
        """
        ...

    @property
    def capsVisibilityChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsVisibilityChanged

        **[signal] void QCandlestickSeries::capsVisibilityChanged()**

        This signal is emitted when the visibility of the candlestick item caps
        changes.

        **Note:** Notifier signal for property **capsVisible** .

        **See also** **capsVisible** .
        """
        ...

    @property
    def capsWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#capsWidthChanged

        **[signal] void QCandlestickSeries::capsWidthChanged()**

        This signal is emitted when the candlestick item caps width changes.

        **Note:** Notifier signal for property **capsWidth** .

        **See also** **capsWidth** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#clicked

        **[signal] void QCandlestickSeries::clicked(QCandlestickSet * set )**

        This signal is emitted when the candlestick item specified by **set** is
        clicked on the chart.
        """
        ...

    @property
    def countChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#countChanged

        **[signal] void QCandlestickSeries::countChanged()**

        This signal is emitted when the number of candlestick items in the
        series changes.

        **Note:** Notifier signal for property **count** .

        **See also** **count** .
        """
        ...

    @property
    def decreasingColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#decreasingColorChanged

        **[signal] void QCandlestickSeries::decreasingColorChanged()**

        This signal is emitted when the candlestick item decreasing color
        changes.

        **Note:** Notifier signal for property **decreasingColor** .

        **See also** **decreasingColor** .
        """
        ...

    @property
    def doubleClicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#doubleClicked

        **[signal] void QCandlestickSeries::doubleClicked(QCandlestickSet * set
        )**

        This signal is emitted when the candlestick item specified by **set** is
        double-clicked on the chart.
        """
        ...

    @property
    def hovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#hovered

        **[signal] void QCandlestickSeries::hovered(bool status ,
        QCandlestickSet * set )**

        This signal is emitted when a mouse is hovered over the candlestick item
        specified by **set** in a chart.

        When the mouse moves over the item, **status** turns `true`, and when
        the mouse moves away again, it turns `false`.
        """
        ...

    @property
    def increasingColorChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#increasingColorChanged

        **[signal] void QCandlestickSeries::increasingColorChanged()**

        This signal is emitted when the candlestick item increasing color
        changes.

        **Note:** Notifier signal for property **increasingColor** .

        **See also** **increasingColor** .
        """
        ...

    @property
    def maximumColumnWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#maximumColumnWidthChanged

        **[signal] void QCandlestickSeries::maximumColumnWidthChanged()**

        This signal is emitted when there is a change in the maximum column
        width of candlestick items.

        **Note:** Notifier signal for property **maximumColumnWidth** .

        **See also** **maximumColumnWidth** .
        """
        ...

    @property
    def minimumColumnWidthChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#minimumColumnWidthChanged

        **[signal] void QCandlestickSeries::minimumColumnWidthChanged()**

        This signal is emitted when there is a change in the minimum column
        width of candlestick items.

        **Note:** Notifier signal for property **minimumColumnWidth** .

        **See also** **minimumColumnWidth** .
        """
        ...

    @property
    def penChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#penChanged

        **[signal] void QCandlestickSeries::penChanged()**

        This signal is emitted when the candlestick item pen changes.

        **Note:** Notifier signal for property **pen** .

        **See also** **pen** .
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#pressed

        **[signal] void QCandlestickSeries::pressed(QCandlestickSet * set )**

        This signal is emitted when the user clicks the candlestick item
        specified by **set** and holds down the mouse button.
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qcandlestickseries.html#released

        **[signal] void QCandlestickSeries::released(QCandlestickSet * set )**

        This signal is emitted when the user releases the mouse press on the
        candlestick item specified by **set**.
        """
        ...
