"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtBluetooth, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtBluetooth

bytes = str


class QLowEnergyServiceData(object):
    """
    https://doc.qt.io/qt-6/qlowenergyservicedata.html

    **Detailed Description**

    An Object of this class provides a service to be added to a GATT server via
    **QLowEnergyController::addService** ().
    """

    ServiceTypePrimary: QLowEnergyServiceData.ServiceType = ...
    ServiceTypeSecondary: QLowEnergyServiceData.ServiceType = ...

    class ServiceType(Enum):
        ServiceTypePrimary: QLowEnergyServiceData.ServiceType = ...
        ServiceTypeSecondary: QLowEnergyServiceData.ServiceType = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#QLowEnergyServiceData

        **QLowEnergyServiceData::QLowEnergyServiceData()**

        Creates a new invalid object of this class.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtBluetooth.QLowEnergyServiceData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#QLowEnergyServiceData-
        1

        **QLowEnergyServiceData::QLowEnergyServiceData(const
        QLowEnergyServiceData & other )**

        Constructs a new object of this class that is a copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def addCharacteristic(
        self, characteristic: PySide6.QtBluetooth.QLowEnergyCharacteristicData
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#addCharacteristic

        **void QLowEnergyServiceData::addCharacteristic(const
        QLowEnergyCharacteristicData & characteristic )**

        Adds **characteristic** to the list of characteristics, if it is valid.

        **See also** **setCharacteristics** ().
        """
        ...

    def addIncludedService(
        self, service: PySide6.QtBluetooth.QLowEnergyService
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#addIncludedService

        **void QLowEnergyServiceData::addIncludedService(QLowEnergyService *
        service )**

        Adds **service** to the list of included services. The **service**
        object must have been returned from a call to
        **QLowEnergyController::addService** . This requirement prevents
        circular includes (which are forbidden by the Bluetooth specification),
        and also helps to support the use case of including more than one
        service of the same type.

        **See also** **setIncludedServices** ().
        """
        ...

    def characteristics(self) -> List[PySide6.QtBluetooth.QLowEnergyCharacteristicData]:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#characteristics

        **QList<QLowEnergyCharacteristicData>
        QLowEnergyServiceData::characteristics() const**

        Returns the list of characteristics.

        **See also** **setCharacteristics** ().
        """
        ...

    def includedServices(self) -> List[PySide6.QtBluetooth.QLowEnergyService]:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#includedServices

        **QList<QLowEnergyService *> QLowEnergyServiceData::includedServices()
        const**

        Returns the list of included services.

        **See also** **setIncludedServices** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#isValid

        **bool QLowEnergyServiceData::isValid() const**

        Returns `true` if this service is has a non-null UUID.
        """
        ...

    def setCharacteristics(
        self,
        characteristics: Sequence[PySide6.QtBluetooth.QLowEnergyCharacteristicData],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#setCharacteristics

        **void QLowEnergyServiceData::setCharacteristics(const
        QList<QLowEnergyCharacteristicData> & characteristics )**

        Sets the list of characteristics to **characteristics**. Only valid
        characteristics are considered.

        **See also** **characteristics** () and **addCharacteristic** ().
        """
        ...

    def setIncludedServices(
        self, services: Sequence[PySide6.QtBluetooth.QLowEnergyService]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#setIncludedServices

        **void QLowEnergyServiceData::setIncludedServices(const
        QList<QLowEnergyService *> & services )**

        Sets the list of included services to **services**. All objects in this
        list must have been returned from a call to
        **QLowEnergyController::addService** .

        **See also** **includedServices** () and **addIncludedService** ().
        """
        ...

    def setType(
        self, type: PySide6.QtBluetooth.QLowEnergyServiceData.ServiceType
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#setType

        **void QLowEnergyServiceData::setType(QLowEnergyServiceData::ServiceType
        type )**

        Sets the type of this service to **type**.

        **See also** **type** ().
        """
        ...

    def setUuid(
        self,
        uuid: Union[
            PySide6.QtBluetooth.QBluetoothUuid.CharacteristicType,
            PySide6.QtBluetooth.QBluetoothUuid.DescriptorType,
            PySide6.QtBluetooth.QBluetoothUuid.ProtocolUuid,
            PySide6.QtBluetooth.QBluetoothUuid.ServiceClassUuid,
            PySide6.QtCore.QUuid,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#setUuid

        **void QLowEnergyServiceData::setUuid(const QBluetoothUuid & uuid )**

        Sets the UUID of this service to **uuid**.

        **See also** **uuid** ().
        """
        ...

    def swap(self, other: PySide6.QtBluetooth.QLowEnergyServiceData) -> None:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#swap

        **void QLowEnergyServiceData::swap(QLowEnergyServiceData & other )**

        Swaps this object with **other**.
        """
        ...

    def type(self) -> PySide6.QtBluetooth.QLowEnergyServiceData.ServiceType:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#type

        **QLowEnergyServiceData::ServiceType QLowEnergyServiceData::type()
        const**

        Returns the type of this service.

        **See also** **setType** ().
        """
        ...

    def uuid(self) -> PySide6.QtBluetooth.QBluetoothUuid:
        """
        https://doc.qt.io/qt-6/qlowenergyservicedata.html#uuid

        **QBluetoothUuid QLowEnergyServiceData::uuid() const**

        Returns the UUID of this service.

        **See also** **setUuid** ().
        """
        ...
