"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtAxContainer, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Sequence, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtAxContainer

bytes = str


class QAxScript(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaxscript.html

    **Detailed Description**

    Every instance of the QAxScript class represents a piece of scripting code
    in a particular scripting language. The code is loaded into the script
    engine using **load** (). Functions declared in the code can be called using
    **call** ().

    The script provides **scriptEngine** () provides feedback to the application
    through signals. The most important signal is the **error** () signal.
    Direct access to the **QAxScriptEngine**  is provided through the
    **scriptEngine** () function.

    **Warning:** This class is not available with the bcc5.5 compiler.

    **See also** **QAxScriptEngine** , **QAxScriptManager** , **QAxBase** , and
    **ActiveQt Framework** .
    """

    FunctionNames: QAxScript.FunctionFlags = ...
    FunctionSignatures: QAxScript.FunctionFlags = ...

    class FunctionFlags(Enum):
        FunctionNames: QAxScript.FunctionFlags = ...
        FunctionSignatures: QAxScript.FunctionFlags = ...

    def __init__(
        self, name: str, manager: PySide6.QtAxContainer.QAxScriptManager
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaxscript.html#QAxScript

        **QAxScript::QAxScript(const QString & name , QAxScriptManager * manager
        )**

        Constructs a QAxScript object called **name** and registers it with the
        **QAxScriptManager**  **manager**. This is usually done by the
        **QAxScriptManager**  class when **loading a script** .

        A script should always have a name. A manager is necessary to allow the
        script code to reference objects in the application. The **manager**
        takes ownership of the object.
        """
        ...

    @overload
    def call(self, function: str, arguments: Sequence[Any]) -> Any:
        """
        https://doc.qt.io/qt-6/qaxscript.html#call

        **QVariant QAxScript::call(const QString & function , const QVariant &
        var1 = QVariant(), const QVariant & var2 = QVariant(), const QVariant &
        var3 = QVariant(), const QVariant & var4 = QVariant(), const QVariant &
        var5 = QVariant(), const QVariant & var6 = QVariant(), const QVariant &
        var7 = QVariant(), const QVariant & var8 = QVariant())**

        Calls **function** , passing the parameters **var1** , **var1** ,
        **var2** , **var3** , **var4** , **var5** , **var6** , **var7** and
        **var8** as arguments and returns the value returned by the function, or
        an invalid **QVariant**  if the function does not return a value or when
        the function call failed.

        See **QAxScriptManager::call** () for more information about how to call
        script functions.
        """
        ...

    @overload
    def call(
        self,
        function: str,
        v1: Any = ...,
        v2: Any = ...,
        v3: Any = ...,
        v4: Any = ...,
        v5: Any = ...,
        v6: Any = ...,
        v7: Any = ...,
        v8: Any = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qaxscript.html#call-1

        **QVariant QAxScript::call(const QString & function , QList<QVariant> &
        arguments )**

        This is an overloaded function.

        Calls **function** passing **arguments** as parameters, and returns the
        result. Returns when the script's execution has finished.

        See **QAxScriptManager::call** () for more information about how to call
        script functions.
        """
        ...

    def functions(
        self, arg__1: PySide6.QtAxContainer.QAxScript.FunctionFlags = ...
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaxscript.html#functions

        **QStringList QAxScript::functions(QAxScript::FunctionFlags flags =
        FunctionNames) const**

        Returns a list of all the functions in this script if the respective
        script engine supports introspection; otherwise returns an empty list.
        The functions are either provided with full prototypes or only as names,
        depending on the value of **flags**.

        **See also** **QAxScriptEngine::hasIntrospection** ().
        """
        ...

    def load(self, code: str, language: str = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qaxscript.html#load

        **bool QAxScript::load(const QString & code , const QString & language =
        QString())**

        Loads the script source **code** written in language **language** into
        the script engine. Returns true if **code** was successfully entered
        into the script engine; otherwise returns false.

        If **language** is empty (the default) it will be determined
        heuristically. If **code** contains the string `End Sub` it will be
        interpreted as VBScript, otherwise as JScript. Additional scripting
        languages can be registered using **QAxScriptManager::registerEngine**
        ().

        This function can only be called once for each **QAxScript**  object,
        which is done automatically when using **QAxScriptManager::load** ().
        """
        ...

    def scriptCode(self) -> str:
        """
        https://doc.qt.io/qt-6/qaxscript.html#scriptCode

        **QString QAxScript::scriptCode() const**

        Returns the script's code, or the null-string if no code has been loaded
        yet.

        **See also** **load** ().
        """
        ...

    def scriptEngine(self) -> PySide6.QtAxContainer.QAxScriptEngine:
        """
        https://doc.qt.io/qt-6/qaxscript.html#scriptEngine

        **QAxScriptEngine *QAxScript::scriptEngine() const**

        Returns a pointer to the script engine.

        You can use the object returned to connect signals to the script
        functions, or to access the script engine directly.
        """
        ...

    def scriptName(self) -> str:
        """
        https://doc.qt.io/qt-6/qaxscript.html#scriptName

        **QString QAxScript::scriptName() const**

        Returns the name of the script.
        """
        ...

    @property
    def entered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#entered

        **[signal] void QAxScript::entered()**

        This signal is emitted when a script engine has started executing code.
        """
        ...

    @property
    def error(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#error

        **[signal] void QAxScript::error(int code , const QString & description
        , int sourcePosition , const QString & sourceText )**

        This signal is emitted when an execution error occurred while running a
        script.

        **code** , **description** , **sourcePosition** and **sourceText**
        contain information about the execution error.
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#finished

        **[signal] void QAxScript::finished()**

        This signal is emitted when a script engine has finished executing code.

        **Note:** Signal **finished** is overloaded in this class. To connect to
        this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(axScript, QOverload<>::of(&**QAxScript** ::finished),
        [=](){ /* ... */ });
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#finished-1

        **[signal] void QAxScript::finished(const QVariant & result )**

        This is an overloaded function.

        **result** contains the script's result. This will be an invalid
        **QVariant**  if the script has no return value.

        **Note:** Signal **finished** is overloaded in this class. To connect to
        this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(axScript, QOverload<const **QVariant**  &>::of(&**QAxScript**
        ::finished),
                [=](const **QVariant**  &result){ /* ... */ });
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#finished-2

        **[signal] void QAxScript::finished(int code , const QString & source ,
        const QString & description , const QString & help )**

        This is an overloaded function.

        **code** , **source** , **description** and **help** contain exception
        information when the script terminated.

        **Note:** Signal **finished** is overloaded in this class. To connect to
        this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(axScript, QOverload<int, const **QString**  &, const **QString**
        &, const **QString**  &>::of(&**QAxScript** ::finished),
                [=](int
        code, const **QString**  &source, const **QString**  &description, const
        **QString**  &help){ /* ... */ });
        """
        ...

    @property
    def stateChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qaxscript.html#stateChanged

        **[signal] void QAxScript::stateChanged(int state )**

        This signal is emitted when a script engine changes state. **state** can
        be any value in the `QAxScriptEngine::State` enumeration.
        """
        ...
