# Examples 

### Calculation of CFI and QFI
The example is discussed in [Example 3.1](./guide/guide_bounds.md#example3_1) 
and [Example 3.4](./guide/guide_bounds.md#example3_4) in quantum metrological tools.  
[CramerRao_bounds.ipynb](examples/Python examples/CramerRao_bounds.ipynb)  
[CramerRao_bounds.jl](examples/Julia examples/CramerRao_bounds.jl) 

### Calculation of CFIM, QFIM, HCRB and NHB
The example is discussed in detail in [Example 3.7](./guide/guide_bounds.md#example3_7) 
in quantum metrological tools.  
[HCRB_NHB.ipynb](examples/Python examples/HCRB_NHB.ipynb)  
[HCRB_NHB.jl](examples/Julia examples/HCRB_NHB.jl)  

### Calculation of Bayesian Cramér-Rao bounds
The example is discussed in detail in [Example 3.8](./guide/guide_bounds.md#example3_8) 
in quantum metrological tools.  
[Bayesian_CramerRao_bounds.ipynb](examples/Python examples/Bayesian_CramerRao_bounds.ipynb)  
[Bayesian_CramerRao_bounds.jl](examples/Julia examples/Bayesian_CramerRao_bounds.jl)  

### Bayesian estimation
The example is discussed in detail in [Example 3.9](./guide/guide_bounds.md#example3_9) 
in quantum metrological tools.   
[Bayesian_estimation.ipynb](examples/Python examples/Bayesian_estimation.ipynb)  
[Bayesian_estimation.jl](examples/Julia examples/Bayesian_estimation.jl)  

### Control optimization in single qubit system (single parameter)
The example is discussed in detail in [Example 5.1](./guide/guide_bounds.md#example5_1) 
in control optimization.  
[control_optimization_NV.ipynb](examples/Python examples/control_optimization_NV.ipynb)  
[control_optimization_NV.jl](examples/Julia examples/control_optimization_NV.jl)  

### Control optimization in NV center (multiparameter) 
The example is discussed in detail in [Example 5.2](./guide/guide_bounds.md#example5_2) 
in control optimization.  
[control_optimization_qubit.ipynb](examples/Python examples/control_optimization_qubit.ipynb)  
[control_optimization_qubit.jl](examples/Julia examples/control_optimization_qubit.jl)  
 
### State optimization in LMG model (single parameter) 
The example is discussed in detail in [Example 6.1](./guide/guide_bounds.md#example6_1) 
in state optimization.  
[state_optimization_LMG1.ipynb](examples/Python examples/state_optimization_LMG1.ipynb)  
[state_optimization_LMG1.jl](examples/Julia examples/state_optimization_LMG1.jl)  

### State optimization in LMG model (multiparameter) 
The example is discussed in detail in [Example 6.2](./guide/guide_bounds.md#example6_2) 
in state optimization.  
[state_optimization_LMG2.ipynb](examples/Python examples/state_optimization_LMG2.ipynb)  
[state_optimization_LMG2.jl](examples/Julia examples/state_optimization_LMG2.jl) 

### Measurement optimization in single qubit system (single parameter) 
The example is discussed in detail in [Example 7.2](./guide/guide_bounds.md#example7_2) 
in measurement optimization.  
[measurement_optimization_qubit.ipynb](examples/Python examples/measurement_optimization_qubit.ipynb)  
[measurement_optimization_qubit.jl](examples/Julia examples/measurement_optimization_projection_qubit.jl)  

### Measurement optimization in NV center (multiparameter) 
The example is discussed in detail in [Example 7.3](./guide/guide_bounds.md#example7_3) 
in measurement optimization.  
[measurement_optimization_NV.ipynb](examples/Python examples/measurement_optimization_NV.ipynb)  
[measurement_optimization_NV.jl](examples/Julia examples/measurement_optimization_projection_NV.jl)  

### Comprehensive optimization in single qubit system (single parameter) 
The example is discussed in detail in [Example 8.1](./guide/guide_bounds.md#example8_1) 
in comprehensive optimization.  
[comprehensive_optimization_qubit.ipynb](examples/Python examples/comprehensive_optimization_qubit.ipynb)  
[comprehensive_optimization_qubit.jl](examples/Julia examples/SCMopt_qubit.jl) 


### Comprehensive optimization in NV center (multiparameter) 
The example is discussed in detail in [Example 8.2](./guide/guide_bounds.md#example8_2) 
in comprehensive optimization.  
[comprehensive_optimization_NV.ipynb](examples/Python examples/comprehensive_optimization_NV.ipynb)  
[comprehensive_optimization_NV.jl](examples/Julia examples/SCMopt_NV.jl)

---
