# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyzscaler', 'pyzscaler.cspm', 'pyzscaler.zia', 'pyzscaler.zpa']

package_data = \
{'': ['*']}

install_requires = \
['python-box>=5.3.0,<6.0.0', 'restfly>=1.4.0,<2.0.0']

setup_kwargs = {
    'name': 'pyzscaler',
    'version': '0.2.3',
    'description': 'A python SDK for Zscaler.',
    'long_description': 'pyZscaler is an unofficial SDK for interacting with Zscaler APIs\n=====================================================================\npyZscaler aims to provide a uniform and easy-to-use interface for each of the Zscaler product APIs.\n\n\n.. attention:: This SDK is not affiliated with, nor supported by Zscaler in any way.\n\n   :strong:`Caveats`\n\n   - Not all features may be implemented.\n   - Implemented features may be buggy or incorrect.\n   - Bugs will be fixed in my own time.\n\nOverview\n==========\nWith each Zscaler product having its own developer documentation and authentication methods, this SDK should simplify\nyour ability to develop software that uses the Zscaler API.\n\nThis SDK leverages the very awesome `RESTfly framework <https://restfly.readthedocs.io/en/latest/index.html>`_ developed by Steve McGrath, which simplifies the development of\nbuilding libraries to interact with RESTful APIs. A big thank you to Steve.\n\nFeatures\n----------\n- Simplified authentication with Zscaler APIs.\n- Uniform interaction with all Zscaler APIs.\n- Uses `python-box <https://github.com/cdgriffith/Box/wiki>`_ to add dot notation access to json data structures.\n- Zscaler API output automatically converted from CamelCase to Snake Case.\n\nProducts\n---------\n- Zscaler Private Access (ZPA)\n- Zscaler Internet Access (ZIA)\n- Cloud Security Posture Management (CSPM) - (work in progress)\n\nInstallation\n==============\n\nThe most recent version can be installed from pypi as per below.\n\n.. code-block:: console\n\n    $ pip install pyzscaler\n\nUsage\n========\nBefore you can interact with any of the Zscaler APIs, you may need to generate API keys or retrieve tenancy information\nfor each product that you are interfacing with. Once you have the requirements and you have installed pyZscaler,\nyou\'re ready to go.\n\nGetting started with ZIA\n--------------------------\nFor ZIA, you will need to provide params when instantiating the class or set the environment variables as per the\ntable below:\n\n.. list-table:: ZIA Requirements\n   :header-rows: 1\n\n   * - Param\n     - ENV\n     - Description\n   * - cloud\n     - ``ZIA_CLOUD``\n     - The cloud that your ZIA tenant is provisioned on.\n   * - api_key\n     - ``ZIA_API_KEY``\n     - The API key generated from your ZIA console.\n   * - username\n     - ``ZIA_USERNAME``\n     - The username of your administrator user that will be used for API calls.\n   * - password\n     - ``ZIA_PASSWORD``\n     - The password for the administrator user.\n\n`How to generate the API_KEY <https://help.zscaler.com/zia/api-getting-started#RetrieveAPIKey>`_\n\nHow to determine the ZIA CLOUD\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nYou can find the name of the cloud in the URL that admins use to log into the Zscaler service. E.g.\nif an organisation logs into admin.zscaler.net, then that organization\'s cloud name is zscaler.net. You don\'t\nneed to supply the .net suffix with pyZscaler, so the ``CLOUD`` arg would simply be ``zscaler``.\n\n.. list-table:: ZIA Cloud List\n   :header-rows: 1\n\n   * - URL\n     - CLOUD\n   * - admin.zscaler.net\n     - zscaler\n   * - admin.zscalerone.net\n     - zscalerone\n   * - admin.zscalertwo.net\n     - zscalertwo\n   * - admin.zscalerthree.net\n     - zscalerthree\n   * - admin.zscloud.net\n     - zscloud\n   * - admin.zscalerbeta.net\n     - zscalerbeta\n   * - admin.zscalergov.net\n     - zscalergov\n\n\n.. code-block:: python\n\n    from pyzscaler.zia import ZIA\n    zia = ZIA(api_key=\'API_KEY\', cloud=\'CLOUD\', username=\'USERNAME\', password=\'PASSWORD\')\n    for user in zia.users.list():\n        pprint(user)\n\nGetting started with ZPA\n--------------------------\nFor ZPA, you will need to provide params when instantiating the class or set the environment variables as per the\ntable below:\n\n.. list-table:: ZPA Requirements\n   :header-rows: 1\n\n   * - Param\n     - ENV\n     - Description\n   * - client_id\n     - ``ZPA_CLIENT_ID``\n     - The client ID that is associated with the client secret.\n   * - client_secret\n     - ``ZPA_CLIENT_SECRET``\n     - The client secret that was generated for the client ID.\n   * - customer_id\n     - ``ZPA_CUSTOMER_ID``\n     - The customer ID for the ZPA tenancy.\n\n- `How to generate the CLIENT_ID, CLIENT_SECRET and find the CUSTOMER_ID <https://help.zscaler.com/zpa/about-api-keys>`_\n\n\n.. code-block:: python\n\n    from pyzscaler.zpa import ZPA\n    zpa = ZPA(client_id=\'CLIENT_ID\', client_secret=\'CLIENT_SECRET\', customer_id=\'CUSTOMER_ID\')\n    for app_segment in zpa.app_segments.list():\n        pprint(app_segment)\n\n\nLicense\n=========\nMIT License\n\nCopyright (c) 2021 Mitch Kelly\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.',
    'author': 'Mitch Kelly',
    'author_email': 'me@mkelly.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://mitchos.github.io/pyZscaler/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
