"""
This module serves the same purpose of oldcopanames.py. It catalogs the old naming conventions of UO.

Functionally, though this is a fairly inelegant solution, memory-wise, this is still faster than attempting to match
many entries against compiled regex over and over.
"""


OLD_UO_GOOGLE = {
    'Seoul - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Seoul '}, 'Nagoya - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Tokyo - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Tokyo '}, 'Fukuoka - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Osaka - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Osaka '}, 'Busan - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Busan '}, 'Hiroshima - JP&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Seoul - KR&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Seoul '}, 'Fukuoka - JP&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Tokyo - JP&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Tokyo '}, 'Hiroshima - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Jeju - EN&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Jeju '}, 'Nagoya - JP&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Hong Kong - Brand EN&&Brand modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - Brand EN', 'AdGroupName': 'Brand modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - Brand CN&&Brand modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - Brand CN', 'AdGroupName': 'Brand modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Busan - KR&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Busan '}, 'Osaka - JP&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Brand broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Osaka '}, 'Jeju - KR&&Brand broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Brand broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Jeju '}, 'Busan - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong flights last minute exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong air tickets broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong airfare broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong airline low cost broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong cheap air broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong deals broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong flight book broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong flight book broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong flights broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Busan - KR&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Fukuoka - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong international exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong international exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka - JP&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Guam NGO - EN&&Guam': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam cheap air broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam airfare broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam TAK airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam TAK airport broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam air tickets broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam deals broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam flights broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam travel': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam travel', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Guam NGO - EN&&Guam holiday': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': 'Guam holiday', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hiroshima - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima - JP&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hong Kong - CN&&Busan flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang DAD airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang DAD airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima airline low cost broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima cheap air broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima airfare broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima HIJ airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima HIJ airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima deals broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming international modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya NGO airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya NGO airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Mandalay flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Mandalay flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka KIX airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka KIX airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Osaka flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket HKT airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket HKT airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul ICN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul ICN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Siem Reap flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Siem Reap cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung international modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo HND airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo HND airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo NRT airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo NRT airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi WUX airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi WUX airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo international modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Tokyo flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi cheap air exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi deals exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima HIJ airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima HIJ airport exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Jeju air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Jeju air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Jeju flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Jeju flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Jeju cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Jeju cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima deals broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima airline low cost broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima airfare broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Mandalay cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Mandalay cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Nagoya airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Siem Reap air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Siem Reap deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu TAK airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Takamatsu flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Takamatsu flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Yangon air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Wuxi deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Yangon flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Busan airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Mai deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Rai air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Rai cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Chiang Rai flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam GUM airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam GUM airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien HUN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien HUN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima KOJ airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima KOJ airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kagoshima air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Kunming airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Lanzhou air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Lanzhou cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Lanzhou flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Saipan air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Saipan flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Siem Reap REP airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap REP airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Seoul flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Yangon airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Fukuoka FUK airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka FUK airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Guam deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Jeju CJU airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Jeju CJU airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Saipan SPN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan SPN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Yangon cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Yangon airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Da Nang airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hiroshima airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki ISG airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki ISG airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ishigaki air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Hualien flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Lanzhou airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Lanzhou flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Ningbo cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Phuket air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Saipan airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - CN&&Taichung RMQ airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung RMQ airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan PUS airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan PUS airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan remarketing shopping': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan remarketing shopping', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan remarketing attractions': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan remarketing attractions', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan remarketing travel': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan remarketing travel', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai CNX airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai CNX airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang DAD airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang DAD airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka FUK airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka FUK airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima HIJ airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima cheap air broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima HIJ airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima HIJ airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima airfare broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima deals broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima remarketing attractions': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima remarketing attractions', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima remarketing travel': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima remarketing travel', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju CJU airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju CJU airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming KMG airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming KMG airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay MDL airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay MDL airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya NGO airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya NGO airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo NGB airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo NGB airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka KIX airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka KIX airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flight book exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket HKT airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket HKT airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flight book exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul ICN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul ICN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap REP airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap REP airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung RMQ airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung RMQ airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo HND airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo HND airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - Brand EN&&Brand mega sale': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - Brand EN', 'AdGroupName': 'Brand mega sale', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo NRT airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo NRT airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi WUX airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi WUX airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flight book exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon RGN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon RGN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Busan flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima cheap airline broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima cheap airline broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima flight book broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flight book broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima flights last minute broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights last minute broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki ISG airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki ISG airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ishigaki deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima KOJ airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima KOJ airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima KOJ airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima KOJ airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima KOJ airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima KOJ airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Jeju flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima deals broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima cheap air broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima airfare broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima flights last minute broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights last minute broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kunming deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Mandalay flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Mandalay flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Mandalay', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Ningbo flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Seoul flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flight book exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu TAK airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu TAK airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu airfare broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu TAK airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu cheap air broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu deals broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Takamatsu flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Takamatsu flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Tokyo deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Wuxi deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Wuxi deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai CEI airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai CEI airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam GUM airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam GUM airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien HUN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien HUN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu TAK airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - CN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hualien deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou LHW airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou LHW airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Lanzhou air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu cheap air broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Phuket cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&Takamatsu flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - CN&&Takamatsu flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan SPN airport': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan SPN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Siem Reap international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Da Nang flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Yangon cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Mai flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Chiang Rai cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Fukuoka flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Guam airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Hiroshima airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima airline low cost broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Kagoshima flight book broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flight book broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Nagoya flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Osaka flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights last minute exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Saipan flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&Taichung flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flight book modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Jeju - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong air tickets broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong airfare broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong airline low cost broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong cheap air broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong deals broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong flight book broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong flight book broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Jeju - KR&&Hong Kong flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': 'Hong Kong flights broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Nagoya - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya - JP&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'New_Hong Kong&&Hong Kong Price': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Price', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Booking': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Booking', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Ticket': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Flight': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Cheap': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Cheap', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Sale': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Sale', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hong Kong&&Hong Kong Comparing': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': 'Hong Kong Comparing', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Osaka - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong flights last minute modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong flights last minute exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Takamatsu HK - CN&&Takamatsu': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - CN&&Takamatsu travel': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu travel', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Osaka - JP&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka - JP&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Seoul - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flights last minute modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong flights last minute exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flights last minute exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong air tickets broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong airfare broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong airline low cost broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong airline low cost broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong cheap air broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong deals broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong flight book broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong flight book broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong flights broad', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - KR&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Takamatsu HK - CN&&Takamatsu TAK airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu TAK airport exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Seoul - KR&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Takamatsu HK - EN&&Takamatsu air tickets broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Brand_JP&&Brand Name BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Brand Name BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Brand Name BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Brand Name BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu TAK airport broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu airfare broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu TAK airport exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu TAK airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Fukuoka_JP&&Fukuoka - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Fukuoka_JP', 'AdGroupName': 'Fukuoka - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Brand_JP&&Generic BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Generic BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Generic BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Generic + Departure BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic + Departure BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu cheap air broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu cheap air broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu deals broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu deals broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Hiroshima_JP&&Hiroshima - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hiroshima_JP', 'AdGroupName': 'Hiroshima - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Haneda_JP&&Haneda - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Haneda_JP', 'AdGroupName': 'Haneda - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu flights broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu travel': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu travel', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu HK - EN&&Takamatsu holiday': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': 'Takamatsu holiday', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Tokyo - EN&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong flights last minute modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong flights last minute modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Ishigaki_JP&&Ishigaki - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Ishigaki_JP', 'AdGroupName': 'Ishigaki - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - EN&&Hong Kong cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong deals exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong deals exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Kagoshima_JP&&Kagoshima - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Kagoshima_JP', 'AdGroupName': 'Kagoshima - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - EN&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - EN&&Hong Kong flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': 'Hong Kong flight book exact', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong air tickets modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Brand_EN&&Misspelling BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Misspelling BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Nagoya_JP&&Nagoya - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Nagoya_JP', 'AdGroupName': 'Nagoya - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Nagoya_JP_to_Guam&&Nagoya - Guam BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Nagoya_JP_to_Guam', 'AdGroupName': 'Nagoya - Guam BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Guam', 'GeoTarget': ''}, 'New_Narita_JP&&Narita - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Narita_JP', 'AdGroupName': 'Narita - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong airfare modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong airline low cost exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Osaka_JP&&Osaka - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': 'Osaka - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong cheap air exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong cheap air modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong flight book modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong flights exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong flights modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo - JP&&Hong Kong international exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong international exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Takamatsu_JP&&Takamatsu - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Takamatsu_JP', 'AdGroupName': 'Takamatsu - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong international modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong international modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Takamatsu HK - CN&&Takamatsu airfare broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu airfare broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong airfare exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong airfare exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Takamatsu HK - CN&&Takamatsu air tickets exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': 'Takamatsu air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong cheap airline exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Tokyo_JP&&Tokyo - Hong Kong BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': 'Tokyo - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Tokyo - JP&&Hong Kong deals modified broad': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': 'Hong Kong deals modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Brand_JP&&Website BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Website BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Website BMM': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Website BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Seoul - EN&&Hong Kong flight book exact': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': 'Hong Kong flight book exact', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Seoul - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - EN', 'AdGroupName': '', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Nagoya - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Tokyo - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Fukuoka - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Osaka - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Busan - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - EN', 'AdGroupName': '', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Hiroshima - JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Seoul - KR&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Seoul - KR', 'AdGroupName': '', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Seoul '}, 'Fukuoka - JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Fukuoka - JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Tokyo - JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Tokyo - JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Hiroshima - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hiroshima - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Jeju - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - EN', 'AdGroupName': '', 'Market': 'KR', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Nagoya - JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Nagoya - JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Hong Kong - Brand EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - Brand EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - Brand CN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - Brand CN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Busan - KR&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Busan - KR', 'AdGroupName': '', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Osaka - JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Osaka - JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Jeju - KR&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Jeju - KR', 'AdGroupName': '', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Jeju '}, 'Guam NGO - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Guam NGO - EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': '', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': '', 'GeoTarget': 'Hong Kong '}, 'Takamatsu HK - CN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - CN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Hong Kong&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hong Kong', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Takamatsu HK - EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'Takamatsu HK - EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'New_Brand_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Brand_EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Fukuoka_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Fukuoka_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Hiroshima_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Hiroshima_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Haneda_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Haneda_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Ishigaki_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Ishigaki_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Kagoshima_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Kagoshima_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Nagoya_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Nagoya_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Nagoya_JP_to_Guam&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Nagoya_JP_to_Guam', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Guam', 'GeoTarget': ''}, 'New_Narita_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Narita_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Osaka_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Takamatsu_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Takamatsu_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'New_Tokyo_JP&&': {'SearchEngine': 'Google', 'AccountName': 'HK Express', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': ''}
}

OLD_UO_YAHOO = {'New_Brand_EN&&Website BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Website BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Website BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Website BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Tokyo&&Tokyo to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo', 'AdGroupName': 'Tokyo to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo&&Tokyo to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo', 'AdGroupName': 'Tokyo to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo&&Tokyo to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo', 'AdGroupName': 'Tokyo to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Tokyo&&Tokyo to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo', 'AdGroupName': 'Tokyo to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Hong Kong - English&&Tokyo flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo deals modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Tokyo air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Tokyo air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Hong Kong '}, 'New_Tokyo_JP&&Tokyo - Hong Kong BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': 'Tokyo - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Kanto&&Tokyo': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Tokyo', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Kanto'}, 'Hong Kong - English&&Taichung cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Taichung cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Taichung cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Taichung cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Seoul flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Seoul flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Seoul cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Seoul cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Seoul cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Seoul cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Seoul airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Seoul airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Seoul air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Seoul air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Phuket cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Phuket cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Phuket cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Phuket cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Phuket airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Phuket airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Phuket air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Phuket air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Penang flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Penang flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Penang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Penang cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Penang cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Penang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Penang cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Penang cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Penang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Penang airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Penang airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Penang', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Penang air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Penang air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Penang', 'GeoTarget': 'Hong Kong '}, 'Osaka&&Osaka to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka', 'AdGroupName': 'Osaka to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka&&Osaka to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka', 'AdGroupName': 'Osaka to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka&&Osaka to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka', 'AdGroupName': 'Osaka to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Osaka&&Osaka to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka', 'AdGroupName': 'Osaka to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Hong Kong - English&&Osaka international modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka deals modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Osaka air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Osaka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Hong Kong '}, 'New_Osaka_JP&&Osaka - Hong Kong BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': 'Osaka - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Kansai&&Osaka': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Osaka', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': 'Kansai'}, 'Narita&&Narita to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Narita', 'AdGroupName': 'Narita to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Narita'}, 'Narita&&Narita to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Narita', 'AdGroupName': 'Narita to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Narita'}, 'Narita&&Narita to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Narita', 'AdGroupName': 'Narita to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Narita'}, 'Narita&&Narita to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Narita', 'AdGroupName': 'Narita to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Narita'}, 'Kanto&&Narita': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Narita', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': 'Kanto'}, 'Nagoya&&Nagoya to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Nagoya to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya&&Nagoya to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Nagoya to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Nagoya&&Nagoya to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Nagoya to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Hong Kong - English&&Nagoya flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Nagoya cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Nagoya cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Nagoya airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Nagoya airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Nagoya air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Nagoya air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Hong Kong '}, 'New_Nagoya_JP&&Nagoya - Guam BMM (copied)': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Nagoya_JP', 'AdGroupName': 'Nagoya - Guam BMM (copied)', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Guam', 'GeoTarget': 'Nagoya '}, 'Nagoya&&Nagoya': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Nagoya', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Nagoya '}, 'NGO&&NGO to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'NGO', 'AdGroupName': 'NGO to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'NGO&&NGO to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'NGO', 'AdGroupName': 'NGO to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'New_Brand_EN&&Misspelling BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Misspelling BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Nagoya&&LCC': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'LCC', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&LCC': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'LCC', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&LCC': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'LCC', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Kansai&&LCC': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'LCC', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kansai'}, 'Kanto&&LCC': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'LCC', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kanto'}, 'Hong Kong - English&&Kunming cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kunming cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Kunming cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kunming cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Kunming airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kunming airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Kota Kinabalu cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kota Kinabalu cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kota Kinabalu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Kota Kinabalu cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kota Kinabalu cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kota Kinabalu', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Kota Kinabalu airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Kota Kinabalu airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kota Kinabalu', 'GeoTarget': 'Hong Kong '}, 'New_Osaka_JP&&Kansai - Hong Kong BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': 'Kansai - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Kansai&&Kansai': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Kansai', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kansai', 'GeoTarget': 'Kansai'}, 'KIX&&KIX to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'KIX', 'AdGroupName': 'KIX to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Kansai'}, 'KIX&&KIX to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'KIX', 'AdGroupName': 'KIX to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Kansai'}, 'KIX&&KIX to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'KIX', 'AdGroupName': 'KIX to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Kansai'}, 'KIX&&KIX to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'KIX', 'AdGroupName': 'KIX to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Kansai'}, 'Nagoya&&Japan': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Japan', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&Japan': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Japan', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&Japan': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Japan', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hiroshima '}, 'Kansai&&Japan': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Japan', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kansai', 'GeoTarget': 'Kansai'}, 'Kanto&&Japan': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Japan', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kanto', 'GeoTarget': 'Kanto'}, 'Busan&&Hong Kong flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Busan', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Chiang Mai&&Hong Kong flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Chiang Mai', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Chiang Mai'}, 'Hong Kong&&Hong Kong flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Hiroshima&&Hong Kong flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hong Kong&&Hong Kong flights last minute modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': 'Hong Kong flights last minute modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Hiroshima&&Hong Kong flights exact': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong flights exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Ningbo&&Hong Kong flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Ningbo', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Ningbo'}, 'Hong Kong&&Hong Kong flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Hiroshima&&Hong Kong flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Ningbo&&Hong Kong cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Ningbo', 'AdGroupName': 'Hong Kong cheap airline modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Ningbo'}, 'Hiroshima&&Hong Kong cheap airline exact': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong cheap airline exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Busan&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Busan', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Tokyo_old&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo_old', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Fukuoka_old&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka_old', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Kota Kinabalu&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kota Kinabalu', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Kota Kinabalu'}, 'Ningbo&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Ningbo', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Ningbo'}, 'Osaka_old&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka_old', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Penang&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Penang', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Penang'}, 'Phuket&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Phuket', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Phuket'}, 'Taichung&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Taichung', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Taichung'}, 'Hong Kong&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Hiroshima&&Hong Kong cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima&&Hong Kong cheap air exact': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong cheap air exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Tokyo_old&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo_old', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Hiroshima&&Hong Kong airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong airline low cost modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima&&Hong Kong airline low cost exact': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong airline low cost exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Kota Kinabalu&&Hong Kong airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kota Kinabalu', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Kota Kinabalu'}, 'Hiroshima&&Hong Kong airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong airfare modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Kunming&&Hong Kong air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kunming', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Kunming'}, 'Phuket&&Hong Kong air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Phuket', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Phuket'}, 'Hong Kong&&Hong Kong air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Hiroshima&&Hong Kong air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima&&Hong Kong air tickets exact': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hong Kong air tickets exact', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'New_Hiroshima_JP&&Hiroshima - Hong Kong BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Hiroshima_JP', 'AdGroupName': 'Hiroshima - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Hiroshima&&Hiroshima': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Hiroshima', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': 'Hiroshima '}, 'Haneda&&Haneda to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Haneda', 'AdGroupName': 'Haneda to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Haneda'}, 'Haneda&&Haneda to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Haneda', 'AdGroupName': 'Haneda to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Haneda'}, 'Haneda&&Haneda to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Haneda', 'AdGroupName': 'Haneda to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Haneda'}, 'Haneda&&Haneda to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Haneda', 'AdGroupName': 'Haneda to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Haneda'}, 'Kanto&&Haneda': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Haneda', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Haneda', 'GeoTarget': 'Kanto'}, 'New_Brand_EN&&Generic BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Generic BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Generic BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Generic + Departure BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic + Departure BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Fukuoka&&Fukuoka to HK flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Fukuoka to HK flights modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka&&Fukuoka to HK flight book modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Fukuoka to HK flight book modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka&&Fukuoka to HK cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Fukuoka to HK cheap air modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka&&Fukuoka to HK air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Fukuoka to HK air tickets modified broad', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Hong Kong - English&&Fukuoka international modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Fukuoka air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Fukuoka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Hong Kong '}, 'New_Fukuoka_JP&&Fukuoka - Hong Kong BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Fukuoka_JP', 'AdGroupName': 'Fukuoka - Hong Kong BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Fukuoka&&Fukuoka': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Fukuoka', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': 'Fukuoka '}, 'Nagoya&&Flight Ticket': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Flight Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&Flight Ticket': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Flight Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&Flight Ticket': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Flight Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Kansai&&Flight Ticket': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Flight Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kansai'}, 'Kanto&&Flight Ticket': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Flight Ticket', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kanto'}, 'Nagoya&&Flight': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&Flight': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&Flight': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Kansai&&Flight': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kansai'}, 'Kanto&&Flight': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Flight', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': 'Kanto'}, 'Hong Kong - English&&Chiang Mai cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Chiang Mai cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Chiang Mai cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Chiang Mai cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Chiang Mai airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Chiang Mai airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Chiang Mai airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Chiang Mai airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Chiang Mai air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Chiang Mai air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': 'Hong Kong '}, 'Nagoya&&Cheap Airfare': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Cheap Airfare', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Fukuoka&&Cheap Airfare': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Cheap Airfare', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Hiroshima&&Cheap Airfare': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Cheap Airfare', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Kansai&&Cheap Airfare': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Cheap Airfare', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Kanto&&Cheap Airfare': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Cheap Airfare', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - English&&Busan international modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan international modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan flights modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan cheap airline modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan cheap air modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan airline low cost modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan airfare modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Busan air tickets modified broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Busan air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': 'Hong Kong '}, 'Brand&&Brand broad Japanese': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Brand', 'AdGroupName': 'Brand broad Japanese', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - Brand&&Brand broad English': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - Brand', 'AdGroupName': 'Brand broad English', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Brand&&Brand broad English': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Brand', 'AdGroupName': 'Brand broad English', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Brand&&Brand broad Chinese': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Brand', 'AdGroupName': 'Brand broad Chinese', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - Chinese&&Brand broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - Chinese', 'AdGroupName': 'Brand broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - English&&Brand broad': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': 'Brand broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hong Kong '}, 'New_Brand_EN&&Brand Name BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Brand Name BMM', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Brand Name BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Brand Name BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Nagoya&&Brand': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': 'Brand', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&Brand': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Brand', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&Brand': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': 'Brand', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Hiroshima '}, 'Kansai&&Brand': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': 'Brand', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Kansai'}, 'Kanto&&Brand': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': 'Brand', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': 'Kanto'}, 'New_Tokyo_JP&&Tokyo - Nha Trang BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': 'Tokyo - Nha Trang BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Naha Trang', 'GeoTarget': 'Tokyo '}, 'New_Tokyo_JP&&Tokyo - Hong Kong EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': 'Tokyo - Hong Kong EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'New_Osaka_JP&&Kansai - Hong Kong EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': 'Kansai - Hong Kong EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'New_Osaka_JP&&Osaka - Hong Kong EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': 'Osaka - Hong Kong EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'New_Nagoya_JP&&Nagoya - Guam EX (copied)': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Nagoya_JP', 'AdGroupName': 'Nagoya - Guam EX (copied)', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Guam', 'GeoTarget': 'Nagoya '}, 'New_Hiroshima_JP&&Hiroshima - Hong Kong EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Hiroshima_JP', 'AdGroupName': 'Hiroshima - Hong Kong EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'New_Fukuoka_JP&&Fukuoka - Hong Kong EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Fukuoka_JP', 'AdGroupName': 'Fukuoka - Hong Kong EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'New_Brand_JP&&Seasonal BMM': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Seasonal BMM', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Brand Name EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Brand Name EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Generic + Departure EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic + Departure EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Generic EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Generic EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&Website EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': 'Website EX', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Website EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Website EX', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Misspelling EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Misspelling EX', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Generic EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Generic EX', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&Brand Name EX': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': 'Brand Name EX', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_EN&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_EN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'New_Brand_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Brand_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Tokyo&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': '', 'GeoTarget': 'Tokyo '}, 'Hong Kong - English&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - English', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Hong Kong '}, 'New_Tokyo_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Tokyo_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Naha Trang', 'GeoTarget': 'Tokyo '}, 'Kanto&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kanto', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Kanto'}, 'Osaka&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'New_Osaka_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Osaka_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Kansai&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kansai', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Kansai'}, 'Narita&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Narita', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Narita'}, 'Nagoya&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Nagoya', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Nagoya '}, 'New_Nagoya_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Nagoya_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Guam', 'GeoTarget': 'Nagoya '}, 'NGO&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'NGO', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Nagoya '}, 'Fukuoka&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Fukuoka '}, 'Hiroshima&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hiroshima', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Hiroshima '}, 'KIX&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'KIX', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Kansai'}, 'Busan&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Busan', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Busan '}, 'Chiang Mai&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Chiang Mai', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Chiang Mai'}, 'Hong Kong&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Hong Kong '}, 'Ningbo&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Ningbo', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Ningbo'}, 'Tokyo_old&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Tokyo_old', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Tokyo '}, 'Fukuoka_old&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Fukuoka_old', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Kota Kinabalu&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kota Kinabalu', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Kota Kinabalu'}, 'Osaka_old&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Osaka_old', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Osaka '}, 'Penang&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Penang', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Penang'}, 'Phuket&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Phuket', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Phuket'}, 'Taichung&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Taichung', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Taichung'}, 'Kunming&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Kunming', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Kunming'}, 'New_Hiroshima_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Hiroshima_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Hiroshima '}, 'Haneda&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Haneda', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': 'Haneda'}, 'New_Fukuoka_JP&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'New_Fukuoka_JP', 'AdGroupName': '', 'Market': 'JP', 'Language': 'jp', 'CampaignType': 'NB', 'KeywordType': 'Route', 'Destination': 'Hong Kong', 'GeoTarget': 'Fukuoka '}, 'Brand&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Brand', 'AdGroupName': '', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': ''}, 'Hong Kong - Brand&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - Brand', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Hong Kong '}, 'Hong Kong - Chinese&&': {'SearchEngine': 'Yahoo! Japan', 'AccountName': 'HONG KONG EXPRESS AIRWAYS LIMITED', 'CampaignName': 'Hong Kong - Chinese', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '', 'GeoTarget': 'Hong Kong '}
                }

OLD_UO_BING = {'Hong Kong - Brand CN&&Brand broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - Brand CN', 'AdGroupName': 'Brand broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - Brand EN&&Brand broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - Brand EN', 'AdGroupName': 'Brand broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Busan PUS airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Busan PUS airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai CNX airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai CNX airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Mai flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Mai flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Rai CEI airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai CEI airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Rai cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Chiang Rai flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Chiang Rai flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - CN&&Da Nang DAD airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Da Nang DAD airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka deals exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka deals exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Fukuoka FUK airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Fukuoka FUK airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Guam GUM airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Guam GUM airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima air tickets broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima cheap air broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima cheap air broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima deals broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima deals broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima flight book broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flight book broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima HIJ airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima HIJ airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima HIJ airport exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima HIJ airport exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima HIJ airport modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima HIJ airport modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hiroshima international broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hiroshima international broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Hualien HUN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Hualien HUN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Ishigaki ISG airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ishigaki ISG airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima air tickets broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima deals broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima deals broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima flight book broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flight book broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flights broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima KOJ airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima KOJ airport broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kagoshima KOJ airport exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kagoshima KOJ airport exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Kunming KMG airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Kunming KMG airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - CN&&Lanzhou airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - CN&&Lanzhou cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - CN&&Lanzhou flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Lanzhou flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya cheap airline modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Nagoya NGO airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Nagoya NGO airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - CN&&Ningbo air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - CN&&Ningbo deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - CN&&Ningbo flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - CN&&Ningbo NGB airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Ningbo NGB airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka cheap air exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka cheap airline modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka international modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka international modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Osaka KIX airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Osaka KIX airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu flights modified broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu travel': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu travel', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - CN&&Phuket HKT airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Phuket HKT airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - CN&&Saipan deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - CN&&Saipan flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - CN&&Saipan SPN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Saipan SPN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul ICN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul ICN airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Seoul international modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Seoul international modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap deals exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap deals exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Siem Reap REP airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Siem Reap REP airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Taichung RMQ airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Taichung RMQ airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airfare exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airfare modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo airline low cost modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo cheap air modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo cheap airline modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo flight book modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flight book modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Tokyo HND airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Tokyo HND airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi cheap air exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi flight book exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi flight book exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi flights exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi international exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi international exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Wuxi WUX airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Wuxi WUX airport', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'Hong Kong - CN&&Yangon air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon air tickets exact', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - CN&&Yangon air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon air tickets modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - CN&&Yangon deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon deals modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - CN&&Yangon flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': 'Yangon flights modified broad', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Busan PUS airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Busan PUS airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai CNX airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai CNX airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Mai flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Mai flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Rai air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu cheap air modified broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu TAK airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Rai CEI airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai CEI airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Rai cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Rai flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Chiang Rai flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Chiang Rai flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang DAD airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang DAD airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang flights last minute modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights last minute modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Da Nang flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Da Nang flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka cheap airline exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Fukuoka FUK airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Fukuoka FUK airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Guam GUM airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Guam GUM airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Guam', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima air tickets broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima airline low cost broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima airline low cost broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima deals broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima deals broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima HIJ airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima HIJ airport exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima HIJ airport modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima HIJ airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hiroshima international broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hiroshima international broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hiroshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - EN&&Hualien HUN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Hualien HUN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hualien', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Ishigaki ISG airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ishigaki ISG airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ishigaki', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju CJU airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju CJU airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Jeju flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Jeju flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Jeju', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima air tickets broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima cheap air broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima cheap air broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima KOJ airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima KOJ airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kagoshima KOJ airport modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kagoshima KOJ airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kagoshima', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Kunming KMG airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Kunming KMG airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Hong Kong - EN&&Lanzhou flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - EN&&Lanzhou flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - EN&&Lanzhou LHW airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Lanzhou LHW airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Nagoya NGO airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Nagoya NGO airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Ningbo NGB airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Ningbo NGB airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka airline low cost exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka cheap airline exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka deals exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka deals exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Osaka KIX airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Osaka KIX airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Phuket HKT airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Phuket HKT airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - EN&&Saipan SPN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Saipan SPN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Saipan', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu holiday': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu holiday', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul airline low cost exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul cheap airline exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Seoul ICN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Seoul ICN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Siem Reap REP airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Siem Reap REP airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung airline low cost exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung airline low cost exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Taichung RMQ airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Taichung RMQ airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo airfare exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airfare exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu air tickets modified broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo airfare modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airfare modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo airline low cost modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo airline low cost modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu air tickets broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu air tickets broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo cheap airline exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap airline exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo cheap airline modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo cheap airline modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu deals broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu deals broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo deals modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo deals modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Takamatsu - CN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo HND airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo HND airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Tokyo NRT airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Tokyo NRT airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Hong Kong - EN&&Yangon air tickets modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon air tickets modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - EN&&Yangon cheap air modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon cheap air modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - EN&&Yangon flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - EN&&Yangon flights modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon flights modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Hong Kong - EN&&Yangon RGN airport': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': 'Yangon RGN airport', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Yangon', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu air tickets exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu air tickets exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu cheap air exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu cheap air exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu flights broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu flights broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu flights exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu flights exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu TAK airport broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu TAK airport broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu TAK airport exact': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu TAK airport exact', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu TAK airport modified broad': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu TAK airport modified broad', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Takamatsu - EN&&Takamatsu travel': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': 'Takamatsu travel', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - Brand CN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - Brand CN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - Brand EN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - Brand EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Hong Kong - CN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - CN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': '', 'GeoTarget': ''}, 'Takamatsu - CN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - CN', 'AdGroupName': '', 'Market': 'JP', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}, 'Hong Kong - EN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Hong Kong - EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': '', 'GeoTarget': ''}, 'Takamatsu - EN&&': {'SearchEngine': 'Bing', 'AccountName': 'Hong Kong Express Airways Limited', 'CampaignName': 'Takamatsu - EN', 'AdGroupName': '', 'Market': 'HK', 'Language': 'en', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Takamatsu', 'GeoTarget': ''}
               }

OLD_UO_NAVER = {
    '홍콩익스프레스&&HongKong Travel': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'HongKong Travel', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, '홍콩익스프레스&&HongKong Flight_#0002': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'HongKong Flight_#0002', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, '홍콩익스프레스&&Google-Keyword_#0001': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'Google-Keyword_#0001', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, '홍콩익스프레스&&Brand - HKExpress_#0002': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'Brand - HKExpress_#0002', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Spring 2017&&Brand - HKExpress_#0002': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': 'Spring 2017', 'AdGroupName': 'Brand - HKExpress_#0002', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'Spring 2017&&Spring Campaign': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': 'Spring 2017', 'AdGroupName': 'Spring Campaign', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, '홍콩익스프레스&&HK_Flight\xa0': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'HK_Flight\xa0', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, '홍콩익스프레스&&HK_Flight': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': 'HK_Flight', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, '홍콩익스프레스&&': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': '홍콩익스프레스', 'AdGroupName': '', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '', 'GeoTarget': ''}, 'Spring 2017&&': {'SearchEngine': 'Naver', 'AccountName': '', 'CampaignName': 'Spring 2017', 'AdGroupName': '', 'Market': 'KR', 'Language': 'ko', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}}

OLD_UO_BAIDU = {
    'Ningbo Ticket[Deleted]&&Ningbo[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo Ticket[Deleted]', 'AdGroupName': 'Ningbo[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Phuket[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Phuket[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Ningbo[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Osaka[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Osaka[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Tokyo[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Tokyo[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Seoul[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Seoul[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Chiang Mai[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang Mai[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'TaiChung[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChung[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'HK[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HK[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Nagoya[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Nagoya[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'TokyoHNDAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoHNDAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'TokyoNRTAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoNRTAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'SeoulICNAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulICNAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'OsakaKIXAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaKIXAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'KunmingKMGAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingKMGAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'HKTicket[Deleted]&&Hong Kong[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HKTicket[Deleted]', 'AdGroupName': 'Hong Kong[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'SeoulTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'PhuketTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'FukuokaTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'BusanTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'TaiChungTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Chiang MaiTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'OsakaTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'TokyoTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'NagoyaTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Da NangTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Da NangTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Siem ReapTicket[Deleted]&&Asia Pacific - Cities[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Siem ReapTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Cities[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'KoreaTicket[Deleted]&&Asia Pacific - Countries[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KoreaTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Countries[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Korea', 'GeoTarget': ''}, 'TaiwanTicket[Deleted]&&Asia Pacific - Countries[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiwanTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Countries[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Taiwan', 'GeoTarget': ''}, 'ThailandTicket[Deleted]&&Asia Pacific - Countries[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ThailandTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Countries[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Thailand', 'GeoTarget': ''}, 'JapanTicket[Deleted]&&Asia Pacific - Countries[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'JapanTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Countries[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Japan', 'GeoTarget': ''}, 'MalaysiaTicket[Deleted]&&Asia Pacific - Countries[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'MalaysiaTicket[Deleted]', 'AdGroupName': 'Asia Pacific - Countries[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Malaysia', 'GeoTarget': ''}, 'KunmingTicket[Deleted]&&Kunming[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingTicket[Deleted]', 'AdGroupName': 'Kunming[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'SalesTicket[Deleted]&&Generic & Competitors[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SalesTicket[Deleted]', 'AdGroupName': 'Generic & Competitors[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Competitor[Deleted]&&Generic & Competitors[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Competitor[Deleted]', 'AdGroupName': 'Generic & Competitors[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Low cost carrier[Deleted]&&Generic & Competitors[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Low cost carrier[Deleted]', 'AdGroupName': 'Generic & Competitors[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'TicketOffer[Deleted]&&Generic & Competitors[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TicketOffer[Deleted]', 'AdGroupName': 'Generic & Competitors[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Brand Term[Deleted]&&HKE Brand[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Brand Term[Deleted]', 'AdGroupName': 'HKE Brand[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'WuxiTicket[Deleted]&&Wuxi[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'WuxiTicket[Deleted]', 'AdGroupName': 'Wuxi[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'NingboNGBAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NingboNGBAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Busan[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Busan[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'NagoyaNGOAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaNGOAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'BusanPUSAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanPUSAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Kunming[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Kunming[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hunming', 'GeoTarget': ''}, 'Fukuoka[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Fukuoka[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'PhuketHKTAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketHKTAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'FukuokaFUKAirport[Deleted]&&Flight Route[Deleted]': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaFUKAirport[Deleted]', 'AdGroupName': 'Flight Route[Deleted]', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Nagoya&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Nagoya', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'FukuokaFUKAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaFUKAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'TaiChung&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChung', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Seoul&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Seoul', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Phuket&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Phuket', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'TokyoNRTAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoNRTAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'OsakaKIXAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaKIXAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Osaka&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Osaka', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Tokyo&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Tokyo', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Chiang MaiCNXAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiCNXAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Kunming&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Kunming', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Ningbo&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Busan&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Busan', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Chiang Mai&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang Mai', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'HK&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HK', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'NingboNGBAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NingboNGBAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'TokyoHNDAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoHNDAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'PhuketTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Da NangTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Da NangTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'TaiChungTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'OsakaTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Chiang MaiTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'NagoyaTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'FukuokaTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'ThailandTicket&&Asia Pacific - Countries': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ThailandTicket', 'AdGroupName': 'Asia Pacific - Countries', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Thailand', 'GeoTarget': ''}, 'Low cost carrier&&Generic & Competitors': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Low cost carrier', 'AdGroupName': 'Generic & Competitors', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Competitor&&Generic & Competitors': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Competitor', 'AdGroupName': 'Generic & Competitors', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Brand Term&&HKE Brand': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Brand Term', 'AdGroupName': 'HKE Brand', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'KunmingTicket&&Kunming': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingTicket', 'AdGroupName': 'Kunming', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'WuxiTicket&&Wuxi': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'WuxiTicket', 'AdGroupName': 'Wuxi', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'BusanPUSAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanPUSAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'TaiChungRMQAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungRMQAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Fukuoka&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Fukuoka', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'NagoyaNGOAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaNGOAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'PhuketHKTAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketHKTAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'SeoulICNAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulICNAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'KunmingKMGAirport&&Flight Route': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingKMGAirport', 'AdGroupName': 'Flight Route', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'BusanTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'SeoulTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Siem ReapTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Siem ReapTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'TokyoTicket&&Asia Pacific - Cities': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoTicket', 'AdGroupName': 'Asia Pacific - Cities', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'JapanTicket&&Asia Pacific - Countries': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'JapanTicket', 'AdGroupName': 'Asia Pacific - Countries', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Japan', 'GeoTarget': ''}, 'KoreaTicket&&Asia Pacific - Countries': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KoreaTicket', 'AdGroupName': 'Asia Pacific - Countries', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Korea', 'GeoTarget': ''}, 'MalaysiaTicket&&Asia Pacific - Countries': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'MalaysiaTicket', 'AdGroupName': 'Asia Pacific - Countries', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Malaysia', 'GeoTarget': ''}, 'TaiwanTicket&&Asia Pacific - Countries': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiwanTicket', 'AdGroupName': 'Asia Pacific - Countries', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Taiwan', 'GeoTarget': ''}, 'SalesTicket&&Generic & Competitors': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SalesTicket', 'AdGroupName': 'Generic & Competitors', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'TicketOffer&&Generic & Competitors': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TicketOffer', 'AdGroupName': 'Generic & Competitors', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Ningbo Ticket&&Ningbo': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo Ticket', 'AdGroupName': 'Ningbo', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'HKTicket&&Hong Kong': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HKTicket', 'AdGroupName': 'Hong Kong', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'LanzhouTicket&&Lanzhou': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'LanzhouTicket', 'AdGroupName': 'Lanzhou', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'PRD&&Pearl River Delta Campaign': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PRD', 'AdGroupName': 'Pearl River Delta Campaign', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Pearl River Delta', 'GeoTarget': ''}, 'QuanzhouTicket&&Quanzhou': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'QuanzhouTicket', 'AdGroupName': 'Quanzhou', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Quanzhou', 'GeoTarget': ''}, 'ZhengzhouTicket&&Zhengzhou': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ZhengzhouTicket', 'AdGroupName': 'Zhengzhou', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Zhengzhou', 'GeoTarget': ''}, 'Ningbo Ticket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo Ticket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Phuket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Phuket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Ningbo[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Osaka[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Osaka[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Tokyo[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Tokyo[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Seoul[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Seoul[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Chiang Mai[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang Mai[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'TaiChung[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChung[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'HK[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HK[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'Nagoya[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Nagoya[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'TokyoHNDAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoHNDAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'TokyoNRTAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoNRTAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'SeoulICNAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulICNAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'OsakaKIXAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaKIXAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'KunmingKMGAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingKMGAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'HKTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HKTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'SeoulTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'PhuketTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'FukuokaTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'BusanTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'TaiChungTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Chiang MaiTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'OsakaTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'TokyoTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'NagoyaTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'Da NangTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Da NangTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'Siem ReapTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Siem ReapTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'KoreaTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KoreaTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Korea', 'GeoTarget': ''}, 'TaiwanTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiwanTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Taiwan', 'GeoTarget': ''}, 'ThailandTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ThailandTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Thailand', 'GeoTarget': ''}, 'JapanTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'JapanTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Japan', 'GeoTarget': ''}, 'MalaysiaTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'MalaysiaTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Malaysia', 'GeoTarget': ''}, 'KunmingTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'SalesTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SalesTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Competitor[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Competitor[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Low cost carrier[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Low cost carrier[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'TicketOffer[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TicketOffer[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Brand Term[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Brand Term[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'WuxiTicket[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'WuxiTicket[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'NingboNGBAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NingboNGBAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Busan[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Busan[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'NagoyaNGOAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaNGOAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'BusanPUSAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanPUSAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Kunming[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Kunming[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hunming', 'GeoTarget': ''}, 'Fukuoka[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Fukuoka[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'PhuketHKTAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketHKTAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'FukuokaFUKAirport[Deleted]&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaFUKAirport[Deleted]', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'Nagoya&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Nagoya', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'FukuokaFUKAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaFUKAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'TaiChung&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChung', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Seoul&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Seoul', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Phuket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Phuket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'TokyoNRTAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoNRTAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'OsakaKIXAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaKIXAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Osaka&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Osaka', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Tokyo&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Tokyo', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'Chiang MaiCNXAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiCNXAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'Kunming&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Kunming', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'Ningbo&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'Busan&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Busan', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'Chiang Mai&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang Mai', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'HK&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HK', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'NingboNGBAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NingboNGBAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'TokyoHNDAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoHNDAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'PhuketTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'Da NangTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Da NangTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Da Nang', 'GeoTarget': ''}, 'TaiChungTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'OsakaTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'OsakaTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Osaka', 'GeoTarget': ''}, 'Chiang MaiTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Chiang MaiTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Chiang Mai', 'GeoTarget': ''}, 'NagoyaTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'FukuokaTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'FukuokaTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'ThailandTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ThailandTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Thailand', 'GeoTarget': ''}, 'Low cost carrier&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Low cost carrier', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Competitor&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Competitor', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Brand Term&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Brand Term', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'BR', 'KeywordType': 'Brand', 'Destination': '0', 'GeoTarget': ''}, 'KunmingTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'WuxiTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'WuxiTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Wuxi', 'GeoTarget': ''}, 'BusanPUSAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanPUSAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'TaiChungRMQAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiChungRMQAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tai Chung', 'GeoTarget': ''}, 'Fukuoka&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Fukuoka', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Fukuoka', 'GeoTarget': ''}, 'NagoyaNGOAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'NagoyaNGOAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Nagoya', 'GeoTarget': ''}, 'PhuketHKTAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PhuketHKTAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Phuket', 'GeoTarget': ''}, 'SeoulICNAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulICNAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'KunmingKMGAirport&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KunmingKMGAirport', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Kunming', 'GeoTarget': ''}, 'BusanTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'BusanTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Busan', 'GeoTarget': ''}, 'SeoulTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SeoulTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Seoul', 'GeoTarget': ''}, 'Siem ReapTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Siem ReapTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Siem Reap', 'GeoTarget': ''}, 'TokyoTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TokyoTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Tokyo', 'GeoTarget': ''}, 'JapanTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'JapanTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Japan', 'GeoTarget': ''}, 'KoreaTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'KoreaTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Korea', 'GeoTarget': ''}, 'MalaysiaTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'MalaysiaTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Malaysia', 'GeoTarget': ''}, 'TaiwanTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TaiwanTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Taiwan', 'GeoTarget': ''}, 'SalesTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'SalesTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'TicketOffer&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'TicketOffer', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Generics', 'Destination': '0', 'GeoTarget': ''}, 'Ningbo Ticket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'Ningbo Ticket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Ningbo', 'GeoTarget': ''}, 'HKTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'HKTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Hong Kong', 'GeoTarget': ''}, 'LanzhouTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'LanzhouTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Lanzhou', 'GeoTarget': ''}, 'PRD&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'PRD', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Pearl River Delta', 'GeoTarget': ''}, 'QuanzhouTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'QuanzhouTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Quanzhou', 'GeoTarget': ''}, 'ZhengzhouTicket&&': {'SearchEngine': 'Baidu', 'AccountName': '', 'CampaignName': 'ZhengzhouTicket', 'AdGroupName': '', 'Market': 'CN', 'Language': 'zh', 'CampaignType': 'NB', 'KeywordType': 'Dest', 'Destination': 'Zhengzhou', 'GeoTarget': ''}
}
