import { Construct } from 'constructs';
import { Dashboard, DashboardProps } from './dashboard';
import { DataSource, DataSourceProps } from './datasource';
/**
 * @stability stable
 */
export interface GrafanaProps {
    /**
     * Specify a custom image for Grafana.
     *
     * @default "public.ecr.aws/ubuntu/grafana:latest"
     * @stability stable
     */
    readonly image?: string;
    /**
     * Create an ingress to provide external access to the Grafana cluster.
     *
     * @default true
     * @stability stable
     */
    readonly ingress?: boolean;
    /**
     * Type of service to be created (NodePort, ClusterIP or LoadBalancer).
     *
     * @default ClusterIP
     * @stability stable
     */
    readonly serviceType?: string;
    /**
     * Default admin username.
     *
     * @default "root"
     * @stability stable
     */
    readonly adminUser?: string;
    /**
     * Default admin password.
     *
     * @default "secret"
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Require login in order to view or manage dashboards.
     *
     * @default false
     * @stability stable
     */
    readonly requireLogin?: boolean;
    /**
     * Default data source - equivalent to calling `grafana.addDataSource`.
     *
     * @default - no data source added
     * @stability stable
     */
    readonly defaultDataSource?: DataSourceProps;
    /**
     * Labels to apply to all Grafana resources.
     *
     * @default - { app: "grafana" }
     * @stability stable
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Namespace to apply to all Grafana resources.
     *
     * The Grafana Operator must be
     * installed in this namespace for resources to be recognized.
     *
     * @default - undefined (will be assigned to the 'default' namespace)
     * @stability stable
     */
    readonly namespace?: string;
}
/**
 * A Grafana instance.
 *
 * @stability stable
 */
export declare class Grafana extends Construct {
    private readonly dataSources;
    private readonly dashboards;
    private readonly namespace;
    private readonly labels;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: GrafanaProps);
    /**
     * Adds a data source.
     *
     * By default, labels are automatically added so that
     * the data source is detected by Grafana.
     *
     * @stability stable
     */
    addDataSource(id: string, props: DataSourceProps): DataSource;
    /**
     * Creates a dashboard associated with a particular data source.
     *
     * By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     *
     * @stability stable
     */
    addDashboard(id: string, props: DashboardProps): Dashboard;
}
