import { Duration } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface DashboardProps {
    /**
     * Title of the dashboard.
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Group dashboards into folders.
     *
     * @default - default folder
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Specify a mapping from data source variables to data source names.
     *
     * This is only needed if you are importing an existing dashboard's JSON
     * and it specifies variables within an "__inputs" field.
     *
     * @default - no data source variables
     * @stability stable
     * @example
     *
     * { DS_PROMETHEUS: "my-prometheus-ds" }
     */
    readonly dataSourceVariables?: {
        [name: string]: string;
    };
    /**
     * Auto-refresh interval.
     *
     * @default - 5 seconds
     * @stability stable
     */
    readonly refreshRate?: Duration;
    /**
     * Time range for the dashboard, e.g. last 6 hours, last 7 days, etc.
     *
     * @default - 6 hours
     * @stability stable
     */
    readonly timeRange?: Duration;
    /**
     * Specify plugins required by the dashboard.
     *
     * @stability stable
     */
    readonly plugins?: GrafanaPlugin[];
    /**
     * Labels to apply to the kubernetes resource.
     *
     * When adding a dashboard to a Grafana instance using `grafana.addDashboard`,
     * labels provided to Grafana will be automatically applied. Otherwise,
     * labels must be added manually.
     *
     * @default - no labels
     * @stability stable
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Namespace to apply to the kubernetes resource.
     *
     * When adding a dashboard to a Grafana instance using `grafana.addDashboard`,
     * the namespace will be automatically inherited.
     *
     * @default - undefined (will be assigned to the 'default' namespace)
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * All other dashboard customizations.
     *
     * @see https://grafana.com/docs/grafana/latest/dashboards/json-model/
     * @stability stable
     */
    readonly jsonModel?: {
        [key: string]: any;
    };
}
/**
 * A Grafana dashboard.
 *
 * @see https://grafana.com/docs/grafana/latest/http_api/dashboard/
 * @stability stable
 */
export declare class Dashboard extends Construct {
    private readonly plugins;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DashboardProps);
    /**
     * Adds one or more plugins.
     *
     * @stability stable
     */
    addPlugins(...plugins: GrafanaPlugin[]): void;
}
/**
 * @stability stable
 */
export interface GrafanaPlugin {
    /**
     * Name of the plugin, e.g. "grafana-piechart-panel".
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Version of the plugin, e.g. "1.3.6".
     *
     * @stability stable
     */
    readonly version: string;
}
