/*!
 @file a.hpp
 @brief algorithm library
 @copyright Copyright (C) 2020-present tqfx, All rights reserved.
*/

#ifndef __A_A_HPP__
#define __A_A_HPP__

#include "a.h"

namespace a
{
/*!
 @addtogroup AA algorithm library based on C++
 @{
*/

typedef a_bool_t bool_t;
typedef a_void_t void_t;
typedef a_size_t size_t;

typedef a_i8_t i8_t;
typedef a_u8_t u8_t;

typedef a_i16_t i16_t;
typedef a_u16_t u16_t;

typedef a_i32_t i32_t;
typedef a_u32_t u32_t;

typedef a_i64_t i64_t;
typedef a_u64_t u64_t;

typedef a_imax_t imax_t;
typedef a_umax_t umax_t;

typedef a_iptr_t iptr_t;
typedef a_uptr_t uptr_t;

typedef a_diff_t diff_t;

typedef a_c_t c_t;
typedef a_i_t i_t;
typedef a_u_t u_t;

typedef a_is_t is_t;
typedef a_us_t us_t;

typedef a_il_t il_t;
typedef a_ul_t ul_t;

typedef a_ill_t ill_t;
typedef a_ull_t ull_t;

// clang-format off

typedef  a_int_t  int_t;
typedef a_sint_t sint_t;
typedef a_uint_t uint_t;

typedef  a_byte_t byte_t;
typedef  a_char_t char_t;
typedef a_schar_t schar_t;
typedef a_uchar_t uchar_t;

typedef  a_str_t  str_t;
typedef a_cstr_t cstr_t;
typedef a_vptr_t vptr_t;
typedef a_cptr_t cptr_t;

typedef a_f32_t f32_t;
typedef a_f64_t f64_t;

// clang-format on

/*! @} AA */
} // namespace a

#endif /* __A_A_HPP__ */
