import abc
from abc import ABC, abstractmethod
from typing import Union

class Packaging(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    def forward(self, i: bytes) -> bytes: ...
    @abstractmethod
    def backward(self, o: bytes) -> bytes: ...

class Conveyor(Packaging):
    def __init__(self, *packer: Packaging) -> None: ...
    def forward(self, i: bytes) -> bytes: ...
    def backward(self, o: bytes) -> bytes: ...

class Compression(Packaging):
    def __init__(self, level: int = ...) -> None: ...
    def forward(self, i: bytes) -> bytes: ...
    def backward(self, o: bytes) -> bytes: ...

class Pickling(Packaging):
    def forward(self, i: bytes) -> bytes: ...
    def backward(self, o: bytes) -> bytes: ...

class Base64(Packaging):
    def forward(self, i: bytes) -> bytes: ...
    def backward(self, o: bytes) -> bytes: ...

class Encryption(Packaging):
    def __init__(self, *, key: Union[str, bytes] = ..., password: Union[str, bytes] = ..., seed: int = ...) -> None: ...
    @property
    def key(self) -> str: ...
    @staticmethod
    def generate_key(password: Union[str, bytes] = ..., seed: int = ...) -> str: ...
    def forward(self, i: bytes) -> bytes: ...
    def backward(self, o: bytes) -> bytes: ...
