# daemon-application

## Description

A simple python package for creating daemon applications.

*Notice:*

- *Runs the application in daemon mode on Linux only. On Windows, the application runs in foreground model.*


## Install

```
pip install daemon-application
```

## Usage

### Example for raw APIs

```
import time
import threading
import signal
from daemon_application import daemon_start

stopflag = False

def main():
    def on_exit(*args, **kwargs):
        with open("backgroud.log", "a", encoding="utf-8") as fobj:
            print("process got exit signal...", file=fobj)
            print(args, file=fobj)
            print(kwargs, file=fobj)
        global stopflag
        stopflag = True
    signal.signal(signal.SIGTERM, on_exit)
    signal.signal(signal.SIGINT, on_exit)
    while not stopflag:
        time.sleep(1)
        print(time.time())

if __name__ == "__main__":
    print("start background application...")
    daemon_start(main, "background.pid", True)
```

### Example for DaemonApplication

```
import time
from daemon_application import DaemonApplication

class HelloApplication(DaemonApplication):
    def main(self):
        while True:
            print("hello")
            time.sleep(1)

controller = HelloApplication().get_controller()

if __name__ == "__main__":
    controller()

```

### Example for DaemonApplication adding new global options

```
import time
import click
from daemon_application import DaemonApplication

class HelloApplication(DaemonApplication):

    def get_main_options(self):
        options = [
            click.option("-m", "--message", default="hello")
        ]
        return options + super().get_main_options()

    def main(self):
        while True:
            print(self.config["message"])
            time.sleep(1)

controller = HelloApplication().get_controller()

if __name__ == "__main__":
    controller()
```

*The output of the command help that added a new global option*

```
Usage: example.py [OPTIONS] COMMAND [ARGS]...

Options:
  --pidfile TEXT          pidfile file path.
  --workspace TEXT        Set running folder
  --daemon / --no-daemon  Run application in background or in foreground.
  -c, --config TEXT       Config file path. Application will search config
                          file if this option is missing. Use sub-command
                          show-config-fileapaths to get the searching tactics.

  -m, --message TEXT
  --help                  Show this message and exit.

Commands:
  restart                Restart Daemon application.
  show-config-filepaths  Print out the config searching paths.
  start                  Start daemon application.
  stop                   Stop daemon application.
```

## Configs

### Config items and default values

- pidfile: app.pid
- stop-timeout: 30
- stop-signal: SIGINT
- daemon: True
- workspace: ""
- loglevel: INFO
- logfile: app.log
- logfmt: default

### srpcd config items and default values

- server.listen: 0.0.0.0
- server.port: 8381
- server.engine_class: daemon_application.app.SimpleXmlRpcServerEngine
- enable-debug-service: true
- services: []

### services fields

- class: class path string, e.g. zenutils.serviceutils.DebugService
- args: []
- kwargs: {}


## Note

Logging is not enabled by default, you may need to enable it at the first line of the main function using `logutils.setup(**self.config)`.

## Release

### v0.5.7

- Improve the srpcd command.

### v0.5.6

- Add SimpleRpcServer class and srpcd command.

### v0.5.5

- Config in DaemonApplication is set to the dictutils.Object class for ease use while remaining compatible with all dict operations.

### v0.5.4

- Doc update.

### v0.5.3

- Add DaemonApplication.load_config, so that you can start DaemonApplication service directly by your code.
- Add stop_timeout for daemon_stop. If stop timeout, kill process tree by force.

### v0.5.2

- Add global options: loglevel, logfile, logfmt.
- Update default_config override mechanism.

### v0.4.4

- Fix the problem in sub-command stop.

### v0.4.3

- Deps on pyyaml.

### v0.4.2

- Remove a print() statement.

### v0.4.1

- Fix documents URLs.

### v0.4.0

- Remove fastutils deps.
- Add `--config` global command option for DaemonApplication.
- Provide a way to override the global options for subclass of DaemonApplication.
- The sub-command `restart` will do just `start` if the old application is not running or crashed.
- Use gitee.com source code hosting service.

### v0.3.3

- Fix show-config-filepaths.

### v0.3.2

- Add click deps in requirements.txt

### v0.3.1

- Add DaemonApplication.

### v0.3.0

- New wrapper.

### v0.2.1

- Old releases.
